/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.easupgrade.compensation.InterfaceCmpUpGradeException;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionCollection;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionFactory;
import com.kingdee.shr.easupgrade.compensation.UpGradeConnectionInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class UpGradeUtil {
    private static Logger logger = Logger.getLogger(UpGradeUtil.class);
    private static final int MAX_DATA_ROW = 8000;

    public static String dateToString(Object obj, String pattern) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof java.util.Date || obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                return sdf.format(obj);
            }
            return String.valueOf(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDbType(Connection conn) {
        String dbType = "oracle";
        try {
            DatabaseMetaData meta = conn.getMetaData();
            dbType = meta.getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dbType;
    }

    public static String datetoString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof java.util.Date || obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(obj);
            }
            return String.valueOf(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void execute(Context ctx, String sql, Connection conn, boolean release) throws BOSException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
            if (release) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, Connection conn, boolean release) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                if (release) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        if (release) {
            SQLUtils.cleanup((Connection)conn);
        }
        return jdbcRowSet;
    }

    public static int[] executeBatchAndReturn(Connection conn, String sql, List paramsList, boolean release) throws BOSException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                int[] nArray = ps.executeBatch();
                return nArray;
            }
        }
        catch (SQLException exc) {
            Object sb = null;
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
            if (release) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return new int[0];
    }

    public static int[] executeBatchRoll(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn;
        PreparedStatement ps;
        block11: {
            ps = null;
            conn = null;
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (flag) break block11;
            int[] nArray = ps.executeBatch();
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        try {
            conn.commit();
        }
        catch (SQLException exc) {
            try {
                Object sb = null;
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }

    public static boolean checkHasUpGraded() throws EASBizException, BOSException {
        boolean flag = false;
        boolean cmpFlag = CmpCalTableFactory.getRemoteInstance().exists("where description like '%EAS HR\u5386\u53f2\u85aa\u916c\u6570\u636e\u8fc1\u79fb%'");
        boolean adjFlag = FixAdjustSalaryFactory.getRemoteInstance().exists("where description like '%EASHR\u5b9a\u8c03\u85aa\u6570\u636e\u8fc1\u79fb%'");
        boolean bl = flag = cmpFlag || adjFlag;
        if (flag) {
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.ALREADY_UPGRADE_ERROR);
        }
        return flag;
    }

    public static boolean checkHasCmpUpGraded() throws EASBizException, BOSException {
        boolean cmpFlag = CmpCalTableFactory.getRemoteInstance().exists("where description like '%EAS HR\u5386\u53f2\u85aa\u916c\u6570\u636e\u8fc1\u79fb%'");
        if (cmpFlag) {
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.ALREADY_UPGRADE_ERROR);
        }
        return cmpFlag;
    }

    public static String getCurrentTimeStr() {
        Calendar calendar = Calendar.getInstance();
        java.util.Date date = calendar.getTime();
        return UpGradeUtil.toSqlDate(date);
    }

    public static String toSqlDate(java.util.Date date) {
        String res = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            res = "{ts'" + sdf.format(date) + "'}";
        }
        catch (Exception e5) {
            return null;
        }
        return res;
    }

    public static java.util.Date toDate(Object obj) {
        java.util.Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (str.indexOf("{ts'") != -1 && str.lastIndexOf("'}") != -1) {
            str = str.substring(str.indexOf("ts{'") + 5, str.lastIndexOf("'}"));
        }
        if (!(str.matches("\\d{4}[-|/]{1}\\d{1,2}[-|/]{1}\\d{1,2}(.*)") || str.matches("(.*)\\d{1,2}:\\d{1,2}:\\d{1,2}(.*)") || obj instanceof java.util.Date)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)str)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                res = sdf.parse(str);
            }
            catch (ParseException e) {
                sdf = new SimpleDateFormat("yyyy/M/d");
                try {
                    res = sdf.parse(str);
                }
                catch (ParseException e1) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd");
                    try {
                        res = sdf.parse(str);
                    }
                    catch (ParseException e2) {
                        sdf = new SimpleDateFormat("yyyy-M-d");
                        try {
                            res = sdf.parse(str);
                        }
                        catch (ParseException e3) {
                            sdf = new SimpleDateFormat("EEE MMM d H:m:s z y");
                            try {
                                res = sdf.parse(str);
                            }
                            catch (ParseException e4) {
                                sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
                                try {
                                    res = sdf.parse(str);
                                }
                                catch (ParseException e5) {
                                    res = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    public static Connection getOuterConnection(Context ctx, String connName) throws BOSException, SQLException, EASBizException {
        UpGradeConnectionCollection configColl = null;
        configColl = StringUtils.isEmpty((String)connName) ? UpGradeConnectionFactory.getLocalInstance(ctx).getUpGradeConnectionCollection() : UpGradeConnectionFactory.getLocalInstance(ctx).getUpGradeConnectionCollection("where name='" + connName + "'");
        UpGradeConnectionInfo ConnectionInfo = null;
        if (configColl.size() <= 0) {
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.NULL_CONNECT_ERROR);
        }
        ConnectionInfo = configColl.get(0);
        String IP = null;
        String DB = null;
        String username = null;
        String password = null;
        String DBtype = ConnectionInfo.getDBType().getName().toString();
        IP = ConnectionInfo.getIP();
        DB = ConnectionInfo.getInstance();
        int port = ConnectionInfo.getPort();
        username = ConnectionInfo.getUsername();
        password = ConnectionInfo.getPassword();
        if (DBtype.equalsIgnoreCase("SQLserver")) {
            try {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            String url = "jdbc:microsoft:sqlserver://" + IP + ":" + port + ";databaseName=" + DB + "";
            DriverManager.setLoginTimeout(300);
            try {
                logger.info((Object)">>>>>>>>>>22222222DBtype=SQLserver");
                return DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e1) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        if (DBtype.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + IP + ":" + port + ":" + DB + "";
                logger.info((Object)">>>>>>>>>>22222222DBtype=oracle");
                return DriverManager.getConnection(url, username, password);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                try {
                    String dbType = DBType.Oracle.getValue().toString();
                    return KSQLUtil.getKSQLConnection((DataBaseType)DataBaseType.getInstance((String)dbType), (String)IP, (int)port, (String)DB, (String)username, (String)password);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
                }
            }
        }
        if (DBtype.equalsIgnoreCase("db2")) {
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                String url = "jdbc:db2://" + IP + ":" + port + "/" + DB + "";
                Properties props = new Properties();
                props.setProperty("user", username);
                props.setProperty("password", password);
                logger.info((Object)">>>>>>>>>>22222222DBtype=db2");
                return DriverManager.getConnection(url, props);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        logger.info((Object)">>>>>>>>>>22222222DBtype=null");
        return null;
    }
}

