/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpExpHisUpgradeFacadeFactory;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.easupgrade.emp.UpGradeSHRExcepion;
import com.kingdee.shr.easupgrade.emp.app.AbstractUpGradePersonControllerBean;
import com.kingdee.shr.easupgrade.emp.util.Person;
import com.kingdee.shr.easupgrade.emp.util.UpGradePersonInPosSQLTool;
import com.kingdee.shr.easupgrade.emp.util.UpGradePersonNotInPosSQLTool;
import com.kingdee.shr.easupgrade.emp.util.UpGradePersonTool;
import com.kingdee.shr.easupgrade.emp.util.UpGradeResult;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpGradePersonControllerBean
extends AbstractUpGradePersonControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.easupgrade.emp.app.UpGradePersonControllerBean");

    private void validateEnvironment(Context ctx) throws UpGradeSHRExcepion, BOSException {
        String selectHRInitSQL = "select * from T_HR_HRInit where FHRORGUNITID is not null and FISFINISH=1";
        String selectSHRStartOrg = "select top 1 * from T_ORG_ADMIN WHERE FISSTARTSHR = 1";
        String selectSHRPersonExist = "select top 1 * from T_HR_EmpOrgRelation";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectHRInitSQL);
            if (rs == null || !rs.next()) {
                throw new UpGradeSHRExcepion(UpGradeSHRExcepion.NO_EASHR);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSHRStartOrg);
            if (rs == null || !rs.next()) {
                throw new UpGradeSHRExcepion(UpGradeSHRExcepion.NOT_INIT_SHR);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSHRPersonExist);
            if (rs != null && rs.next()) {
                throw new UpGradeSHRExcepion(UpGradeSHRExcepion.DUPLICATE_UPGRADE);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        UpGradePersonTool.addPersonWorkExpCurIdColumn(ctx);
    }

    private void upGradePersonInPosition(Context ctx) throws BOSException {
        String condition = "AND PM.FID IS NOT NULL";
        String selectPersonInPositionSQL = UpGradePersonInPosSQLTool.getPersonQuerySQL(condition);
        IRowSet rs = null;
        Map personMap = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectPersonInPositionSQL);
            personMap = UpGradePersonInPosSQLTool.translateRSToPersonInfo(ctx, rs);
            UpGradePersonInPosSQLTool.runUpGradePersonInPositionDataLegal(ctx, personMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u5728\u804c\u5458\u5de5\u5931\u8d25");
        }
    }

    private void upGradePersonNotInPosition(Context ctx) throws BOSException {
        String selectPersonNotInPositionSQL = UpGradePersonNotInPosSQLTool.getPersonNotInPositionQuerySQL(null);
        IRowSet rs = null;
        Map<String, Person> personMap = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectPersonNotInPositionSQL);
            personMap = UpGradePersonNotInPosSQLTool.translateRSToPersonNotInPosition(ctx, rs);
            UpGradePersonNotInPosSQLTool.runUpGradePersonNotInPositionDataLegal(ctx, personMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u4e0d\u5728\u804c\u4eba\u5458\u5931\u8d25");
        }
    }

    @Override
    protected void _runUpGrade(Context ctx) throws BOSException, UpGradeSHRExcepion {
        UpGradeResult result = UpGradeResult.getInstance(ctx);
        result.setPer0();
        this.validateEnvironment(ctx);
        result.setPer5();
        this.upGradePersonInPosition(ctx);
        result.setPerFinishedPersonInPos();
        this.upGradePersonNotInPosition(ctx);
        this.upGradeEmpPostExperienceHis(ctx);
        this.upGradePersonAndHisEffdt(ctx);
        result.setPer100();
    }

    private void upGradePersonAndHisEffdt(Context ctx) throws BOSException {
        String SQL = "update t_bd_person set feffdt = {ts'" + HRUtil.EARLIEST_EFFDT + "'}";
        DbUtil.execute((Context)ctx, (String)SQL);
        SQL = "update t_bd_personhis set feffdt = {ts'" + HRUtil.EARLIEST_EFFDT + "'}";
        DbUtil.execute((Context)ctx, (String)SQL);
    }

    private void upGradeEmpPostExperienceHis(Context ctx) throws BOSException {
        String historySQL = "delete from T_HR_EmpPostExperienceHis";
        DbUtil.execute((Context)ctx, (String)historySQL);
        historySQL = "insert into T_HR_EmpPostExperienceHis (FAdminOrgID,FEffdt,FLeffdt,FAssignType,FID,FPersonID,FPositionID) select fadminorgid,feffdt,fleffdt,fassigntype,newbosid('F8D314CB'),fpersonid,fpositionid from T_HR_EmpOrgRelation where  fisinner=1;";
        DbUtil.execute((Context)ctx, (String)historySQL);
        try {
            EmpExpHisUpgradeFacadeFactory.getRemoteInstance().upgradeAllForMan();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _recoverUpGrade(Context ctx, IObjectValue params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("delete from T_HR_UpGradePerson");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_hr_empLaborRelation ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_hr_empLaborRelationHis ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_hr_emporgrelation");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_hr_empFlowInOut");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from T_HR_EmpPostExperienceHis");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

