/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.emp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.easupgrade.emp.UpGradePersonInfo;
import com.kingdee.shr.easupgrade.emp.UpGradeStateEnum;
import com.kingdee.shr.easupgrade.emp.util.Person;
import com.kingdee.shr.easupgrade.emp.util.PositionMember;
import com.kingdee.shr.easupgrade.emp.util.UpGradePersonTool;
import com.kingdee.shr.easupgrade.emp.util.UpGradeResult;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpGradePersonInPosSQLTool
extends UpGradePersonTool {
    public static String getPersonQuerySQL(String condition) {
        if (condition == null) {
            condition = "";
        }
        String s = "SELECT \"PERSON\".FID AS \"ID\", \"PERSON\".FNumber AS \"NUMBER\", \"PERSON\".FIDCARDNO AS \"IDCARDNO\", \"PERSON\".FPASSPORTNO AS \"PASSPORTNO\",\"PERSON\".FEMPLOYEETYPEID AS \"EMPTYPE\",\"ADMIN\".FID AS \"ADMINID\", \"ADMIN\".FName_l2 AS \"ADMINNAME\", \"ADMIN\".FISSTARTSHR AS \"ADMINSTARTSHR\",\"ADMINSTART\".FEFFECTDATE AS \"ADMINSTARTDATE\",\"PM\".FID AS \"PMID\",\"PM\".FPOSITIONID AS \"PMPOSITION\",\"PM\".FBEGINDATE AS \"PMBEGINDATE\",\"PM\".FENDDATE AS \"PMENDDATE\",\"PM\".FISPRIMARY AS \"PMISPRIMARY\",\"UPGRADEPERSON\".FUpGradeState AS UPGRADESTARE,\"ADMIN\".FSortCode, \"POSITION\".FIndex,\"POSITION\".FNUMBER,\"PERSON\".FIndex FROM T_BD_Person AS \"PERSON\" LEFT OUTER JOIN T_ORG_PositionMember AS \"PM\" ON \"PERSON\".FID = \"PM\".FPersonID LEFT OUTER JOIN T_ORG_Position AS \"POSITION\" ON \"PM\".FPositionID = \"POSITION\".FID LEFT OUTER JOIN T_ORG_Admin AS \"ADMIN\" ON \"POSITION\".FADMINORGUNITID = \"ADMIN\".FID LEFT OUTER JOIN T_HR_SHRAdminActivated AS \"ADMINSTART\" ON \"POSITION\".FADMINORGUNITID = \"ADMINSTART\".FADMINORGUNITID LEFT OUTER JOIN T_HR_UpGradePerson AS \"UPGRADEPERSON\" ON \"PERSON\".FID = \"UPGRADEPERSON\".FPERSONID WHERE (\"UPGRADEPERSON\".FUpGradeState = 2 or \"UPGRADEPERSON\".FUpGradeState is null)" + condition + " ORDER BY " + " \"ADMIN\".FSortCode ASC," + " \"POSITION\".FIndex ASC," + " \"POSITION\".FNUMBER ASC," + " \"PERSON\".FIndex ASC," + "\"NUMBER\" ASC";
        return s;
    }

    public static Map translateRSToPersonInfo(Context ctx, IRowSet rs) throws SQLException {
        HashMap<String, Person> personMap = new HashMap<String, Person>();
        Person personModel = null;
        while (rs.next()) {
            try {
                String ID = rs.getString("ID");
                String NUMBER = rs.getString("NUMBER");
                String IDCARDNO = rs.getString("IDCARDNO");
                String PASSPORTNO = rs.getString("PASSPORTNO");
                String EMPTYPE = rs.getString("EMPTYPE");
                int UPGRADESTARE = rs.getInt("UPGRADESTARE");
                String PMID = rs.getString("PMID");
                String ADMINID = rs.getString("ADMINID");
                String ADMINNAME = rs.getString("ADMINNAME");
                boolean ADMINSTARTSHR = rs.getBoolean("ADMINSTARTSHR");
                Date ADMINSTARTDATE = rs.getDate("ADMINSTARTDATE");
                String PMPOSITION = rs.getString("PMPOSITION");
                Date PMBEGINDATE = rs.getDate("PMBEGINDATE");
                Date PMENDDATE = rs.getDate("PMENDDATE");
                boolean PMISPRIMARY = rs.getBoolean("PMISPRIMARY");
                PositionMember pm = new PositionMember(PMID, ADMINID, ADMINNAME, ADMINSTARTSHR, ADMINSTARTDATE, PMPOSITION, PMBEGINDATE, PMENDDATE, PMISPRIMARY);
                personModel = !personMap.containsKey(ID) ? new Person(ID, NUMBER, IDCARDNO, PASSPORTNO, EMPTYPE, UPGRADESTARE) : (Person)personMap.get(ID);
                personModel.getPms().add(pm);
                if (PMISPRIMARY) {
                    personModel.setPrimaryPM(pm);
                }
                personMap.put(ID, personModel);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return personMap;
    }

    public static void runUpGradePersonInPositionDataLegal(Context ctx, Map<String, Person> personMap) throws BOSException {
        Iterator<String> it = personMap.keySet().iterator();
        Person personModel = null;
        List<PositionMember> pms = null;
        PositionMember pm = null;
        UpGradePersonInfo upGradePersonInfo = null;
        PersonInfo personInfo = null;
        ArrayList<UpGradePersonInfo> validateList = new ArrayList<UpGradePersonInfo>();
        HashSet<String> validPersonIds = new HashSet<String>();
        int count = 0;
        int validCount = 0;
        int inValidCount = 0;
        while (it.hasNext()) {
            ++count;
            boolean valid = true;
            personModel = personMap.get(it.next());
            upGradePersonInfo = new UpGradePersonInfo();
            upGradePersonInfo.setId(BOSUuid.create((String)"CD6F7726"));
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personModel.getId()));
            upGradePersonInfo.setPerson(personInfo);
            upGradePersonInfo.setUpGradeState(UpGradeStateEnum.success);
            pms = personModel.getPms();
            int size = pms.size();
            for (int i = 0; i < size; ++i) {
                pm = pms.get(i);
                if (pm.getPmBeginDate() == null) {
                    upGradePersonInfo.setReason("\u4efb\u804c\u60c5\u51b5\u4e2d\u5b58\u5728\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\u7684\u8bb0\u5f55");
                    upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                    valid = false;
                    break;
                }
                if (!pm.isAdminIsStartSHR()) {
                    upGradePersonInfo.setReason("\u4efb\u804c\u60c5\u51b5\u4e2d\u5b58\u5728\u4efb\u804c\u7ec4\u7ec7\u672a\u542f\u7528s-HR\u5e94\u7528\u7684\u8bb0\u5f55");
                    upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                    valid = false;
                    break;
                }
                if (!DateTimeUtils.dayBefore((java.util.Date)pm.getPmBeginDate(), (java.util.Date)pm.getAdminStartDate())) continue;
                upGradePersonInfo.setReason("\u4efb\u804c\u60c5\u51b5\u4e2d\u5b58\u5728\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e\u4efb\u804c\u7ec4\u7ec7s-HR\u5e94\u7528\u521d\u59cb\u5316\u65e5\u671f\u7684\u8bb0\u5f55");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
                break;
            }
            if (StringUtils.isEmpty((String)personModel.getEmployeetype())) {
                upGradePersonInfo.setReason("\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            }
            if (StringUtils.isEmpty((String)personModel.getIdCardNo()) && StringUtils.isEmpty((String)personModel.getPassPortNo())) {
                upGradePersonInfo.setReason("\u8eab\u4efd\u8bc1\u548c\u62a4\u7167\u53f7\u540c\u65f6\u4e3a\u7a7a");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            }
            if (valid) {
                validPersonIds.add(personModel.getId());
                ++validCount;
            } else {
                ++inValidCount;
            }
            validateList.add(upGradePersonInfo);
            if (validateList.size() == BATCH_SIZE) {
                UpGradePersonInPosSQLTool.batchUpgradePersonInPosition(ctx, validPersonIds, personMap);
                UpGradePersonInPosSQLTool.batchProcessUpgradeResult(ctx, validateList);
                validateList.clear();
                validPersonIds.clear();
            }
            UpGradeResult.getInstance(ctx).setPerRunningPersonInPos(count, validCount, inValidCount);
        }
        if (validateList.size() > 0) {
            UpGradePersonInPosSQLTool.batchUpgradePersonInPosition(ctx, validPersonIds, personMap);
            UpGradePersonInPosSQLTool.batchProcessUpgradeResult(ctx, validateList);
            validateList.clear();
            validPersonIds.clear();
        }
        UpGradePersonInPosSQLTool.batchUpdateEmpPosOtherFields(ctx);
    }

    private static void batchUpgradePersonInPosition(Context ctx, Set<String> validPersonIds, Map<String, Person> personMap) throws BOSException {
        if (validPersonIds.size() == 0) {
            return;
        }
        String personId = "";
        String validPersonIdSetStr = HRUtil.getStrFromSet(validPersonIds);
        String activateEndDate = "{ts'2199-12-31'}";
        String updatePersonSQL = "update t_bd_person set feffdt = ? , fleffdt = " + activateEndDate + " where fid = ?";
        String updatePersonHisSQL = "update t_bd_personhis set feffdt =? , fleffdt = " + activateEndDate + " where FHistoryRelateID = ?";
        String updatePPSQL = "update t_hr_personposition set feffdt = ?  , fleffdt = " + activateEndDate + " where fpersonId = ?";
        String updatePPHisSQL = "update t_hr_personpositionhis set feffdt = ?  , fleffdt = " + activateEndDate + " where fpersonId = ?";
        String insertEmpPosSQL = "insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT,fIsInner)values (?,?,?,?, ?,?,?,? )";
        Person personModel = null;
        PositionMember pm = null;
        java.util.Date minBeginDate = null;
        Object[] params = null;
        Object[] paramsEmpPos = null;
        ArrayList<Object[]> paramsListPerson = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsListEmpPos = new ArrayList<Object[]>();
        Iterator<String> it = validPersonIds.iterator();
        while (it.hasNext()) {
            params = new Object[2];
            personId = it.next();
            personModel = personMap.get(personId);
            minBeginDate = UpGradePersonInPosSQLTool.getMinBeginDateFromPM(personModel.getPms());
            params[0] = minBeginDate;
            params[1] = personId;
            paramsListPerson.add(params);
            int size = personModel.getPms().size();
            for (int i = 0; i < size; ++i) {
                pm = personModel.getPms().get(i);
                paramsEmpPos = new Object[]{BOSUuid.create((String)"29288929").toString(), personId, pm.getAdminId(), pm.getPositionId(), pm.isPrimary(), pm.getPmBeginDate(), new Date(HRUtil.getMaxEndDate().getTime()), 1};
                paramsListEmpPos.add(paramsEmpPos);
            }
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)updatePersonSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)updatePersonHisSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)updatePPSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)updatePPHisSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)insertEmpPosSQL, paramsListEmpPos);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u5347\u7ea7\u5458\u5de5\u57fa\u672c\u4fe1\u606f\\\u804c\u4e1a\u4fe1\u606f\\\u4f01\u4e1a\u4efb\u804c\u7ecf\u5386\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a" + e.getMessage());
        }
        paramsListPerson = null;
        paramsListEmpPos = null;
        String sql = "update T_HR_EmpOrgRelation set FActionID='P/OSDCPfQXqU0TB/LQoA6uZovtk=',FActionTypeID='EsEKwrCMQ+6PnuELVFdjcJYRae4=' where fIsInner=1 and FAssignType=1 and FPersonID in " + validPersonIdSetStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_HR_EmpOrgRelation set FActionID='DawAAAApaaPmaL7Z',FActionTypeID='LmP5wPYYSQyaIXIpUynDHJYRae4=' where fIsInner=1 and FAssignType=0 and FPersonID in " + validPersonIdSetStr;
        DbUtil.execute((Context)ctx, (String)sql);
        UpGradePersonInPosSQLTool.upGradeEmpPosLaborRelation(ctx, validPersonIdSetStr);
        UpGradePersonInPosSQLTool.upGradeEmpPosLaborRelationHis(ctx, validPersonIdSetStr);
        UpGradePersonInPosSQLTool.upGradePersonWorkExpCurToEmpPos(ctx, validPersonIdSetStr);
    }

    private static java.util.Date getMinBeginDateFromPM(List<PositionMember> pms) {
        java.util.Date minBeginDate = pms.get(0).getPmBeginDate();
        java.util.Date tempBeginDate = null;
        PositionMember pm = null;
        if (pms.size() == 1) {
            return minBeginDate;
        }
        int size = pms.size();
        for (int i = 1; i < size; ++i) {
            pm = pms.get(i);
            tempBeginDate = pm.getPmBeginDate();
            if (!DateTimeUtils.dayBefore((java.util.Date)tempBeginDate, (java.util.Date)minBeginDate)) continue;
            minBeginDate = tempBeginDate;
        }
        return minBeginDate;
    }
}

