/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.emp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.easupgrade.emp.UpGradePersonInfo;
import com.kingdee.shr.easupgrade.emp.UpGradeStateEnum;
import com.kingdee.shr.easupgrade.emp.util.Person;
import com.kingdee.shr.easupgrade.emp.util.PersonWorkExpCur;
import com.kingdee.shr.easupgrade.emp.util.UpGradePersonTool;
import com.kingdee.shr.easupgrade.emp.util.UpGradeResult;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpGradePersonNotInPosSQLTool
extends UpGradePersonTool {
    public static String getPersonNotInPositionQuerySQL(String condition) {
        if (condition == null) {
            condition = "";
        }
        String s = "SELECT \"PERSON\".FID AS \"ID\", \"PERSON\".FNumber AS \"NUMBER\", \"PERSON\".FIDCARDNO AS \"IDCARDNO\", \"PERSON\".FPASSPORTNO AS \"PASSPORTNO\",\"PERSON\".FEMPLOYEETYPEID AS \"EMPTYPE\",\"ADMINSTART\".FISSTARTSHR AS \"ADMINSTARTSHR\",\"ADMINSTART\".FEFFDT AS \"ADMINSTARTDATE\",\"PWORK\".FID AS \"PWORKID\",\"PWORK\".FBEGINDATE AS \"BEGINDATE\",\"PWORK\".FENDDATE AS \"ENDDATE\",\"PWORK\".FPOSITIONID AS \"POSITIONID\",\"PWORK\".FDeptID AS \"ADMINID\",\"PWORK\".FPastPositon AS \"PASTPOSITION\",\"PWORK\".FPastDept AS \"PASTDEPT\",\"PWORK\".FISPRIMARY AS \"ISPRIMARY\" FROM T_BD_Person AS \"PERSON\" LEFT OUTER JOIN T_ORG_PositionMember AS \"PM\" ON \"PERSON\".FID = \"PM\".FPersonID LEFT OUTER JOIN T_HR_PersonPosition AS \"PP\" ON \"PERSON\".FID = \"PP\".FPersonID LEFT OUTER JOIN T_HR_PERSONWORKEXPCUR \"PWORK\" ON \"PWORK\".FPERSONID = \"PERSON\".FID LEFT OUTER JOIN T_ORG_ADMIN \"ADMINSTART\" ON \"PWORK\".FDEPTID = \"ADMINSTART\".FID WHERE (\"PM\".FPositionID IS NULL) " + condition + " ORDER BY " + "\"NUMBER\" ASC";
        return s;
    }

    public static Map<String, Person> translateRSToPersonNotInPosition(Context ctx, IRowSet rs) throws SQLException {
        HashMap<String, Person> personMap = new HashMap<String, Person>();
        Person personModel = null;
        while (rs.next()) {
            try {
                String ID = rs.getString("ID");
                String NUMBER = rs.getString("NUMBER");
                String IDCARDNO = rs.getString("IDCARDNO");
                String PASSPORTNO = rs.getString("PASSPORTNO");
                String EMPTYPE = rs.getString("EMPTYPE");
                int UPGRADESTARE = 1;
                boolean ADMINSTARTSHR = rs.getBoolean("ADMINSTARTSHR");
                Date ADMINSTARTDATE = rs.getDate("ADMINSTARTDATE");
                String ADMINID = rs.getString("ADMINID");
                String PWORKID = rs.getString("PWORKID");
                Date BEGINDATE = rs.getDate("BEGINDATE");
                Date ENDDATE = rs.getDate("ENDDATE");
                String POSITIONID = rs.getString("POSITIONID");
                String PASTPOSITION = rs.getString("PASTPOSITION");
                String PASTDEPT = rs.getString("PASTDEPT");
                boolean ISPRIMARY = rs.getBoolean("ISPRIMARY");
                personModel = !personMap.containsKey(ID) ? new Person(ID, NUMBER, IDCARDNO, PASSPORTNO, EMPTYPE, UPGRADESTARE) : (Person)personMap.get(ID);
                if (!StringUtils.isEmpty((String)PWORKID)) {
                    PersonWorkExpCur pworkCur = new PersonWorkExpCur(PWORKID, ADMINID, ADMINSTARTSHR, ADMINSTARTDATE, POSITIONID, BEGINDATE, ENDDATE, PASTDEPT, PASTPOSITION, ISPRIMARY);
                    personModel.getPworks().add(pworkCur);
                }
                personMap.put(ID, personModel);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return personMap;
    }

    public static void runUpGradePersonNotInPositionDataLegal(Context ctx, Map<String, Person> personMap) throws BOSException {
        Iterator<String> it = personMap.keySet().iterator();
        Person personModel = null;
        List<PersonWorkExpCur> pworks = null;
        PersonWorkExpCur pworkCur = null;
        PersonWorkExpCur pworkLast = null;
        UpGradePersonInfo upGradePersonInfo = null;
        PersonInfo personInfo = null;
        java.util.Date maxEndDate = null;
        ArrayList<UpGradePersonInfo> validateList = new ArrayList<UpGradePersonInfo>();
        HashSet<String> validPersonIds = new HashSet<String>();
        boolean valid = true;
        int count = 0;
        int validCount = 0;
        int inValidCount = 0;
        while (it.hasNext()) {
            personModel = personMap.get(it.next());
            upGradePersonInfo = new UpGradePersonInfo();
            upGradePersonInfo.setId(BOSUuid.create((String)"CD6F7726"));
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personModel.getId()));
            upGradePersonInfo.setPerson(personInfo);
            upGradePersonInfo.setUpGradeState(UpGradeStateEnum.success);
            pworks = personModel.getPworks();
            maxEndDate = UpGradePersonNotInPosSQLTool.getMaxEndDateFromPW(pworks);
            pworkLast = null;
            valid = true;
            boolean hasPrimaryPwork = false;
            int size = pworks.size();
            for (int i = 0; i < size; ++i) {
                pworkCur = pworks.get(i);
                if (!pworkCur.isPrimary() || StringUtils.isEmpty((String)pworkCur.getPositionId())) continue;
                hasPrimaryPwork = true;
                if (maxEndDate == null) {
                    pworkLast = null;
                    personModel.setPworkLast(null);
                    continue;
                }
                if (!DateTimeUtils.dayEquals((java.util.Date)pworkCur.getEndDate(), (java.util.Date)maxEndDate)) continue;
                pworkLast = pworkCur;
                personModel.setPworkLast(pworkLast);
                break;
            }
            if (!hasPrimaryPwork) {
                upGradePersonInfo.setReason("\u4efb\u804c\u5386\u53f2\u4e0d\u5b58\u5728\u4efb\u804c\u804c\u4f4d\u662f\u7cfb\u7edf\u5185\u804c\u4f4d\u7684\u8bb0\u5f55");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            } else if (pworkLast == null) {
                upGradePersonInfo.setReason("\u4efb\u804c\u5386\u53f2\u4e2d\u7cfb\u7edf\u5185\u804c\u4f4d\u8bb0\u5f55\u7684\u7ed3\u675f\u65e5\u671f\u90fd\u4e3a\u7a7a");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            } else if (!pworkLast.isAdminIsStartSHR()) {
                upGradePersonInfo.setReason("\u4efb\u804c\u5386\u53f2\u4e2d\u7cfb\u7edf\u5185\u804c\u4f4d\u8bb0\u5f55\u4e2d\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u6700\u665a\u7684\u4e00\u6761\u8bb0\u5f55\uff0c\u5176\u4efb\u804c\u7ec4\u7ec7\u672a\u542f\u7528s-HR\u5e94\u7528");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            } else if (DateTimeUtils.dayBefore((java.util.Date)pworkLast.getEndDate(), (java.util.Date)pworkLast.getAdminStartDate())) {
                upGradePersonInfo.setReason("\u4efb\u804c\u5386\u53f2\u4e2d\u7cfb\u7edf\u5185\u804c\u4f4d\u8bb0\u5f55\u4e2d\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u6700\u665a\u7684\u4e00\u6761\u8bb0\u5f55\uff0c\u5176\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u65e9\u4e8e\u4efb\u804c\u7ec4\u7ec7\u7684s-HR\u5e94\u7528\u521d\u59cb\u5316\u65e5\u671f");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            }
            if (StringUtils.isEmpty((String)personModel.getEmployeetype())) {
                upGradePersonInfo.setReason("\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            }
            if (StringUtils.isEmpty((String)personModel.getIdCardNo()) && StringUtils.isEmpty((String)personModel.getPassPortNo())) {
                upGradePersonInfo.setReason("\u8eab\u4efd\u8bc1\u548c\u62a4\u7167\u53f7\u540c\u65f6\u4e3a\u7a7a");
                upGradePersonInfo.setUpGradeState(UpGradeStateEnum.failed);
                valid = false;
            }
            if (valid) {
                validPersonIds.add(personModel.getId());
                ++validCount;
            } else {
                ++inValidCount;
            }
            validateList.add(upGradePersonInfo);
            if (validateList.size() == BATCH_SIZE) {
                UpGradePersonNotInPosSQLTool.batchUpgradePerson(ctx, validPersonIds, personMap);
                UpGradePersonNotInPosSQLTool.batchProcessUpgradeResult(ctx, validateList);
                validateList.clear();
                validPersonIds.clear();
            }
            UpGradeResult.getInstance(ctx).setPerRunningPersonNotInPos(count, validCount, inValidCount);
        }
        if (validateList.size() > 0) {
            UpGradePersonNotInPosSQLTool.batchUpgradePerson(ctx, validPersonIds, personMap);
            UpGradePersonNotInPosSQLTool.batchProcessUpgradeResult(ctx, validateList);
            validateList.clear();
            validPersonIds.clear();
        }
        UpGradePersonNotInPosSQLTool.batchUpdateEmpPosOtherFields(ctx);
    }

    private static void batchUpgradePerson(Context ctx, Set<String> validPersonIds, Map<String, Person> personMap) throws BOSException {
        if (validPersonIds.size() == 0) {
            return;
        }
        String personId = "";
        String validPersonIdSetStr = HRUtil.getStrFromSet(validPersonIds);
        String activateEndDate = "{ts'2199-12-31'}";
        String updatePersonSQL = "update t_bd_person set feffdt = ? , fleffdt = " + activateEndDate + " where fid = ?";
        String updatePersonHisSQL = "update t_bd_personhis set feffdt =? , fleffdt = " + activateEndDate + " where FHistoryRelateID = ?";
        String updatePPSQL = "update t_hr_personposition set feffdt = ?  , fleffdt = " + activateEndDate + ",FPrimaryPositionID=?  where fpersonId = ?";
        String updatePPHisSQL = "update t_hr_personpositionhis set feffdt = ?  , fleffdt = " + activateEndDate + ",FPrimaryPositionID=? where fpersonId = ?";
        String insertEmpPosSQL = "insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT,fIsInner,PersonWorkExpCurId)values (?,?,?,?, ?,?,?,?, ?)";
        Person personModel = null;
        Object pm = null;
        PersonWorkExpCur pworkCurLast = null;
        List<PersonWorkExpCur> pworks = null;
        java.util.Date newBeginDate = null;
        Date newBeginDateSQL = null;
        Object[] params = null;
        Object[] paramsPP = null;
        Object[] paramsEmpPos = null;
        ArrayList<Object[]> paramsListPerson = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsListEmpPos = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsListPP = new ArrayList<Object[]>();
        Iterator<String> it = validPersonIds.iterator();
        while (it.hasNext()) {
            params = new Object[2];
            paramsEmpPos = new Object[9];
            paramsPP = new Object[3];
            personId = it.next();
            personModel = personMap.get(personId);
            pworks = personModel.getPworks();
            pworkCurLast = personModel.getPworkLast();
            newBeginDate = HRUtil.getAftereDate((java.util.Date)pworkCurLast.getEndDate());
            newBeginDateSQL = new Date(newBeginDate.getTime());
            params[0] = newBeginDateSQL;
            params[1] = personId;
            paramsListPerson.add(params);
            paramsPP[0] = newBeginDateSQL;
            paramsPP[1] = pworkCurLast.getPositionId();
            paramsPP[2] = personId;
            paramsListPP.add(paramsPP);
            paramsEmpPos[0] = BOSUuid.create((String)"29288929").toString();
            paramsEmpPos[1] = personId;
            paramsEmpPos[2] = pworkCurLast.getAdminId();
            paramsEmpPos[3] = pworkCurLast.getPositionId();
            paramsEmpPos[4] = pworkCurLast.isPrimary();
            paramsEmpPos[5] = newBeginDateSQL;
            paramsEmpPos[6] = new Date(HRUtil.getMaxEndDate().getTime());
            paramsEmpPos[7] = 1;
            paramsEmpPos[8] = "";
            paramsListEmpPos.add(paramsEmpPos);
        }
        try {
            DbUtil.executeBatch((Context)ctx, (String)updatePersonSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)updatePersonHisSQL, paramsListPerson);
            DbUtil.executeBatch((Context)ctx, (String)updatePPSQL, paramsListPP);
            DbUtil.executeBatch((Context)ctx, (String)updatePPHisSQL, paramsListPP);
            DbUtil.executeBatch((Context)ctx, (String)insertEmpPosSQL, paramsListEmpPos);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u5347\u7ea7\u4e0d\u5728\u804c\u5458\u5de5\u57fa\u672c\u4fe1\u606f\\\u804c\u4e1a\u4fe1\u606f\\\u4f01\u4e1a\u4efb\u804c\u7ecf\u5386\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a" + e.getMessage());
        }
        paramsListPerson = null;
        paramsListEmpPos = null;
        UpGradePersonNotInPosSQLTool.upGradePersonPositionDep(ctx, validPersonIdSetStr);
        String sql = "update T_HR_EmpOrgRelation set FActionID='P/OSDCPfQXqU0TB/LQoA6uZovtk=',FActionTypeID='EsEKwrCMQ+6PnuELVFdjcJYRae4=' where fIsInner=1 and FAssignType=1 and FPersonID in " + validPersonIdSetStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_HR_EmpOrgRelation set FActionID='DawAAAApaaPmaL7Z',FActionTypeID='LmP5wPYYSQyaIXIpUynDHJYRae4=' where fIsInner=1 and FAssignType=0 and FPersonID in " + validPersonIdSetStr;
        DbUtil.execute((Context)ctx, (String)sql);
        UpGradePersonNotInPosSQLTool.upGradeEmpPosLaborRelation(ctx, validPersonIdSetStr);
        UpGradePersonNotInPosSQLTool.upGradeEmpPosLaborRelationHis(ctx, validPersonIdSetStr);
        UpGradePersonNotInPosSQLTool.upGradePersonWorkExpCurToEmpPos(ctx, validPersonIdSetStr);
    }

    private static void upGradePersonPositionDep(Context ctx, String validPersonIdSetStr) throws BOSException {
        String select_sql = "select pp.fid ppId,position.fadminorgunitid adminId from t_hr_personposition pp  left join t_org_position position on pp.fprimarypositionid = position.fid where pp.fpersonid in " + validPersonIdSetStr;
        String updatePPSQL = "update t_hr_personposition set fpersondep = ? where fid = ?";
        ArrayList<Object[]> paramsListPP = new ArrayList<Object[]>();
        Object[] params = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)select_sql);
        try {
            while (rs.next()) {
                String fid = rs.getString("ppId");
                String fadminId = rs.getString("adminId");
                params = new Object[]{fid, fadminId};
                paramsListPP.add(params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DbUtil.executeBatch((Context)ctx, (String)updatePPSQL, paramsListPP);
        String select_sql12 = "select pp.fid ppId,position.fadminorgunitid adminId from t_hr_personpositionhis pp  left join t_org_position position on pp.fprimarypositionid = position.fid where pp.fpersonid in " + validPersonIdSetStr;
        String updatePPHISSQL = "update t_hr_personpositionhis set fpersondep = ? where fid = ?";
        ArrayList<Object[]> paramsListPPHIS = new ArrayList<Object[]>();
        Object[] paramsHIS = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)select_sql12);
        try {
            while (rs.next()) {
                String fid = rs.getString("ppId");
                String fadminId = rs.getString("adminId");
                paramsHIS = new Object[]{fid, fadminId};
                paramsListPPHIS.add(paramsHIS);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        DbUtil.executeBatch((Context)ctx, (String)updatePPHISSQL, paramsListPPHIS);
    }

    private static java.util.Date getMaxEndDateFromPW(List<PersonWorkExpCur> pworks) {
        java.util.Date maxEndDate = null;
        java.util.Date tempEndDate = null;
        for (PersonWorkExpCur pwork : pworks) {
            if (!pwork.isPrimary()) continue;
            tempEndDate = pwork.getEndDate();
            if (maxEndDate != null && !DateTimeUtils.dayAfter((java.util.Date)tempEndDate, (java.util.Date)maxEndDate)) continue;
            maxEndDate = tempEndDate;
        }
        return maxEndDate;
    }
}

