/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.baseconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheRouterManager;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.shr.formulaplatform.app.CollectionUtil;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaSqlParam;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FormulaSqlBuilder
extends CommonSHRSqlBuilder {
    public static final Pattern PATTERN_FN_SQL = Pattern.compile("\\$sql\\(([\\w\\.\\(\\)]+)\\)", 2);
    public static final String CACHE_TYPE = "shr.structureAndQueryConfigcache";
    public static final String FN_SQL_FIELD = "aggregateFn";
    public static final String FIELD_REPLACE_FLAG = "@field";

    public String getSql(Context ctx, SqlParam param) throws EASBizException, BOSException {
        this.addSelectMapping(ctx, param);
        String sql = super.getSql(ctx, param);
        if (CollectionUtil.isEmpty(param.getSelectMapping())) {
            int onIndex = sql.indexOf(" ON ") + 4;
            String selectFiled = sql.substring(onIndex, sql.indexOf("=", onIndex));
            sql = "select " + selectFiled + sql.substring(sql.indexOf(" FROM"));
        }
        sql = this.formulaSqlProcess(sql);
        return sql;
    }

    protected void addSelectMapping(Context ctx, SqlParam param) throws BOSException {
        String[] autoExtendField;
        Map selectMapping = param.getSelectMapping();
        String[] stringArray = autoExtendField = param instanceof FormulaSqlParam ? ((FormulaSqlParam)param).getAutoExtendField() : null;
        if (CollectionUtil.isEmpty(selectMapping) || autoExtendField == null || autoExtendField.length == 0) {
            return;
        }
        ArrayList allKeys = new ArrayList(selectMapping.keySet());
        for (String selectField : allKeys) {
            if (selectField == null || !selectField.toLowerCase().endsWith(".id") && !"id".equalsIgnoreCase(selectField)) continue;
            StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)param.getScheme(), (String)selectField);
            for (String autoKey : autoExtendField) {
                String newFiled = selectField.contains(".") ? selectField.substring(0, selectField.lastIndexOf(".") + 1) + autoKey : autoKey;
                QueryConfigFieldInfo queryField = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)param.getScheme(), (String)newFiled);
                if (queryField == null) continue;
                selectMapping.put(newFiled, newFiled);
            }
        }
    }

    public Map<String, String> getSqlMap(Context ctx, SqlParam param) throws EASBizException, BOSException {
        Map sqlMap = super.getSqlMap(ctx, param);
        for (String key : sqlMap.keySet()) {
            sqlMap.put(key, this.formulaSqlProcess((String)sqlMap.get(key)));
        }
        return sqlMap;
    }

    protected String formulaSqlProcess(String sql) throws EASBizException, BOSException {
        sql = this.processAggregateConfig(sql);
        sql = this.processSqlFn(sql);
        sql = this.processNeedReplaceVars(sql);
        return sql;
    }

    protected String processNeedReplaceVars(String sql) throws EASBizException, BOSException {
        Map<String, String> needReplaceVars = null;
        if (this.param instanceof FormulaSqlParam) {
            needReplaceVars = ((FormulaSqlParam)this.param).getNeedReplaceVars();
        }
        if (needReplaceVars == null) {
            return sql;
        }
        for (String key : needReplaceVars.keySet()) {
            int i = -key.length();
            while ((i = sql.indexOf(key, i + key.length())) >= 0) {
                sql = sql.replace(key, needReplaceVars.get(key));
            }
        }
        return sql;
    }

    protected String processAggregateConfig(String sql) throws EASBizException, BOSException {
        String extOpts;
        String clientNum;
        HashMap<String, Map<String, String>> aggregateMap = new HashMap<String, Map<String, String>>();
        String containJudge = MessageFormat.format("{0}{1}{2}", "\"", FN_SQL_FIELD, "\"");
        List<StructureConfigColumnsInfo> strucConfigCols = this.getStrucConfigCols();
        for (StructureConfigColumnsInfo structColInfo : strucConfigCols) {
            clientNum = structColInfo.getStructureConfig().getClientNumber();
            extOpts = structColInfo.getExtendOptions();
            if (extOpts == null || !extOpts.contains(containJudge) || aggregateMap.containsKey(clientNum)) continue;
            aggregateMap.put(clientNum, new HashMap());
            this.assembleSqlField2AggregateMap((Map)aggregateMap.get(clientNum), clientNum, sql);
        }
        for (StructureConfigColumnsInfo structColInfo : strucConfigCols) {
            clientNum = structColInfo.getStructureConfig().getClientNumber();
            if (!aggregateMap.containsKey(clientNum)) continue;
            extOpts = structColInfo.getExtendOptions();
            ((Map)aggregateMap.get(clientNum)).put(this.getFieldClause(this.getPropertyInfo(structColInfo.getStructureConfig(), structColInfo.getNumber())), StringUtils.isEmpty((String)extOpts) ? null : JSON.parseObject((String)extOpts).getString(FN_SQL_FIELD));
        }
        sql = this.processSqlWithAggregateMap(sql, aggregateMap);
        return sql;
    }

    protected List<StructureConfigColumnsInfo> getStrucConfigCols() throws BOSException {
        ICacheRouter cacheRouter = CacheRouterManager.getInstance().getCustomRouter(CACHE_TYPE);
        String key = MessageFormat.format("{0}_{1}_", 5, this.param.getScheme());
        String preCacheType = MessageFormat.format("{0}#{1}", this.ctx.getAIS(), CACHE_TYPE);
        List queryFileds = cacheRouter.searchKeys(preCacheType, key);
        int fieldStartInd = preCacheType.length() + 1;
        if (queryFileds == null || queryFileds.size() == 0 || cacheRouter.getCache(preCacheType, queryFileds.get(0).toString().substring(fieldStartInd), false) == null) {
            StructureConfigConvertHelper.getQueryFieldByKey((Context)this.ctx, (String)this.param.getScheme(), (String)FN_SQL_FIELD);
            queryFileds = cacheRouter.searchKeys(preCacheType, key);
        }
        if (queryFileds == null || queryFileds.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<StructureConfigColumnsInfo> strucConfigCols = new ArrayList<StructureConfigColumnsInfo>(queryFileds.size());
        for (Object field : queryFileds) {
            Object fieldInfo = cacheRouter.getCache(preCacheType, field.toString().substring(fieldStartInd), false);
            strucConfigCols.add(((QueryConfigFieldInfo)fieldInfo).getFactField());
        }
        return strucConfigCols;
    }

    protected String processSqlWithAggregateMap(String sql, Map<String, Map<String, String>> aggregateMap) {
        StringBuffer selectSql = new StringBuffer();
        StringBuffer groupSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        StringBuffer havingSql = new StringBuffer();
        for (String clientNumber : aggregateMap.keySet()) {
            Matcher tableMatcher = Pattern.compile("(([\\w_]+)\\s+AS)\\s+\"" + clientNumber.toUpperCase() + "\"").matcher(sql);
            if (!tableMatcher.find()) continue;
            selectSql.setLength(0);
            groupSql.setLength(0);
            whereSql.setLength(0);
            havingSql.setLength(0);
            for (String field : aggregateMap.get(clientNumber).keySet()) {
                String aggregateFn = aggregateMap.get(clientNumber).get(field);
                this.assembleAggregateFn2Sql(field, aggregateFn, selectSql, groupSql, whereSql, havingSql);
            }
            if (groupSql.length() <= 0 || selectSql.length() <= 0) continue;
            groupSql.setCharAt(groupSql.length() - 1, ')');
            selectSql.replace(0, 1, "(select ");
            selectSql.append(" from ").append(tableMatcher.group(2));
            if (whereSql.length() > 4) {
                selectSql.append(" where ").append(whereSql.substring(4));
            }
            if (havingSql.length() > 4) {
                selectSql.append(" having ").append(havingSql.substring(4));
            }
            selectSql.append(" group by ").append(groupSql);
            sql = sql.replaceAll(tableMatcher.group(1), selectSql.append(" AS ").toString());
        }
        return sql;
    }

    protected void assembleAggregateFn2Sql(String field, String aggregateFn, StringBuffer selectSql, StringBuffer groupSql, StringBuffer whereSql, StringBuffer havingSql) {
        String havingConfig;
        if (StringUtils.isBlank((String)aggregateFn)) {
            return;
        }
        if (!JSON.isValid((String)aggregateFn)) {
            String[] fnArr;
            for (String key : fnArr = aggregateFn.split(",")) {
                if (!key.equalsIgnoreCase("group")) {
                    selectSql.append(",").append(key).append("(").append(field).append(") ").append(field);
                    continue;
                }
                groupSql.append(field).append(",");
                if (fnArr.length != 1) continue;
                selectSql.append(",").append(field);
            }
            return;
        }
        JSONObject aggregateFnObj = JSON.parseObject((String)aggregateFn);
        String whereConfig = (String)aggregateFnObj.remove((Object)"where");
        if (StringUtils.isNotBlank((String)whereConfig)) {
            whereSql.append("and ").append(whereConfig.replaceAll(FIELD_REPLACE_FLAG, field));
        }
        if (StringUtils.isNotBlank((String)(havingConfig = (String)aggregateFnObj.remove((Object)"having")))) {
            havingSql.append("and ").append(havingConfig.replaceAll(FIELD_REPLACE_FLAG, field));
        }
        if (aggregateFnObj.containsKey((Object)"group")) {
            groupSql.append(field).append(",");
            selectSql.append(",").append(field);
            aggregateFnObj.remove((Object)"group");
        }
        for (String key : aggregateFnObj.keySet()) {
            selectSql.append(",").append(key).append("(").append(field).append(") ").append(field);
        }
    }

    protected void assembleSqlField2AggregateMap(Map<String, String> aggregateMap, String clientNum, String sql) {
        String findReg = MessageFormat.format("{0}{1}{2}", "\"", clientNum.toUpperCase(), "\"\\.([\\w\\$]+)");
        Matcher matcher = Pattern.compile(findReg).matcher(sql);
        while (matcher.find()) {
            aggregateMap.put(matcher.group(1), "group");
        }
    }

    protected String processSqlFn(String sql) throws EASBizException, BOSException {
        return PATTERN_FN_SQL.matcher(sql).replaceAll("$1");
    }
}

