/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile.formulaexpr;

import com.kingdee.shr.formulaplatform.compile.formulaexpr.ExprType;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExpr;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.operator.OperatorBracket;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.operator.OperatorLogic;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.operator.OperatorMathCal;
import java.util.HashMap;
import java.util.Map;

public class OperatorExpr
extends FormulaExpr {
    public static final char QUOTATION = '\"';
    public static Map<Object, Class<? extends OperatorExpr>> operatorExprContainer;
    private static Map<Object, String> operatorNameContainer;
    private String operatorName;

    public OperatorExpr() {
        this.setExprType(ExprType.Operator);
    }

    public OperatorExpr(String expr) {
        super(expr);
        this.setExprType(ExprType.Operator);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public OperatorExpr setOperatorName(String operatorName) {
        this.operatorName = operatorName;
        return this;
    }

    public static OperatorExpr getOperatorExpr(String operator) {
        if (!operatorExprContainer.containsKey(operator)) {
            return null;
        }
        OperatorExpr operatorExpr = null;
        try {
            operatorExpr = operatorExprContainer.get(operator).newInstance();
            operatorExpr.setExpr(operator);
            operatorExpr.setOperatorName(operatorNameContainer.get(operator));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return operatorExpr;
    }

    private static void initContainer() {
        operatorExprContainer = new HashMap<Object, Class<? extends OperatorExpr>>();
        operatorNameContainer = new HashMap<Object, String>();
        OperatorLogic.initOperator();
        OperatorMathCal.initOperator();
        OperatorBracket.initOperator();
        OperatorExpr.initOperator();
    }

    public static void initOperator() {
        OperatorExpr.addOperatorExpr("||", OperatorExpr.class, "or");
        OperatorExpr.addOperatorExpr("|", OperatorExpr.class, "byteOr");
        OperatorExpr.addOperatorExpr("&&", OperatorExpr.class, "and");
        OperatorExpr.addOperatorExpr("&", OperatorExpr.class, "byteAnd");
        OperatorExpr.addOperatorExpr(";", OperatorExpr.class, "semicolon");
        OperatorExpr.addOperatorExpr("=", OperatorExpr.class, "assign");
        OperatorExpr.addOperatorExpr(",", OperatorExpr.class, "common");
    }

    public static void addOperatorExpr(String operator, Class<? extends OperatorExpr> cls, String operationName) {
        operatorExprContainer.put(operator, cls);
        operatorNameContainer.put(operator, operationName);
    }

    static {
        OperatorExpr.initContainer();
    }
}

