/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.log.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.log.LogLevel;
import com.kingdee.shr.log.LogType;
import com.kingdee.shr.log.cache.LogConfigBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LogConfigCacheHelper {
    private static Logger logger = Logger.getLogger(LogConfigCacheHelper.class);
    private static final String CACHE_TYPE = "shr.logconfig";

    private static String getKey(int logType, String key) {
        return MessageFormat.format("{0}_{1}", logType, key);
    }

    private static LogConfigBean get(int logType, String key) {
        return (LogConfigBean)CacheService.getInstance().get(CACHE_TYPE, LogConfigCacheHelper.getKey(logType, key));
    }

    private static void put(int logType, String key, LogConfigBean value) {
        CacheService.getInstance().put(CACHE_TYPE, LogConfigCacheHelper.getKey(logType, key), (Object)value);
    }

    public static void remove(int logType, String key) {
        CacheService.getInstance().remove(CACHE_TYPE, LogConfigCacheHelper.getKey(logType, key));
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    private static LogConfigBean getLogConfigBeanByDB(Context ctx, int logType, String key) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select (case when t2.FImplClass  is not null then t2.FImplClass else t0.FImplClass end)  FImplClass,");
        sb.append(" (case when t2.FImplClass  is not null then t2.Flevel else t0.Flevel end)  Flevel,");
        sb.append(" t1.FName,");
        sb.append(" t1.FParams,");
        sb.append(" t1.FCaption_l1,");
        sb.append(" t1.FCaption_l2,");
        sb.append(" t1.FCaption_l3,");
        sb.append(" t1.FUrl");
        sb.append(" from T_HR_LogConfig t0");
        sb.append(" left join T_HR_LogConfigEntry t1 on  t0.fid = t1.fparentId");
        sb.append(" left join T_HR_LogConfigExt t2 on t0.fid = t2.fparentId");
        sb.append(" where t0.fstate = ? and t0.FLogType = ? and t1.furl = ? ");
        LogConfigBean bean = null;
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{1, logType, key});
            HashMap<String, String> caption = null;
            while (rs.next()) {
                bean = new LogConfigBean();
                bean.setImplClass(rs.getString("FImplClass"));
                bean.setLevel(LogLevel.getEnum(rs.getInt("Flevel")));
                bean.setButtonName(rs.getString("FName"));
                bean.setUrl(rs.getString("FUrl"));
                bean.setLogType(LogType.getEnum(logType));
                String params = rs.getString("FParams");
                if (!StringUtils.isEmpty((String)params) && params.startsWith("{") && params.endsWith("}")) {
                    bean.setParams(JSONUtils.convertJsonToObject((Context)ctx, (String)rs.getString("FParams")));
                } else if (!StringUtils.isEmpty((String)params) && params.startsWith("[") && params.endsWith("]")) {
                    bean.setParams(JSONUtils.convertJsonToObject((Context)ctx, (String)rs.getString("FParams"), List.class));
                } else {
                    bean.setParams(null);
                }
                caption = new HashMap<String, String>();
                caption.put(LocaleUtils.getShortCode((Locale)LocaleUtils.locale_l1), rs.getString("FCaption_l1"));
                caption.put(LocaleUtils.getShortCode((Locale)LocaleUtils.locale_l2), rs.getString("FCaption_l2"));
                caption.put(LocaleUtils.getShortCode((Locale)LocaleUtils.locale_l3), rs.getString("FCaption_l3"));
                bean.setCaption(caption);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return bean;
    }

    public static LogConfigBean getLogConfigBean(Context ctx, int logType, String key) throws BOSException {
        LogConfigBean bean = LogConfigCacheHelper.get(logType, key);
        if (null == bean && null != (bean = LogConfigCacheHelper.getLogConfigBeanByDB(ctx, logType, key))) {
            LogConfigCacheHelper.put(logType, key, bean);
        }
        return bean;
    }
}

