/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.app.AbstractWebCodeProcessControllerBean;
import com.kingdee.shr.ml.util.MutilanUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WebCodeProcessControllerBean
extends AbstractWebCodeProcessControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.WebCodeProcessControllerBean");
    private static Pattern pat = Pattern.compile("<script.*src=\"(.*)\"");
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = SHRSyssettingUtil.getEasWebWarPath();
    private static final Set<String> NOT_INCLUDE_UIPK = new HashSet<String>(){
        {
            this.add("com.kingdee.shr.compensation.app.ImportInfo");
        }
    };
    public static final String SONG_TI = "\u5b8b\u4f53";
    public static final String YA_HEI = "\u5fae\u8f6f\u96c5\u9ed1";

    @Override
    protected void _startProcessTask(Context ctx, String number) throws BOSException {
        StringBuffer numberBuf = new StringBuffer();
        if (!StringUtils.isEmpty((CharSequence)number)) {
            String[] numArr = number.split(",");
            for (int i = 0; i < numArr.length; ++i) {
                numberBuf.append("'" + numArr[i] + "'");
                if (i == numArr.length - 1) continue;
                numberBuf.append(", ");
            }
        }
        try {
            TreeMap<String, Integer> processMap = new TreeMap<String, Integer>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber number, ftotal total from t_shr_webCodeProcess order by fnumber");
            while (rs.next()) {
                String num = rs.getString("number");
                int total = rs.getInt("total");
                processMap.put(num, total);
            }
            String numFilterSql = numberBuf.toString();
            String uptSql = "update t_shr_webCodeProcess set fstate = 1, fpercent = 0 ";
            if (!StringUtils.isEmpty((CharSequence)numFilterSql)) {
                uptSql = uptSql + "where fnumber in (" + numFilterSql + ")";
            }
            DbUtil.execute((Context)ctx, (String)uptSql);
            if (!StringUtils.isEmpty((CharSequence)number)) {
                String[] numArr = number.split(",");
                for (int i = 0; i < numArr.length; ++i) {
                    this.handleWebCodeByNum(ctx, numArr[i], processMap);
                }
            } else {
                Set keys = processMap.keySet();
                for (String key : keys) {
                    this.handleWebCodeByNum(ctx, key, processMap);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWebCodeByNum(Context ctx, String number, Map<String, Integer> processMap) throws BOSException, SQLException {
        try {
            String deleteSQL = "delete from t_shr_webcodecheck where fnumber = '" + number + "'";
            String insertSQL = "insert into t_shr_webcodecheck(fid, fproject, fnumber, fullpath, ftype, fuipk, filename, fkey, fres) values(newbosid('4516CC64'), ?, ?, ?, ?, ?, ?, null, ?)";
            String updateSQL = "update t_shr_webcodeprocess set fstate = ?, fpercent = ?, finish = ? where fnumber = '" + number + "'";
            String resetSQL = "update t_shr_webcodeprocess set fstate = 0, fpercent = 0, finish = 0 where fnumber = '" + number + "'";
            String selectSQL = "select  uiviewtree.fnumber number, uiviewtree.fname_l2 name, uiview.fid fid, uiview.fcontent content, uiview.fuipk uipk, uiview.fvardefine vardefine from s_bs_uiview uiview inner join s_bs_uiviewtree uiviewtree on uiview.ftreeid = uiviewtree.fid where uiviewtree.fnumber = '" + number + "' order by uiviewtree.fnumber ";
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            DbUtil.execute((Context)ctx, (String)resetSQL);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            ArrayList<Object[]> checkParamsList = new ArrayList<Object[]>();
            int index = 0;
            while (rs.next()) {
                ++index;
                HashMap map = new HashMap();
                String fid = rs.getString("fid");
                String num = rs.getString("number");
                String name = rs.getString("name");
                String content = rs.getString("content");
                String uipk = rs.getString("uipk");
                String vardefine = rs.getString("vardefine");
                String appCode = "";
                if (index % 50 == 0) {
                    Object[] params;
                    Integer total = processMap.get(num);
                    int percent = (int)Math.floor(index * 100 / total);
                    if (percent == 100) {
                        params = new Object[]{2, percent, index};
                        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
                    } else {
                        params = new Object[]{1, percent, index};
                        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)uipk) && NOT_INCLUDE_UIPK.contains(uipk)) continue;
                if (!StringUtils.isEmpty((CharSequence)vardefine)) {
                    appCode = vardefine.substring(vardefine.lastIndexOf("=") + 1);
                }
                if (StringUtils.isEmpty((CharSequence)content)) continue;
                String fullPath = "";
                RandomAccessFile br = null;
                try {
                    Matcher mat = pat.matcher(new String(content.getBytes("8859_1"), "utf8"));
                    HashSet<String> resSet = null;
                    while (mat.find()) {
                        resSet = new HashSet<String>();
                        fullPath = mat.group(1);
                        if (fullPath.indexOf("${appPath}") >= 0) {
                            fullPath = fullPath.replace("${appPath}", EAS_EAR_ROOT + File.separator + SHR_WEB_WAR_NAME + File.separator + "addon");
                            if (!StringUtils.isEmpty((CharSequence)vardefine)) {
                                fullPath = fullPath.replace("${appCode}", appCode);
                            }
                        } else {
                            fullPath = EAS_EAR_ROOT + File.separator + SHR_WEB_WAR_NAME + File.separator + fullPath;
                        }
                        logger.error((Object)("#### uiview script: " + fullPath));
                        String fileName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
                        try {
                            br = new RandomAccessFile(fullPath, "rw");
                            MutilanUtils.resetAnalysisLineFlag();
                            String str = null;
                            while ((str = br.readLine()) != null) {
                                String lineStr = new String(str.getBytes("8859_1"), "utf8");
                                String pattern = "('.*[\u4e00-\u9fa5]+.*')";
                                Pattern pat1 = Pattern.compile(pattern);
                                Matcher mat1 = pat1.matcher(MutilanUtils.analysisLine(lineStr));
                                while (mat1.find()) {
                                    String res = mat1.group(1);
                                    if (res.indexOf(SONG_TI) >= 0 || res.indexOf(YA_HEI) >= 0) continue;
                                    if (!resSet.contains(res)) {
                                        checkParamsList.add(new Object[]{name, num, fullPath.replaceAll("/", "\\\\"), num, uipk, fileName, res});
                                        resSet.add(res);
                                    }
                                    if (checkParamsList.size() % 1000 != 0) continue;
                                    try {
                                        DbUtil.executeBatch((Context)ctx, (String)insertSQL, checkParamsList);
                                    }
                                    catch (Exception e) {
                                        for (int i = 0; i < checkParamsList.size(); ++i) {
                                            try {
                                                DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])((Object[])checkParamsList.get(i)));
                                                continue;
                                            }
                                            catch (Exception e2) {
                                                logger.error((Object)("####error format script: " + ((Object[])checkParamsList.get(i))[2].toString() + " content: " + ((Object[])checkParamsList.get(i))[6].toString()));
                                                e2.printStackTrace();
                                            }
                                        }
                                    }
                                    checkParamsList.clear();
                                }
                            }
                        }
                        finally {
                            if (br == null) continue;
                            br.close();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)("####error FileNotFound script: " + fullPath));
                }
                catch (IOException e) {
                    logger.error((Object)("#### error IO script: " + fullPath));
                }
                finally {
                    if (br == null) continue;
                    br.close();
                }
            }
            if (checkParamsList.size() > 0) {
                try {
                    DbUtil.executeBatch((Context)ctx, (String)insertSQL, checkParamsList);
                }
                catch (Exception e) {
                    for (int i = 0; i < checkParamsList.size(); ++i) {
                        try {
                            DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])((Object[])checkParamsList.get(i)));
                            continue;
                        }
                        catch (Exception e2) {
                            logger.error((Object)("####error format script: " + ((Object[])checkParamsList.get(i))[2].toString() + " content: " + ((Object[])checkParamsList.get(i))[6].toString()));
                            e2.printStackTrace();
                        }
                    }
                }
                checkParamsList.clear();
            }
            Object[] params = new Object[]{2, 100, index};
            logger.error((Object)("#### uiview index: " + index));
            DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Map _getProcessTask(Context ctx) throws BOSException {
        HashMap<String, Serializable> processMap = new HashMap<String, Serializable>();
        processMap.put("isFinish", Integer.valueOf(0));
        ArrayList processList = new ArrayList();
        String selectSQL1 = "select * from t_shr_webcodeprocess where fstate != 2";
        String selectSQL2 = "select fnumber, fpercent from t_shr_webcodeprocess";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL1);
            if (!rs.next()) {
                processMap.put("isFinish", Integer.valueOf(1));
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL2);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String number = rs.getString("fnumber");
                int percent = rs.getInt("fpercent");
                map.put("number", number);
                map.put("percent", percent);
                processList.add(map);
            }
            processMap.put("processList", processList);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return processMap;
    }

    private static void closeStream(Closeable ... sList) {
        for (Closeable s : sList) {
            try {
                if (s == null) continue;
                s.close();
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJsonFile(String fileName) {
        String string;
        String jsonStr = "";
        InputStreamReader reader = null;
        FileInputStream fis = null;
        try {
            File jsonFile = new File(fileName);
            fis = new FileInputStream(jsonFile);
            reader = new InputStreamReader((InputStream)fis, "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            string = jsonStr = sb.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                WebCodeProcessControllerBean.closeStream(reader, fis);
                throw throwable;
            }
            WebCodeProcessControllerBean.closeStream(reader, fis);
            return string2;
        }
        WebCodeProcessControllerBean.closeStream(reader, fis);
        return string;
    }
}

