/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.orgchart.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.orgchart.OrgChartBizException;
import com.kingdee.shr.orgchart.OrgChartSettingCollection;
import com.kingdee.shr.orgchart.OrgChartSettingFactory;
import com.kingdee.shr.orgchart.SelectedConfigCollection;
import com.kingdee.shr.orgchart.SelectedConfigFactory;
import com.kingdee.shr.orgchart.util.HROrgChartUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigRepository {
    private static final ConfigRepository repository = new ConfigRepository();
    private static final Logger logger = Logger.getLogger(ConfigRepository.class);
    private Map<String, Map<String, Object>> allDCsConfigCache = Collections.synchronizedMap(new HashMap());

    private ConfigRepository() {
    }

    public static ConfigRepository getInstance() {
        return repository;
    }

    public void initialize(Context ctx) throws BOSException, EASBizException {
        if (this.allDCsConfigCache.get(ctx.getAIS()) != null) {
            return;
        }
        this.doInitialize(ctx);
    }

    private synchronized void doInitialize(Context ctx) throws BOSException, EASBizException {
        if (ctx == null || ctx.getAIS() == null || ctx.getAIS().trim().length() == 0) {
            ArrayList newList = HROrgChartUtil.getDCList();
            String dbString = null;
            for (int i = 0; i < newList.size(); ++i) {
                try {
                    DCInfo info = (DCInfo)newList.get(i);
                    Context newCtx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                    newCtx.setUserName(info.getUserName());
                    newCtx.put((Object)"dbType", (Object)HROrgChartUtil.getDBType(info.getDBType()));
                    dbString = info.getNumber() + "-" + info.getDataSource();
                    this.initOneDC(newCtx);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("init service config  lose = " + dbString + e.getMessage()));
                }
            }
        } else {
            this.initOneDC(ctx);
        }
    }

    private void initOneDC(Context ctx) throws BOSException, EASBizException {
        long start = Calendar.getInstance().getTimeInMillis();
        try {
            OrgChartSettingCollection orgChartSettingCollection = OrgChartSettingFactory.getLocalInstance(ctx).getOrgChartSettingCollection();
            SelectedConfigCollection selectedConfigCollection = SelectedConfigFactory.getLocalInstance(ctx).getSelectedConfigCollection();
            if (orgChartSettingCollection == null) {
                return;
            }
            String dbKey = ctx.getAIS();
            int size = orgChartSettingCollection.size();
            for (int i = 0; i < size; ++i) {
                Map<Object, Object> oneDCConfig = null;
                if (this.allDCsConfigCache.get(dbKey) == null) {
                    oneDCConfig = Collections.synchronizedMap(new HashMap());
                    this.allDCsConfigCache.put(dbKey, oneDCConfig);
                } else {
                    oneDCConfig = this.allDCsConfigCache.get(dbKey);
                }
                oneDCConfig.put("setting", (Object)orgChartSettingCollection);
                oneDCConfig.put("selectedConfig", (Object)orgChartSettingCollection);
            }
            long time = Calendar.getInstance().getTimeInMillis() - start;
            logger.info((Object)("Time consuming to initialize card template configuration registry\uff1a" + time + "ms."));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)((Object)new OrgChartBizException(OrgChartBizException.LOAD_REG_INFO_ERRORS, e)));
        }
    }
}

