/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractEvaResultSummaryAuditBillControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillEntryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillEntryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillEntryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.util.EvaResultSummaryBillUtil;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaResultSummaryAuditBillControllerBean
extends AbstractEvaResultSummaryAuditBillControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("billState", (Object)HRBillStateEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    @Override
    protected String _createAuditBill(Context ctx, String ids) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("evaPlan.name"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.id"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.name"));
        sic.add(new SelectorItemInfo("evaPlan.belongOrg.id"));
        evi.setSelector(sic);
        EvaResultSummaryCollection evaResultColl = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(evi);
        if (!evaResultColl.isEmpty()) {
            EvaResultSummaryAuditBillInfo evaResultAuditBillInfo = new EvaResultSummaryAuditBillInfo();
            PerfPeriodInfo periodInfo = evaResultColl.get(0).getPeriod();
            PerfPlanInfo planInfo = evaResultColl.get(0).getEvaPlan();
            evaResultAuditBillInfo.put("period", periodInfo.getId().toString());
            evaResultAuditBillInfo.put("hrOrgUnit", planInfo.getHrUnitOrg());
            evaResultAuditBillInfo.put("adminOrg", planInfo.getBelongOrg().getId().toString());
            evaResultAuditBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            evaResultAuditBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            evaResultAuditBillInfo.setBillState(HRBillStateEnum.SAVED);
            int evaResultSize = evaResultColl.size();
            CoreBaseCollection entryColl = new CoreBaseCollection();
            for (int i = 0; i < evaResultSize; ++i) {
                EvaResultSummaryAuditBillEntryInfo entryInfo = new EvaResultSummaryAuditBillEntryInfo();
                entryInfo.setBill(evaResultAuditBillInfo);
                entryInfo.put("evaResult", evaResultColl.get(i).getId().toString());
                entryInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                entryInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                entryColl.add((CoreBaseInfo)entryInfo);
            }
            try {
                evaResultAuditBillInfo.put("entrys", entryColl);
                IObjectPK auditBillId = EvaResultSummaryAuditBillFactory.getLocalInstance(ctx).addnew(evaResultAuditBillInfo);
                CoreBaseCollection resultColl = new CoreBaseCollection();
                for (int j = 0; j < evaResultSize; ++j) {
                    evaResultColl.get(j).setIsCreateAuditBill(YesOrNoEnum.YES);
                    resultColl.add((CoreBaseInfo)evaResultColl.get(j));
                }
                EvaResultSummaryFactory.getLocalInstance(ctx).save(resultColl);
                return auditBillId.toString();
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected String _addRowEntrys(Context ctx, String ids, String billId) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("evaPlan.name"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.id"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.name"));
        sic.add(new SelectorItemInfo("evaPlan.belongOrg.id"));
        evi.setSelector(sic);
        EvaResultSummaryCollection evaResultColl = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(evi);
        int evaResultSize = evaResultColl.size();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        CoreBaseCollection resultColl = new CoreBaseCollection();
        for (int j = 0; j < evaResultSize; ++j) {
            EvaResultSummaryAuditBillEntryInfo entryInfo = new EvaResultSummaryAuditBillEntryInfo();
            entryInfo.put("bill", billId);
            entryInfo.setEvaResult(evaResultColl.get(j));
            entryColl.add((CoreBaseInfo)entryInfo);
            evaResultColl.get(j).setIsCreateAuditBill(YesOrNoEnum.YES);
            resultColl.add((CoreBaseInfo)evaResultColl.get(j));
        }
        try {
            EvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).addnew(entryColl);
            EvaResultSummaryFactory.getLocalInstance(ctx).save(resultColl);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return null;
    }

    @Override
    protected String _deleteRowEntrys(Context ctx, String ids, String billId) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        Object[] billIdArr = billId.split(",");
        HashSet billIdSet = new HashSet(Arrays.asList((Object[])billIdArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("bill", billIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaResult.id"));
        evi.setSelector(sic);
        EvaResultSummaryAuditBillEntryCollection evaResultAuditBillEntryColl = EvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).getEvaResultSummaryAuditBillEntryCollection(evi);
        int size = evaResultAuditBillEntryColl.size();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        for (int j = 0; j < size; ++j) {
            EvaResultSummaryInfo evaResultInfo = evaResultAuditBillEntryColl.get(j).getEvaResult();
            evaResultInfo.setIsCreateAuditBill(YesOrNoEnum.NO);
            entryColl.add((CoreBaseInfo)evaResultInfo);
        }
        try {
            EvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).delete(filter);
            SelectorItemCollection updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("isCreateAuditBill"));
            EvaResultSummaryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)entryColl, updateSic);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return null;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        List<String> needUpdateStateResultIds = EvaResultSummaryBillUtil.getNeedUpdateIsCreateBillStateIds(model, false);
        IObjectPK save = super.save(ctx, model);
        if (needUpdateStateResultIds.size() > 0) {
            DbUtil.execute((Context)ctx, (String)("update T_EVA_EvaResultSummary set FIsCreateAuditBill = 1 where fid in('" + StringUtils.join(needUpdateStateResultIds, (String)"','") + "')"));
        }
        return save;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EvaResultSummaryAuditBillEntryCollection entrys;
        EvaResultSummaryAuditBillInfo billInfo = (EvaResultSummaryAuditBillInfo)model;
        if (billInfo.getHrOrgUnit() == null) {
            billInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if ((entrys = billInfo.getEntrys()) == null || entrys.isEmpty()) {
            EvaResultSummaryAuditBillInfo oldInfo = (EvaResultSummaryAuditBillInfo)this._getValue(ctx, "select id, entrys.*  where id = '" + pk.toString() + "'");
            model.put("entrys", oldInfo.get("entrys"));
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _deleteAuditBill(Context ctx, String billIds) throws BOSException {
        Object[] idArr = billIds.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        this.deleteRowEntrys(ctx, "", billIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        try {
            EvaResultSummaryAuditBillFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
    }

    @Override
    protected void _cancelBill(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isNotEmpty((CharSequence)billIds)) {
            block3: {
                try {
                    TheThirdMessageUtil.recycleWFAssign(ctx, billIds);
                }
                catch (Exception e) {
                    String message = "recycle the third message failed,billID:('" + billIds + "')";
                    if (!logger.isDebugEnabled()) break block3;
                    logger.error(message, (Throwable)e);
                }
            }
            DbUtil.execute((Context)ctx, (String)("UPDATE T_EVA_EvaResultAuditBill SET FBillState=0 WHERE FID in('" + billIds.replace(",", "','") + "')"));
        }
    }
}

