/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractOrgEvaResultSummaryAuditBillControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummaryAuditBill;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummaryAuditBillEntry;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillEntryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillEntryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillEntryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.util.EvaResultSummaryBillUtil;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgEvaResultSummaryAuditBillControllerBean
extends AbstractOrgEvaResultSummaryAuditBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("billState", (Object)HRBillStateEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    @Override
    protected String _createAuditBill(Context ctx, String ids) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("evaPlan.name"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.id"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.name"));
        sic.add(new SelectorItemInfo("evaPlan.belongOrg.id"));
        evi.setSelector(sic);
        OrgEvaResultSummaryCollection evaResultColl = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(evi);
        if (!evaResultColl.isEmpty()) {
            OrgEvaResultSummaryAuditBillInfo orgEvaResultAuditBillInfo = new OrgEvaResultSummaryAuditBillInfo();
            PerfPeriodInfo periodInfo = evaResultColl.get(0).getPeriod();
            PerfPlanInfo planInfo = evaResultColl.get(0).getEvaPlan();
            orgEvaResultAuditBillInfo.put("period", periodInfo.getId().toString());
            orgEvaResultAuditBillInfo.put("hrOrgUnit", planInfo.getHrUnitOrg());
            orgEvaResultAuditBillInfo.put("adminOrg", planInfo.getBelongOrg().getId().toString());
            orgEvaResultAuditBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            orgEvaResultAuditBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            orgEvaResultAuditBillInfo.setBillState(HRBillStateEnum.SAVED);
            int evaResultSize = evaResultColl.size();
            CoreBaseCollection entryColl = new CoreBaseCollection();
            for (int i = 0; i < evaResultSize; ++i) {
                OrgEvaResultSummaryAuditBillEntryInfo entryInfo = new OrgEvaResultSummaryAuditBillEntryInfo();
                entryInfo.setBill(orgEvaResultAuditBillInfo);
                entryInfo.put("evaResult", evaResultColl.get(i).getId().toString());
                entryInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                entryInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                entryColl.add((CoreBaseInfo)entryInfo);
            }
            try {
                orgEvaResultAuditBillInfo.put("entrys", entryColl);
                IObjectPK auditBillId = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx).addnew(orgEvaResultAuditBillInfo);
                CoreBaseCollection resultColl = new CoreBaseCollection();
                for (int j = 0; j < evaResultSize; ++j) {
                    evaResultColl.get(j).setIsCreateAuditBill(YesOrNoEnum.YES);
                    resultColl.add((CoreBaseInfo)evaResultColl.get(j));
                }
                OrgEvaResultSummaryFactory.getLocalInstance(ctx).save(resultColl);
                return auditBillId.toString();
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected String _addRowEntrys(Context ctx, String ids, String billId) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("evaPlan.name"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.id"));
        sic.add(new SelectorItemInfo("evaPlan.hrUnitOrg.name"));
        sic.add(new SelectorItemInfo("evaPlan.belongOrg.id"));
        evi.setSelector(sic);
        OrgEvaResultSummaryCollection evaResultColl = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(evi);
        int evaResultSize = evaResultColl.size();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        CoreBaseCollection resultColl = new CoreBaseCollection();
        for (int j = 0; j < evaResultSize; ++j) {
            OrgEvaResultSummaryAuditBillEntryInfo entryInfo = new OrgEvaResultSummaryAuditBillEntryInfo();
            entryInfo.put("bill", billId);
            entryInfo.setEvaResult(evaResultColl.get(j));
            entryColl.add((CoreBaseInfo)entryInfo);
            evaResultColl.get(j).setIsCreateAuditBill(YesOrNoEnum.YES);
            resultColl.add((CoreBaseInfo)evaResultColl.get(j));
        }
        try {
            OrgEvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).addnew(entryColl);
            OrgEvaResultSummaryFactory.getLocalInstance(ctx).save(resultColl);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return null;
    }

    @Override
    protected String _deleteRowEntrys(Context ctx, String ids, String billId) throws BOSException {
        Object[] idArr = ids.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        Object[] billIdArr = billId.split(",");
        HashSet billIdSet = new HashSet(Arrays.asList((Object[])billIdArr));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("bill", billIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaResult.id"));
        evi.setSelector(sic);
        OrgEvaResultSummaryAuditBillEntryCollection evaResultAuditBillEntryColl = OrgEvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryAuditBillEntryCollection(evi);
        int size = evaResultAuditBillEntryColl.size();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        for (int j = 0; j < size; ++j) {
            OrgEvaResultSummaryInfo evaResultInfo = evaResultAuditBillEntryColl.get(j).getEvaResult();
            evaResultInfo.setIsCreateAuditBill(YesOrNoEnum.NO);
            entryColl.add((CoreBaseInfo)evaResultInfo);
        }
        try {
            OrgEvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx).delete(filter);
            SelectorItemCollection updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("isCreateAuditBill"));
            OrgEvaResultSummaryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)entryColl, updateSic);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return null;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        List<String> needUpdateStateResultIds = EvaResultSummaryBillUtil.getNeedUpdateIsCreateBillStateIds(model, true);
        IObjectPK save = super.save(ctx, model);
        if (needUpdateStateResultIds.size() > 0) {
            DbUtil.execute((Context)ctx, (String)("update T_EVA_OrgEvaResultSummary set FIsCreateAuditBill = 1 where fid in('" + StringUtils.join(needUpdateStateResultIds, (String)"','") + "')"));
        }
        return save;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        OrgEvaResultSummaryAuditBillEntryCollection entrys;
        OrgEvaResultSummaryAuditBillInfo billInfo = (OrgEvaResultSummaryAuditBillInfo)model;
        if (billInfo.getHrOrgUnit() == null) {
            billInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if ((entrys = billInfo.getEntrys()) == null || entrys.isEmpty()) {
            OrgEvaResultSummaryAuditBillInfo oldInfo = (OrgEvaResultSummaryAuditBillInfo)this._getValue(ctx, "select id, entrys.*  where id = '" + pk.toString() + "'");
            model.put("entrys", oldInfo.get("entrys"));
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IOrgEvaResultSummaryAuditBill ievaResultAuditBill = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
        OrgEvaResultSummaryAuditBillInfo billInfo = ievaResultAuditBill.getOrgEvaResultSummaryAuditBillInfo((IObjectPK)new ObjectUuidPK(billId));
        billInfo.setBillState(HRBillStateEnum.AUDITED);
        billInfo.setAuditor(CurrentUserUtil.getUserInfoByPersonId(ctx, CurrentUserUtil.getCurrentPerson(ctx).getId().toString()));
        billInfo.setApplyDate(new Date());
        ievaResultAuditBill.save((CoreBaseInfo)billInfo);
        StringBuffer resultIdSb = new StringBuffer();
        IOrgEvaResultSummaryAuditBillEntry iEvaResultBillEntry = OrgEvaResultSummaryAuditBillEntryFactory.getLocalInstance(ctx);
        OrgEvaResultSummaryAuditBillEntryCollection evaResultAuditBillEntryColl = iEvaResultBillEntry.getOrgEvaResultSummaryAuditBillEntryCollection(" where bill='" + billId + "'");
        if (!evaResultAuditBillEntryColl.isEmpty()) {
            int entrySize = evaResultAuditBillEntryColl.size();
            for (int i = 0; i < entrySize; ++i) {
                if (i == 0) {
                    resultIdSb.append(evaResultAuditBillEntryColl.get(i).getEvaResult().getId().toString());
                    continue;
                }
                resultIdSb.append(",").append(evaResultAuditBillEntryColl.get(i).getEvaResult().getId().toString());
            }
        }
        OrgEvaResultSummaryControllerBean.getInstance().auditEvaResut(ctx, resultIdSb.toString(), false);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IOrgEvaResultSummaryAuditBill ievaResultAuditBill = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
        OrgEvaResultSummaryAuditBillInfo billInfo = ievaResultAuditBill.getOrgEvaResultSummaryAuditBillInfo((IObjectPK)new ObjectUuidPK(billId));
        billInfo.setBillState(HRBillStateEnum.AUDITEND);
        ievaResultAuditBill.save((CoreBaseInfo)billInfo);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException {
        IOrgEvaResultSummaryAuditBill ievaResultAuditBill = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
        try {
            OrgEvaResultSummaryAuditBillInfo billInfo = ievaResultAuditBill.getOrgEvaResultSummaryAuditBillInfo((IObjectPK)new ObjectUuidPK(billId));
            billInfo.setBillState(HRBillStateEnum.SUBMITED);
            ievaResultAuditBill.save((CoreBaseInfo)billInfo);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IOrgEvaResultSummaryAuditBill ievaResultAuditBill = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
        OrgEvaResultSummaryAuditBillInfo billInfo = ievaResultAuditBill.getOrgEvaResultSummaryAuditBillInfo((IObjectPK)new ObjectUuidPK(billId));
        billInfo.setBillState(HRBillStateEnum.SAVED);
        ievaResultAuditBill.save((CoreBaseInfo)billInfo);
    }

    @Override
    protected void _deleteAuditBill(Context ctx, String billIds) throws BOSException {
        Object[] idArr = billIds.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])idArr));
        this.deleteRowEntrys(ctx, "", billIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        try {
            OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
    }

    @Override
    protected void _cancelBill(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isNotEmpty((CharSequence)billIds)) {
            block3: {
                try {
                    TheThirdMessageUtil.recycleWFAssign(ctx, billIds);
                }
                catch (Exception e) {
                    String message = "recycle the third message failed,billID:('" + billIds + "')";
                    if (!logger.isDebugEnabled()) break block3;
                    logger.error(message, (Throwable)e);
                }
            }
            DbUtil.execute((Context)ctx, (String)("UPDATE T_EVA_OrgEvaResultAuditBill SET FBillState=0 WHERE FID in('" + billIds.replace(",", "','") + "')"));
            String updateResultStr = " update t_eva_orgevaresultsummary set FIsCreateAuditBill = 0 where fid in (select FEVARESULTID from T_EVA_OrgResultAuditBillEntry where FBILLID in ('" + billIds.replace(",", "','") + "'))";
            DbUtil.execute((Context)ctx, (String)updateResultStr);
        }
    }
}

