/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractTargetNodeControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.ITargetNode;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetEvaluModeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDef;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class TargetNodeControllerBean
extends AbstractTargetNodeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeControllerBean");
    private static final String TARGET_INDICATOR = "1";
    private static final String TARGET_RECORD = "2";

    @Override
    protected Map _reference(Context ctx, String targetIds, String period, String referPeriod, String workFlow, String referWorkFlow, boolean isOrg) throws BOSException, EASBizException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> targetIdSet = new HashSet<String>();
        targetIdSet.addAll(Arrays.asList(targetIds.split(",")));
        HashSet<String> perfFileIds = new HashSet<String>();
        Map<String, CoreBaseInfo> rTargetMap = this.getReferTargetMap(ctx, targetIdSet, perfFileIds, isOrg);
        if (CollectionUtils.isEmpty(rTargetMap)) {
            result.put("invalidParam", targetIdSet);
            return result;
        }
        Set<String> normalIndicators = this.getNormalIndicators(rTargetMap);
        targetIdSet.removeAll(normalIndicators);
        if (!CollectionUtils.isEmpty(normalIndicators)) {
            result.put("normalErr", normalIndicators);
        }
        if (CollectionUtils.isEmpty(targetIdSet)) {
            return result;
        }
        for (String item : normalIndicators) {
            rTargetMap.remove(item);
        }
        Map<String, CoreBaseInfo> targetMap = this.getCurrentTargetMap(ctx, period, workFlow, perfFileIds, isOrg);
        Map<String, String> targetRelationMap = this.getTargetRelationMap(ctx, targetIdSet, targetMap, rTargetMap);
        Set<String> hasRelations = targetRelationMap.keySet();
        targetIdSet.removeAll(hasRelations);
        result.put("noRelTarget", targetIdSet);
        if (hasRelations.size() > 0) {
            HashSet<String> hasTargetNodes = new HashSet<String>();
            TargetNodeCollection rTargetNodes = this.getReferTargetNodeColls(ctx, hasRelations, referWorkFlow);
            ITargetNode iTargetNode = TargetNodeFactory.getLocalInstance(ctx);
            if (rTargetNodes != null && !rTargetNodes.isEmpty()) {
                HashSet<String> nodeErr = new HashSet<String>();
                IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
                CoreBaseCollection colls = new CoreBaseCollection();
                Iterator it = rTargetNodes.iterator();
                while (it.hasNext()) {
                    CoreBaseInfo curTargetInfo;
                    TargetNodeInfo rNodeInfo = (TargetNodeInfo)it.next();
                    String targetId = rNodeInfo.getIndicatorId();
                    WFNodeDefInfo rNodeDefInfo = rNodeInfo.getWfNode();
                    WFNodeDefCollection nodeDefs = iwfNodeDef.getWFNodeDefCollection("where level=" + rNodeDefInfo.getLevel() + " and nodeSeq = " + rNodeDefInfo.getNodeSeq() + " and workflow = '" + workFlow + "'");
                    if (nodeDefs == null || nodeDefs.isEmpty()) {
                        nodeErr.add(targetId);
                        continue;
                    }
                    String currTargetId = targetRelationMap.get(targetId);
                    if (StringUtils.isEmpty((String)currTargetId) || (curTargetInfo = targetMap.get(currTargetId)) == null) continue;
                    PerfEvaObjectInfo evaObj = (PerfEvaObjectInfo)curTargetInfo.get("evaObj");
                    String evaObjId = evaObj.getId().toString();
                    WFNodeDefInfo nodeDefInfo = nodeDefs.get(0);
                    String curTargetId = targetRelationMap.get(targetId);
                    TargetNodeInfo nodeInfo = new TargetNodeInfo();
                    BeanUtils.copyProperties((Object)rNodeInfo, (Object)nodeInfo);
                    nodeInfo.put("wfNode", nodeDefInfo);
                    nodeInfo.put("evaObj", evaObj);
                    nodeInfo.setIndicatorId(curTargetId);
                    nodeInfo.setId(null);
                    colls.add((CoreBaseInfo)nodeInfo);
                    hasTargetNodes.add(targetId);
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObjId, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("wfNode", (Object)nodeDefInfo.getId().toString(), CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("indicatorId", (Object)curTargetId, CompareType.EQUALS));
                    iTargetNode.delete(filterInfo);
                }
                iTargetNode.save(colls);
                if (nodeErr.size() > 0) {
                    result.put("noRelWorkflow", nodeErr);
                }
            }
            hasRelations.removeAll(hasTargetNodes);
            if (hasRelations.size() > 0) {
                result.put("noData", hasRelations);
            }
        }
        return result;
    }

    private SelectorItemCollection getTargetInstSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("evaObj.id");
        selectors.add("evaObj.number");
        selectors.add("evaObj.perfFile.id");
        selectors.add("person.id");
        selectors.add("workFlow.id");
        selectors.add("workFlow.series");
        selectors.add("perfPeriod");
        selectors.add("refTarget");
        selectors.add("number");
        selectors.add("name");
        selectors.add("evaObj.canAdjustEvaluer");
        return selectors;
    }

    private SelectorItemCollection getRecordInstSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("evaObj.id");
        selectors.add("evaObj.number");
        selectors.add("evaObj.perfFile.id");
        selectors.add("person.id");
        selectors.add("workFlow.id");
        selectors.add("workFlow.series");
        selectors.add("perfPeriod");
        selectors.add("refTarget");
        selectors.add("keyCode");
        selectors.add("keyItem");
        selectors.add("evaObj.canAdjustEvaluer");
        return selectors;
    }

    private TargetNodeCollection getReferTargetNodeColls(Context ctx, Set<String> hasRelations, String referWorkFlow) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("indicatorId", hasRelations, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("wfNode.workflow.id", (Object)referWorkFlow));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("evaObj.id");
        selectors.add("evaObj.number");
        selectors.add("wfNode.id");
        selectors.add("wfNode.workflow");
        selectors.add("wfNode.level");
        selectors.add("wfNode.nodeSeq");
        selectors.add("indicatorId");
        selectors.add("indicatorType");
        selectors.add("person");
        selectors.add("personNumber");
        selectors.add("personName");
        selectors.add("weight");
        selectors.add("personPosition.id");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        ITargetNode iTargetNode = TargetNodeFactory.getLocalInstance(ctx);
        return iTargetNode.getTargetNodeCollection(evi);
    }

    private Map<String, CoreBaseInfo> getCurrentTargetMap(Context ctx, String period, String workFlow, Set<String> perfFileIds, boolean isOrg) throws BOSException {
        HashMap<String, CoreBaseInfo> targetMap = new HashMap<String, CoreBaseInfo>();
        SelectorItemCollection selectors = this.getTargetInstSelectors();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfPeriod", (Object)period));
        filterInfo.getFilterItems().add(new FilterItemInfo("workFlow.id", (Object)workFlow));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.canAdjustEvaluer", (Object)1));
        if (!CollectionUtils.isEmpty(perfFileIds)) {
            if (isOrg) {
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.number", perfFileIds, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.perfFile.id", perfFileIds, CompareType.INCLUDE));
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        IndicatorTargetCollection targets = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(evi);
        this.combineTargetMap(targets, targetMap, null, isOrg);
        selectors = this.getRecordInstSelectors();
        evi.setSelector(selectors);
        RecordTargetCollection records = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(evi);
        this.combineRecordTargetMap(records, targetMap, null, isOrg);
        return targetMap;
    }

    private Map<String, CoreBaseInfo> getReferTargetMap(Context ctx, Set<String> targetIds, Set<String> perfFileIds, boolean isOrg) throws BOSException {
        HashMap<String, CoreBaseInfo> targetMap = new HashMap<String, CoreBaseInfo>();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", targetIds, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(this.getTargetInstSelectors());
        IndicatorTargetCollection rTargets = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(evi);
        this.combineTargetMap(rTargets, targetMap, perfFileIds, isOrg);
        evi.setSelector(this.getRecordInstSelectors());
        RecordTargetCollection rRecords = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(evi);
        this.combineRecordTargetMap(rRecords, targetMap, perfFileIds, isOrg);
        return targetMap;
    }

    private Set<String> getNormalIndicators(Map<String, CoreBaseInfo> targetMap) {
        HashSet<String> indicators = new HashSet<String>();
        if (!CollectionUtils.isEmpty(targetMap)) {
            for (Map.Entry<String, CoreBaseInfo> item : targetMap.entrySet()) {
                Object targetId;
                PerfEvaObjectInfo evaObjectInfo;
                CoreBaseInfo target = item.getValue();
                if (target == null || (evaObjectInfo = (PerfEvaObjectInfo)target.get("evaObj")) == null || !TargetEvaluModeEnum.NOMORAL.equals((Object)evaObjectInfo.getCanAdjustEvaluer()) || (targetId = target.get("id")) == null) continue;
                indicators.add(targetId.toString());
            }
        }
        return indicators;
    }

    private Map<String, String> getTargetRelationMap(Context ctx, Set<String> targetIdSet, Map<String, CoreBaseInfo> targetMap, Map<String, CoreBaseInfo> rTargetMap) {
        HashMap<String, String> targetRelationMap = new HashMap<String, String>();
        if (targetMap.size() > 0) {
            for (Map.Entry<String, CoreBaseInfo> item : targetMap.entrySet()) {
                boolean isRefered = false;
                HashMap<String, String> referTargetMap2 = new HashMap<String, String>();
                CoreBaseInfo curInfo = item.getValue();
                String curTargetId = item.getKey();
                String curRefTargetId = StringUtils.cnulls((Object)curInfo.get("refTarget"));
                String curPerfFileId = StringUtils.cnulls((Object)curInfo.get("perfFileId"));
                String curNumber = StringUtils.cnulls((Object)curInfo.get("number"));
                String curName = StringUtils.cnulls((Object)curInfo.get("name"));
                String curTargetType = (String)curInfo.get("targetType");
                if (TARGET_RECORD.equals(curTargetType)) {
                    curNumber = StringUtils.cnulls((Object)curInfo.get("keyCode"));
                    curName = StringUtils.cnulls((Object)curInfo.get("keyItem"));
                }
                for (Map.Entry<String, CoreBaseInfo> refItem : rTargetMap.entrySet()) {
                    CoreBaseInfo refInfo = refItem.getValue();
                    String refTargetId = refItem.getKey();
                    String refRefTargetId = StringUtils.cnulls((Object)refInfo.get("refTarget"));
                    String refPerfFileId = StringUtils.cnulls((Object)refInfo.get("perfFileId"));
                    if (!curPerfFileId.equals(refPerfFileId)) continue;
                    if (!StringUtils.isEmpty((String)curRefTargetId) && curRefTargetId.equals(refRefTargetId)) {
                        targetRelationMap.put(refTargetId, curTargetId);
                        isRefered = true;
                        break;
                    }
                    String refNumber = StringUtils.cnulls((Object)refInfo.get("number"));
                    String refName = StringUtils.cnulls((Object)refInfo.get("name"));
                    String refTargetType = (String)refInfo.get("targetType");
                    if (TARGET_RECORD.equals(refTargetType)) {
                        refNumber = StringUtils.cnulls((Object)refInfo.get("keyCode"));
                        refName = StringUtils.cnulls((Object)refInfo.get("keyItem"));
                    }
                    if (!curTargetType.equals(refTargetType) || !curNumber.equals(refNumber) || !curName.equals(refName)) continue;
                    referTargetMap2.put(refTargetId, curTargetId);
                }
                if (isRefered) continue;
                targetRelationMap.putAll(referTargetMap2);
            }
        }
        return targetRelationMap;
    }

    private void combineTargetMap(IndicatorTargetCollection targets, Map<String, CoreBaseInfo> targetMap, Set<String> perfFileIds, boolean isOrg) {
        if (targets != null && !targets.isEmpty()) {
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                IndicatorTargetInfo targetInfo = (IndicatorTargetInfo)it.next();
                targetInfo.put("targetType", TARGET_INDICATOR);
                targetMap.put(targetInfo.getId().toString(), (CoreBaseInfo)targetInfo);
                PerfEvaObjectInfo evaObj = targetInfo.getEvaObj();
                String perfFileId = evaObj.getNumber();
                if (!isOrg) {
                    perfFileId = evaObj.getPerfFile().getId().toString();
                }
                if (perfFileIds != null) {
                    perfFileIds.add(perfFileId);
                }
                targetInfo.put("perfFileId", perfFileId);
            }
        }
    }

    private void combineRecordTargetMap(RecordTargetCollection records, Map<String, CoreBaseInfo> targetMap, Set<String> perfFileIds, boolean isOrg) {
        if (records != null && !records.isEmpty()) {
            Iterator it = records.iterator();
            while (it.hasNext()) {
                RecordTargetInfo recordInfo = (RecordTargetInfo)it.next();
                recordInfo.put("targetType", TARGET_RECORD);
                targetMap.put(recordInfo.getId().toString(), (CoreBaseInfo)recordInfo);
                PerfEvaObjectInfo evaObj = recordInfo.getEvaObj();
                String perfFileId = evaObj.getNumber();
                if (!isOrg) {
                    perfFileId = evaObj.getPerfFile().getId().toString();
                }
                if (perfFileIds != null) {
                    perfFileIds.add(perfFileId);
                }
                recordInfo.put("perfFileId", perfFileId);
            }
        }
    }
}

