/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.indecator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.shr.perfweb.app.base.indecator.AbstractIndecatorTypeControllerBean;
import com.kingdee.shr.perfweb.app.base.indecator.IndTypeStatusEnum;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeCollection;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorCollection;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorFactory;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorInfo;
import com.kingdee.shr.perfweb.app.base.indecator.ReferenceStatusEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndecatorTypeControllerBean
extends AbstractIndecatorTypeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeControllerBean");

    @Override
    protected void _doDisableTypes(Context ctx, String typeId) throws BOSException {
        if (StringUtils.isEmpty((String)typeId)) {
            return;
        }
        String updateSql = "UPDATE T_PEF_IndecatorType SET FStatus = ? WHERE FID = ? OR FParentTypeIds LIKE ? ";
        Object[] params = new Object[]{9, typeId, "%" + typeId + "%"};
        DbUtil.execute((Context)ctx, (String)"UPDATE T_PEF_IndecatorType SET FStatus = ? WHERE FID = ? OR FParentTypeIds LIKE ? ", (Object[])params);
    }

    @Override
    protected void _deleteSelfAndSubTypes(Context ctx, String typeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)typeId)) {
            return;
        }
        IndecatorTypeInfo typeInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(typeId));
        String deleteSql = "DELETE FROM T_PEF_IndecatorType WHERE (FID = ? OR FParentTypeIds LIKE ?) AND FISDEFAULT <> 1 ";
        Object[] params = new Object[]{typeId, "%" + typeId + "%"};
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_PEF_IndecatorType WHERE (FID = ? OR FParentTypeIds LIKE ?) AND FISDEFAULT <> 1 ", (Object[])params);
        if (typeInfo != null && typeInfo.getParent() != null && typeInfo.getParent().getId() != null) {
            this.updateParentTypeIsLeafValue(ctx, typeInfo.getParent().getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _addNewType(Context ctx, IndecatorTypeInfo model) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)model.getNumber()) || StringUtils.isEmpty((String)model.getName())) {
            return null;
        }
        model.setIsLeaf(true);
        if (model.getStatus() == null) {
            model.setStatus(IndTypeStatusEnum.UNUSABLE);
        }
        model.setRefStatus(ReferenceStatusEnum.UNREFERENCED);
        model.setIsDefault(false);
        String parentId = null;
        if (model.getParent() != null && model.getParent().getId() != null) {
            parentId = model.getParent().getId().toString();
        }
        if (parentId == null) {
            model.setLongNumber(model.getNumber());
            model.setParentTypeIds("");
            model.setLevel(1);
            model.setLongName(model.getName());
            return this._addnew(ctx, (IObjectValue)model);
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            mutexService.requestObjIDForUpdate(parentId);
            ObjectUuidPK parentPK = new ObjectUuidPK(parentId);
            IndecatorTypeInfo parent = this.getIndecatorTypeInfo(ctx, (IObjectPK)parentPK);
            if (parent == null) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.PARENTINDECATORTYPENOTFOUND, new Object[]{parentId});
            }
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                this._update(ctx, (IObjectPK)parentPK, (IObjectValue)parent);
            }
            model.setLevel(parent.getLevel() + 1);
            model.setLongNumber(parent.getLongNumber() + "!" + model.getNumber());
            model.setLongName(parent.getLongName() + "_" + model.getName());
            model.setParentTypeIds(parent.getParentTypeIds() == null ? "[" + parentId + "]" : parent.getParentTypeIds() + "," + "[" + parentId + "]");
            IObjectPK iObjectPK = this._addnew(ctx, (IObjectValue)model);
            return iObjectPK;
        }
        finally {
            mutexService.releaseObjIDForUpdate(parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateType(Context ctx, IObjectPK pk, IndecatorTypeInfo newModel) throws BOSException, EASBizException {
        if (newModel == null || pk == null || StringUtils.isEmpty((String)newModel.getNumber()) || StringUtils.isEmpty((String)newModel.getName())) {
            return;
        }
        IObjectPK baseInfoChangePK = super._beforeSaveOperation(ctx, (IObjectValue)newModel);
        List<String> relatedObjectIds = this.getRelatedObjectIdsWhenUpdate(ctx, pk, newModel);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            mutexService.batchRequestObjIDForUpdate(relatedObjectIds);
            IndecatorTypeInfo currentModel = this.getIndecatorTypeInfo(ctx, pk);
            if (currentModel == null) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.INDECATORTYPENOTFOUND, new Object[]{pk.toString()});
            }
            newModel.setIsDefault(false);
            newModel.setIsLeaf(currentModel.isIsLeaf());
            newModel.setStatus(currentModel.getStatus());
            newModel.setRefStatus(currentModel.getRefStatus());
            if (currentModel.getParent() != null && currentModel.getParent().getId() != null) {
                if (newModel.getParent() != null && newModel.getParent().getId() != null) {
                    if (!newModel.getParent().getId().equals((Object)currentModel.getParent().getId())) {
                        this.updateNewParentInfo(ctx, newModel);
                        this._update(ctx, pk, (IObjectValue)newModel);
                        this.updateChildrenNotesInfo(ctx, newModel, currentModel, true);
                        this.updateParentTypeIsLeafValue(ctx, currentModel.getParent().getId().toString());
                        this._writeReviseLog(ctx, (IObjectValue)newModel);
                        return;
                    }
                    newModel.setLevel(currentModel.getLevel());
                    newModel.setParentTypeIds(currentModel.getParentTypeIds());
                    if (currentModel.getNumber().equals(newModel.getNumber())) {
                        newModel.setLongNumber(currentModel.getLongNumber());
                    } else {
                        newModel.setLongNumber(currentModel.getLongNumber().substring(0, currentModel.getLongNumber().lastIndexOf("!") + 1) + newModel.getNumber());
                    }
                    if (currentModel.getName().equals(newModel.getName())) {
                        newModel.setLongName(currentModel.getLongName());
                    } else {
                        newModel.setLongName(currentModel.getLongName().substring(0, currentModel.getLongName().lastIndexOf("_") + 1) + newModel.getName());
                    }
                    this._update(ctx, pk, (IObjectValue)newModel);
                    this.updateChildrenNotesInfo(ctx, newModel, currentModel, false);
                    this._writeReviseLog(ctx, (IObjectValue)newModel);
                    return;
                }
                newModel.setLevel(1);
                newModel.setParentTypeIds("");
                newModel.setLongNumber(newModel.getNumber());
                newModel.setLongName(newModel.getName());
                this._update(ctx, pk, (IObjectValue)newModel);
                this.updateChildrenNotesInfo(ctx, newModel, currentModel, true);
                this.updateParentTypeIsLeafValue(ctx, currentModel.getParent().getId().toString());
                this._writeReviseLog(ctx, (IObjectValue)newModel);
                return;
            }
            if (newModel.getParent() != null && newModel.getParent().getId() != null) {
                this.updateNewParentInfo(ctx, newModel);
                this._update(ctx, pk, (IObjectValue)newModel);
                this.updateChildrenNotesInfo(ctx, newModel, currentModel, true);
                this._writeReviseLog(ctx, (IObjectValue)newModel);
                return;
            }
            newModel.setLevel(1);
            newModel.setParentTypeIds("");
            newModel.setLongNumber(newModel.getNumber());
            newModel.setLongName(newModel.getName());
            this._update(ctx, pk, (IObjectValue)newModel);
            this.updateChildrenNotesInfo(ctx, newModel, currentModel, false);
            this._writeReviseLog(ctx, (IObjectValue)newModel);
            return;
        }
        finally {
            mutexService.batchReleaseObjIDForUpdate(relatedObjectIds);
            if (BaseItemStateEnum.ENABLE.equals((Object)newModel.getState())) {
                if (null != baseInfoChangePK) {
                    this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                } else {
                    baseInfoChangePK = this._afterSaveOperation(ctx, pk.toString(), (IObjectValue)newModel);
                    if (null != baseInfoChangePK) {
                        this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                    }
                }
            }
        }
    }

    private List<String> getRelatedObjectIdsWhenUpdate(Context ctx, IObjectPK pk, IndecatorTypeInfo newModel) throws EASBizException, BOSException {
        IndecatorTypeInfo currentModel;
        ArrayList<String> ids = new ArrayList<String>();
        if (newModel.getParent() != null && newModel.getParent().getId() != null) {
            ids.add(newModel.getParent().getId().toString());
        }
        if ((currentModel = this.getIndecatorTypeInfo(ctx, pk)) != null) {
            if (currentModel.getParent() != null && currentModel.getParent().getId() != null) {
                ids.add(currentModel.getParent().getId().toString());
            }
            ids.add(currentModel.getId().toString());
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParentTypeIsLeafValue(Context ctx, String typeId) throws BOSException, EASBizException {
        if (typeId == null) {
            return;
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            mutexService.requestObjIDForUpdate(typeId);
            IndecatorTypeInfo typeInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(typeId));
            if (typeInfo == null) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.INDECATORTYPENOTFOUND, new Object[]{typeId});
            }
            IndecatorTypeCollection children = this.getIndecatorTypeCollection(ctx, "where parent.id = '" + typeId + "'");
            if (!typeInfo.isIsLeaf() && (children == null || children.isEmpty())) {
                typeInfo.setIsLeaf(true);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(typeId), (IObjectValue)typeInfo);
            }
        }
        finally {
            mutexService.releaseObjIDForUpdate(typeId);
        }
    }

    private void updateNewParentInfo(Context ctx, IndecatorTypeInfo newModel) throws BOSException, EASBizException {
        if (newModel == null || newModel.getParent() == null || newModel.getParent().getId() == null) {
            return;
        }
        ObjectUuidPK newParentPK = new ObjectUuidPK(newModel.getParent().getId());
        IndecatorTypeInfo newParent = this.getIndecatorTypeInfo(ctx, (IObjectPK)newParentPK);
        if (newParent == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARENTINDECATORTYPENOTFOUND, new Object[]{newParentPK.toString()});
        }
        if (newParent.isIsLeaf()) {
            newParent.setIsLeaf(false);
            this._update(ctx, (IObjectPK)newParentPK, (IObjectValue)newParent);
        }
        newModel.setLevel(newParent.getLevel() + 1);
        newModel.setParentTypeIds(newParent.getParentTypeIds() == null ? "[" + newParent.getId().toString() + "]" : newParent.getParentTypeIds() + "," + "[" + newParent.getId().toString() + "]");
        newModel.setLongNumber(newParent.getLongNumber() + "!" + newModel.getNumber());
        newModel.setLongName(newParent.getLongName() + "_" + newModel.getName());
    }

    private ArrayList<String> getTypeIds(IndecatorTypeCollection types) {
        ArrayList<String> ids = new ArrayList<String>();
        if (types != null) {
            for (int i = 0; i < types.size(); ++i) {
                if (types.get(i) == null) continue;
                ids.add(types.get(i).getId().toString());
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildrenNotesInfo(Context ctx, IndecatorTypeInfo newModel, IndecatorTypeInfo currentModel, boolean changeNode) throws BOSException {
        if (newModel == null || newModel.getId() == null || newModel.isIsLeaf()) {
            return;
        }
        String id = newModel.getId().toString();
        IndecatorTypeCollection children = this.getIndecatorTypeCollection(ctx, "where parentTypeIds like '%[" + id + "]%'");
        ArrayList<String> childrenIds = this.getTypeIds(children);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            mutexService.batchRequestObjIDForUpdate(childrenIds);
            if (changeNode) {
                this.updateChildrenParentTypeIds(ctx, newModel);
                this.updateChildrenLevel(ctx, id);
                this.updateChildrenlongNumber(ctx, newModel, currentModel.getNumber());
                this.updateChildrenlongName(ctx, newModel, currentModel.getLongName());
            } else {
                if (!currentModel.getNumber().equals(newModel.getNumber())) {
                    this.updateChildrenlongNumber(ctx, newModel, currentModel.getNumber());
                }
                if (!currentModel.getLongName().equals(newModel.getLongName())) {
                    this.updateChildrenlongName(ctx, newModel, currentModel.getLongName());
                }
            }
        }
        finally {
            mutexService.batchReleaseObjIDForUpdate(childrenIds);
        }
    }

    private void updateChildrenParentTypeIds(Context ctx, IndecatorTypeInfo typeInfo) throws BOSException {
        String id = typeInfo.getId().toString();
        String formatId = "[" + id + "]";
        String formatId2 = "%[" + id + "]%";
        String parentTypeIds = typeInfo.getParentTypeIds() == null ? "" : typeInfo.getParentTypeIds();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" UPDATE T_PEF_INDECATORTYPE                                                                                                                                  ");
        updateSql.append("    SET                                                                                                                                                      ");
        updateSql.append("    FPARENTTYPEIDS =                                                                                                                                         ");
        updateSql.append("      (CASE                                                                                                                                                  ");
        updateSql.append("       WHEN CHARINDEX(?, FPARENTTYPEIDS) <> 0 AND ? IS NOT NULL                                                                                              ");
        updateSql.append("         THEN ? || ',' || SUBSTRING(FPARENTTYPEIDS, CHARINDEX(?, FPARENTTYPEIDS),(LENGTH(FPARENTTYPEIDS) - CHARINDEX(?, FPARENTTYPEIDS) + 1))                ");
        updateSql.append("       WHEN CHARINDEX(?, FPARENTTYPEIDS) <> 0 AND ? IS NULL                                                                                                  ");
        updateSql.append("         THEN SUBSTRING(FPARENTTYPEIDS, CHARINDEX(?, FPARENTTYPEIDS),(LENGTH(FPARENTTYPEIDS) - CHARINDEX(?, FPARENTTYPEIDS) + 1))                            ");
        updateSql.append("       ELSE                                                                                                                                                  ");
        updateSql.append("         FPARENTTYPEIDS                                                                                                                                      ");
        updateSql.append("       END)                                                                                                                                                  ");
        updateSql.append("  WHERE FPARENTTYPEIDS LIKE ?                                                                                                                                ");
        Object[] params = new Object[]{formatId, parentTypeIds, parentTypeIds, formatId, formatId, formatId, parentTypeIds, formatId, formatId, formatId2};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
    }

    private void updateChildrenlongNumber(Context ctx, IndecatorTypeInfo typeInfo, String currentNumber) throws BOSException {
        String id = typeInfo.getId().toString();
        String formatId2 = "%[" + id + "]%";
        String formatNumber1 = currentNumber + "!";
        String formatNumber2 = "!" + currentNumber + "!";
        String longNumber = typeInfo.getLongNumber();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" UPDATE T_PEF_INDECATORTYPE                                                                                                                                  ");
        updateSql.append("    SET                                                                                                                                                      ");
        updateSql.append("    FLONGNUMBER =                                                                                                                                            ");
        updateSql.append("     (CASE                                                                                                                                                   ");
        updateSql.append("       WHEN CHARINDEX(?, FLONGNUMBER) = 1                                                                                                                    ");
        updateSql.append("         THEN ? || '!' || SUBSTRING(FLONGNUMBER, (1 + LENGTH(?)) ,(LENGTH(FLONGNUMBER) - LENGTH(?)))                                                         ");
        updateSql.append("       WHEN CHARINDEX(?, FLONGNUMBER) > 1                                                                                                                    ");
        updateSql.append("         THEN ? || '!' || SUBSTRING(FLONGNUMBER, (CHARINDEX(?, FLONGNUMBER) + LENGTH(?)) ,(LENGTH(FLONGNUMBER) - CHARINDEX(?, FLONGNUMBER) + 1 - LENGTH(?))) ");
        updateSql.append("       ELSE                                                                                                                                                  ");
        updateSql.append("         FLONGNUMBER                                                                                                                                         ");
        updateSql.append("       END)                                                                                                                                                  ");
        updateSql.append("  WHERE FPARENTTYPEIDS LIKE ?                                                                                                                                ");
        Object[] params = new Object[]{formatNumber1, longNumber, formatNumber1, formatNumber1, formatNumber2, longNumber, formatNumber2, formatNumber2, formatNumber2, formatNumber2, formatId2};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
    }

    private void updateChildrenlongName(Context ctx, IndecatorTypeInfo typeInfo, String currentLongName) throws BOSException {
        String formatId = "%[" + typeInfo.getId().toString() + "]%";
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE T_PEF_INDECATORTYPE                                                                  ");
        sql.append("    SET                                                                                      ");
        sql.append("    FLONGNAME =                                                                              ");
        sql.append("     (CASE                                                                                   ");
        sql.append("       WHEN CHARINDEX(?, FLONGNAME) = 1                                                      ");
        sql.append("         THEN ? || SUBSTRING(FLONGNAME, (LENGTH(?) + 1),(LENGTH(FLONGNAME) - LENGTH(?)))     ");
        sql.append("       ELSE                                                                                  ");
        sql.append("         FLONGNAME                                                                           ");
        sql.append("       END)                                                                                  ");
        sql.append("  WHERE FPARENTTYPEIDS LIKE ?                                                                ");
        Object[] params = new Object[]{currentLongName, typeInfo.getLongName(), currentLongName, currentLongName, formatId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void updateChildrenLevel(Context ctx, String id) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE T_PEF_INDECATORTYPE                                                               ");
        sql.append("    SET FLEVEL = (LENGTH(FPARENTTYPEIDS) - LENGTH(REPLACE(FPARENTTYPEIDS, ',', '')) + 2)  ");
        sql.append("  WHERE FPARENTTYPEIDS LIKE ?                                                             ");
        Object[] params = new Object[]{"%[" + id + "]%"};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    @Override
    protected void _referenceType(Context ctx, int operateFlag, String typeId) throws BOSException, EASBizException {
        if (typeId == null || operateFlag != 0 && operateFlag != 1) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARAMINVALID);
        }
        ObjectUuidPK pk = new ObjectUuidPK(typeId);
        IndecatorTypeInfo type = this.getIndecatorTypeInfo(ctx, (IObjectPK)pk);
        if (operateFlag == 0) {
            if (type != null && ReferenceStatusEnum.REFERENCED.equals((Object)type.getRefStatus())) {
                type.setRefStatus(ReferenceStatusEnum.UNREFERENCED);
                this._update(ctx, (IObjectPK)pk, (IObjectValue)type);
            }
        } else {
            if (type == null || !IndTypeStatusEnum.USABLE.equals((Object)type.getStatus()) || !type.isIsLeaf()) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.INDECATORTYPEINVALID);
            }
            if (!ReferenceStatusEnum.REFERENCED.equals((Object)type.getRefStatus())) {
                type.setRefStatus(ReferenceStatusEnum.REFERENCED);
                this._update(ctx, (IObjectPK)pk, (IObjectValue)type);
            }
        }
    }

    protected String _fillReviseLogContent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IndecatorTypeInfo parentInfo;
        IndecatorTypeInfo info = (IndecatorTypeInfo)model;
        UserInfo ouserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getCreator().getId()));
        UserInfo cuserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getLastUpdateUser().getId()));
        SHRBasicItemInfo shrBasicItemInfo = SHRBasicItemFactory.getLocalInstance((Context)ctx).getSHRBasicItemInfo((IObjectPK)new ObjectUuidPK(info.getShrBasicItem().getId()));
        HROrgUnitInfo hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getHrOrgUnit().getId()));
        HashMap<String, String> result = new HashMap<String, String>(3);
        ArrayList<Locale> langs = new ArrayList<Locale>(3);
        langs.add(LocaleUtils.locale_l1);
        langs.add(LocaleUtils.locale_l2);
        langs.add(LocaleUtils.locale_l3);
        Map systemFormat = UserNantionalUtil.getSystemSolutionNationalFormat((Context)ctx);
        String parentName = "";
        if (info.getParent() != null && info.getParent().getId() != null && (parentInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()))) != null) {
            parentName = parentInfo.getLongName();
        }
        for (Locale l : langs) {
            StringBuffer sb = new StringBuffer();
            sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TYPENAMEWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)info.getName())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TYPENUMBERWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)info.getNumber())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TYPEDESCRIPTIONWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)info.getDecription())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PARENTTYPEWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)parentName)})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.BASEITEMWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)shrBasicItemInfo.getName())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CREATEHRORGWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)hrOrgUnitInfo.getName())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SHAREPOLICYWITHSUFFIX, l, new Object[]{info.getUsePolicy().getAlias(l)})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMPRESETNORNOTWITHSUFFIX, l, new Object[]{info.isIsSysPreset() ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YES, l) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NO, l)})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STATEWITHSUFFIX, l, new Object[]{info.getState().getAlias(l)})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CREATORWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)(ouserInfo == null ? null : ouserInfo.getName()))})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CREATETIMESUFFIX, l, new Object[]{DateUtils.paseTimestamp2String((Timestamp)info.getLastUpdateTime(), (String)((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LASTUPDATORWITHSUFFIX, l, new Object[]{StringUtils.cnulls((String)(cuserInfo == null ? null : cuserInfo.getName()))})).append("\n").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LASTUPDATETIMEWITHSUFFIX, l, new Object[]{DateUtils.paseTimestamp2String((Timestamp)info.getLastUpdateTime(), (String)((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())})).append("\n");
            result.put(l.getDisplayName(), sb.toString());
        }
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SHRBaseItemInfo model = null;
        try {
            model = this.getSHRBaseItemInfo(ctx, (IObjectPK)pk, this.getShrBaseItemSelector());
        }
        catch (ObjectNotFoundException e) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMDELETED);
        }
        this.doState(ctx, model, BaseItemStateEnum.ENABLE);
        model.setState(BaseItemStateEnum.ENABLE);
        this._enableOrgRefBaseInfo(ctx, (IObjectValue)model);
    }

    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SHRBaseItemInfo model = this.getSHRBaseItemInfo(ctx, (IObjectPK)pk, this.getShrBaseItemSelector());
        this.doState(ctx, model, BaseItemStateEnum.DISABLE, false);
        model.setState(BaseItemStateEnum.DISABLE);
        this._disableOrgRefBaseInfo(ctx, (IObjectValue)model);
        this.disableChildTypes(ctx, id);
    }

    private void disableChildTypes(Context ctx, String id) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parentTypeIds", (Object)("%" + id + "%"), CompareType.LIKE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getShrBaseItemSelector());
        HashSet<String> indecatorTypeIds = new HashSet<String>();
        indecatorTypeIds.add(id);
        IndecatorTypeCollection indecatorTypeCollection = this.getIndecatorTypeCollection(ctx, evi);
        if (indecatorTypeCollection != null && indecatorTypeCollection.size() > 0) {
            for (int i = 0; i < indecatorTypeCollection.size(); ++i) {
                IndecatorTypeInfo model = indecatorTypeCollection.get(i);
                this.doState(ctx, model, BaseItemStateEnum.DISABLE, true);
                model.setState(BaseItemStateEnum.DISABLE);
                this._disableOrgRefBaseInfo(ctx, (IObjectValue)model);
                indecatorTypeIds.add(model.getId().toString());
            }
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("indecatorType", indecatorTypeIds, CompareType.INCLUDE));
        evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        PerfIndecatorCollection coll = PerfIndecatorFactory.getLocalInstance(ctx).getPerfIndecatorCollection(evi);
        if (coll != null && coll.size() > 0) {
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int j = 0; j < coll.size(); ++j) {
                PerfIndecatorInfo perfIndecatorInfo = coll.get(j);
                perfIndecatorInfo.setState(BaseItemStateEnum.DISABLE);
                coreBaseCollection.add((CoreBaseInfo)perfIndecatorInfo);
            }
            PerfIndecatorFactory.getLocalInstance(ctx).save(coreBaseCollection);
        }
    }

    private SelectorItemCollection getShrBaseItemSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("shrBasicItem.id"));
        selector.add(new SelectorItemInfo("usePolicy"));
        selector.add(new SelectorItemInfo("isSysPreset"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        return selector;
    }

    private void doState(Context ctx, SHRBaseItemInfo model, BaseItemStateEnum state) throws BOSException, EASBizException {
        if (null == model) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMNOTEXIST);
        }
        if (this.isParentTypeDisabled(ctx, model)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARENTINDECATORTYPEENABLEREQUIRED);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && !BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.DATADIABLEINVALIDERR);
        }
        if (BaseItemStateEnum.ENABLE.equals((Object)state) && BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.DATAENABLEINVALIDERR);
        }
        if (null == model.getHrOrgUnit() || StringUtils.isEmpty((String)model.getHrOrgUnit().getNumber())) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.HRORGREQUIEDFORCREATEBASEITM);
        }
        SHRBaseItemInfo updateModel = new SHRBaseItemInfo();
        updateModel.setId(model.getId());
        updateModel.setState(state);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        this.updatePartial(ctx, (CoreBaseInfo)updateModel, selector);
    }

    private void doState(Context ctx, SHRBaseItemInfo model, BaseItemStateEnum state, boolean flag) throws BOSException, EASBizException {
        if (null == model) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMNOTEXIST);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && BaseItemStateEnum.NEW.equals((Object)model.getState())) {
            if (flag) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.SUBTYPEUNENABLEEXIST);
            }
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMDIABLEERR);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            if (!flag) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMDIABLED);
            }
        } else if (BaseItemStateEnum.ENABLE.equals((Object)state) && BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            if (!flag) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMENABLED);
            }
        } else if (null != model.getHrOrgUnit() && !StringUtils.isEmpty((String)model.getHrOrgUnit().getNumber())) {
            SHRBaseItemInfo updateModel = new SHRBaseItemInfo();
            updateModel.setId(model.getId());
            updateModel.setState(state);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("state");
            this.updatePartial(ctx, (CoreBaseInfo)updateModel, selector);
        } else {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.HRORGREQUIEDFORCREATEBASEITM);
        }
    }

    private boolean isParentTypeDisabled(Context ctx, SHRBaseItemInfo model) throws EASBizException, BOSException {
        IndecatorTypeInfo parentTypeInfo;
        IndecatorTypeInfo indecatorTypeInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
        return indecatorTypeInfo.getParent() != null && BaseItemStateEnum.DISABLE.equals((Object)(parentTypeInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(indecatorTypeInfo.getParent().getId()))).getState());
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (null == pk) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.IDREQUIEDFORDELETE);
        }
        SHRBaseItemInfo model = this.getSHRBaseItemInfo(ctx, pk);
        this._beforeDeleteOperation(ctx, (IObjectValue)model, false);
        try {
            IndecatorTypeInfo indecatorTypeInfo = this.getIndecatorTypeInfo(ctx, pk);
            super._delete(ctx, pk);
            this.deleteChildTypes(ctx, pk);
            if (indecatorTypeInfo.getParent() != null) {
                IndecatorTypeInfo updateParentInfo = this.getIndecatorTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(indecatorTypeInfo.getParent().getId()));
                updateParentInfo.setIsLeaf(true);
                this.save(ctx, (CoreBaseInfo)updateParentInfo);
            }
        }
        catch (ObjectReferedException var5) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMREFEREDDELINVALID, new Object[]{model.getNumber()});
        }
    }

    private void deleteChildTypes(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parentTypeIds", (Object)("%" + pk.toString() + "%"), CompareType.LIKE));
        evi.setFilter(filterInfo);
        IndecatorTypeCollection indecatorTypeCollection = this.getIndecatorTypeCollection(ctx, evi);
        if (indecatorTypeCollection != null && indecatorTypeCollection.size() > 0) {
            for (int i = 0; i < indecatorTypeCollection.size(); ++i) {
                this._beforeDeleteOperation(ctx, (IObjectValue)indecatorTypeCollection.get(i), false);
                super._delete(ctx, pk);
            }
        }
    }

    protected IObjectPK[] _beforeDeleteOperation(Context ctx, IObjectValue shrBaseItem, boolean flag) throws BOSException, EASBizException {
        SHRBaseItemInfo model = (SHRBaseItemInfo)shrBaseItem;
        if (null == model) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMNOTEXIST);
        }
        if (model.isIsSysPreset()) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.SYSINNERDATADELERR, new Object[]{model.getNumber()});
        }
        IObjectPK[] baseInfoOrgRefPK = null;
        if (BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            if (flag) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.SUBTYPEENABLEEXIST, new Object[]{model.getNumber()});
            }
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMENABLEDDELINVALID, new Object[]{model.getNumber()});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            if (flag) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.SUBTYPEDISABLEEXIST, new Object[]{model.getNumber()});
            }
            throw new SHRPerfWebBizException(SHRPerfWebBizException.BASEITEMDISABLEDDELINVALID, new Object[]{model.getNumber()});
        }
        return baseInfoOrgRefPK;
    }
}

