/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.talentReview;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.SystemUnifiedLevelCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.SystemUnifiedLevelFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.SystemUnifiedLevelInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.AbstractTalentReviewRuleControllerBean;
import com.kingdee.shr.perfweb.app.base.talentReview.DistributionBasisTypeEnum;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorDetailFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorLevelDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorLevelDetailFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorLevelDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerDetailFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerLevelDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerLevelDetailFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerLevelDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalentReviewRuleControllerBean
extends AbstractTalentReviewRuleControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TalentReviewRuleInfo ruleInfo = (TalentReviewRuleInfo)model;
        if (ruleInfo.getId() != null) {
            String id = ruleInfo.getId().toString();
            TalentReviewRuleHorLevelDetailFactory.getLocalInstance(ctx).delete("where horDetail.reviewRule = '" + id + "'");
            TalentReviewRuleVerLevelDetailFactory.getLocalInstance(ctx).delete("where verDetail.reviewRule = '" + id + "'");
            this.reSeqContent(ctx, ruleInfo);
        }
        this.setSystemUnifiedLevel(ctx, ruleInfo);
        TalentReviewSolutionInfo solutionInfo = new TalentReviewSolutionInfo();
        solutionInfo.setRegenerateResult(true);
        solutionInfo.setId(ruleInfo.getSolution().getId());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("regenerateResult"));
        TalentReviewSolutionFactory.getLocalInstance(ctx).updatePartial(solutionInfo, selectors);
        return super._save(ctx, model);
    }

    private void setSystemUnifiedLevel(Context ctx, TalentReviewRuleInfo ruleInfo) throws BOSException {
        SystemUnifiedLevelCollection systemLevels = SystemUnifiedLevelFactory.getLocalInstance(ctx).getSystemUnifiedLevelCollection();
        HashMap<String, SystemUnifiedLevelInfo> levelMap = new HashMap<String, SystemUnifiedLevelInfo>();
        if (systemLevels != null && !systemLevels.isEmpty()) {
            Iterator it = systemLevels.iterator();
            while (it.hasNext()) {
                SystemUnifiedLevelInfo info = (SystemUnifiedLevelInfo)it.next();
                levelMap.put(info.getName(), info);
            }
            if (DistributionBasisTypeEnum.LEVEL.equals((Object)ruleInfo.getHorDistributionType())) {
                Iterator horIt = ruleInfo.getHorDistributions().iterator();
                while (horIt.hasNext()) {
                    TalentReviewRuleHorDetailInfo horInfo = (TalentReviewRuleHorDetailInfo)horIt.next();
                    TalentReviewRuleHorLevelDetailCollection horLevels = horInfo.getLevels();
                    Iterator horLevelIt = horLevels.iterator();
                    while (horLevelIt.hasNext()) {
                        TalentReviewRuleHorLevelDetailInfo horLevelDetailInfo = (TalentReviewRuleHorLevelDetailInfo)horLevelIt.next();
                        horLevelDetailInfo.setSystemLevel((SystemUnifiedLevelInfo)levelMap.get(horLevelDetailInfo.getName()));
                    }
                }
            }
            if (DistributionBasisTypeEnum.LEVEL.equals((Object)ruleInfo.getVerDistributionType())) {
                Iterator verIt = ruleInfo.getVerDistributions().iterator();
                while (verIt.hasNext()) {
                    TalentReviewRuleVerDetailInfo verInfo = (TalentReviewRuleVerDetailInfo)verIt.next();
                    TalentReviewRuleVerLevelDetailCollection verLevels = verInfo.getLevels();
                    Iterator verLevelIt = verLevels.iterator();
                    while (verLevelIt.hasNext()) {
                        TalentReviewRuleVerLevelDetailInfo verLevelDetailInfo = (TalentReviewRuleVerLevelDetailInfo)verLevelIt.next();
                        verLevelDetailInfo.setSystemLevel((SystemUnifiedLevelInfo)levelMap.get(verLevelDetailInfo.getName()));
                    }
                }
            }
        }
    }

    private void reSeqContent(Context ctx, TalentReviewRuleInfo ruleInfo) throws BOSException, EASBizException {
        String id = ruleInfo.getId().toString();
        String solutionId = ruleInfo.getSolution().getId().toString();
        TalentReviewContentCollection contentColls = TalentReviewContentFactory.getLocalInstance(ctx).getTalentReviewContentCollection("where solution = '" + solutionId + "' order by seq");
        if (contentColls != null && !contentColls.isEmpty()) {
            TalentReviewRuleHorDetailCollection horColls = TalentReviewRuleHorDetailFactory.getLocalInstance(ctx).getTalentReviewRuleHorDetailCollection("select id, seq where reviewRule = '" + id + "'");
            TalentReviewRuleVerDetailCollection verColls = TalentReviewRuleVerDetailFactory.getLocalInstance(ctx).getTalentReviewRuleVerDetailCollection("select id, seq where reviewRule = '" + id + "'");
            int horSize = horColls.size();
            int verSize = verColls.size();
            if (horColls != null && !horColls.isEmpty()) {
                TalentReviewContentInfo contentInfo;
                HashSet<Integer> toDelContentSeqs = new HashSet<Integer>();
                HashSet<Integer> toAddContentSeqs = new HashSet<Integer>();
                TalentReviewRuleControllerBean.getHorToDelOrAddDistributions(horColls, verSize, ruleInfo, toDelContentSeqs, toAddContentSeqs);
                TalentReviewRuleControllerBean.getVerToDelOrAddDistributions(verColls, horSize, ruleInfo, toDelContentSeqs, toAddContentSeqs);
                if (toDelContentSeqs.size() > 0) {
                    Iterator contentIt = contentColls.iterator();
                    while (contentIt.hasNext()) {
                        TalentReviewContentInfo contentInfo2 = (TalentReviewContentInfo)contentIt.next();
                        Integer seq = contentInfo2.getSeq();
                        if (!toDelContentSeqs.contains(seq)) continue;
                        contentIt.remove();
                    }
                }
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                int remainSize = contentColls.size();
                HashSet<Integer> reSeqs = new HashSet<Integer>();
                reSeqs.addAll(toAddContentSeqs);
                for (int i = 0; i < remainSize; ++i) {
                    int reSeq = i;
                    if (reSeqs.contains(reSeq)) {
                        while (reSeqs.contains(reSeq)) {
                            ++reSeq;
                        }
                    }
                    reSeqs.add(reSeq);
                    contentInfo = contentColls.get(i);
                    contentInfo.setSeq(reSeq);
                    coreBaseCollection.add((CoreBaseInfo)contentInfo);
                }
                if (toDelContentSeqs.size() > 0) {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("seq", toDelContentSeqs, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId));
                    TalentReviewContentFactory.getLocalInstance(ctx).delete(filterInfo);
                }
                if (toAddContentSeqs.size() > 0) {
                    for (Integer seq : toAddContentSeqs) {
                        contentInfo = new TalentReviewContentInfo();
                        contentInfo.setSeq(seq);
                        contentInfo.put("solution", solutionId);
                        coreBaseCollection.add((CoreBaseInfo)contentInfo);
                    }
                }
                TalentReviewContentFactory.getLocalInstance(ctx).save(coreBaseCollection);
            }
        }
    }

    private static void getHorToDelOrAddDistributions(TalentReviewRuleHorDetailCollection horColls, int verSize, TalentReviewRuleInfo ruleInfo, Set<Integer> toDelContentSeqs, Set<Integer> toAddContentSeqs) {
        List<Integer> contentSeqs;
        HashMap<String, Integer> horMap = new HashMap<String, Integer>();
        Iterator horIt = horColls.iterator();
        while (horIt.hasNext()) {
            TalentReviewRuleHorDetailInfo horDetailInfo = (TalentReviewRuleHorDetailInfo)horIt.next();
            horMap.put(horDetailInfo.getId().toString(), horDetailInfo.getSeq());
        }
        HashSet<Integer> toAddHorSeqs = new HashSet<Integer>();
        Set horIds = horMap.keySet();
        HashMap<String, Integer> toUpdateHorMap = new HashMap<String, Integer>();
        TalentReviewRuleHorDetailCollection existHorColls = ruleInfo.getHorDistributions();
        Iterator horIt2 = existHorColls.iterator();
        while (horIt2.hasNext()) {
            TalentReviewRuleHorDetailInfo horDetailInfo = (TalentReviewRuleHorDetailInfo)horIt2.next();
            if (horDetailInfo.getId() != null) {
                toUpdateHorMap.put(horDetailInfo.getId().toString(), horDetailInfo.getSeq());
                continue;
            }
            toAddHorSeqs.add(horDetailInfo.getSeq());
        }
        Set toUpdateHorIds = toUpdateHorMap.keySet();
        horIds.removeAll(toUpdateHorIds);
        int horSize = horColls.size();
        for (String horId : horIds) {
            contentSeqs = TalentReviewRuleControllerBean.getContentRegion(horSize, verSize, (Integer)horMap.get(horId), true);
            toDelContentSeqs.addAll(contentSeqs);
        }
        horSize = existHorColls.size();
        for (Integer addSeq : toAddHorSeqs) {
            contentSeqs = TalentReviewRuleControllerBean.getContentRegion(horSize, verSize, addSeq, true);
            toAddContentSeqs.addAll(contentSeqs);
        }
    }

    private static void getVerToDelOrAddDistributions(TalentReviewRuleVerDetailCollection verColls, int horSize, TalentReviewRuleInfo ruleInfo, Set<Integer> toDelContentSeqs, Set<Integer> toAddContentSeqs) {
        List<Integer> contentSeqs;
        HashMap<String, Integer> verMap = new HashMap<String, Integer>();
        Iterator verIt = verColls.iterator();
        while (verIt.hasNext()) {
            TalentReviewRuleVerDetailInfo horDetailInfo = (TalentReviewRuleVerDetailInfo)verIt.next();
            verMap.put(horDetailInfo.getId().toString(), horDetailInfo.getSeq());
        }
        HashSet<Integer> toAddVerSeqs = new HashSet<Integer>();
        Set verIds = verMap.keySet();
        HashMap<String, Integer> toUpdateHorMap = new HashMap<String, Integer>();
        TalentReviewRuleVerDetailCollection existVerColls = ruleInfo.getVerDistributions();
        Iterator verIt2 = existVerColls.iterator();
        while (verIt2.hasNext()) {
            TalentReviewRuleVerDetailInfo verDetailInfo = (TalentReviewRuleVerDetailInfo)verIt2.next();
            if (verDetailInfo.getId() != null) {
                toUpdateHorMap.put(verDetailInfo.getId().toString(), verDetailInfo.getSeq());
                continue;
            }
            toAddVerSeqs.add(verDetailInfo.getSeq());
        }
        Set toUpdateHorIds = toUpdateHorMap.keySet();
        verIds.removeAll(toUpdateHorIds);
        int verSize = verColls.size();
        for (String verId : verIds) {
            contentSeqs = TalentReviewRuleControllerBean.getContentRegion(horSize, verSize, (Integer)verMap.get(verId), false);
            toDelContentSeqs.addAll(contentSeqs);
        }
        verSize = existVerColls.size();
        for (Integer addSeq : toAddVerSeqs) {
            contentSeqs = TalentReviewRuleControllerBean.getContentRegion(horSize, verSize, addSeq, false);
            toAddContentSeqs.addAll(contentSeqs);
        }
    }

    private static List<Integer> getContentRegion(int xSize, int ySize, int seq, boolean isX) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int count = 0;
        for (int j = 0; j < ySize; ++j) {
            for (int i = xSize - 1; i >= 0; --i) {
                if (isX && i == seq || !isX && j == seq) {
                    result.add(count);
                }
                ++count;
            }
        }
        return result;
    }
}

