/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.comprehensive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.AppealStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.comprehensive.AbstractSumCalResultAppealBillControllerBean;
import com.kingdee.shr.perfweb.app.comprehensive.ISumCalResultAppealBill;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillCollection;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillFactory;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class SumCalResultAppealBillControllerBean
extends AbstractSumCalResultAppealBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.perfweb.app.comprehensive.SumCalResultAppealBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String billId = model.get("id").toString();
        ISumCalResultAppealBill iEvaResultAppealBill = SumCalResultAppealBillFactory.getLocalInstance(ctx);
        SumCalResultAppealBillInfo billInfo = iEvaResultAppealBill.getSumCalResultAppealBillInfo(" select appealScore,appealGrade  where id ='" + billId + "'");
        Object appealScore = model.get("appealScore");
        Object appealGrade = model.get("appealGrade");
        if (billInfo != null) {
            this.updateEvaResultStatus(ctx, billId, AppealStateEnum.APPEALING.getValue());
            if (appealScore == null) {
                appealScore = billInfo.get("appealScore");
            }
            if (appealGrade == null) {
                appealGrade = billInfo.get("appealGrade");
            }
        }
        model.put("auditScore", appealScore);
        model.put("auditGrade", appealGrade);
        return super._submit(ctx, model);
    }

    private void updateEvaResultStatus(Context ctx, String billId, int appealState) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("update T_EVA_EvaResultSummary set FAppealState = ? where fid in(select FEvaResultID from  T_PEF_SumCalResultAppealBill where FID in('" + billId.replaceAll(",", "','") + "'))"), (Object[])new Object[]{appealState});
    }

    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super.setAuditEnd(ctx, billId);
        this.updateEvaResultStatus(ctx, billId.toString(), AppealStateEnum.FAILED.getValue());
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        ISumCalResultAppealBill iEvaResultAppealBill = SumCalResultAppealBillFactory.getLocalInstance(ctx);
        SumCalResultAppealBillInfo billInfo = iEvaResultAppealBill.getSumCalResultAppealBillInfo(" select auditScore,auditGrade, appealScore, appealGrade, evaResult.* , evaResult.evaPlan.appealDealType, perfScorLevelDefine.id, evaResult.perfScorLevel.perfLevelDefInfo.*, evaResult.summaryPersonEvaObject.perfSummarySchemeBase.perfRate.perfLevelDefInfo.*  where id ='" + billID + "'");
        if (billInfo != null) {
            EvaResultSummaryInfo summaryInfo = billInfo.getEvaResult();
            HashMap<String, String> appealInfo = new HashMap<String, String>();
            String perfScorLevelDefine = "";
            String appealGrade = billInfo.getAuditGrade();
            String appealScore = billInfo.getAuditScore();
            if (billInfo.getPerfScorLevelDefine() != null) {
                perfScorLevelDefine = billInfo.getPerfScorLevelDefine().getId().toString();
            } else {
                PerfScorLevelDefineCollection levels = summaryInfo.getPerfScorLevel() == null ? (summaryInfo.getSummaryPersonEvaObject().getPerfSummarySchemeBase().getPerfRate() != null ? summaryInfo.getSummaryPersonEvaObject().getPerfSummarySchemeBase().getPerfRate().getPerfLevelDefInfo() : null) : summaryInfo.getPerfScorLevel().getPerfLevelDefInfo();
                if (levels != null && !levels.isEmpty()) {
                    Iterator defineIt = levels.iterator();
                    while (defineIt.hasNext()) {
                        PerfScorLevelDefineInfo defineInfo = (PerfScorLevelDefineInfo)defineIt.next();
                        if (!defineInfo.getPerfLevelName().equals(appealGrade)) continue;
                        perfScorLevelDefine = defineInfo.getId().toString();
                        break;
                    }
                }
            }
            appealInfo.put("perfScorLevelDefine", perfScorLevelDefine);
            appealInfo.put("appealGrade", appealGrade);
            appealInfo.put("appealScore", appealScore);
            EvaResultSummaryFactory.getLocalInstance(ctx).dealAppealPass(summaryInfo, appealInfo);
        }
    }

    @Override
    protected void _withdrawBill(Context ctx, String billId) throws BOSException {
        block2: {
            DBUtil.execute((Context)ctx, (String)("update T_PEF_SumCalResultAppealBill set Fbillstate=0 where fid in ('" + billId.replace(",", "','") + "')"));
            try {
                TheThirdMessageUtil.recycleWFAssign(ctx, billId);
                this.updateEvaResultStatus(ctx, billId, AppealStateEnum.NOAPPEAL.getValue());
            }
            catch (Exception e) {
                String message = "recycle the third message failed,billID:('" + billId + "')";
                if (!logger.isDebugEnabled()) break block2;
                logger.error((Object)message, (Throwable)e);
            }
        }
    }

    @Override
    protected void _delBillByBillID(Context ctx, String billId) throws BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        ISumCalResultAppealBill iEvaResult = SumCalResultAppealBillFactory.getLocalInstance(ctx);
        try {
            if (iEvaResult.exists("where billState !=0 and id = '" + billId + "' ")) {
                throw new BOSException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.cannotEditBill, ctx));
            }
            this.updateEvaResultStatus(ctx, billId, AppealStateEnum.NOAPPEAL.getValue());
            DBUtil.execute((Context)ctx, (String)("update T_PEF_SumCalResultAppealBill set FValid=0 where fid in ('" + billId.replace(",", "','") + "')"));
        }
        catch (EASBizException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"it is failed to delBillByBillID cause EASBizException!", (Throwable)e);
            }
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected List _endProcess(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isEmpty((String)billIds)) {
            return null;
        }
        try {
            ArrayList<String> billIdList = new ArrayList<String>();
            for (String billId : billIds.split(",")) {
                billIdList.add(billId);
            }
            ArrayList<String> resultList = new ArrayList<String>();
            String unValidBillStatus = "3,4";
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)unValidBillStatus, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = entityViewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            SumCalResultAppealBillCollection unValidBillList = this.getSumCalResultAppealBillCollection(ctx, entityViewInfo);
            if (unValidBillList != null && unValidBillList.size() > 0) {
                int len = unValidBillList.size();
                for (int i = 0; i < len; ++i) {
                    resultList.add(unValidBillList.get(i).getId().toString());
                }
            }
            if (!CollectionUtils.isEmpty(resultList)) {
                billIdList.removeAll(resultList);
            }
            if (CollectionUtils.isEmpty(billIdList)) {
                return resultList;
            }
            DBUtil.execute((Context)ctx, (String)("update T_PEF_SumCalResultAppealBill set Fbillstate=4 where fid in ('" + org.apache.commons.lang3.StringUtils.join(billIdList, (String)"','") + "')"));
            List<String> failedBillIdList = TheThirdMessageUtil.recycleWFAssign(ctx, org.apache.commons.lang3.StringUtils.join(billIdList, (String)","));
            if (!CollectionUtils.isEmpty(failedBillIdList)) {
                billIdList.removeAll(failedBillIdList);
                resultList.addAll(failedBillIdList);
            }
            if (!CollectionUtils.isEmpty(billIdList)) {
                this.updateEvaResultStatus(ctx, org.apache.commons.lang3.StringUtils.join(billIdList, (String)","), AppealStateEnum.FAILED.getValue());
            }
            return resultList;
        }
        catch (Exception e) {
            String message = "recycle the third message failed,billID:('" + billIds + "')";
            if (logger.isDebugEnabled()) {
                logger.error((Object)message, (Throwable)e);
            }
            throw new BOSException(e.getMessage());
        }
    }
}

