/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.workflow;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWFLevelDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWFLevelDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.StatusEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeAreaExtendConfigCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeAreaExtendConfigInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WorkFlowRefStatusEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.AbstractPerfWorkFlowDefFacadeControllerBean;
import com.kingdee.shr.perfweb.base.bean.NodeAreaBean;
import com.kingdee.shr.perfweb.base.bean.NodeAreaExtendConfigBean;
import com.kingdee.shr.perfweb.base.bean.NodeBean;
import com.kingdee.shr.perfweb.base.bean.NodeLevelBean;
import com.kingdee.shr.perfweb.base.bean.NodeLevelList;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.ReflectUtils;
import com.kingdee.shr.perfweb.utils.UUIDUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class PerfWorkFlowDefFacadeControllerBean
extends AbstractPerfWorkFlowDefFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowDefFacadeControllerBean");
    private static final String EDITTYPE_CHANGE = "1";

    @Override
    protected String _saveBaseInfo(Context ctx, String number, HashMap nameMap, String allowConcurrent, String type, int level, String ruleId, String wfid) throws BOSException {
        String res = null;
        String sourceNumber = "";
        String sourceName = "";
        int sourceLevel = 0;
        IPWorkFlowDef ipFlowDef = null;
        PWorkFlowDefInfo workFlowInfo = null;
        try {
            ipFlowDef = PWorkFlowDefFactory.getRemoteInstance();
            if (!("null".equals(wfid) || StringUtils.isEmpty((String)wfid) || type.equals("0"))) {
                workFlowInfo = ipFlowDef.getPWorkFlowDefInfo((IObjectPK)new ObjectUuidPK(wfid));
                sourceLevel = workFlowInfo.getSeries();
                sourceNumber = workFlowInfo.getNumber();
                sourceName = workFlowInfo.getName();
            } else {
                workFlowInfo = new PWorkFlowDefInfo();
                workFlowInfo.setId(BOSUuid.read((String)wfid));
            }
        }
        catch (BOSException e1) {
            throw new BOSException("[PERFWEB]it is failed to get workflow information", (Throwable)e1);
        }
        catch (EASBizException e) {
            throw new BOSException("[PERFWEB]it is failed to get workflow information", (Throwable)e);
        }
        String name = String.valueOf(nameMap.get("name"));
        workFlowInfo.setName(name);
        String l1Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L1);
        String l2Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L2);
        String l3Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L3);
        workFlowInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l1Flag)) ? name : MapUtils.getParam(nameMap, "name" + l1Flag), LocaleUtils.locale_l1);
        workFlowInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l2Flag)) ? name : MapUtils.getParam(nameMap, "name" + l2Flag), LocaleUtils.locale_l2);
        workFlowInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l3Flag)) ? name : MapUtils.getParam(nameMap, "name" + l3Flag), LocaleUtils.locale_l3);
        workFlowInfo.setNumber(number);
        workFlowInfo.setSeries(level);
        workFlowInfo.setConcurrent(allowConcurrent);
        workFlowInfo.setPerfRule(ruleId);
        workFlowInfo.setRefStatus(WorkFlowRefStatusEnum.UNREF);
        if (type.equals("0")) {
            workFlowInfo.setWfStatus(StatusEnum.DISABLED);
            try {
                if (ipFlowDef.exists("where name='" + name.replace("'", "''") + "' and perfRule='" + ruleId + "'")) {
                    res = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.WORKFLOWNAMEREPEATE, ctx, new Object[]{name});
                } else {
                    workFlowInfo.setUniqId(UUIDUtils.generateUuid());
                    workFlowInfo.setVid(EDITTYPE_CHANGE);
                    IObjectPK pk = ipFlowDef.addnew(workFlowInfo);
                    PerfWorkFlowDefFacadeControllerBean.addPerfWorkFlowHis(ctx, pk.toString());
                    res = "200";
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                throw new BOSException("e" + e);
            }
            return res;
        }
        try {
            if (!name.equals(sourceName) && ipFlowDef.exists("where name='" + name.replace("'", "''") + "' and perfRule= '" + ruleId + "'")) {
                res = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.WORKFLOWNAMEREPEATE, ctx, new Object[]{name});
                return res;
            }
            if (level < sourceLevel) {
                IPWFLevelDef ipWFLevel = PWFLevelDefFactory.getRemoteInstance();
                IWFNodeDef iWFNode = WFNodeDefFactory.getRemoteInstance();
                for (int i = level + 1; i <= sourceLevel; ++i) {
                    ipWFLevel.delete(" where workflow='" + wfid + "' and level=" + i);
                    iWFNode.delete(" where workflow='" + wfid + "' and level=" + i);
                }
            }
            ipFlowDef.save((CoreBaseInfo)workFlowInfo).toString();
            res = "200";
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new BOSException("e" + e);
        }
        return res;
    }

    @Override
    protected String _saveDetailInfo(Context ctx, String wfid, String jsonStr, String editType) throws BOSException, EASBizException {
        Gson gson = new Gson();
        NodeLevelList levelList = (NodeLevelList)gson.fromJson(jsonStr, NodeLevelList.class);
        IPWFLevelDef ipwfLevel = PWFLevelDefFactory.getLocalInstance(ctx);
        IWFNodeDef iwfNode = WFNodeDefFactory.getLocalInstance(ctx);
        String type = "0";
        if (wfid != null && wfid.length() > 0) {
            ipwfLevel.delete("where workflow='" + wfid + "'");
            iwfNode.delete("where workflow='" + wfid + "'");
            type = EDITTYPE_CHANGE;
        } else {
            BOSUuid bosUuid = BOSUuid.create((String)"DB27F143");
            wfid = bosUuid.toString();
        }
        int wfLevel = 0;
        for (NodeLevelBean levelBean : levelList.getNodeLevelList()) {
            PWFLevelDefInfo pwfLevDefInfo = new PWFLevelDefInfo();
            pwfLevDefInfo.setLevel(Integer.parseInt(levelBean.getLevel()));
            pwfLevDefInfo.setWorkflow(wfid);
            int nodeNum = 0;
            for (NodeBean node : levelBean.getNodeList()) {
                WFNodeDefInfo nodeInfo = new WFNodeDefInfo();
                ReflectUtils.setValueFromObj(node, nodeInfo);
                nodeInfo.put("workflow", wfid);
                nodeInfo.setLevel(Integer.parseInt(levelBean.getLevel()));
                ++nodeNum;
                WFNodeAreaExtendConfigCollection extendConfigCollection = new WFNodeAreaExtendConfigCollection();
                List<NodeAreaBean> extendConfigList = node.getExtendConfigList();
                if (!CollectionUtils.isEmpty(extendConfigList)) {
                    for (NodeAreaBean nodeAreaBean : extendConfigList) {
                        List<NodeAreaExtendConfigBean> extendConfigList1 = nodeAreaBean.getExtendConfigList();
                        if (CollectionUtils.isEmpty(extendConfigList1)) continue;
                        for (NodeAreaExtendConfigBean areaExtendConfigBean : extendConfigList1) {
                            WFNodeAreaExtendConfigInfo wfNodeAreaExtendConfigInfo = new WFNodeAreaExtendConfigInfo();
                            wfNodeAreaExtendConfigInfo.put("areaBaseId", nodeAreaBean.getAreaBaseId());
                            wfNodeAreaExtendConfigInfo.put("areaBaseName", nodeAreaBean.getAreaBaseName_l1(), LocaleUtils.locale_L1);
                            wfNodeAreaExtendConfigInfo.put("areaBaseName", nodeAreaBean.getAreaBaseName_l2(), LocaleUtils.locale_L2);
                            wfNodeAreaExtendConfigInfo.put("areaBaseName", nodeAreaBean.getAreaBaseName_l3(), LocaleUtils.locale_L3);
                            wfNodeAreaExtendConfigInfo.put("colName", areaExtendConfigBean.getColName());
                            wfNodeAreaExtendConfigInfo.put("showName", areaExtendConfigBean.getShowName_l1(), LocaleUtils.locale_L1);
                            wfNodeAreaExtendConfigInfo.put("showName", areaExtendConfigBean.getShowName_l2(), LocaleUtils.locale_L2);
                            wfNodeAreaExtendConfigInfo.put("showName", areaExtendConfigBean.getShowName_l3(), LocaleUtils.locale_L3);
                            wfNodeAreaExtendConfigInfo.put("configValue", areaExtendConfigBean.getConfigValue());
                            extendConfigCollection.add(wfNodeAreaExtendConfigInfo);
                        }
                    }
                }
                nodeInfo.put("wfNodeAreaExtendConfig", (Object)extendConfigCollection);
                iwfNode.addnew(nodeInfo);
            }
            pwfLevDefInfo.setNodeNum(nodeNum);
            ipwfLevel.addnew(pwfLevDefInfo);
            ++wfLevel;
        }
        HashMap<String, String> nameMap = levelList.getWorkFlowName();
        if (EDITTYPE_CHANGE.equals(type)) {
            IPWorkFlowDef ipWF = PWorkFlowDefFactory.getLocalInstance(ctx);
            PWorkFlowDefInfo pWFInfo = ipWF.getPWorkFlowDefInfo((IObjectPK)new ObjectUuidPK(wfid));
            pWFInfo.setSeries(wfLevel);
            pWFInfo.setConcurrent(levelList.getWorkFlowName().get("wfConcurrnet"));
            String l1Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L1);
            String l2Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L2);
            String l3Flag = SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_L3);
            String name = StringUtils.isEmpty((String)nameMap.get("name")) ? pWFInfo.getName() : nameMap.get("name");
            pWFInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l1Flag)) ? name : MapUtils.getParam(nameMap, "name" + l1Flag), LocaleUtils.locale_l1);
            pWFInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l2Flag)) ? name : MapUtils.getParam(nameMap, "name" + l2Flag), LocaleUtils.locale_l2);
            pWFInfo.setName(StringUtils.isEmpty((String)MapUtils.getParam(nameMap, "name" + l3Flag)) ? name : MapUtils.getParam(nameMap, "name" + l3Flag), LocaleUtils.locale_l3);
            ipWF.save((CoreBaseInfo)pWFInfo);
            if (EDITTYPE_CHANGE.equals(editType)) {
                PerfWorkFlowDefFacadeControllerBean.addPerfWorkFlowHis(ctx, wfid);
            }
        } else {
            this._saveBaseInfo(ctx, nameMap.get("wfnumber"), nameMap, nameMap.get("wfConcurrnet"), type, wfLevel, nameMap.get("ruleId"), wfid);
        }
        return wfid;
    }

    private static void addPerfWorkFlowHis(Context ctx, String wfid) throws BOSException, EASBizException {
        int i;
        IPWorkFlowDef ipWorkFlowDef = PWorkFlowDefFactory.getLocalInstance(ctx);
        IPWFLevelDef ipwfLevelDef = PWFLevelDefFactory.getLocalInstance(ctx);
        IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
        IPWorkFlowDefHIS ipWorkFlowDefHIS = PWorkFlowDefHISFactory.getLocalInstance(ctx);
        IPWFLevelDefHIS ipwfLevelDefHIS = PWFLevelDefHISFactory.getLocalInstance(ctx);
        IWFNodeDefHIS iwfNodeDefHIS = WFNodeDefHISFactory.getLocalInstance(ctx);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        PWorkFlowDefInfo pWorkFlowDefInfo = ipWorkFlowDef.getPWorkFlowDefInfo((IObjectPK)new ObjectUuidPK(wfid));
        PWFLevelDefCollection pwfLevelDefCollection = ipwfLevelDef.getPWFLevelDefCollection("where workflow='" + wfid + "'");
        WFNodeDefCollection wfNodeDefCollection = iwfNodeDef.getWFNodeDefCollection("where workflow='" + wfid + "'");
        IObjectPK pk = null;
        if (pWorkFlowDefInfo != null) {
            PWorkFlowDefHISInfo pWorkFlowDefHISInfo = new PWorkFlowDefHISInfo();
            BeanUtils.copyProperties((Object)pWorkFlowDefInfo, (Object)pWorkFlowDefHISInfo);
            pWorkFlowDefHISInfo.setEFFDT(nowDate);
            pWorkFlowDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
            pWorkFlowDefHISInfo.setCreateTime(nowTime);
            pWorkFlowDefHISInfo.setHistoryRelateId(pWorkFlowDefInfo.getId());
            pWorkFlowDefHISInfo.setId(null);
            pk = ipWorkFlowDefHIS.addnew(pWorkFlowDefHISInfo);
        }
        if (pk != null && pwfLevelDefCollection != null && pwfLevelDefCollection.size() > 0) {
            CoreBaseCollection pwfLevelDefBaseColl = new CoreBaseCollection();
            for (i = 0; i < pwfLevelDefCollection.size(); ++i) {
                PWFLevelDefInfo pwfLevelDefInfo = pwfLevelDefCollection.get(i);
                PWFLevelDefHISInfo pwfLevelDefHISInfo = new PWFLevelDefHISInfo();
                BeanUtils.copyProperties((Object)pwfLevelDefInfo, (Object)pwfLevelDefHISInfo);
                pwfLevelDefHISInfo.setEFFDT(nowDate);
                pwfLevelDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
                pwfLevelDefHISInfo.setCreateTime(nowTime);
                pwfLevelDefHISInfo.setHistoryRelateId(pwfLevelDefInfo.getId());
                pwfLevelDefHISInfo.setWorkflow(pk.toString());
                pwfLevelDefHISInfo.setId(null);
                pwfLevelDefBaseColl.add((CoreBaseInfo)pwfLevelDefHISInfo);
            }
            ipwfLevelDefHIS.addnewBatchData(pwfLevelDefBaseColl);
        }
        if (pk != null && wfNodeDefCollection != null && wfNodeDefCollection.size() > 0) {
            CoreBaseCollection wfNodeDefBaseColl = new CoreBaseCollection();
            for (i = 0; i < wfNodeDefCollection.size(); ++i) {
                WFNodeDefInfo wfNodeDefInfo = wfNodeDefCollection.get(i);
                WFNodeDefHISInfo wfNodeDefHISInfo = new WFNodeDefHISInfo();
                BeanUtils.copyProperties((Object)wfNodeDefInfo, (Object)wfNodeDefHISInfo);
                wfNodeDefHISInfo.setEFFDT(nowDate);
                wfNodeDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
                wfNodeDefHISInfo.setCreateTime(nowTime);
                wfNodeDefHISInfo.setHistoryRelateId(wfNodeDefInfo.getId());
                wfNodeDefHISInfo.setWorkflow(pk.toString());
                wfNodeDefHISInfo.setId(null);
                wfNodeDefBaseColl.add((CoreBaseInfo)wfNodeDefHISInfo);
            }
            iwfNodeDefHIS.addnewBatchData(wfNodeDefBaseColl);
        }
    }
}

