/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.workflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.wx.HttpKit;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.AbstractPerfWxMessageFacadeControllerBean;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfWxMessageFacadeControllerBean
extends AbstractPerfWxMessageFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.workflow.PerfWxMessageFacadeControllerBean");
    private static final int SCAN_ROWS = 500;
    private static volatile boolean isLock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _pushMessages(Context ctx) throws BOSException {
        if (!PerfWxMessageFacadeControllerBean.isExistWxMessageHisTable(ctx)) {
            throw new BOSException("table T_EVA_WxMessageHis not exist");
        }
        Class<WXUtil> wxUtilClass = WXUtil.class;
        ProtectionDomain pd = wxUtilClass.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        PerfWxMessageFacadeControllerBean.delWxMessageHis(ctx);
        Properties config = PerfWxMessageFacadeControllerBean.getConfig(ctx);
        String title = config.getProperty("title");
        String appPath = config.getProperty("appPath");
        String appName = config.getProperty("appName");
        String authorize = config.getProperty("authorize");
        String eid = config.getProperty("eid");
        String url = config.getProperty("url");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!isLock) {
            isLock = true;
            try {
                String[] wxConfig;
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)MsgType.NOTICE, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("bizType", (Object)MsgBizType.OFFICE, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)MsgSourceStatus.EMPTY, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("bizCustomizedFlag", (Object)"PERFWEB", CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("sendTime", (Object)DateUtil.getDayBegin(), CompareType.GREATER_EQUALS));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("title"));
                sic.add(new SelectorItemInfo("receiver"));
                sic.add(new SelectorItemInfo("body"));
                sic.add(new SelectorItemInfo("sendTime"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(sic);
                IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
                int totalCount = ibmcMessage.getCount(evi);
                int page = totalCount / 500;
                if (totalCount % 500 != 0) {
                    ++page;
                }
                if ((wxConfig = WXUtil.getWXConfig()) == null || wxConfig.length != 3) {
                    throw new BOSException("The current data center with enterprise WeChat doesn't integration");
                }
                HashSet<String> validSendMessageIds = new HashSet<String>();
                int length = 500;
                for (int j = 1; j <= page; ++j) {
                    List bcmMessages;
                    if (j * 500 > totalCount) {
                        length = totalCount - (j - 1) * 500;
                    }
                    if ((bcmMessages = ibmcMessage.getPagingList(evi, (j - 1) * 500, length)) == null || bcmMessages.size() <= 0) continue;
                    HashSet<String> messages = new HashSet<String>();
                    HashMap<String, BMCMessageInfo> resultMap = new HashMap<String, BMCMessageInfo>();
                    for (int k = 0; k < bcmMessages.size(); ++k) {
                        BMCMessageInfo info = (BMCMessageInfo)bcmMessages.get(k);
                        String id = info.getId().toString();
                        resultMap.put(id, info);
                        messages.add(id);
                    }
                    Set<String> sendMessages = PerfWxMessageFacadeControllerBean.getWxMessageHis(ctx, messages);
                    if (sendMessages != null && sendMessages.size() > 0) {
                        messages.removeAll(sendMessages);
                    }
                    HashSet<String> receivers = new HashSet<String>();
                    for (String messageId : messages) {
                        BMCMessageInfo info = (BMCMessageInfo)resultMap.get(messageId);
                        receivers.add(info.getReceiver());
                    }
                    if (receivers.size() <= 0) continue;
                    Map<String, String> wxUserIdMap = PerfWxMessageFacadeControllerBean.getWxUserIdByUserIds(ctx, receivers);
                    for (String messageId : messages) {
                        BMCMessageInfo info = (BMCMessageInfo)resultMap.get(messageId);
                        String text = info.getTitle();
                        String body = info.getBody();
                        String receiver = info.getReceiver();
                        String finalTitle = title + "\n" + sf.format(info.getSendTime()) + "\n";
                        text = body;
                        String wxUserId = wxUserIdMap.get(receiver);
                        if (StringUtils.isEmpty((String)wxUserId) || !PerfWxMessageFacadeControllerBean.pushMessage(ctx, wxConfig, wxUserId, finalTitle, text, url)) continue;
                        validSendMessageIds.add(info.getId().toString());
                    }
                }
                if (validSendMessageIds != null && validSendMessageIds.size() > 0) {
                    PerfWxMessageFacadeControllerBean.addWxMessageHis(ctx, validSendMessageIds);
                }
            }
            finally {
                isLock = false;
            }
        }
    }

    private static String getWXMessageText(String title, String text, String body) {
        return title + body;
    }

    private static String combineWxMessageDetailUrl(String[] wxConfig, String eid, String appPath, String appName, String authorize, String msgDetail) throws BOSException {
        String corpid = wxConfig[0];
        String agentid = wxConfig[2];
        if (StringUtils.isEmpty((String)eid)) {
            eid = corpid;
        }
        String redirectUri = new StringBuffer("https://bos.kingdee.com/workflow/mbos/mbos.html").append("?appid=").append(agentid).append("&eid=").append(eid).append("&path=").append(appPath).append("&name=").append(appName).append("&agentid=").append(agentid).append("&agentid=").append(agentid).append("#/wxmessage_detail?msg=").append(msgDetail).toString();
        if ("false".equals(authorize)) {
            return redirectUri.toString();
        }
        try {
            redirectUri = URLEncoder.encode(redirectUri, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException: ", (Throwable)e);
        }
        StringBuffer authorizeUrl = new StringBuffer("https://open.weixin.qq.com/connect/oauth2/authorize").append("?appid=").append(corpid).append("&redirect_uri=").append(redirectUri).append("&response_type=code&scope=SCOPE&agentid=").append(agentid).append("&connect_redirect=1&state=").append(corpid).append("#wechat_redirect");
        return authorizeUrl.toString();
    }

    public static String getWxUserIdByUserId(Context ctx, String userId) {
        String wxUserId = "";
        String sql = "select FXTID from T_PM_EASWXUSERMAP where FUSERID = '" + userId + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null && rowSet.size() > 0) {
                rowSet.next();
                wxUserId = rowSet.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return wxUserId;
    }

    public static Map<String, String> getWxUserIdByUserIds(Context ctx, Set<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select FUserId, FXTID from T_PM_EASWXUSERMAP where ";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("FUSERID", userIds, CompareType.INCLUDE));
        sql = sql + filterInfo.toSql();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    map.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return map;
    }

    public static boolean isExistWxMessageHisTable(Context ctx) {
        Boolean isExist = false;
        String sql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='T_EVA_WxMessageHis'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() > 0) {
                isExist = true;
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
        return isExist;
    }

    public static Set<String> getAllWxMessageHis(Context ctx) throws BOSException {
        HashSet<String> messageIds = null;
        String sql = "select FBMCMessageId from T_EVA_WxMessageHis";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null && rowSet.size() > 0) {
                messageIds = new HashSet<String>();
                while (rowSet.next()) {
                    messageIds.add(rowSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return messageIds;
    }

    public static void delWxMessageHis(Context ctx) throws BOSException {
        String sql = "delete from T_EVA_WxMessageHis where ";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("FCreateTime", (Object)DateUtil.getDayBegin(), CompareType.LESS));
        sql = sql + filterInfo.toSql();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static Set<String> getWxMessageHis(Context ctx, Set<String> messageIds) throws BOSException {
        HashSet<String> results = null;
        String sql = "select FBMCMessageId from T_EVA_WxMessageHis where ";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("FBMCMessageId", messageIds, CompareType.INCLUDE));
        sql = sql + filterInfo.toSql();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null && rowSet.size() > 0) {
                results = new HashSet<String>();
                while (rowSet.next()) {
                    results.add(rowSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWxMessageHis(Context ctx, Set<String> messageIds) throws BOSException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sf.format(new Date());
        StringBuilder insertSQL = new StringBuilder();
        insertSQL.append("insert into T_EVA_WxMessageHis ");
        insertSQL.append("(FBMCMessageId, FCreateTime) ");
        insertSQL.append(" values(?,?) ");
        Connection conn = null;
        PreparedStatement insertPstmt = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            insertPstmt = conn.prepareStatement(insertSQL.toString());
            for (String messageId : messageIds) {
                insertPstmt.setString(1, messageId);
                insertPstmt.setTimestamp(2, Timestamp.valueOf(dateStr));
                insertPstmt.addBatch();
            }
            insertPstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error("SQLException: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertPstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)insertPstmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)insertPstmt, (Connection)conn);
    }

    public static Properties getConfig(Context ctx) throws BOSException {
        Properties config;
        block5: {
            StringBuilder sql = new StringBuilder();
            config = new Properties();
            sql.append("SELECT TOP 1 FSettingMsg FROM T_WX_SaveSetting ").append("ORDER BY FCreateTime DESC");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (iRowSet != null && iRowSet.next()) {
                    String settingMsg = iRowSet.getString("FSettingMsg");
                    if (StringUtils.isEmpty((String)settingMsg)) {
                        throw new BOSException("The current data center with enterprise WeChat doesn't integration");
                    }
                    String[] str = settingMsg.split(";");
                    int length = str.length;
                    for (int i = 0; i < length; ++i) {
                        String[] val = str[i].split("==");
                        config.put(val[0], val[1]);
                    }
                    break block5;
                }
                throw new BOSException("The current data center with enterprise WeChat doesn't integration");
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        return config;
    }

    public static boolean pushMessage(Context ctx, String[] wxConfig, String user, String title, String text, String url) {
        String wxurl = null;
        try {
            String agentId = wxConfig[2];
            agentId = agentId == null ? "1000011" : agentId;
            Class<WXUtil> wxUtilClass = WXUtil.class;
            Method[] methods = wxUtilClass.getMethods();
            Object res = null;
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!"getSendMessageUrl".equals(method.getName())) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes != null && paramTypes.length == 1) {
                    if (!String.class.equals(paramTypes[0])) break;
                    res = method.invoke(null, agentId);
                    break;
                }
                res = method.invoke(null, new Object[0]);
                break;
            }
            wxurl = (String)res;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
        String wxMsgJson = PerfWxMessageFacadeControllerBean.createMsg(ctx, wxConfig, user, title, text, url);
        return PerfWxMessageFacadeControllerBean.pushMessage(wxMsgJson, wxurl);
    }

    public static boolean pushMessage(Context ctx, String[] wxConfig, List<String> users, String title, String text, String url) {
        boolean result = true;
        String wxurl = null;
        try {
            wxurl = WXUtil.getSendMessageUrl((String)"agentId");
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
        String wxMsgJson = PerfWxMessageFacadeControllerBean.createMsg(ctx, wxConfig, users, title, text, url);
        result = result && PerfWxMessageFacadeControllerBean.pushMessage(wxMsgJson, wxurl);
        return true;
    }

    private static boolean pushMessage(String wxMsgJson, String wxurl) {
        try {
            String re = HttpKit.post((String)wxurl, (String)wxMsgJson);
            JSONObject jb = JSONObject.fromObject((Object)re);
            int errorcode = (Integer)jb.get("errcode");
            if (errorcode == 0) {
                return true;
            }
            logger.error("sendMessage error, errcode=" + errorcode);
            return false;
        }
        catch (Exception t) {
            logger.error("", (Throwable)t);
            return false;
        }
    }

    private static String createMsg(Context ctx, String[] wxConfig, String user, String title, String text, String url) {
        String description = null;
        description = text;
        if (StringUtils.isEmpty((String)title)) {
            title = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFNOTICE, ctx);
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("msgtype", "news");
        msgMap.put("touser", user);
        msgMap.put("agentid", wxConfig[2]);
        HashMap newsMap = new HashMap(1);
        HashMap<String, String> articleMap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> articlesList = new ArrayList<HashMap<String, String>>(1);
        articlesList.add(articleMap);
        newsMap.put("articles", articlesList);
        msgMap.put("news", newsMap);
        articleMap.put("title", title);
        articleMap.put("description", description);
        articleMap.put("url", url);
        JSONObject json = JSONObject.fromObject(msgMap);
        return json.toString();
    }

    private static String createMsg(Context ctx, String[] wxConfig, List<String> users, String title, String text, String url) {
        String touser = "";
        for (int i = 0; i < users.size(); ++i) {
            if (i > 0) {
                touser = touser + "|";
            }
            touser = touser + users.get(i);
        }
        return PerfWxMessageFacadeControllerBean.createMsg(ctx, wxConfig, touser, title, text, url);
    }
}

