/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.util.Strings;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.common.PerfConfigCollection;
import com.kingdee.shr.perfweb.app.common.PerfConfigFactory;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.CustomPageHelper;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import com.kingdee.shr.perfweb.utils.PersonBaseUtils;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import com.kingdee.shr.perfweb.utils.RequestUtils;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TargetFillService
implements ICustomDataProcessor {
    private static final int ESTABLISHED = 1;
    private static final int UNESTABLISHED = 0;
    private static final int ASSIGNED = 3;
    private static final int UNASSIGBED = 2;
    private static final String ISDELETEONLY = "1";
    private static String teamTarget = "1";
    private static Logger logger = LoggerFactory.getLogger(TargetFillService.class);
    private static final String ADDTARGET = "addTarget";
    private static final String REFTARGET = "refTarget";
    private static final String SETTARGETWORKFLOW = "setTargetWorkflow";

    private GoalsMessageReceiverCollection getEvaObjectCollectinByUser(Context ctx, boolean isOrg) throws BOSException, EASBizException {
        IObjectPK userId = ctx.getCaller();
        UserInfo user = UserFactory.getRemoteInstance().getUserByID(userId);
        String oql = "where receiver = '" + user.getPerson().getId().toString() + "' and isSelf = 0";
        oql = isOrg ? oql + " and person = 'ORG'" : oql + " and person <> 'ORG'";
        GoalsMessageReceiverCollection coll = GoalsMessageReceiverFactory.getRemoteInstance().getGoalsMessageReceiverCollection(oql);
        return coll;
    }

    public FilterInfo getCustomFilter(Context ctx, String periodId, boolean isOrg) throws EASBizException, BOSException {
        GoalsMessageReceiverCollection coll = this.getEvaObjectCollectinByUser(ctx, isOrg);
        HashSet<String> evaIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            evaIdSet.add(coll.get(i).getEvaObj().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        if (CollectionUtils.isEmpty(evaIdSet)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"Gj2uquUTd0SAKhO8Xs+JB4GI54s="));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", evaIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)3, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unitAfterFiller", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("targetTransmitWay", (Object)ISDELETEONLY, CompareType.NOTEQUALS));
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            String[] split = periodId.split(",");
            HashSet<String> periods = new HashSet<String>(Arrays.asList(split));
            filter.getFilterItems().add(new FilterItemInfo("period.id", periods, CompareType.INCLUDE));
        }
        return filter;
    }

    public void afterGetListData(List<HashMap<String, Object>> rows, Context ctx) {
        Object isOrgObj;
        boolean isOrg = false;
        HashSet<String> evaObjs = new HashSet<String>();
        if (rows != null && rows.size() > 0 && (isOrgObj = rows.get(0).get("isOrg")) != null) {
            isOrg = isOrgObj instanceof Integer ? ISDELETEONLY.equals(String.valueOf(isOrgObj)) : ISDELETEONLY.equals(String.valueOf(((BizEnumValueDTO)isOrgObj).getValue()));
        }
        for (HashMap<String, Object> hashMap : rows) {
            EvaluFormAreaBaseCollection evaAreaBaseColl;
            String goalsScore;
            String goalsPercent;
            block18: {
                String id = (String)hashMap.get("id");
                evaObjs.add(id);
                goalsPercent = hashMap.get("goalsPercent").toString();
                goalsScore = hashMap.get("goalsScore").toString();
                evaAreaBaseColl = null;
                try {
                    evaAreaBaseColl = PersonBaseUtils.getEvaluFormAreaBaseColl(ctx, id);
                }
                catch (BOSException e) {
                    if (logger.isDebugEnabled()) {
                        logger.error("perfweb:Targetfillservice afterGetListData error", (Throwable)e);
                    }
                }
                catch (EASBizException e) {
                    if (!logger.isDebugEnabled()) break block18;
                    logger.error("perfweb:Targetfillservice afterGetListData error", (Throwable)e);
                }
            }
            if (evaAreaBaseColl != null && evaAreaBaseColl.size() > 0) {
                PerformanceRuleInfo performanceRule = evaAreaBaseColl.get(0).getPerformanceRule();
                PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, performanceRule.getId().toString());
                int scoringWay = 0;
                scoringWay = ruleInfo.getScoringWay().getValue();
                if (scoringWay == 0) {
                    goalsScore = null;
                    hashMap.put("goalsScore", goalsScore);
                } else if (scoringWay == 1) {
                    goalsPercent = null;
                    hashMap.put("goalsPercent", goalsPercent);
                }
            }
            DecimalFormat df = new DecimalFormat("0.00");
            if (!StringUtils.isEmpty((CharSequence)goalsPercent)) {
                hashMap.put("goalsPercent", df.format(Double.valueOf(goalsPercent)));
            }
            if (StringUtils.isEmpty((CharSequence)goalsScore)) {
                // empty if block
            }
            if (StringUtils.isEmpty((CharSequence)goalsScore)) continue;
            hashMap.put("goalsScore", df.format(Double.valueOf(goalsScore)));
        }
        Map<Object, Object> orgResponsorMap = new HashMap();
        if (isOrg) {
            try {
                orgResponsorMap = OrgAssessmentUtils.getOrgResponsors(ctx, evaObjs);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
            if (orgResponsorMap == null) {
                return;
            }
            for (HashMap<String, Object> row : rows) {
                String id = (String)row.get("id");
                if (!isOrg) continue;
                List responsor = (List)orgResponsorMap.get(id);
                if (responsor != null) {
                    row.put("orgResponsors", StringUtils.join((Iterable)responsor, (String)","));
                    continue;
                }
                row.put("orgResponsors", "");
            }
        }
    }

    public void getPlanFilter(Context ctx, Map<String, Object> resultMap, Map param) throws EASBizException {
        String period = (String)param.get("period");
        PerfPeriodInfo periodiInfo = null;
        StringBuilder planIds = new StringBuilder(48);
        resultMap.put("planFilter", "-1");
        if (!Strings.isEmpty((String)period)) {
            try {
                periodiInfo = PerfPeriodFactory.getRemoteInstance().getPerfPeriodInfo((IObjectPK)new ObjectUuidPK(period));
                String perfPlan = periodiInfo.getPerfPlan().getId().toString();
                PerfPlanInfo perfPlanInfo = PerfPlanFactory.getRemoteInstance().getPerfPlanInfo((IObjectPK)new ObjectUuidPK(perfPlan));
                String perfRule = perfPlanInfo.getPerfRule().getId().toString();
                PerfPlanCollection coll = PerfPlanFactory.getRemoteInstance().getPerfPlanCollection("where perfRule = '" + perfRule + "'");
                for (int i = 0; i < coll.size(); ++i) {
                    planIds.append("'").append(coll.get(i).getId().toString()).append("'").append(",");
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
                throw new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED);
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
                throw new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERROCCURED);
            }
        }
        resultMap.put("planFilter", planIds.toString().subSequence(0, planIds.length() - 1));
    }

    public void getEvaObjTabList(Context ctx, Map<String, Object> allMap, HttpServletRequest request) throws EASBizException {
        String page;
        String rows;
        String period = RequestUtils.getParam(request, "period");
        request.setAttribute("sidx", (Object)"t.Fnumber");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)period)) {
            resultMap.put("total", "0");
            resultMap.put("records", "0");
            resultMap.put("page", ISDELETEONLY);
            resultMap.put("rows", "10");
            allMap.put("data", resultMap);
            return;
        }
        String string = rows = request.getParameter("rowsNum") != null ? request.getParameter("rowsNum") : RequestUtils.getAttribute(request, "rows");
        if (!Strings.isEmpty((String)rows)) {
            request.setAttribute("rows", (Object)rows);
        }
        String string2 = page = request.getParameter("pageNum") != null ? request.getParameter("pageNum") : RequestUtils.getAttribute(request, "page");
        if (!Strings.isEmpty((String)page)) {
            request.setAttribute("page", (Object)page);
        }
        String filterItems = RequestUtils.getParam(request, "filterItems");
        String useMyOwnTarget = RequestUtils.getParam(request, "useMyOwnTarget");
        params.put("period", period);
        params.put("sidx", "t.Fnumber");
        params.put("rows", rows);
        params.put("page", page);
        params.put("filterItems", filterItems);
        params.put("useMyOwnTarget", useMyOwnTarget);
        this.getEvaObjTabList(ctx, allMap, params);
    }

    public void getEvaObjTabList(Context ctx, Map<String, Object> allMap, Map<String, Object> requestMap) throws EASBizException {
        Map<Object, Object> resultMap = new HashMap();
        String period = MapUtils.getParam(requestMap, "period");
        String useMyOwnTarget = MapUtils.getParam(requestMap, "useMyOwnTarget");
        String filterItems = MapUtils.getParam(requestMap, "filterItems");
        HashSet<String> orgIds = new HashSet<String>(PermitUtil.getCurrentUserOwnOrg(ctx));
        if (orgIds.size() < 1) {
            orgIds.add("  ");
        }
        FilterItemInfo orgFilterItem = new FilterItemInfo("t. FADMINORGUNITID", orgIds, CompareType.INCLUDE);
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sql = new StringBuffer(48);
        sql = sql.append("SELECT t.*,t.fname" + mlFlag + " as Fname , K.FNAME" + mlFlag + " AS fpositionname from T_EVA_PerfEvaObject t ").append("  LEFT OUTER JOIN T_EVA_PERFFILE J ").append("    ON T.FPERFFILEID = J.FID").append("  LEFT OUTER JOIN T_ORG_Position K ").append("    ON J.FPOSITIONID = K.FID").append(" WHERE 1=1 ").append("   AND T.fperiodid = '" + period + "'").append(" AND  " + orgFilterItem.toString());
        if (ISDELETEONLY.equals(useMyOwnTarget)) {
            String currentPersonId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            sql.append(" AND t.fpersonid = '" + currentPersonId + "'");
        }
        if (!Strings.isEmpty((String)filterItems)) {
            filterItems = filterItems.replace("evaObj.number", "t.FNumber").replace("evaObj.name", "t.FName" + mlFlag).replace("evaObj.positionName", "K.FNAME" + mlFlag);
            sql.append(" AND " + filterItems);
        }
        try {
            resultMap = CustomPageHelper.getPageCallbackData(ctx, requestMap, sql.toString(), "t.FlastUpdateTime DESC,t.FID", (ICustomDataProcessor)this, "2");
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.QUERYERR);
        }
        allMap.put("data", resultMap);
    }

    @Override
    public int getTotalCount(Context ctx, String sql) {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rowSet, String type) {
        LinkedList list = new LinkedList();
        try {
            HashMap<String, String> allMap = null;
            if ("2".equals(type)) {
                while (rowSet.next()) {
                    allMap = new HashMap<String, String>();
                    allMap.put("id", rowSet.getString("FID"));
                    allMap.put("number", rowSet.getString("FNumber"));
                    allMap.put("name", rowSet.getString("FName"));
                    allMap.put("positionname", rowSet.getString("fpositionname"));
                    allMap.put("person", rowSet.getString("FPersonID"));
                    int state = rowSet.getInt("FPersonalGoalStatus");
                    if (0 == state) {
                        allMap.put("state", PerfEvaObjectPersonalGoalStatusEnum.UNESTABLISHED.getAlias());
                    } else if (1 == state) {
                        allMap.put("state", PerfEvaObjectPersonalGoalStatusEnum.ESTABLISHED.getAlias());
                    } else if (2 == state) {
                        allMap.put("state", PerfEvaObjectPersonalGoalStatusEnum.UNASSIGBED.getAlias());
                    } else if (3 == state) {
                        allMap.put("state", PerfEvaObjectPersonalGoalStatusEnum.ASSIGNED.getAlias());
                    }
                    allMap.put("totalweight", rowSet.getString("FGoalsPercent") + "%");
                    list.add(allMap);
                }
            } else {
                String refreshPersonHeadPic = ISDELETEONLY;
                PerfConfigCollection configs = PerfConfigFactory.getLocalInstance(ctx).getPerfConfigCollection("select paraName, paraValue where category='multiEvaluate' ");
                if (configs != null && !configs.isEmpty()) {
                    refreshPersonHeadPic = configs.get(0).getParaValue();
                }
                while (rowSet.next()) {
                    allMap = new HashMap();
                    allMap.put("id", rowSet.getString("FID"));
                    String personNum = rowSet.getString("FpersonNumber");
                    String personId = rowSet.getString("FPerson");
                    allMap.put("number", personNum);
                    allMap.put("personId", personId);
                    allMap.put("workerName", rowSet.getString("FPERSONNAME"));
                    allMap.put("period", rowSet.getString("FPeriodID"));
                    String imagePath = PhotoUtils.getPhotoPath(ctx, personId, personNum, refreshPersonHeadPic);
                    allMap.put("imagePath", imagePath);
                    int state = rowSet.getInt("FPersonalGoalStatus");
                    String stateInfo = "";
                    switch (state) {
                        case 0: {
                            stateInfo = PerfEvaObjectPersonalGoalStatusEnum.UNESTABLISHED.getAlias();
                            break;
                        }
                        case 1: {
                            stateInfo = PerfEvaObjectPersonalGoalStatusEnum.ESTABLISHED.getAlias();
                            break;
                        }
                        case 2: {
                            stateInfo = PerfEvaObjectPersonalGoalStatusEnum.UNASSIGBED.getAlias();
                            break;
                        }
                        case 3: {
                            stateInfo = PerfEvaObjectPersonalGoalStatusEnum.ASSIGNED.getAlias();
                            break;
                        }
                        default: {
                            stateInfo = PerfEvaObjectPersonalGoalStatusEnum.UNESTABLISHED.getAlias();
                        }
                    }
                    allMap.put("target", stateInfo);
                    list.add(allMap);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return list;
    }

    public FilterInfo getCustomFilter(Context ctx, Map map) throws EASBizException {
        if (null == map || map.size() <= 0) {
            return null;
        }
        String period = (String)map.get("period");
        boolean isOrg = ISDELETEONLY.equals(null != map.get("isOrg") ? String.valueOf(map.get("isOrg")) : "0");
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String oql = "select evaObj.id where receiver = '" + personId + "' and isSelf = '" + ISDELETEONLY + "'  and handleStatus='" + ISDELETEONLY + "' and msgType='" + "0" + "' and targetStatus = '" + "0" + "'";
        oql = isOrg ? oql + " AND Person = 'ORG'" : oql + " AND Person <> 'ORG'";
        HashSet<Object> periods = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)period)) {
            String[] split = period.split(",");
            periods = new HashSet<String>(Arrays.asList(split));
        }
        if (!StringUtils.isEmpty((CharSequence)period)) {
            StringBuffer PeroidStr = new StringBuffer();
            for (String str : periods) {
                PeroidStr.append("'").append(str).append("',");
            }
            PeroidStr.deleteCharAt(PeroidStr.length() - 1);
            oql = oql + " and period in (" + PeroidStr.toString() + ")";
        }
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("receiver", (Object)personId, CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("isSelf", (Object)ISDELETEONLY, CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("handleStatus", (Object)ISDELETEONLY, CompareType.EQUALS));
        GoalsMessageReceiverCollection coll = null;
        try {
            coll = GoalsMessageReceiverFactory.getRemoteInstance().getGoalsMessageReceiverCollection(oql);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        HashSet<String> evaIdSet = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                evaIdSet.add(coll.get(i).getEvaObj().getId().toString());
            }
        }
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((CharSequence)period)) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", periods, CompareType.INCLUDE));
        }
        if (evaIdSet.size() <= 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", evaIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)"0,1", CompareType.INCLUDE));
        return filter;
    }
}

