/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.common;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.CLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhrBean {
    private static Logger logger = LoggerFactory.getLogger(EhrBean.class);
    public Map<String, Object> properties = new HashMap<String, Object>();

    public EhrBean() {
        this.properties.put("OID", null);
        this.properties.put("CREATOR", null);
        this.properties.put("WHOMODIFIED", null);
        this.properties.put("TIMEMODIFIED", null);
        this.properties.put("STRUCTURENUM", null);
    }

    public EhrBean(Map formParameters) {
        this();
        if (formParameters == null) {
            return;
        }
        for (String key : formParameters.keySet()) {
            if (key == null) continue;
            try {
                if (this.properties.containsKey(key.toUpperCase())) {
                    this.properties.remove(key);
                }
                this.properties.put(key.toUpperCase(), formParameters.get(key));
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public void addProperty(String key, Object value) {
        this.addPropertyValue(key, value);
    }

    public void addPropertyValue(String key, Object value) {
        if (key == null) {
            return;
        }
        if (this.properties.containsKey(key.toUpperCase())) {
            this.properties.remove(key.toUpperCase());
        }
        this.properties.put(key.toUpperCase(), value);
    }

    public boolean containProperty(String key) {
        if (key == null) {
            return false;
        }
        return this.properties.containsKey(key.toUpperCase());
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.getPropertyValue(key);
    }

    public Object getPropertyValue(String key) {
        if (key == null) {
            return null;
        }
        if (this.properties.containsKey(key.toUpperCase())) {
            if (this.properties.get(key.toUpperCase()) instanceof CLOB) {
                try {
                    CLOB clob = (CLOB)this.properties.get(key.toUpperCase());
                    long l = clob.length();
                    int i = (int)l;
                    return clob.getSubString(1L, i);
                }
                catch (SQLException e) {
                    throw new RuntimeException("invalid CLOB data\uff01");
                }
            }
            return this.properties.get(key.toUpperCase());
        }
        return null;
    }

    public void removeProperty(String key) {
        if (key == null) {
            return;
        }
        if (this.properties.containsKey(key.toUpperCase())) {
            this.properties.remove(key.toUpperCase());
        }
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPropertyValue(String key, Object value) {
        if (key == null) {
            return;
        }
        if (this.properties.containsKey(key.toUpperCase())) {
            this.properties.put(key.toUpperCase(), value);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (String key : this.properties.keySet()) {
            String value = null;
            if (this.getProperty(key) != null) {
                value = this.getProperty(key).toString();
            }
            if (value == null) {
                value = "";
            }
            str.append(", " + key + "=" + value);
        }
        if (str.length() > 0) {
            str.deleteCharAt(0);
        }
        return str.toString();
    }
}

