/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.common.PerfConfigCollection;
import com.kingdee.shr.perfweb.app.common.PerfConfigFactory;
import com.kingdee.shr.perfweb.app.common.PerfConfigInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IWholeComment;
import com.kingdee.shr.perfweb.app.workflow.IsVisibleEnum;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.AttachmentUtil;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMyPerfHistoryDetailService
implements IHRMsfService {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.osf.GetMyPerfHistoryDetailService");

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        IRowSet rs;
        int lengthtemp;
        String getTargetType;
        HashMap<String, String> args = new HashMap<String, String>();
        String evaObjId = (String)map.get("evaObjId");
        String isHadEvaluateScore = (String)map.get("isHadEvaluateScore");
        String gradeTaskNode = map.get("gradeTaskNode") == null ? "" : (String)map.get("gradeTaskNode");
        String viewMode = map.get("viewMode") == null ? "" : (String)map.get("viewMode");
        String isShowAuditedWholeForm = map.get("isShowAuditedWholeForm") == null ? "false" : (String)map.get("isShowAuditedWholeForm");
        args.put("viewMode", viewMode);
        args.put("isShowAuditedWholeForm", isShowAuditedWholeForm);
        args.put("TYPE", "");
        if (StringUtils.isEmpty((String)gradeTaskNode)) {
            gradeTaskNode = GetEntityInfoUtils.getLastCommittedGradeTaskNodeIdByEvaObj(ctx, evaObjId);
            getTargetType = "0";
        } else {
            args.put("TYPE", "viewMyDealScore");
            args.put("viewMode", "viewMyDealScore");
            getTargetType = "2";
        }
        logger.error("gradeTaskNode=" + gradeTaskNode);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String personBaseSQL = GetMyPerfHistoryDetailService.getBaseSQL(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getNumber(), map);
        String positionName = (String)map.get("positionName");
        String perfResult = (String)map.get("perfResult");
        String perfPlanId = (String)map.get("perfPlanId");
        Object[] params = new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()};
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionName) && positionName.equals(perfResult)) {
            params = Arrays.copyOf(params, params.length + 3);
            params[1] = "%" + positionName + "%";
            params[2] = perfResult + "%";
            params[3] = perfResult + "%";
        } else {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionName)) {
                lengthtemp = params.length;
                params = Arrays.copyOf(params, params.length + 1);
                params[lengthtemp] = "%" + positionName + "%";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)perfResult)) {
                lengthtemp = params.length;
                params = Arrays.copyOf(params, params.length + 2);
                params[lengthtemp] = perfResult + "%";
                params[lengthtemp + 1] = perfResult + "%";
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)perfPlanId)) {
            lengthtemp = params.length;
            params = Arrays.copyOf(params, params.length + 1);
            params[lengthtemp] = perfPlanId;
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)personBaseSQL, (Object[])params)) != null && rs.size() > 0) {
            try {
                rs.next();
                Map<String, Object> personBase = GetMyPerfHistoryDetailService.formatItem(ctx, rs);
                result.put("personBase", personBase);
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        try {
            Map<String, Object> indicatorsMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, evaObjId, gradeTaskNode, getTargetType, null, null, null);
            Map<String, List<Map<String, Object>>> indicatorScores = EvaFormUtil.getOnlyCurrentAndPrevScore(ctx, evaObjId, gradeTaskNode, EvaFormUtil.getAllTargetIds(indicatorsMap), getTargetType);
            EvaFormUtil.combineIndicatorsScoreList(indicatorsMap, indicatorScores);
            result.put("indecators", indicatorsMap);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        result.put("wholeComment", this.getCurrentAndPrevWholeComment(ctx, evaObjId, gradeTaskNode, args));
        return result;
    }

    private Boolean getMobileShowOtherScore(Context ctx) {
        boolean mobileMyPerfScoreShowOther = Boolean.FALSE;
        try {
            PerfConfigInfo perfConfigInfo;
            PerfConfigCollection configs = PerfConfigFactory.getRemoteInstance().getPerfConfigCollection("select paraValue where category='multiEvaluate' and paraName='mobileMyPerfScoreShowOther'");
            if (configs != null && !configs.isEmpty() && (perfConfigInfo = configs.get(0)) != null && perfConfigInfo.getParaValue() != null && "1".equals(perfConfigInfo.getParaValue())) {
                mobileMyPerfScoreShowOther = Boolean.TRUE;
            }
        }
        catch (BOSException e) {
            logger.error("get perf config err", (Throwable)e);
        }
        return mobileMyPerfScoreShowOther;
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> getCurrentAndPrevWholeComment(Context ctx, String evaObj, String gradeTaskNode, Map<String, String> args) throws EASBizException {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        DecimalFormat df = new DecimalFormat("0.00");
        try {
            void var8_14;
            IWholeComment iWholeComment = WholeCommentFactory.getLocalInstance(ctx);
            Object var8_9 = null;
            if (args.get("TYPE").equalsIgnoreCase("viewMyDealScore")) {
                String viewMode = args.get("viewMode");
                String isShowAuditedWholeForm = args.get("isShowAuditedWholeForm");
                if ("viewMyDealScore".equals(viewMode)) {
                    if (OrgAssessmentUtils.isOrgAssessment(ctx, evaObj)) {
                        OrgEvaResultSummaryInfo evaResultSummaryInfo4Org = GetEntityInfoUtils.getEvaResultSummaryInfo4Org(ctx, evaObj);
                        if ("true".equals(isShowAuditedWholeForm) && evaResultSummaryInfo4Org.getBillState().getValue() == 3) {
                            gradeTaskNode = GetEntityInfoUtils.getLastGradeTaskNodeIdByEvaObj(ctx, evaObj);
                        }
                    } else {
                        EvaResultSummaryInfo resultSummaryInfo = GetEntityInfoUtils.getEvaResultSummaryInfoByEvaObj(ctx, evaObj);
                        if ("true".equals(isShowAuditedWholeForm) && resultSummaryInfo.getBillState().getValue() == 3) {
                            gradeTaskNode = GetEntityInfoUtils.getLastGradeTaskNodeIdByEvaObj(ctx, evaObj);
                        }
                    }
                    UserInfo userInfo = new PerfGoasFillService().getUserInfo(ctx);
                    GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GetEntityInfoUtils.getMyDealAndPrevGradeTaskNodeInstCollection(ctx, evaObj, gradeTaskNode, userInfo.getPerson().getId().toString());
                } else {
                    GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GetEntityInfoUtils.getOnlyCurrentAndPrevGradeTaskNodeInstCollection(ctx, evaObj, gradeTaskNode, viewMode);
                }
            } else {
                GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GetEntityInfoUtils.getCurrentAndPrevGradeTaskNodeInstCollection(ctx, evaObj, gradeTaskNode);
            }
            HashSet<String> gradeNodes = new HashSet<String>();
            if (var8_14 != null && var8_14.size() > 0) {
                for (int i = 0; i < var8_14.size(); ++i) {
                    GradeTaskNodeInstInfo gradeTaskNodeInfo = var8_14.get(i);
                    if (IsVisibleEnum.HIDDEN.equals((Object)gradeTaskNodeInfo.getIsVisible())) continue;
                    String gradeNodeId = gradeTaskNodeInfo.getId().toString();
                    WFNodeDefInfo nodeInfo = GetEntityInfoUtils.getWFNodeDefInfo(ctx, gradeTaskNodeInfo.getWfNode().getId().toString());
                    PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, gradeTaskNodeInfo.getEvaObj().getId().toString());
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("nodeName", StringUtils.isEmpty((String)nodeInfo.getNodeName()) ? "" : nodeInfo.getNodeName());
                    map.put("nodeHandlerName", gradeTaskNodeInfo.getNodeHandlerName());
                    map.put("evaObjName", evaObjInfo.getName());
                    map.put("isSelf", gradeTaskNodeInfo.getIsSelf().getValue());
                    map.put("nodeHandlerId", gradeTaskNodeInfo.getNodeHandler() == null ? "" : gradeTaskNodeInfo.getNodeHandler().getId());
                    map.put("perfGradeEvaluate", nodeInfo.getPerfGradeEvaluate().getValue());
                    map.put("nodeWeight", StringUtils.isEmpty((String)nodeInfo.getNodeWeight()) ? "" : nodeInfo.getNodeWeight());
                    map.put("gradeTaskNode", gradeTaskNodeInfo.getId().toString());
                    map.put("needScore", nodeInfo.getNeedScore().getValue());
                    list.add(map);
                    gradeNodes.add(gradeNodeId);
                }
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("gradeTaskNodeInst", gradeNodes, CompareType.INCLUDE));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                WholeCommentCollection wholeCommentColl = iWholeComment.getWholeCommentCollection(evi);
                HashMap<String, WholeCommentInfo> wholeCommentInfoMap = new HashMap<String, WholeCommentInfo>();
                if (wholeCommentColl != null && wholeCommentColl.size() > 0) {
                    for (int i = 0; i < wholeCommentColl.size(); ++i) {
                        WholeCommentInfo wholeCommentInfo = wholeCommentColl.get(i);
                        wholeCommentInfoMap.put(wholeCommentInfo.getGradeTaskNodeInst().getId().toString(), wholeCommentInfo);
                    }
                    String hideUnselfWholeScore = PerfConfigUtils.getConfigByNumber(ctx, "Perf010");
                    String hideUnselfWholeGrade = PerfConfigUtils.getConfigByNumber(ctx, "Perf009");
                    if (OrgAssessmentUtils.isOrgAssessment(ctx, evaObj)) {
                        hideUnselfWholeScore = PerfConfigUtils.getConfigByNumber(ctx, "Perf510");
                        hideUnselfWholeGrade = PerfConfigUtils.getConfigByNumber(ctx, "Perf509");
                    }
                    for (Map map : list) {
                        String gradeTaskInstNode = (String)map.get("gradeTaskNode");
                        WholeCommentInfo wholeCommentInfo = (WholeCommentInfo)wholeCommentInfoMap.get(gradeTaskInstNode);
                        HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, gradeTaskNode, evaObj);
                        if ("true".equals(hideUnselfWholeScore) && 1 != (Integer)map.get("isSelf")) {
                            map.put("wholeScore", "");
                        } else if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0") && wholeCommentInfo.get("score") != null && !StringUtils.isEmpty((String)((String)targrtMap.get("sumScore"))) && args.get("TYPE").equalsIgnoreCase("viewMyDealScore")) {
                            df.setRoundingMode(RoundingMode.HALF_UP);
                            map.put("wholeScore", df.format(wholeCommentInfo.getScore() - Float.valueOf((String)targrtMap.get("sumScore")).floatValue()));
                        } else {
                            map.put("wholeScore", df.format(wholeCommentInfo.getScore()));
                        }
                        if ("true".equals(hideUnselfWholeGrade) && 1 != (Integer)map.get("isSelf")) {
                            map.put("wholeGrade", "");
                        } else {
                            boolean perfGradeEvaluate = "0".equals(map.get("perfGradeEvaluate"));
                            map.put("wholeGrade", wholeCommentInfo.getGrade() == null || perfGradeEvaluate ? "" : wholeCommentInfo.getGrade());
                        }
                        map.put("wholeComment", wholeCommentInfo.getComment() == null ? "" : wholeCommentInfo.getComment());
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        for (Map map : list) {
            String gradeNodeId = (String)map.get("gradeTaskNode");
            this.addAttachmentList(ctx, map, gradeNodeId, evaObj);
        }
        return list;
    }

    private void addAttachmentList(Context ctx, Map<String, Object> map, String gradeNodeId, String evaObj) {
        try {
            List<Object> attachmentList = new ArrayList();
            try {
                if (evaObj != null) {
                    attachmentList = AttachmentUtil.getAttachments(ctx, evaObj, Arrays.asList(gradeNodeId));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            map.put("attachmentList", attachmentList);
            logger.error("attachmentList:{}", (Object)JSON.toJSONString((Object)(attachmentList == null ? "null" : attachmentList)));
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public static String getBaseSQL(Context ctx, String number, Map map) throws EASBizException, BOSException {
        String positionName = (String)map.get("positionName");
        String perfResult = (String)map.get("perfResult");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        String evaObjId = (String)map.get("evaObjId");
        FilterInfo dateFilter = new FilterInfo();
        Timestamp sysDate = DateUtil.getTime();
        dateFilter.getFilterItems().add(new FilterItemInfo("d.FEFFDT", (Object)sysDate, CompareType.LESS_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("d.FLEFFDT", (Object)sysDate, CompareType.GREATER));
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sb = new StringBuffer("SELECT a.FID, a.FPersonID, a.FPeriodID, a.FEvaPlanID, a.FPositionName, a.FPName, a.FPnumber, a.FStatus,");
        sb.append(" a.FAdminOrgName, a.FLastSumScore,a.FLastGradeLevel, d.FAdminOrgID, ").append(" replace(tochar(b.FPStartDate,'yyyy-mm-dd'),'-','.')||'-'||replace(tochar(b.FPEndDate,'yyyy-mm-dd'),'-','.') FPeriodDate, ").append(" c.FName" + mlFlag + " FPerfPlanName, a.FIsImportByHand, a.FPeriodYear,  ").append(" a.FPeriodType, a.FPeriodTime, FEvaObjID, c.FPerfModelName, b.FName FPeriodName  ").append(" from (").append(" select * from T_EVA_EvaResultSummary ").append(" where FPnumber = ? ").append(" and FBillState = 3) a ").append(" left join T_HR_EmpOrgRelation d ").append(" on a.FPersonID = d.FPersonID ").append(" and d.FAssignType = 1").append(" and d.FISINNER = 1").append(" and d.FISENROLLED = 1").append(" and " + dateFilter.toSql()).append(" left join T_ORG_Admin e ").append(" on d.FAdminOrgID = e.FID ").append(" left join T_EVA_PerfPeriod b ").append(" on a.FPeriodID = b.FID ").append(" left join T_EVA_PerfPlan c ").append(" on a.FEvaPlanID = c.FID ").append(" where 1=1 ");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionName) && positionName.equals(perfResult)) {
            sb.append(" and (a.FPositionName like ?").append(" or a.FLastSumScore like ? or a.FLastGradeLevel like ?)");
        } else {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionName)) {
                sb.append(" and a.FPositionName like ? ");
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)perfResult)) {
                sb.append(" and (a.FLastSumScore like ? or a.FLastGradeLevel like ?)");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)belongOrgId)) {
            sb.append("and d.FAdminOrgID in (SELECT RANGE.FORGID  FROM T_PM_ORGRANGE RANGE").append(" LEFT OUTER JOIN T_ORG_ADMIN a").append(" ON RANGE.FORGID = a.FID  WHERE  RANGE.FTYPE = 20 ").append("AND a.FISSTARTSHR = 1 ").append(" AND RANGE.FUSERID = '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "') ");
            try {
                AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where id='" + belongOrgId + "'");
                if (adminOrgColl != null && adminOrgColl.size() > 0) {
                    String longNumber = adminOrgColl.get(0).getLongNumber();
                    sb.append(" and d.FAdminOrgID  in (select fid from T_ORG_Admin where FLongNumber like '" + longNumber + "!%')");
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        if (OrgAssessmentUtils.isOrgAssessment(ctx, evaObjId)) {
            sb = new StringBuffer(sb.toString().replace("T_EVA_EvaResultSummary", "T_EVA_OrgEvaResultSummary"));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)perfPlanId)) {
            sb.append(" and a.FEvaPlanID = ? ");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("a.FPeriodID", periods, CompareType.INCLUDE));
            sb.append(" and " + filterInfo.toSql());
        }
        return sb.toString();
    }

    public static Map<String, Object> formatItem(Context ctx, IRowSet rs) throws SQLException {
        String number;
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", rs.getString("FID"));
        item.put("personId", rs.getString("FPersonID"));
        item.put("periodId", rs.getString("FPeriodID"));
        item.put("perfPlanId", rs.getString("FEvaPlanID"));
        item.put("positionName", rs.getString("FPositionName"));
        item.put("adminOrgName", rs.getString("FAdminOrgName"));
        item.put("adminOrgNumber", rs.getString("FAdminOrgID"));
        item.put("perfModelName", rs.getString("FPerfModelName"));
        item.put("status", rs.getString("FStatus"));
        BigDecimal lastSumScore = rs.getBigDecimal("FLastSumScore");
        if (lastSumScore != null) {
            lastSumScore = lastSumScore.setScale(2, 4);
        }
        item.put("lastSumScore", lastSumScore);
        item.put("lastGradeLevel", rs.getString("FLastGradeLevel"));
        String name = rs.getString("FPName");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)name)) {
            item.put("name", name);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(number = rs.getString("FPnumber")))) {
            item.put("number", number);
        }
        String perfPlanName = rs.getString("FPerfPlanName");
        String periodDate = rs.getString("FPeriodName");
        int isImportByHand = rs.getInt("FIsImportByHand");
        if (1 == isImportByHand) {
            perfPlanName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx);
            String periodYear = rs.getString("FPeriodYear");
            int periodType = rs.getInt("FPeriodType");
            String periodTime = rs.getString("FPeriodTime");
            if (100 == periodType) {
                periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{periodYear});
            } else if (200 == periodType) {
                periodDate = periodTime.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{periodYear}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{periodYear});
            } else if (400 == periodType) {
                String[] yearWithMonths = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MONTHS, ctx, new Object[]{periodYear}).split(",");
                periodDate = yearWithMonths[Integer.valueOf(periodTime) - 1];
            } else if (300 == periodType) {
                periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, ctx, new Object[]{periodYear, periodTime});
            }
        }
        item.put("perfPlanName", perfPlanName);
        item.put("periodDate", periodDate);
        item.put("evaObjId", rs.getString("FEvaObjID"));
        item.put("photo", null);
        return item;
    }
}

