/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMyPerfHistoryService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMyPerfHistoryService.class.getName());
    private static String MULTI_PERF_MODEL_ID = "pER9PCMLSzypG7wVLbGZqqtdChg=";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        result.put("hideAppealResult", !PermissionUtils.hasFunctionPermission(ctx, "KHJGQRAPPEAL"));
        result.put("hideConfirmResult", !PermissionUtils.hasFunctionPermission(ctx, "KHJGQRCONFIRM"));
        boolean hideReviseResult = "true".equalsIgnoreCase(PerfConfigUtils.getConfigByName(ctx, "hideReviseResult", false));
        try {
            String baseSQL = this.getBaseSQL(ctx, map);
            String positionNametemp = (String)map.get("positionName");
            String perfResult = (String)map.get("perfResult");
            String number = (String)map.get("number");
            String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            Object[] params = new Object[]{!StringUtils.isEmpty((CharSequence)number) ? number : personId};
            if (!StringUtils.isEmpty((CharSequence)positionNametemp) && !StringUtils.isEmpty((CharSequence)perfResult)) {
                params = Arrays.copyOf(params, params.length + 3);
                params[1] = "%" + positionNametemp + "%";
                params[2] = "%" + positionNametemp + "%";
                params[3] = "%" + perfResult + "%";
                if (StringUtils.isNumeric((CharSequence)perfResult)) {
                    params = Arrays.copyOf(params, params.length + 1);
                    params[4] = NumberUtils.toDouble((String)perfResult);
                }
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])params);
            int totalCount = rowSet.size();
            int rows = Double.valueOf(map.get("rows").toString()).intValue();
            int page = Double.valueOf(map.get("page").toString()).intValue();
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            IRowSet dataSet = PerfDbUtil.executeQuery(ctx, baseSQL, (page - 1) * rows, length, params);
            LinkedList data = new LinkedList();
            HashSet<String> perfModelIds = new HashSet<String>();
            HashSet<String> multiEvaObjIds = new HashSet<String>();
            while (dataSet.next()) {
                int appealDays;
                String lastSumScore;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                String periodDate = dataSet.getString("periodName");
                int isImportByHand = dataSet.getInt("isImportByHand");
                String perfPlanName = dataSet.getString("perfPlanName");
                String positionName = dataSet.getString("positionName");
                String adminOrgName = dataSet.getString("adminOrgName");
                String planName = dataSet.getString("planName");
                String multiPlanName = dataSet.getString("multiPlanName");
                String posName = dataSet.getString("posName");
                String adminName = dataSet.getString("adminName");
                String personName = dataSet.getString("personName");
                String pname = dataSet.getString("pname");
                if (!StringUtils.isEmpty((CharSequence)planName)) {
                    perfPlanName = planName;
                }
                if (!StringUtils.isEmpty((CharSequence)multiPlanName)) {
                    perfPlanName = multiPlanName;
                }
                if (!StringUtils.isEmpty((CharSequence)posName)) {
                    positionName = posName;
                }
                if (!StringUtils.isEmpty((CharSequence)adminName)) {
                    adminOrgName = adminName;
                }
                if (!StringUtils.isEmpty((CharSequence)personName)) {
                    pname = personName;
                }
                int noDetailFlag = 0;
                if (1 == isImportByHand) {
                    String periodYear = dataSet.getString("periodYear");
                    String periodTime = dataSet.getString("periodTime");
                    int periodType = dataSet.getInt("periodType");
                    if (100 == periodType) {
                        periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{periodYear});
                    } else if (200 == periodType) {
                        periodDate = periodTime.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{periodYear}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{periodYear});
                    } else if (400 == periodType) {
                        String[] yearWithMonths = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MONTHS, ctx, new Object[]{periodYear}).split(",");
                        periodDate = yearWithMonths[Integer.valueOf(periodTime) - 1];
                    } else if (300 == periodType) {
                        periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, ctx, new Object[]{periodYear, periodTime});
                    }
                    noDetailFlag = 1;
                    if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                        perfPlanName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx);
                    }
                } else {
                    String perfModelId = dataSet.getString("perfModelId");
                    if (!StringUtils.isEmpty((CharSequence)perfModelId)) {
                        perfModelIds.add(perfModelId);
                        if (MULTI_PERF_MODEL_ID.equals(perfModelId)) {
                            multiEvaObjIds.add(dataSet.getString("businessId"));
                            noDetailFlag = 1;
                        } else {
                            Date pStartDate = dataSet.getDate("pStartDate");
                            Date pEndDate = dataSet.getDate("pEndDate");
                            if (pStartDate != null && pEndDate != null) {
                                periodDate = DateUtil.dateToStr((java.util.Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((java.util.Date)pEndDate, (String)"yyyy-MM-dd");
                            }
                        }
                    }
                }
                String string = lastSumScore = hideReviseResult ? dataSet.getString("sumScore") : dataSet.getString("lastSumScore");
                if (!StringUtils.isEmpty((CharSequence)lastSumScore)) {
                    Double score = Double.valueOf(lastSumScore);
                    rowMap.put("lastSumScore", String.valueOf(PerfPortalUtils.roudUpRemainGiveDecimal(2, score.floatValue())));
                }
                String lastGradeLevel = hideReviseResult ? dataSet.getString("gradeLevel") : dataSet.getString("lastGradeLevel");
                rowMap.put("lastGradeLevel", StringUtils.isEmpty((CharSequence)lastGradeLevel) ? "" : lastGradeLevel);
                rowMap.put("noDetailFlag", noDetailFlag);
                rowMap.put("periodDate", periodDate);
                rowMap.put("number", dataSet.getString("pnumber"));
                rowMap.put("name", pname);
                rowMap.put("positionName", positionName);
                rowMap.put("adminOrgName", adminOrgName);
                rowMap.put("perfModelName", dataSet.getString("perfModelName"));
                rowMap.put("businessId", dataSet.getString("businessId"));
                rowMap.put("perfModelId", dataSet.getString("perfModelId"));
                rowMap.put("id", dataSet.getString("id"));
                rowMap.put("evaObjId", dataSet.getString("evaObjId"));
                rowMap.put("businessId", dataSet.getString("businessId"));
                rowMap.put("personId", dataSet.getString("personId"));
                rowMap.put("confirmState", dataSet.getString("confirmState"));
                rowMap.put("appealState", dataSet.getString("appealState"));
                rowMap.put("reviseReason", dataSet.getString("reviseReason"));
                if (StringUtils.isBlank((CharSequence)dataSet.getString("confirmState")) || "0".equalsIgnoreCase(dataSet.getString("confirmState")) || "1".equalsIgnoreCase(dataSet.getString("confirmState"))) {
                    if ("0".equalsIgnoreCase(dataSet.getString("needConfirm"))) {
                        rowMap.put("confirmState", 0);
                    } else if ("1".equalsIgnoreCase(dataSet.getString("needConfirm"))) {
                        rowMap.put("confirmState", 1);
                    }
                }
                if (StringUtils.isBlank((CharSequence)dataSet.getString("appealState")) || "0".equalsIgnoreCase(dataSet.getString("appealState")) || "1".equalsIgnoreCase(dataSet.getString("appealState"))) {
                    if ("0".equalsIgnoreCase(dataSet.getString("allowAppeal"))) {
                        rowMap.put("appealState", 0);
                    } else if ("1".equalsIgnoreCase(dataSet.getString("allowAppeal"))) {
                        rowMap.put("appealState", 1);
                    }
                }
                if (3 != dataSet.getInt("billState")) {
                    rowMap.put("appealState", 0);
                }
                if (1 == dataSet.getInt("status")) {
                    rowMap.put("appealState", 0);
                }
                if (1 == dataSet.getInt("isImportByHand")) {
                    rowMap.put("appealState", 0);
                    rowMap.put("confirmState", 0);
                }
                if (1 == dataSet.getInt("historyImport")) {
                    rowMap.put("appealState", 0);
                    rowMap.put("confirmState", 0);
                }
                if (String.valueOf(2).equals(rowMap.get("confirmState"))) {
                    rowMap.put("appealState", 0);
                }
                if (1 != dataSet.getInt("allowAppeal")) {
                    rowMap.put("appealState", 0);
                }
                if (noDetailFlag == 1) {
                    rowMap.put("appealState", 0);
                    rowMap.put("confirmState", 0);
                }
                if (null == dataSet.getDate("auditDate")) {
                    rowMap.put("appealState", 0);
                }
                if ((appealDays = dataSet.getInt("appealDays")) != 0 && null != dataSet.getDate("auditDate")) {
                    java.util.Date now = new java.util.Date();
                    long days = com.kingdee.eas.base.core.util.DateUtil.dateDiff((String)"d", (java.util.Date)dataSet.getDate("auditDate"), (java.util.Date)now) + 1L;
                    if ((long)appealDays - days < 0L) {
                        rowMap.put("appealState", 0);
                    }
                }
                rowMap.put("perfPlanName", perfPlanName);
                data.add(rowMap);
            }
            HashMap<String, String> multiPerfMap = new HashMap<String, String>();
            if (multiEvaObjIds.size() > 0) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", multiEvaObjIds, CompareType.INCLUDE));
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("id"));
                selectorItemCollection.add(new SelectorItemInfo("multiPeriod.pStartDate"));
                selectorItemCollection.add(new SelectorItemInfo("multiPeriod.pEndDate"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectorItemCollection);
                MultiPerfEvaObjectCollection perfEvaObjectCollection = MultiPerfEvaObjectFactory.getLocalInstance(ctx).getMultiPerfEvaObjectCollection(evi);
                if (perfEvaObjectCollection != null && perfEvaObjectCollection.size() > 0) {
                    for (int j = 0; j < perfEvaObjectCollection.size(); ++j) {
                        MultiPerfEvaObjectInfo multiPerfEvaObjectInfo = perfEvaObjectCollection.get(j);
                        java.util.Date pStartDate = multiPerfEvaObjectInfo.getMultiPeriod().getPStartDate();
                        java.util.Date pEndDate = multiPerfEvaObjectInfo.getMultiPeriod().getPEndDate();
                        if (pStartDate == null || pEndDate == null) continue;
                        String periodDate = DateUtil.dateToStr((java.util.Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((java.util.Date)pEndDate, (String)"yyyy-MM-dd");
                        multiPerfMap.put(multiPerfEvaObjectInfo.getId().toString(), periodDate);
                    }
                }
                for (int i = 0; i < data.size(); ++i) {
                    Map resultMap = (Map)data.get(i);
                    String perfModelId = (String)resultMap.get("perfModelId");
                    if (StringUtils.isEmpty((CharSequence)perfModelId) || !MULTI_PERF_MODEL_ID.equals(perfModelId)) continue;
                    resultMap.put("periodDate", multiPerfMap.get(resultMap.get("businessId")));
                }
            }
            int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            result.put("pages", pages);
            result.put("records", totalCount);
            result.put("rows", data);
        }
        catch (SQLException e) {
            logger.error("perfPlan query failed", (Throwable)e);
        }
        return result;
    }

    private static EntityViewInfo getEntityView(Context ctx, Map map) throws BOSException {
        AdminOrgUnitCollection adminOrgUnitCollection;
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String positionName = (String)map.get("positionName");
        String perfResult = (String)map.get("perfResult");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        String number = (String)map.get("number");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
        if (!StringUtils.isEmpty((CharSequence)positionName) && !StringUtils.isEmpty((CharSequence)perfResult)) {
            FilterInfo fastFilter = new FilterInfo();
            fastFilter.getFilterItems().add(new FilterItemInfo("positionName", (Object)("%" + positionName + "%"), CompareType.LIKE));
            fastFilter.getFilterItems().add(new FilterItemInfo("lastGradeLevel", (Object)("%" + perfResult + "%"), CompareType.LIKE));
            if (NumberUtils.isNumber((String)perfResult)) {
                fastFilter.getFilterItems().add(new FilterItemInfo("lastSumScore", (Object)Double.valueOf(perfResult), CompareType.EQUALS));
                fastFilter.setMaskString("#0 OR #1 OR #2");
            } else {
                fastFilter.setMaskString("#0 OR #1");
            }
            filterInfo.mergeFilter(fastFilter, "AND");
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("pnumber", (Object)number, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId) && (adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id='" + belongOrgId + "'")) != null && adminOrgUnitCollection.size() > 0) {
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgLongNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            String perfPlanName = null;
            PerfPlanCollection planCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection("where id='" + perfPlanId + "'");
            if (planCollection != null && planCollection.size() > 0) {
                perfPlanName = planCollection.get(0).getName();
            } else {
                MultiPerfPlanCollection multiPerfPlanCollection = MultiPerfPlanFactory.getLocalInstance(ctx).getMultiPerfPlanCollection("where id='" + perfPlanId + "'");
                if (multiPerfPlanCollection != null && multiPerfPlanCollection.size() > 0) {
                    perfPlanName = multiPerfPlanCollection.get(0).getName();
                }
            }
            if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                logger.error("my perf history list query by perfPlanId not exist");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("evaPlanName", (Object)perfPlanName, CompareType.EQUALS));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            HashSet<String> periodName = new HashSet<String>();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", periods, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            PerfPeriodCollection periodCollection = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(evi);
            if (periodCollection != null && periodCollection.size() > 0) {
                for (int i = 0; i < periodCollection.size(); ++i) {
                    periodName.add(periodCollection.get(0).getName());
                }
            } else {
                MultiPerfPeriodCollection multiPerfPeriodCollection = MultiPerfPeriodFactory.getLocalInstance(ctx).getMultiPerfPeriodCollection(evi);
                if (multiPerfPeriodCollection != null && multiPerfPeriodCollection.size() > 0) {
                    for (int i = 0; i < multiPerfPeriodCollection.size(); ++i) {
                        periodName.add(multiPerfPeriodCollection.get(0).getName());
                    }
                }
            }
            if (periodName.size() == 0) {
                logger.error("my perf history list query by periodId not exist");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("periodName", periodName, CompareType.INCLUDE));
            }
        }
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by isImportByHand, status desc, periodYear desc, periodTime desc, id");
        }
        catch (ParserException e) {
            logger.error("my perf history list sortItems error", (Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("pname"));
        sic.add(new SelectorItemInfo("pnumber"));
        sic.add(new SelectorItemInfo("perfModel.id"));
        sic.add(new SelectorItemInfo("perfModel.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("positionName"));
        sic.add(new SelectorItemInfo("evaPlanName"));
        sic.add(new SelectorItemInfo("evaPlan.name"));
        sic.add(new SelectorItemInfo("periodName"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("adminOrgName"));
        sic.add(new SelectorItemInfo("isImportByHand"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("periodTime"));
        sic.add(new SelectorItemInfo("lastSumScore"));
        sic.add(new SelectorItemInfo("lastGradeLevel"));
        sic.add(new SelectorItemInfo("businessId"));
        sic.add(new SelectorItemInfo("evaPlan.id"));
        sic.add(new SelectorItemInfo("multiPerfPlan.id"));
        sic.add(new SelectorItemInfo("adminOrgName"));
        sic.add(new SelectorItemInfo("person.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        return evi;
    }

    private String getBaseSQL(Context ctx, Map map) throws BOSException {
        AdminOrgUnitCollection adminOrgUnitCollection;
        String permItemId;
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String positionName = (String)map.get("positionName");
        String perfResult = (String)map.get("perfResult");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        String number = (String)map.get("number");
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append(" result.fid AS id,").append(" result.fpname AS pname,").append(" result.fevaobjid AS evaObjId,").append(" result.fbusinessid AS businessId,").append(" result.fpnumber AS pnumber,").append(" result.fstatus AS status,").append(" result.fbillState AS billState,").append(" result.fpositionName AS positionName,").append(" result.fevaPlanName AS perfPlanName,").append(" result.fperiodName AS periodName,").append(" result.fadminOrgName AS adminOrgName,").append(" result.fisImportByHand AS isImportByHand,").append(" result.fhistroryimport AS historyImport,").append(" result.fperiodYear AS periodYear,").append(" result.fperiodType AS periodType,").append(" result.fperiodTime AS periodTime,").append(" result.flastSumScore AS lastSumScore,").append(" result.flastGradeLevel AS lastGradeLevel,").append(" result.FSumScore AS sumScore,").append(" result.FGradeLevel AS gradeLevel,").append(" result.fbusinessId AS businessId,").append(" result.fevaPlanId AS evaPlanId,").append(" result.fmultiPerfPlanId AS multiPerfPlanId,").append(" result.fperfModelId AS perfModelId,").append(" result.fpersonId AS personId,").append(" result.FREVISEREASON AS reviseReason,").append(" perfPlan.fname" + mlFlag + " AS planName,").append(" multiPerfPlan.fname" + mlFlag + " AS multiPlanName,").append(" position.fname" + mlFlag + " AS posName,").append(" adminOrg.fname" + mlFlag + " AS adminName,").append(" person.fname" + mlFlag + " AS personName,").append(" result.fAuditdate AS auditDate,").append(" period.fpStartDate AS pStartDate,").append(" period.fpEndDate AS pEndDate,").append(" perfModel.fname" + mlFlag + " AS perfModelName, ").append(" result.FConfirmState AS confirmState, ").append(" result.FAppealState AS appealState, ").append(" perfPlan.FNeedConfirm AS needConfirm, ").append(" perfPlan.FAppealDays AS appealDays, ").append(" perfPlan.FAllowAppeal AS allowAppeal ").append(" FROM T_EVA_EvaResultSummary result ").append(" LEFT JOIN T_PEF_PerfModel perfModel ").append(" ON perfModel.fid = result.FPerfModelID ").append(" LEFT JOIN T_EVA_PerfPeriod period ").append(" ON period.fid = result.FPeriodID ").append(" LEFT JOIN T_EVA_PerfPlan perfPlan ").append(" ON result.FEvaPlanID = perfPlan.FID ").append(" LEFT JOIN T_EVA_MultiPerfPlan multiPerfPlan ").append(" ON result.FMultiPerfPlanId = multiPerfPlan.FID ").append(" LEFT JOIN T_ORG_Position position ").append(" ON result.FPositionId = position.FID ").append(" LEFT JOIN T_ORG_ADMIN adminOrg ").append(" ON result.FADMINORGNUMBER = adminOrg.FNumber ").append(" LEFT JOIN T_BD_Person person ").append(" ON result.fpersonId = person.FID ").append(" WHERE ").append(" fbillState ='3'");
        String string = permItemId = map.get("permItemId") != null ? (String)map.get("permItemId") : "";
        if (!StringUtils.isEmpty((CharSequence)permItemId)) {
            sb.append(" and FAdminOrgUnitID in (" + SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)permItemId) + ")");
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            sb.append(" AND fpnumber = ? ");
        } else {
            sb.append(" AND fpersonId = ? ");
        }
        if (!StringUtils.isEmpty((CharSequence)positionName) && !StringUtils.isEmpty((CharSequence)perfResult)) {
            sb.append(" AND (fpositionName like ? OR").append(" position.fname" + mlFlag + " like ? OR").append(" flastGradeLevel like ? ");
            if (StringUtils.isNumeric((CharSequence)perfResult)) {
                sb.append(" OR flastSumScore = ?");
            }
            sb.append(")");
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId) && (adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id='" + belongOrgId + "'")) != null && adminOrgUnitCollection.size() > 0) {
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            sb.append(" AND fadminOrgLongNumber like '" + adminOrgUnitInfo.getLongNumber() + "!%'");
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            if ("importByHand".equals(perfPlanId)) {
                sb.append(" and result.FIsImportByHand = '1' and (result.FHistroryImport = '0' or result.FHistroryImport is null) ");
            } else if ("historyImport".equals(perfPlanId)) {
                sb.append(" and result.FHistroryImport = '1' ");
            } else {
                String perfPlanName = null;
                PerfPlanCollection planCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection("where id='" + perfPlanId + "'");
                if (planCollection != null && planCollection.size() > 0) {
                    perfPlanName = planCollection.get(0).getName();
                } else {
                    MultiPerfPlanCollection multiPerfPlanCollection = MultiPerfPlanFactory.getLocalInstance(ctx).getMultiPerfPlanCollection("where id='" + perfPlanId + "'");
                    if (multiPerfPlanCollection != null && multiPerfPlanCollection.size() > 0) {
                        perfPlanName = multiPerfPlanCollection.get(0).getName();
                    }
                }
                if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                    logger.error("my history list query by perfPlanId not exist");
                } else {
                    sb.append(" and result.FEvaPlanName = '" + perfPlanName + "' ");
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            HashSet<String> periodName = new HashSet<String>();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", periods, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            PerfPeriodCollection periodCollection = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(evi);
            if (periodCollection != null && periodCollection.size() > 0) {
                for (int i = 0; i < periodCollection.size(); ++i) {
                    periodName.add(periodCollection.get(i).getName());
                }
            } else {
                MultiPerfPeriodCollection multiPerfPeriodCollection = MultiPerfPeriodFactory.getLocalInstance(ctx).getMultiPerfPeriodCollection(evi);
                if (multiPerfPeriodCollection != null && multiPerfPeriodCollection.size() > 0) {
                    for (int i = 0; i < multiPerfPeriodCollection.size(); ++i) {
                        periodName.add(multiPerfPeriodCollection.get(i).getName());
                    }
                }
            }
            if (periodName.size() == 0) {
                logger.error("my perf history list query by periodId not exist");
            } else {
                FilterInfo periodFilter = new FilterInfo();
                periodFilter.getFilterItems().add(new FilterItemInfo("result.FperiodName", periodName, CompareType.INCLUDE));
                sb.append(" AND " + periodFilter.toSql());
            }
        }
        sb.append(" order by result.fisImportByHand, result.fstatus desc, result.fperiodYear desc, result.fperiodTime desc, result.fid ");
        return sb.toString();
    }
}

