/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPersonPhotoService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetPersonPhotoService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String[] personNumbers;
        HashMap<String, String> result = new HashMap<String, String>();
        Object personIdsParam = map.get("personIds");
        Object personNumbersParam = map.get("personNumbers");
        Object widthParam = map.get("width");
        Object heightParam = map.get("height");
        Object isZipParam = map.get("isZip");
        if (personIdsParam == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "personIds required");
            return result;
        }
        if (personNumbersParam == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "personNumbers required");
            return result;
        }
        String[] personIds = String.valueOf(personIdsParam).split(",");
        if (personIds.length != (personNumbers = String.valueOf(personNumbersParam).split(",")).length) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "the personIds and personNumbers count does not match");
            return result;
        }
        int width = 0;
        int height = 0;
        boolean isZip = false;
        if (widthParam != null) {
            width = (Integer)widthParam;
        }
        if (heightParam != null) {
            height = (Integer)heightParam;
        }
        if (isZipParam != null && "1".equals(String.valueOf(isZipParam))) {
            isZip = true;
        }
        HashMap<String, String> personsMap = new HashMap<String, String>();
        for (int i = 0; i < personIds.length; ++i) {
            personsMap.put(personIds[i], personNumbers[i]);
        }
        Map<Object, Object> photoMap = new HashMap();
        try {
            photoMap = PhotoUtils.getBase64Images(ctx, personsMap, width, height, isZip);
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
        }
        for (Map.Entry item : personsMap.entrySet()) {
            String key = (String)item.getKey();
            personsMap.put(key, (String)photoMap.get(key));
        }
        return personsMap;
    }
}

