/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.AdminOrgFilterUtil;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTeamPerfHistoryService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetTeamPerfHistoryService.class.getName());
    private static String MULTI_PERF_MODEL_ID = "pER9PCMLSzypG7wVLbGZqqtdChg=";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        try {
            String baseSQL = this.getBaseSQL(ctx, map);
            String nameTemp = (String)map.get("name");
            String positionNameTemp = (String)map.get("positionName");
            String perfResult = (String)map.get("perfResult");
            ArrayList<Object> params = new ArrayList<Object>();
            if (!StringUtils.isEmpty((CharSequence)nameTemp) && nameTemp.equals(positionNameTemp) && nameTemp.equals(perfResult)) {
                params.add("%" + nameTemp + "%");
                params.add("%" + positionNameTemp + "%");
                params.add("%" + nameTemp + "%");
                params.add("%" + positionNameTemp + "%");
                params.add(perfResult + "%");
                if (NumberUtils.isNumber((String)nameTemp)) {
                    Double score = Double.parseDouble(nameTemp);
                    params.add(score);
                }
            } else {
                if (!StringUtils.isEmpty((CharSequence)nameTemp)) {
                    params.add("%" + nameTemp + "%");
                }
                if (!StringUtils.isEmpty((CharSequence)positionNameTemp)) {
                    params.add("%" + positionNameTemp + "%");
                }
                if (!StringUtils.isEmpty((CharSequence)perfResult)) {
                    params.add(perfResult);
                    params.add(perfResult + "%");
                }
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])params.toArray());
            int totalCount = rowSet.size();
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            IRowSet dataSet = PerfDbUtil.executeQuery(ctx, baseSQL, (page - 1) * rows, length, params.toArray());
            LinkedList data = new LinkedList();
            HashSet<String> perfModelIds = new HashSet<String>();
            HashSet<String> multiEvaObjIds = new HashSet<String>();
            while (dataSet.next()) {
                String lastSumScore;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                String periodDate = dataSet.getString("periodDate");
                int isImportByHand = dataSet.getInt("isImportByHand");
                String perfPlanName = dataSet.getString("perfPlanName");
                String name = dataSet.getString("name");
                String personName = dataSet.getString("personName");
                String positionName = dataSet.getString("positionName");
                String adminOrgName = dataSet.getString("adminOrgName");
                String multiPlanName = dataSet.getString("multiPlanName");
                String posName = dataSet.getString("posName");
                String adminName = dataSet.getString("adminName");
                if (!StringUtils.isEmpty((CharSequence)multiPlanName)) {
                    perfPlanName = multiPlanName;
                }
                if (!StringUtils.isEmpty((CharSequence)posName)) {
                    positionName = posName;
                }
                if (!StringUtils.isEmpty((CharSequence)adminName)) {
                    adminOrgName = adminName;
                }
                if (!StringUtils.isEmpty((CharSequence)personName)) {
                    name = personName;
                }
                int noDetailFlag = 0;
                if (1 == isImportByHand) {
                    String periodYear = dataSet.getString("periodYear");
                    String periodTime = dataSet.getString("periodTime");
                    int periodType = dataSet.getInt("periodType");
                    if (100 == periodType) {
                        periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{periodYear});
                    } else if (200 == periodType) {
                        periodDate = periodTime.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{periodYear}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{periodYear});
                    } else if (400 == periodType) {
                        String[] yearWithMonths = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MONTHS, ctx, new Object[]{periodYear}).split(",");
                        periodDate = yearWithMonths[Integer.valueOf(periodTime) - 1];
                    } else if (300 == periodType) {
                        periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, ctx, new Object[]{periodYear, periodTime});
                    }
                    noDetailFlag = 1;
                    if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                        perfPlanName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx);
                    }
                } else {
                    String perfModelId = dataSet.getString("perfModelId");
                    if (!StringUtils.isEmpty((CharSequence)perfModelId)) {
                        perfModelIds.add(perfModelId);
                        if (MULTI_PERF_MODEL_ID.equals(perfModelId)) {
                            multiEvaObjIds.add(dataSet.getString("businessId"));
                            noDetailFlag = 1;
                        } else {
                            Date pStartDate = dataSet.getDate("pStartDate");
                            Date pEndDate = dataSet.getDate("pEndDate");
                            if (pStartDate != null && pEndDate != null) {
                                periodDate = DateUtil.dateToStr((java.util.Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((java.util.Date)pEndDate, (String)"yyyy-MM-dd");
                            }
                            if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                                perfPlanName = dataSet.getString("evaPerfPlanName");
                            }
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)periodDate)) {
                    periodDate = dataSet.getString("schemeperiod");
                }
                if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                    perfPlanName = dataSet.getString("schemepname");
                }
                if (!StringUtils.isEmpty((CharSequence)(lastSumScore = dataSet.getString("lastSumScore")))) {
                    Double score = Double.valueOf(lastSumScore);
                    rowMap.put("lastSumScore", String.valueOf(PerfPortalUtils.roudUpRemainGiveDecimal(2, score.floatValue())));
                }
                rowMap.put("lastGradeLevel", StringUtils.isEmpty((CharSequence)dataSet.getString("lastGradeLevel")) ? "" : dataSet.getString("lastGradeLevel"));
                rowMap.put("noDetailFlag", noDetailFlag);
                rowMap.put("periodDate", periodDate);
                rowMap.put("number", dataSet.getString("number"));
                rowMap.put("name", name);
                rowMap.put("positionName", positionName);
                rowMap.put("adminOrgName", adminOrgName);
                rowMap.put("perfModelName", dataSet.getString("perfModelName"));
                rowMap.put("businessId", dataSet.getString("businessId"));
                rowMap.put("perfModelId", dataSet.getString("perfModelId"));
                rowMap.put("id", dataSet.getString("id"));
                rowMap.put("evaObjId", dataSet.getString("evaObjId"));
                rowMap.put("personId", dataSet.getString("personId"));
                rowMap.put("perfPlanName", perfPlanName);
                rowMap.put("photo", null);
                rowMap.put("reviseReason", dataSet.getString("reviseReason"));
                data.add(rowMap);
            }
            HashMap<String, String> multiPerfMap = new HashMap<String, String>();
            if (multiEvaObjIds.size() > 0) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", multiEvaObjIds, CompareType.INCLUDE));
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("id"));
                selectorItemCollection.add(new SelectorItemInfo("multiPeriod.pStartDate"));
                selectorItemCollection.add(new SelectorItemInfo("multiPeriod.pEndDate"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectorItemCollection);
                MultiPerfEvaObjectCollection perfEvaObjectCollection = MultiPerfEvaObjectFactory.getLocalInstance(ctx).getMultiPerfEvaObjectCollection(evi);
                if (perfEvaObjectCollection != null && perfEvaObjectCollection.size() > 0) {
                    for (int j = 0; j < perfEvaObjectCollection.size(); ++j) {
                        MultiPerfEvaObjectInfo multiPerfEvaObjectInfo = perfEvaObjectCollection.get(j);
                        java.util.Date pStartDate = multiPerfEvaObjectInfo.getMultiPeriod().getPStartDate();
                        java.util.Date pEndDate = multiPerfEvaObjectInfo.getMultiPeriod().getPEndDate();
                        if (pStartDate == null || pEndDate == null) continue;
                        String periodDate = DateUtil.dateToStr((java.util.Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((java.util.Date)pEndDate, (String)"yyyy-MM-dd");
                        multiPerfMap.put(multiPerfEvaObjectInfo.getId().toString(), periodDate);
                    }
                }
                for (int i = 0; i < data.size(); ++i) {
                    Map resultMap = (Map)data.get(i);
                    String perfModelId = (String)resultMap.get("perfModelId");
                    if (StringUtils.isEmpty((CharSequence)perfModelId) || !MULTI_PERF_MODEL_ID.equals(perfModelId)) continue;
                    resultMap.put("periodDate", multiPerfMap.get(resultMap.get("businessId")));
                }
            }
            int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            result.put("pages", pages);
            result.put("records", totalCount);
            result.put("rows", data);
        }
        catch (SQLException e) {
            logger.error("perfPlan query failed", (Throwable)e);
        }
        return result;
    }

    private String getBaseSQL(Context ctx, Map map) throws BOSException {
        String permItemId;
        String name = (String)map.get("name");
        String positionName = (String)map.get("positionName");
        String perfResult = (String)map.get("perfResult");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        FilterInfo dateFilter = new FilterInfo();
        Timestamp sysDate = new Timestamp(System.currentTimeMillis());
        dateFilter.getFilterItems().add(new FilterItemInfo("orgRel.FEFFDT", (Object)sysDate, CompareType.LESS_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("orgRel.FLEFFDT", (Object)sysDate, CompareType.GREATER));
        FilterInfo dateFilter2 = new FilterInfo();
        dateFilter2.getFilterItems().add(new FilterItemInfo("pp.FEFFDT", (Object)sysDate, CompareType.LESS_EQUALS));
        dateFilter2.getFilterItems().add(new FilterItemInfo("pp.FLEFFDT", (Object)sysDate, CompareType.GREATER));
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append(" evaResult.FPnumber AS number, evaResult.FPname AS name, evaResult.FID AS id, evaResult.FStatus AS status, ").append(" evaResult.FPeriodID AS periodId, evaResult.FEvaPlanID AS perfPlanId, perfModel.FName" + mlFlag + " perfModelName,").append(" evaResult.FPositionName AS positionName, evaResult.FBusinessId AS businessId, perfPlan.FName" + mlFlag + " AS evaPerfPlanName,").append(" multiPerfPlan.fname" + mlFlag + " AS multiPlanName, person.fname" + mlFlag + " AS personName, position.fname" + mlFlag + " AS posName, ").append(" adminOrgUnit.fname" + mlFlag + " AS adminName, ").append(" evaResult.FAdminOrgName AS adminOrgName, evaResult.FLastSumScore AS lastSumScore, ").append(" evaResult.FLastGradeLevel AS lastGradeLevel, evaResult.FPersonID AS personId,").append(" evaResult.FIsImportByHand AS isImportByHand, evaResult.FMultiPeriodId AS periodId,").append(" evaResult.FPeriodYear AS periodYear, evaResult.FPeriodType AS periodType, ").append(" evaResult.FPeriodTime AS periodTime, evaResult.FEvaObjID AS evaObjId, evaResult.FLastUpdateTime,").append(" evaResult.FPerfModelID AS perfModelId, evaResult.FEvaPlanName AS perfPlanName, evaResult.FPeriodName AS periodDate, evaResult.FREVISEREASON AS reviseReason, ").append(" period.FPStartDate AS pStartDate, period.FPEndDate AS pEndDate, ").append(" summaryScheme.FName" + mlFlag + " AS schemename , summaryScheme.FPeriodStr" + mlFlag + " as schemeperiod").append(" from T_EVA_EvaResultSummary evaResult ").append(" left join T_EVA_SummaryPersonEvaObject  sumaryEvaObj on  evaResult.FSummaryPersonEvaObject=sumaryEvaObj.Fid").append(" left join T_Eva_PerfSummarySchemeBase summaryScheme on sumaryEvaObj.FPerfSummarySchemeBase=summaryScheme.Fid").append(" left join T_BD_PERSON person on evaResult.FPersonID = person.FID ").append(" left join T_HR_EMPORGRELATION orgRel on evaResult.FPersonID = orgRel.FPersonID ").append(" left join T_HR_BDEMPLOYEETYPE employeeType on person.FEmployeeTypeId = employeeType.FID  ").append(" left join T_HR_PERSONPOSITION personPostion on person.FID = personPostion.FPersonId  ").append(" left join T_HR_PERSONPOSITIONHIS pp on pp.FPersonId = person.FID ").append(" left join T_ORG_Admin adminOrgUnit  on adminOrgUnit.FID = personPostion.FPersonDep  ").append(" left join T_ORG_POSITION position on position.Fid = orgRel.FPositionId ").append(" left join T_PM_OrgRange range on range.FORGID = adminOrgUnit.FID").append(" left join T_EVA_PerfPlan perfPlan  on evaResult.FEvaPlanID = perfPlan.FID ").append(" left join T_EVA_PerfPeriod period  on evaResult.FPeriodID = period.FID ").append(" left join T_PEF_PerfModel perfModel  on perfModel.FID = evaResult.FPerfModelID ").append(" inner join (select max(FLastUpdateTime) FLastUpdateTime, FPnumber from T_EVA_EvaResultSummary where FBillState = 3 group by FPnumber) a ").append(" on evaResult.FPnumber = a.FPnumber and evaResult.FLastUpdateTime = a.FLastUpdateTime").append(" left join T_EVA_MultiPerfPlan multiPerfPlan  ON evaResult.FMultiPerfPlanId = multiPerfPlan.FID  ").append(" where orgRel.FAssignType='1' and orgRel.FIsInner='1'and orgRel.FIsEnrolled='1' and (employeeType.FIsOnTheStrength='1' or employeeType.FIsInCount='1') ").append(" and " + dateFilter.toSql()).append(" and " + dateFilter2.toSql()).append(" and range.FUserID = '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "'").append(" and range.FType = 20 ").append(" and adminOrgUnit.FISSTARTSHR = 1");
        String string = permItemId = map.get("permItemId") != null ? (String)map.get("permItemId") : "";
        if (!StringUtils.isEmpty((CharSequence)permItemId)) {
            FilterInfo deFaultFilter = GetTeamPerfHistoryService.getResposeFilter(ctx, permItemId);
            sb.append(" and ").append(deFaultFilter.toSql());
        }
        if (!StringUtils.isEmpty((CharSequence)name) && name.equals(positionName) && name.equals(perfResult)) {
            sb.append(" and (evaResult.FPname like ?").append(" or evaResult.FPositionName like ? ").append(" or person.FName" + mlFlag + " like ? ").append(" or position.FName" + mlFlag + " like ? ").append(" or evaResult.FLastGradeLevel like ? ");
            if (NumberUtils.isNumber((String)name)) {
                Double score = Double.parseDouble(name);
                sb.append("or evaResult.FLastSumScore = ?");
            }
            sb.append(" )");
        } else {
            if (!StringUtils.isEmpty((CharSequence)name)) {
                sb.append(" and evaResult.FPname like ?");
            }
            if (!StringUtils.isEmpty((CharSequence)positionName)) {
                sb.append(" and aa.FPositionName like ?");
            }
            if (!StringUtils.isEmpty((CharSequence)perfResult)) {
                sb.append(" and (evaResult.FLastSumScore = ? or evaResult.FLastGradeLevel like ?)");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            sb.append(" and adminOrgUnit.FID in (" + AdminOrgFilterUtil.getUserIncludeSubAdminOrgRangeSql(ctx, belongOrgId) + ")");
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            if ("importByHand".equals(perfPlanId)) {
                sb.append(" and evaResult.FIsImportByHand = '1' and (evaResult.FHistroryImport = '0' or evaResult.FHistroryImport is null) ");
            } else if ("historyImport".equals(perfPlanId)) {
                sb.append(" and evaResult.FHistroryImport = '1' ");
            } else {
                String perfPlanName = null;
                PerfPlanCollection planCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection("where id='" + perfPlanId + "'");
                if (planCollection != null && planCollection.size() > 0) {
                    perfPlanName = planCollection.get(0).getName();
                } else {
                    MultiPerfPlanCollection multiPerfPlanCollection = MultiPerfPlanFactory.getLocalInstance(ctx).getMultiPerfPlanCollection("where id='" + perfPlanId + "'");
                    if (multiPerfPlanCollection != null && multiPerfPlanCollection.size() > 0) {
                        perfPlanName = multiPerfPlanCollection.get(0).getName();
                    }
                }
                if (StringUtils.isEmpty((CharSequence)perfPlanName)) {
                    logger.error("my perf history list query by perfPlanId not exist");
                } else {
                    sb.append(" and evaResult.FEvaPlanName = '" + perfPlanName + "' ");
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            HashSet<String> periodName = new HashSet<String>();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", periods, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            PerfPeriodCollection periodCollection = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(evi);
            if (periodCollection != null && periodCollection.size() > 0) {
                for (int i = 0; i < periodCollection.size(); ++i) {
                    periodName.add(periodCollection.get(0).getName());
                }
            } else {
                MultiPerfPeriodCollection multiPerfPeriodCollection = MultiPerfPeriodFactory.getLocalInstance(ctx).getMultiPerfPeriodCollection(evi);
                if (multiPerfPeriodCollection != null && multiPerfPeriodCollection.size() > 0) {
                    for (int i = 0; i < multiPerfPeriodCollection.size(); ++i) {
                        periodName.add(multiPerfPeriodCollection.get(0).getName());
                    }
                }
            }
            if (periodName.size() == 0) {
                logger.error("my team perf history list query by periodId not exist");
            } else {
                FilterInfo periodFilter = new FilterInfo();
                periodFilter.getFilterItems().add(new FilterItemInfo("evaResult.periodName", periodName, CompareType.INCLUDE));
                sb.append(" and " + filterInfo.toSql());
            }
        }
        sb.append(" order by evaResult.FIsImportByHand, evaResult.FPeriodYear desc,evaResult.FPeriodType asc,evaResult.FPeriodTime desc, evaResult.FID ");
        return sb.toString();
    }

    public static Map<String, Object> formatItem(Context ctx, IRowSet rs) throws SQLException {
        String number;
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", rs.getString("FID"));
        item.put("personId", rs.getString("FPersonID"));
        item.put("periodId", rs.getString("FPeriodID"));
        item.put("perfPlanId", rs.getString("FEvaPlanID"));
        item.put("positionName", rs.getString("FPositionName"));
        item.put("adminOrgName", rs.getString("FAdminOrgName"));
        item.put("adminOrgNumber", rs.getString("FAdminOrgID"));
        item.put("perfModelName", rs.getString("FPerfModelName"));
        item.put("status", rs.getString("FStatus"));
        BigDecimal lastSumScore = rs.getBigDecimal("FLastSumScore");
        if (lastSumScore != null) {
            lastSumScore = lastSumScore.setScale(2, 4);
        }
        item.put("lastSumScore", lastSumScore);
        item.put("lastGradeLevel", rs.getString("FLastGradeLevel"));
        String name = rs.getString("FPName");
        if (!StringUtils.isEmpty((CharSequence)name)) {
            item.put("name", name);
        }
        if (!StringUtils.isEmpty((CharSequence)(number = rs.getString("FPnumber")))) {
            item.put("number", number);
        }
        String perfPlanName = rs.getString("FPerfPlanName");
        String periodDate = rs.getString("FPeriodName");
        int isImportByHand = rs.getInt("FIsImportByHand");
        if (1 == isImportByHand) {
            perfPlanName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx);
            String periodYear = rs.getString("FPeriodYear");
            int periodType = rs.getInt("FPeriodType");
            String periodTime = rs.getString("FPeriodTime");
            if (100 == periodType) {
                periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{periodYear});
            } else if (200 == periodType) {
                periodDate = periodTime.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{periodYear}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{periodYear});
            } else if (400 == periodType) {
                String[] yearWithMonths = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MONTHS, ctx, new Object[]{periodYear}).split(",");
                periodDate = yearWithMonths[Integer.valueOf(periodTime) - 1];
            } else if (300 == periodType) {
                periodDate = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, ctx, new Object[]{periodYear, periodTime});
            }
        }
        item.put("perfPlanName", perfPlanName);
        item.put("periodDate", periodDate);
        item.put("evaObjId", rs.getString("FEvaObjID"));
        item.put("photo", null);
        return item;
    }

    private static FilterInfo getResposeFilter(Context ctx, String permItemId) {
        FilterInfo deFaultFilter = new FilterInfo();
        String departmentAdminRangeSQL = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)permItemId);
        deFaultFilter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.FID", (Object)departmentAdminRangeSQL, CompareType.INNER));
        return deFaultFilter;
    }

    private static AdminOrgUnitCollection getResponseAdminCollection(Context ctx, Set<String> positionSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("responPosition", positionSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
    }

    private static EmpPosOrgRelationCollection getEmpOrgRelCollection(Context ctx, String person) throws BOSException {
        java.util.Date now = new java.util.Date();
        String currentDate = PerfDateUtils.formatDate(now, "yyyy-MM-dd");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("position.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)person, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)currentDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)currentDate, CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        return EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
    }
}

