/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.osf.CommonListHandlerService;
import com.kingdee.shr.perfweb.util.OrgEvaResultSummaryBizUtil;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ORGEvaluCardList4HisService
extends CommonListHandlerService {
    private Logger logger = LoggerFactory.getLogger(ORGEvaluCardList4HisService.class);

    @Override
    public FilterInfo getDefoFilter(Context ctx, Map param) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        FilterInfo otherFilter = new FilterInfo();
        HashSet errIds = Sets.newHashSet((Object[])new String[]{"Err"});
        PerfEvaluAdminResponsorCollection responsorCollection = null;
        try {
            FilterInfo filterInfo;
            responsorCollection = PerfEvaluAdminResponsorFactory.getRemoteInstance().getPerfEvaluAdminResponsorCollection("select evaObj.id where person.id = '" + personId + "'");
            if (responsorCollection != null && responsorCollection.size() > 0) {
                HashSet<String> evaObjSet = null;
                filterInfo = new FilterInfo();
                evaObjSet = new HashSet<String>();
                Iterator iterator = responsorCollection.iterator();
                while (iterator.hasNext()) {
                    PerfEvaluAdminResponsorInfo next = (PerfEvaluAdminResponsorInfo)iterator.next();
                    evaObjSet.add(next.getEvaObj().getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjSet, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)"3"));
                otherFilter.mergeFilter(filterInfo, "OR");
            } else {
                FilterInfo filterInfo2 = new FilterInfo();
                filterInfo2.getFilterItems().add(new FilterItemInfo("evaObj.id", (Object)errIds, CompareType.INCLUDE));
                otherFilter.mergeFilter(filterInfo2, "OR");
            }
            PerfOrgEvaSumResponsorCollection perfOrgEvaSumResponsorCollection = PerfOrgEvaSumResponsorFactory.getRemoteInstance().getPerfOrgEvaSumResponsorCollection("select OrgEvaResultSummaryId where person.id = '" + personId + "'");
            if (perfOrgEvaSumResponsorCollection != null && perfOrgEvaSumResponsorCollection.size() > 0) {
                HashSet<String> ids = null;
                FilterInfo filterInfo3 = new FilterInfo();
                ids = new HashSet<String>();
                Iterator iterator = perfOrgEvaSumResponsorCollection.iterator();
                while (iterator.hasNext()) {
                    PerfOrgEvaSumResponsorInfo next = (PerfOrgEvaSumResponsorInfo)iterator.next();
                    ids.add(next.getOrgEvaResultSummaryId());
                }
                filterInfo3.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                filterInfo3.getFilterItems().add(new FilterItemInfo("billState", (Object)"3"));
                otherFilter.mergeFilter(filterInfo3, "OR");
            } else {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", (Object)errIds, CompareType.INCLUDE));
                otherFilter.mergeFilter(filterInfo, "OR");
            }
        }
        catch (BOSException e) {
            this.logger.error("BOSException: ", (Throwable)e);
        }
        return otherFilter;
    }

    @Override
    public FilterInfo getAdvanceFilter(Context ctx, Map param) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        String searchText = MapUtils.getParam(param, "searchText");
        String belongOrgId = MapUtils.getParam(param, "belongOrgId");
        String perfPlanId = MapUtils.getParam(param, "perfPlanId");
        String periodId = MapUtils.getParam(param, "periodId");
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)belongOrgId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId) || !StringUtils.isEmpty((CharSequence)periodId)) {
            FilterInfo filter2 = new FilterInfo();
            if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
                filter2.getFilterItems().add(new FilterItemInfo("evaPlan.id", (Object)perfPlanId, CompareType.EQUALS));
            }
            if (!StringUtils.isEmpty((CharSequence)periodId)) {
                Object[] split = periodId.split(",");
                HashSet periodIdSet = Sets.newHashSet((Object[])split);
                filter2.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodIdSet, CompareType.INCLUDE));
            }
            FilterInfo filter3 = new FilterInfo();
            if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
                filter3.getFilterItems().add(new FilterItemInfo("multiPerfPlan.id", (Object)perfPlanId, CompareType.EQUALS));
            }
            if (!StringUtils.isEmpty((CharSequence)periodId)) {
                Object[] split = periodId.split(",");
                HashSet periodIdSet = Sets.newHashSet((Object[])split);
                filter3.getFilterItems().add(new FilterItemInfo("multiPeriod.id", (Object)periodIdSet, CompareType.INCLUDE));
            }
            filter2.mergeFilter(filter3, "or");
            filter.mergeFilter(filter2, "and");
        }
        boolean isNum = false;
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("evaPlanName", (Object)("%" + searchText + "%"), CompareType.LIKE));
            filter1.getFilterItems().add(new FilterItemInfo("lastGradeLevel", (Object)("%" + searchText + "%"), CompareType.LIKE));
            if (NumberUtils.isDigits((String)searchText)) {
                try {
                    double v = NumberUtils.toDouble((String)searchText);
                    isNum = true;
                    filter1.getFilterItems().add(new FilterItemInfo("lastSumScore", (Object)searchText, CompareType.EQUALS));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isNum) {
                filter1.setMaskString("(#0 or #1 or #2 )");
            } else {
                filter1.setMaskString("(#0 or #1 )");
            }
            filter.mergeFilter(filter1, "and");
        }
        return filter;
    }

    @Override
    public void afterGetListData(Context ctx, List list) {
        try {
            OrgEvaResultSummaryBizUtil.desposeResponsorBySummaryResult(ctx, list);
            for (Object o : list) {
                boolean noDetailFlag = false;
                OrgEvaResultSummaryInfo summaryInfo = (OrgEvaResultSummaryInfo)o;
                summaryInfo.put("noDetailFlag", 0);
                if (summaryInfo.getPerfModel() != null && summaryInfo.getPerfModel().getId() != null && summaryInfo.getPerfModel().getId().toString().equals("pER9PCMLSzypG7wVLbGZqqtdChg=")) {
                    summaryInfo.put("noDetailFlag", 1);
                    noDetailFlag = true;
                }
                if (YesOrNoEnum.YES == summaryInfo.getIsImportByHand()) {
                    summaryInfo.put("noDetailFlag", 1);
                    noDetailFlag = true;
                }
                String needConfirm = "0";
                String allowAppeal = "0";
                int appealDays = 0;
                if (summaryInfo.getEvaPlan() != null && summaryInfo.getEvaPlan().isNeedConfirm()) {
                    needConfirm = "1";
                }
                if (summaryInfo.getEvaPlan() != null && summaryInfo.getEvaPlan().isAllowAppeal()) {
                    allowAppeal = "1";
                }
                if (summaryInfo.getEvaPlan() != null) {
                    appealDays = summaryInfo.getEvaPlan().getAppealDays();
                }
                if (StringUtils.isBlank((CharSequence)summaryInfo.getString("confirmState")) || "0".equalsIgnoreCase(summaryInfo.getString("confirmState")) || "1".equalsIgnoreCase(summaryInfo.getString("confirmState"))) {
                    if ("0".equalsIgnoreCase(needConfirm)) {
                        summaryInfo.put("confirmState", 0);
                    } else if ("1".equalsIgnoreCase(needConfirm)) {
                        summaryInfo.put("confirmState", 1);
                    }
                }
                if (StringUtils.isBlank((CharSequence)summaryInfo.getString("appealState")) || "0".equalsIgnoreCase(summaryInfo.getString("appealState")) || "1".equalsIgnoreCase(summaryInfo.getString("appealState"))) {
                    if ("0".equalsIgnoreCase(allowAppeal)) {
                        summaryInfo.put("appealState", 0);
                    } else if ("1".equalsIgnoreCase(allowAppeal)) {
                        summaryInfo.put("appealState", 1);
                    }
                }
                if (StringUtils.isBlank((CharSequence)summaryInfo.getString("appealState"))) {
                    if ("0".equalsIgnoreCase(allowAppeal)) {
                        summaryInfo.put("appealState", 0);
                    } else if ("1".equalsIgnoreCase(allowAppeal)) {
                        summaryInfo.put("appealState", 1);
                    }
                }
                if (3 != summaryInfo.getInt("billState")) {
                    summaryInfo.put("appealState", 0);
                }
                if (1 == summaryInfo.getInt("status")) {
                    summaryInfo.put("appealState", 0);
                }
                if (1 == summaryInfo.getInt("isImportByHand")) {
                    summaryInfo.put("appealState", 0);
                }
                if (1 == summaryInfo.getInt("historyImport")) {
                    summaryInfo.put("appealState", 0);
                }
                if (2 == summaryInfo.getInt("confirmState") && 1 == summaryInfo.getInt("appealState")) {
                    summaryInfo.put("appealState", 0);
                }
                if ("0".equals(allowAppeal)) {
                    summaryInfo.put("appealState", 0);
                }
                if (noDetailFlag) {
                    summaryInfo.put("appealState", 0);
                }
                if (null == summaryInfo.getDate("auditDate")) {
                    summaryInfo.put("appealState", 0);
                }
                if (appealDays == 0 || null == summaryInfo.getDate("auditDate")) continue;
                Date now = new Date();
                long days = DateUtil.dateDiff((String)"d", (Date)summaryInfo.getDate("auditDate"), (Date)now) + 1L;
                if ((long)appealDays - days >= 0L) continue;
                summaryInfo.put("appealState", 0);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception: ", (Throwable)e);
        }
    }

    @Override
    public void afterResultData(Context ctx, Map<String, Object> reMap) {
        try {
            reMap.put("hideAppealResult", !PermissionUtils.hasFunctionPermission(ctx, "ZZKHJGQRAPPEAL"));
            reMap.put("hideConfirmResult", !PermissionUtils.hasFunctionPermission(ctx, "ZZKHJGQRCONFIRM"));
        }
        catch (EASBizException e) {
            this.logger.error("[perfweb]com.kingdee.shr.perfweb.osf.ORGEvaluCardList4HisService.afterResultData have error!" + e.getMessage());
        }
    }
}

