/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.AttachmentsBean;
import com.kingdee.shr.perfweb.osf.AttachmentDownloadService;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.ssl.MyX509TrustManager;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import sun.net.www.protocol.https.Handler;

public class AttachmentUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.AttachmentUtil");
    public static final Map<String, String> TYPEMAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/gif", "gif");
            this.put("image/x-icon", "ico");
            this.put("image/pnetvue", "net");
            this.put("text/x-setext", "etx");
            this.put("application/msword", "doc");
            this.put("application/zip", "zip");
            this.put("video/mp4", "mp4");
            this.put("application/vnd.ms-excel", "xls");
            this.put("application/xml", "xsl");
            this.put("application/pdf", "pdf");
            this.put("text/plain", "txt");
            this.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
            this.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
            this.put("application/vnd.ms-powerpoint", "ppt");
        }
    };

    public static AttachmentInfo getImageInfoByUrl(Context ctx, String url) {
        if (url.startsWith("https:")) {
            return AttachmentUtil.getImageInfoByHttpsUrl(ctx, url);
        }
        if (url.startsWith("http:")) {
            url = url.replaceFirst("http:", "https:");
            return AttachmentUtil.getImageInfoByHttpsUrl(ctx, url);
        }
        return null;
    }

    public static List<AttachmentInfo> getImageInfoByUrlList(Context ctx, List<String> urlList) {
        logger.error("getImageInfoByUrlList::" + JSON.toJSONString((Object)(urlList == null ? "null" : urlList)));
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>();
        if (!CollectionUtils.isEmpty(urlList)) {
            for (String url : urlList) {
                AttachmentInfo info = AttachmentUtil.getImageInfoByHttpsUrl(ctx, url);
                if (info == null) continue;
                attachmentInfoList.add(info);
            }
        }
        return attachmentInfoList;
    }

    public static void saveAttachments(Context ctx, String fid, String permission, List<String> annexList, List<String> annexIdList) throws BOSException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String operId = null;
        if (ctx.getCaller() != null) {
            operId = ctx.getCaller().toString();
        }
        String cu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ArrayList<String> attachmentIDs = new ArrayList<String>();
        ArrayList<String> assoIDs = new ArrayList<String>();
        String queryAttachSql = "select a.FID AS ATTACHMENTID,b.FID AS ASSOID from T_BAS_Attachment a inner join T_BAS_BoattchAsso b on a.FID = b.FAttachmentID where b.FBoID = ? and a.FPermission = ? ";
        if (!CollectionUtils.isEmpty(annexIdList)) {
            String ids = "(" + PerfwebStrUtils.convertListToString(annexIdList) + ")";
            queryAttachSql = queryAttachSql + " and a.FID not in " + ids;
        }
        String deleteAttachSql = "delete T_BAS_Attachment where FID in  ";
        String deleteAssoSql = "delete T_BAS_BoattchAsso where FID in  ";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)queryAttachSql, (Object[])new Object[]{fid, permission});
        if (rs1 != null) {
            try {
                while (rs1.next()) {
                    String attachmentid = rs1.getString("ATTACHMENTID");
                    String assoid = rs1.getString("ASSOID");
                    if (StringUtils.isNotBlank((CharSequence)attachmentid)) {
                        attachmentIDs.add(attachmentid);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)assoid)) continue;
                    assoIDs.add(assoid);
                }
            }
            catch (SQLException e) {
                logger.error("");
            }
        }
        try {
            if (!CollectionUtils.isEmpty(attachmentIDs)) {
                String attachmentIDsList = "(" + PerfwebStrUtils.convertListToString(attachmentIDs.toArray()) + ")";
                DbUtil.execute((Context)ctx, (String)(deleteAttachSql + attachmentIDsList));
            }
            if (!CollectionUtils.isEmpty(assoIDs)) {
                String assoIDsList = "(" + PerfwebStrUtils.convertListToString(assoIDs.toArray()) + ")";
                DbUtil.execute((Context)ctx, (String)(deleteAssoSql + assoIDsList));
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        try {
            List<AttachmentInfo> imageInfoByUrlList = AttachmentUtil.getImageInfoByUrlList(ctx, annexList);
            if (!CollectionUtils.isEmpty(imageInfoByUrlList)) {
                if (imageInfoByUrlList.size() > 32) {
                    // empty if block
                }
                for (AttachmentInfo attachmentInfo : imageInfoByUrlList) {
                    if (attachmentInfo == null) continue;
                    BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
                    boAttchAssoInfo.setBoID(fid);
                    boAttchAssoInfo.setAssoBusObjType(BOSUuid.getBOSObjectType((String)fid, (boolean)true) + "");
                    boAttchAssoInfo.setAssoType("Added Accessories");
                    if (attachmentInfo.getBoAttchAsso() == null) {
                        attachmentInfo.put("boAttchAsso", (Object)new BoAttchAssoCollection());
                    }
                    attachmentInfo.getBoAttchAsso().add(boAttchAssoInfo);
                    String attachmentID = BOSUuid.create((BOSObjectType)attachmentInfo.getBOSType()).toString();
                    String boAttchAssoID = BOSUuid.create((BOSObjectType)boAttchAssoInfo.getBOSType()).toString();
                    String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
                    String insertAssoSql = "insert into T_BAS_BoAttchAsso(FID,FBoID,FAssoType" + mlFlag + ",FAttachmentID,FAssoBusObjType) values (?,?,?,?,?)";
                    DbUtil.execute((Context)ctx, (String)insertAssoSql, (Object[])new Object[]{boAttchAssoID, boAttchAssoInfo.getBoID(), boAttchAssoInfo.getAssoType(), attachmentID, boAttchAssoInfo.getAssoBusObjType()});
                    String insertAttachSql = "insert into T_BAS_Attachment(FID,FCreatorId,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FCOntrolUnitID,FName" + mlFlag + ",FSimpleName,FType,FFile,FIsShared,FSharedDesc" + mlFlag + ",FSize,FSizeInByte,FAttachID,FStorageType,FRemotePath,FPermission) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    String storageType = attachmentInfo.getStorageType() == null ? "0" : attachmentInfo.getStorageType().getValue();
                    DbUtil.execute((Context)ctx, (String)insertAttachSql, (Object[])new Object[]{attachmentID, operId, now, operId, now, cu, attachmentInfo.getName(), attachmentInfo.getSimpleName(), attachmentInfo.getType(), attachmentInfo.getFile(), attachmentInfo.isIsShared(), attachmentInfo.getSharedDesc(), attachmentInfo.getSize(), attachmentInfo.getSizeInByte(), attachmentInfo.getAttachID(), storageType, attachmentInfo.getRemotePath(), permission});
                }
            }
        }
        catch (Exception e) {
            logger.error("add attachment err::" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentInfo getImageInfoByHttpsUrl(Context ctx, String url) {
        String byteMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.BYTE, ctx);
        String noMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NO, ctx);
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        AttachmentInfo ai = null;
        HttpURLConnection conn = null;
        URLConnection urlConnection = null;
        InputStream is = null;
        try {
            byte[] responseBody = null;
            String type = "";
            if (url.startsWith("https:")) {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                URL requestUrl = new URL(null, url, new Handler());
                conn = (HttpsURLConnection)requestUrl.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("GET");
                ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
                conn.connect();
                is = conn.getInputStream();
                type = conn.getHeaderField("Content-Type");
            } else if (url.startsWith("http:")) {
                URL requestUrl2 = new URL(url);
                urlConnection = requestUrl2.openConnection();
                urlConnection.connect();
                is = urlConnection.getInputStream();
                type = urlConnection.getHeaderField("Content-Type");
            }
            responseBody = AttachmentUtil.input2byte(is);
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            String fullname = "";
            if (url.lastIndexOf("/") + 1 < url.length()) {
                fullname = url.substring(url.lastIndexOf("/") + 1, url.length());
            }
            String mainname = "";
            mainname = fullname.contains(".") ? fullname.substring(0, fullname.indexOf(".")) : fullname;
            String extname = "";
            if (fullname.contains(".") && fullname.indexOf(".") + 1 < fullname.length()) {
                extname = fullname.substring(fullname.indexOf(".") + 1, fullname.length());
                extname = extname.toLowerCase();
            }
            if (!StringUtil.isEmpty((String)type)) {
                if (type.contains(";")) {
                    type = type.substring(0, type.indexOf(";"));
                }
                type = TYPEMAP.get(type);
            } else {
                type = extname;
            }
            if (StringUtil.isEmpty((String)type)) {
                type = extname;
            }
            if (StringUtil.isEmpty((String)fullname) && !StringUtil.isEmpty((String)type)) {
                fullname = "attch_" + System.currentTimeMillis() + "." + type;
            }
            if (StringUtil.isEmpty((String)mainname)) {
                mainname = "attch_" + System.currentTimeMillis() + "";
            }
            if (StringUtil.isEmpty((String)extname)) {
                extname = type;
            }
            byte[] content = responseBody;
            ai = new AttachmentInfo();
            ai.setRemotePath(url);
            ai.setName(mainname);
            ai.setSimpleName(extname);
            int size = 0;
            if (content != null && content.length > 0) {
                ai.setFile(content);
                size = content.length;
            } else {
                logger.error("FEE::content.length==0,RemotePath:" + url + ",SimpleName:" + extname);
            }
            ai.setIsShared(false);
            ai.setSharedDesc(noMl);
            if (size < 1024) {
                ai.setSize(size + byteMl);
            } else {
                ai.setSize(size / 1024 + "KB");
            }
            ai.setSizeInByte(size);
            ai.setAttachID("" + System.currentTimeMillis());
            ai.setType(type);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException: ", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error("KeyManagementException: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("getImageInfoByHttpsUrl IOException: ", (Throwable)e);
                }
            }
            try {
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
                urlConnection = null;
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
        return ai;
    }

    public static byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentInfo getImageInfoByHttpUrl(Context ctx, String url) {
        String byteMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.BYTE, ctx);
        String yesMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YES, ctx);
        String noMl = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NO, ctx);
        AttachmentInfo ai = null;
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                System.err.println("Method failed: " + getMethod.getStatusLine());
            }
            String contentType = getMethod.getResponseHeader("Content-Type").getElements()[0].getName();
            String type = TYPEMAP.get(contentType);
            byte[] responseBody = getMethod.getResponseBody();
            String fullname = url.substring(url.lastIndexOf("/") + 1, url.length()) + "." + type;
            String mainname = fullname.substring(0, fullname.lastIndexOf("."));
            String extname = fullname.substring(fullname.lastIndexOf(".") + 1, fullname.length());
            extname = extname.toLowerCase();
            byte[] content = responseBody;
            ai = new AttachmentInfo();
            ai.setName(mainname);
            ai.setSimpleName(extname);
            ai.setFile(content);
            ai.setIsShared(false);
            ai.setSharedDesc(noMl);
            int size = responseBody.length;
            if (size < 1024) {
                ai.setSize(size + byteMl);
            } else {
                ai.setSize(size / 1024 + "KB");
            }
            ai.setSizeInByte(size);
            ai.setAttachID("" + System.currentTimeMillis());
            ai.setType(type);
        }
        catch (HttpException e) {
            logger.error("Please check your provided http address!", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        return ai;
    }

    public static List<AttachmentsBean> getAttachments(Context ctx, String boId, List<String> gradeTaskNodes) throws BOSException, SQLException {
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        ArrayList<AttachmentsBean> attachmentList = new ArrayList<AttachmentsBean>();
        String gradeTaskNodesIds = "";
        if (CollectionUtils.isEmpty(gradeTaskNodes)) {
            return attachmentList;
        }
        gradeTaskNodesIds = "(" + PerfwebStrUtils.convertListToString(gradeTaskNodes) + ")";
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        String queryAttachmentSql = "select a.FAttachID as FAttachID, a.FID  as ID ,a.FNAME" + mlFlag + " as NAME ,a.FFILE as FFILE ,a.FSIZEINBYTE as FSIZEINBYTE,a.FSIZE as FSIZE ,a.FSIMPLENAME as SIMPLENAME, a.FRemotePath as REMOTEPATH,a.FPERMISSION as FPERMISSION from T_BAS_Attachment a inner join T_BAS_BoattchAsso b on a.FID = b.FAttachmentID where b.FBoID = '" + boId + "' and a.FPermission in " + gradeTaskNodesIds;
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)queryAttachmentSql);
        if (rs1 != null) {
            while (rs1.next()) {
                AttachmentsBean attachmentsBean = new AttachmentsBean();
                if (!StringUtil.isEmpty((String)rs1.getString("REMOTEPATH"))) {
                    attachmentsBean.setUrl(rs1.getString("REMOTEPATH"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("ID"))) {
                    attachmentsBean.setId(rs1.getString("ID"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("NAME"))) {
                    attachmentsBean.setName(rs1.getString("NAME"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FSIZE"))) {
                    attachmentsBean.setSize(rs1.getString("FSIZE"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FSIZEINBYTE"))) {
                    attachmentsBean.setSizeInByte(rs1.getInt("FSIZEINBYTE"));
                } else {
                    attachmentsBean.setSizeInByte(0);
                }
                if (!StringUtil.isEmpty((String)rs1.getString("SIMPLENAME"))) {
                    attachmentsBean.setSimplename(rs1.getString("SIMPLENAME"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FPERMISSION"))) {
                    attachmentsBean.setPermission(rs1.getString("FPERMISSION"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FAttachID"))) {
                    attachmentsBean.setAttachId(rs1.getString("FAttachID"));
                }
                attachmentsBean.setFileKey(EvaFormUtil.getFileKey(currentUserId, attachmentsBean.getName(), attachmentsBean.getSizeInByte(), attachmentsBean.getAttachId()));
                attachmentList.add(attachmentsBean);
            }
        }
        AttachmentUtil.setTmpUrl(attachmentList, "");
        return attachmentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTmpUrl(List<AttachmentsBean> attachmentList, String shrUrl) {
        if (!CollectionUtils.isEmpty(attachmentList)) {
            for (AttachmentsBean attachmentsBean : attachmentList) {
                String fileExt;
                String serverPath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator;
                String fileDir = "tmp" + File.separator + "newAttachmentFoler" + File.separator + MD5Util.getMD5String((String)(StringUtils.isBlank((CharSequence)attachmentsBean.getName()) ? System.currentTimeMillis() + "" : attachmentsBean.getName())) + File.separator;
                String realFileDir = serverPath + fileDir;
                File file = new File(SHRCheck.checkFilePath((String)realFileDir));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((fileExt = attachmentsBean.getSimplename()) != null && fileExt.contains(".") && !fileExt.endsWith(".")) {
                    fileExt = fileExt.substring(fileExt.indexOf(".") + 1, fileExt.length());
                }
                String fileName = AttachmentDownloadService.StringFilter(attachmentsBean.getId()) + "." + fileExt;
                String realFileName = realFileDir + fileName;
                file = new File(SHRCheck.checkFilePath((String)realFileName));
                if (file.exists()) {
                    attachmentsBean.setUrl(shrUrl + File.separator + fileDir + fileName);
                    logger.error("exists attachmentInfo id:" + JSON.toJSONString((Object)attachmentsBean.getUrl()));
                    continue;
                }
                FileOutputStream out = null;
                try {
                    IAttachment iAttachment = AttachmentFactory.getRemoteInstance();
                    AttachmentInfo attachmentInfo = iAttachment.getAttachmentInfo(" where id = '" + attachmentsBean.getId() + "' ");
                    if (attachmentInfo == null) {
                        logger.error("not found attachmentInfo id:" + attachmentsBean.getId());
                        continue;
                    }
                    byte[] content = attachmentInfo.getFile();
                    if (content != null && content.length > 0) {
                        out = new FileOutputStream(file);
                        out.write(content);
                        out.flush();
                        out.close();
                    } else {
                        logger.error("FEE::content.length==0,id:+" + attachmentsBean.getId() + ",fileName:" + fileName);
                    }
                    logger.error("FII::id:+" + attachmentsBean.getId() + ",fileName:" + fileName);
                    attachmentsBean.setUrl(shrUrl + File.separator + fileDir + fileName);
                }
                catch (IOException var13) {
                    logger.error(var13.getMessage());
                    logger.error("download fail");
                }
                catch (BOSException var14) {
                    if (var14.getMessage().contains("Connection refused")) {
                        logger.error(var14.getMessage());
                    }
                    logger.error("download fail: ", (Throwable)var14);
                }
                catch (EASBizException e) {
                    logger.error("EASBizException: ", (Throwable)e);
                }
                finally {
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error("IOException: ", (Throwable)e);
                    }
                }
            }
        }
    }

    public static List<AttachmentsBean> getAttachmentsByIds(Context ctx, List<String> ids) throws BOSException, SQLException {
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        ArrayList<AttachmentsBean> attachmentList = new ArrayList<AttachmentsBean>();
        String attachmentIds = "";
        if (CollectionUtils.isEmpty(ids)) {
            return attachmentList;
        }
        attachmentIds = "(" + PerfwebStrUtils.convertListToString(ids) + ")";
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        String queryAttachmentSql = "select a.FAttachID as FAttachID, a.FID  as ID ,a.FNAME" + mlFlag + " as NAME ,a.FFILE as FFILE ,a.FSIZEINBYTE as FSIZEINBYTE,a.FSIZE as FSIZE ,a.FSIMPLENAME as SIMPLENAME, a.FRemotePath as REMOTEPATH,a.FPERMISSION as FPERMISSION from T_BAS_Attachment a inner join T_BAS_BoattchAsso b on a.FID = b.FAttachmentID where a.Fid in " + attachmentIds;
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)queryAttachmentSql);
        if (rs1 != null) {
            while (rs1.next()) {
                AttachmentsBean attachmentsBean = new AttachmentsBean();
                if (!StringUtil.isEmpty((String)rs1.getString("REMOTEPATH"))) {
                    attachmentsBean.setUrl(rs1.getString("REMOTEPATH"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("ID"))) {
                    attachmentsBean.setId(rs1.getString("ID"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("NAME"))) {
                    attachmentsBean.setName(rs1.getString("NAME"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FSIZE"))) {
                    attachmentsBean.setSize(rs1.getString("FSIZE"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FSIZEINBYTE"))) {
                    attachmentsBean.setSizeInByte(rs1.getInt("FSIZEINBYTE"));
                } else {
                    attachmentsBean.setSizeInByte(0);
                }
                if (!StringUtil.isEmpty((String)rs1.getString("SIMPLENAME"))) {
                    attachmentsBean.setSimplename(rs1.getString("SIMPLENAME"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FPERMISSION"))) {
                    attachmentsBean.setPermission(rs1.getString("FPERMISSION"));
                }
                if (!StringUtil.isEmpty((String)rs1.getString("FAttachID"))) {
                    attachmentsBean.setAttachId(rs1.getString("FAttachID"));
                }
                attachmentsBean.setFileKey(EvaFormUtil.getFileKey(currentUserId, attachmentsBean.getName(), attachmentsBean.getSizeInByte(), attachmentsBean.getAttachId()));
                attachmentList.add(attachmentsBean);
            }
        }
        AttachmentUtil.setTmpUrl(attachmentList, "");
        return attachmentList;
    }
}

