/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.google.common.base.Strings;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumLogSourceEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumRevisionLogFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumRevisionLogInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSumRevisionLog;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaResultSumRevisionLogService {
    private static final Logger logger = LoggerFactory.getLogger(EvaResultSumRevisionLogService.class);

    public void generatedEvaResultSumRevisionLog(Context ctx, EvaResultSumLogSourceEnum sourceEnum, EvaResultSummaryInfo evaResultSummaryInfo, String beforeReviseSumScore, String beforeReviseGradeLevel) {
        try {
            BigDecimal b;
            IEvaResultSumRevisionLog localInstance = EvaResultSumRevisionLogFactory.getLocalInstance(ctx);
            EvaResultSumRevisionLogInfo info = new EvaResultSumRevisionLogInfo();
            info.setEvaResultSummary(evaResultSummaryInfo);
            info.setBeforeReviseGradeLevel(beforeReviseGradeLevel);
            info.setAfterReviseGradeLevel(evaResultSummaryInfo.getString("reviseGradeLevel"));
            info.setSourceEnum(sourceEnum);
            info.setReviseReason(evaResultSummaryInfo.getString("reviseReason"));
            if (!Strings.isNullOrEmpty((String)beforeReviseSumScore)) {
                b = new BigDecimal(beforeReviseSumScore);
                info.setBeforeReviseSumScore(b.setScale(2, 4).doubleValue());
            }
            if (!StringUtils.isEmpty((CharSequence)evaResultSummaryInfo.getString("reviseSumScore"))) {
                b = new BigDecimal(evaResultSummaryInfo.getString("reviseSumScore"));
                info.setAfterReviseSumScore(b.setScale(2, 4).doubleValue());
            }
            localInstance.addnew(info);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public void generatedEvaResultSumRevisionLog(Context ctx, EvaResultSumLogSourceEnum sourceEnum, OrgEvaResultSummaryInfo evaResultSummaryInfo, String beforeReviseSumScore, String beforeReviseGradeLevel) {
        try {
            BigDecimal b;
            IEvaResultSumRevisionLog localInstance = EvaResultSumRevisionLogFactory.getLocalInstance(ctx);
            EvaResultSumRevisionLogInfo info = new EvaResultSumRevisionLogInfo();
            info.setOrgEvaResultSummary(evaResultSummaryInfo);
            info.setBeforeReviseGradeLevel(beforeReviseGradeLevel);
            info.setAfterReviseGradeLevel(evaResultSummaryInfo.getString("reviseGradeLevel"));
            info.setSourceEnum(sourceEnum);
            info.setReviseReason(evaResultSummaryInfo.getString("reviseReason"));
            if (!Strings.isNullOrEmpty((String)beforeReviseSumScore)) {
                b = new BigDecimal(beforeReviseSumScore);
                info.setBeforeReviseSumScore(b.setScale(2, 4).doubleValue());
            }
            if (!StringUtils.isEmpty((CharSequence)evaResultSummaryInfo.getString("reviseSumScore"))) {
                b = new BigDecimal(evaResultSummaryInfo.getString("reviseSumScore"));
                info.setAfterReviseSumScore(b.setScale(2, 4).doubleValue());
            }
            localInstance.addnew(info);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public void generatedEvaResultSumRevisionLog(Context ctx, CoreBaseCollection coreBaseCollection) {
        try {
            IEvaResultSumRevisionLog localInstance = null;
            localInstance = ctx == null ? EvaResultSumRevisionLogFactory.getRemoteInstance() : EvaResultSumRevisionLogFactory.getLocalInstance(ctx);
            if (coreBaseCollection != null) {
                localInstance.addnew(coreBaseCollection);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public CoreBaseCollection packageResultSumRevisionLog(EvaResultSumLogSourceEnum sourceEnum, CoreBaseCollection oldSummaryCollection, CoreBaseCollection currentSummaryCollection, boolean isOrg) {
        CoreBaseCollection resultSumRevisionLogCollection = new CoreBaseCollection();
        for (int i = 0; i < oldSummaryCollection.size(); ++i) {
            EvaResultSumRevisionLogInfo logInfo = new EvaResultSumRevisionLogInfo();
            CoreBaseInfo oldInfo = oldSummaryCollection.get(i);
            CoreBaseInfo currentInfo = currentSummaryCollection.get((Object)oldInfo.get("id").toString());
            if (isOrg) {
                logInfo.setOrgEvaResultSummary((OrgEvaResultSummaryInfo)oldInfo);
            } else {
                logInfo.setEvaResultSummary((EvaResultSummaryInfo)oldInfo);
            }
            if (oldInfo.get("reviseSumScore") == null) {
                logInfo.put("beforeReviseSumScore", oldInfo.get("sumScore"));
                logInfo.put("beforeReviseGradeLevel", oldInfo.get("gradeLevel"));
            } else {
                logInfo.put("beforeReviseSumScore", oldInfo.get("reviseSumScore"));
                logInfo.put("beforeReviseGradeLevel", oldInfo.get("reviseGradeLevel"));
            }
            logInfo.put("afterReviseSumScore", currentInfo.get("reviseSumScore"));
            logInfo.setAfterReviseGradeLevel((String)currentInfo.get("reviseGradeLevel"));
            logInfo.setReviseReason((String)currentInfo.get("reviseReason"));
            logInfo.setSourceEnum(sourceEnum);
            resultSumRevisionLogCollection.add((CoreBaseInfo)logInfo);
        }
        return resultSumRevisionLogCollection;
    }
}

