/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataAuditorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataEntriorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IAchivementDataAuditor;
import com.kingdee.shr.perfweb.app.base.evalplan.IAchivementDataEntrior;
import com.kingdee.shr.perfweb.app.base.evalplan.PortalMesTypeEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PerfPortalTodoUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.PerfPortalTodoUtil");

    public static Map<String, Integer> getPortalToDoDataCount(Context ctx, String personId, boolean isOrg) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (personId == null) {
            personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            Assert.notNull((Object)personId);
        }
        int teamTargetCount = 0;
        int teamPersonalEvaCount = 0;
        int myTargetCount = 0;
        int mySefEvaCount = 0;
        int multiAssessmentCount = 0;
        int myAchievementInputTaskCount = 0;
        int myAchievementInputTaskCount4Org = 0;
        try {
            teamTargetCount = PerfPortalUtils.getTeamTargetCount(ctx, personId, isOrg);
        }
        catch (Exception e) {
            logger.error("perfportal[get goalsTransmit count err]\uff0ce={}", (Throwable)e);
        }
        try {
            teamPersonalEvaCount = PerfPortalUtils.getTeamTargetCommentCount(ctx, personId, isOrg);
        }
        catch (Exception e) {
            logger.error("perfportal[get goalsScore count err]\uff0ce={}", (Throwable)e);
        }
        try {
            myTargetCount = PerfPortalTodoUtil.getPersonnalTargetCount(ctx, personId, isOrg);
        }
        catch (Exception e) {
            logger.error("perfportal[get my goals count err]\uff0ce={}", (Throwable)e);
        }
        try {
            mySefEvaCount = PerfPortalUtils.getPersonalTargetCommentCount(ctx, isOrg);
        }
        catch (Exception e) {
            logger.error("perfportal[get my goals score err]\uff0ce={}", (Throwable)e);
        }
        try {
            myAchievementInputTaskCount = PerfPortalUtils.getAchievementDataEntryCount(ctx, "myAchivement", isOrg);
        }
        catch (Exception e) {
            logger.error("perfportal[get my achive entry and submit err]\uff0ce={}", (Throwable)e);
        }
        try {
            myAchievementInputTaskCount4Org = PerfPortalTodoUtil.getOrgAchievementDataEntryCount(ctx, personId, "myAchivement");
        }
        catch (Exception e) {
            logger.error("perfportal[get org achive entry and submit err]\uff0ce={}", (Throwable)e);
        }
        try {
            Map<String, Set<String>> periodAndCountMap = PerfPortalUtils.getMultiAssessmentPeriodList(ctx, isOrg ? "1" : "0");
            Set<String> periodList = periodAndCountMap.get("count");
            multiAssessmentCount = periodList.size();
        }
        catch (Exception e) {
            logger.error("perfportal[get 360 dai ban data err]\uff0ce={}", (Throwable)e);
        }
        map.put("teamTargetCount", teamTargetCount);
        map.put("teamPersonalEvaCount", teamPersonalEvaCount);
        map.put("myTargetCount", myTargetCount);
        map.put("mySefEvaCount", mySefEvaCount);
        map.put("multiAssessmentCount", multiAssessmentCount);
        map.put("myAchievementInputTaskCount", myAchievementInputTaskCount);
        map.put("myAchievementInputTaskCount4Org", myAchievementInputTaskCount4Org);
        map.put("othersTodoCount", PerfPortalUtils.getOthersTodoCount(ctx));
        return map;
    }

    public static Map<String, Object> getFunctionPermission(Context ctx) throws EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean myGoals = PermissionUtils.hasFunctionPermission(ctx, "myGoals");
        resultMap.put("myGoals", myGoals);
        boolean groupGoals = PermissionUtils.hasFunctionPermission(ctx, "groupGoals");
        resultMap.put("groupGoals", groupGoals);
        boolean goalsFilledFlag = PermissionUtils.hasFunctionPermission(ctx, "goalsFilled");
        resultMap.put("goalsFilled", goalsFilledFlag);
        boolean myTeamGoals = PermissionUtils.hasFunctionPermission(ctx, "myTeamGoals");
        resultMap.put("myTeamGoals", myTeamGoals);
        boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "perfSumInterview");
        resultMap.put("perfSumInterview", perfSumInterview);
        boolean myHistoryFlag = PermissionUtils.hasFunctionPermission(ctx, "myHistory");
        resultMap.put("myHistory", myHistoryFlag);
        boolean groupHistoryFlag = PermissionUtils.hasFunctionPermission(ctx, "groupHistory");
        resultMap.put("groupHistory", groupHistoryFlag);
        resultMap.put("evaResultStat", PermissionUtils.hasFunctionPermission(ctx, "evaResultStat"));
        boolean processedScoresFlag = PermissionUtils.hasFunctionPermission(ctx, "processedScores");
        resultMap.put("processedScores", processedScoresFlag);
        boolean teamPersonalTarget = PermissionUtils.hasFunctionPermission(ctx, "teamPersonalTarget");
        resultMap.put("teamPersonalTarget", teamPersonalTarget);
        boolean teamPersonalTargetEva = PermissionUtils.hasFunctionPermission(ctx, "teamPersonalTargetEva");
        resultMap.put("teamPersonalTargetEva", teamPersonalTargetEva);
        boolean assessment360 = PermissionUtils.hasFunctionPermission(ctx, "assessment360");
        resultMap.put("assessment360", assessment360);
        boolean orgAssessment360 = PermissionUtils.hasFunctionPermission(ctx, "orgAssessment360");
        resultMap.put("orgAssessment360", orgAssessment360);
        boolean myEvaTargetFill = PermissionUtils.hasFunctionPermission(ctx, "myEvaTargetFill");
        resultMap.put("myEvaTargetFill", myEvaTargetFill);
        boolean myEvaSelf = PermissionUtils.hasFunctionPermission(ctx, "myEvaSelf");
        resultMap.put("myEvaSelf", myEvaSelf);
        boolean myAchievementInputTask = PermissionUtils.hasFunctionPermission(ctx, "myAchievementInputTask");
        resultMap.put("myAchievementInputTask", myAchievementInputTask);
        boolean othersTodoCount = PermissionUtils.hasFunctionPermission(ctx, "othersTodoCount");
        resultMap.put("othersTodoCount", othersTodoCount);
        boolean myTargrtMap = PermissionUtils.hasFunctionPermission(ctx, "myTargetMap");
        resultMap.put("myTargetMap", myTargrtMap);
        boolean orgGoalContent = PermissionUtils.hasFunctionPermission(ctx, "orgGoalContent");
        resultMap.put("orgGoalContent", orgGoalContent);
        boolean groupHistory4OrgContent = PermissionUtils.hasFunctionPermission(ctx, "groupHistory4OrgContent");
        resultMap.put("groupHistory4OrgContent", groupHistory4OrgContent);
        boolean myEvaSelf4Org = PermissionUtils.hasFunctionPermission(ctx, "myEvaSelf4Org");
        resultMap.put("myEvaSelf4Org", myEvaSelf4Org);
        boolean teamPersonalTargetEva4Org = PermissionUtils.hasFunctionPermission(ctx, "teamPersonalTargetEva4Org");
        resultMap.put("teamPersonalTargetEva4Org", teamPersonalTargetEva4Org);
        boolean targetEvaDone4Org = PermissionUtils.hasFunctionPermission(ctx, "targetEvaDone4Org");
        resultMap.put("targetEvaDone4Org", targetEvaDone4Org);
        boolean orgHadFilled = PermissionUtils.hasFunctionPermission(ctx, "orgHadFilled");
        resultMap.put("orgHadFilled", orgHadFilled);
        boolean orgHadTransmited = PermissionUtils.hasFunctionPermission(ctx, "orgHadTransmited");
        resultMap.put("orgHadTransmited", orgHadTransmited);
        boolean orgTeamTarget = PermissionUtils.hasFunctionPermission(ctx, "orgTeamTarget");
        resultMap.put("orgTeamTarget", orgTeamTarget);
        boolean orgTargetFill = PermissionUtils.hasFunctionPermission(ctx, "myEvaTargetFill4Org");
        resultMap.put("myEvaTargetFill4Org", orgTargetFill);
        boolean orgTargetTransmit = PermissionUtils.hasFunctionPermission(ctx, "teamPersonalTarget4Org");
        resultMap.put("teamPersonalTarget4Org", orgTargetTransmit);
        boolean myHistoryTarget4Org = PermissionUtils.hasFunctionPermission(ctx, "myHistoryTarget4Org");
        resultMap.put("myHistoryTarget4Org", myHistoryTarget4Org);
        boolean myAchievementInputTask4org = PermissionUtils.hasFunctionPermission(ctx, "myAchievementInputTask4Org");
        resultMap.put("myAchievementInputTask4Org", myAchievementInputTask4org);
        boolean achivementDataToInput4org = PermissionUtils.hasFunctionPermission(ctx, "achivementDataToInput4Org");
        resultMap.put("achivementDataToInput4Org", achivementDataToInput4org);
        boolean achivementDataToReview40rg = PermissionUtils.hasFunctionPermission(ctx, "achivementDataToReview40rg");
        resultMap.put("achivementDataToReview40rg", achivementDataToReview40rg);
        boolean myOrgAchivementEntry = PermissionUtils.hasFunctionPermission(ctx, "myORGAchivementEntry");
        resultMap.put("myORGAchivementEntry", myOrgAchivementEntry);
        boolean achivementDataToInput = PermissionUtils.hasFunctionPermission(ctx, "achivementDataToInput");
        resultMap.put("achivementDataToInput", achivementDataToInput);
        boolean achivementDataToReview = PermissionUtils.hasFunctionPermission(ctx, "achivementDataToReview");
        resultMap.put("achivementDataToReview", achivementDataToReview);
        boolean performanceDone = false;
        if (groupGoals || processedScoresFlag) {
            performanceDone = true;
        }
        boolean myPerformance = false;
        if (myGoals || myHistoryFlag) {
            myPerformance = true;
        }
        boolean teamPerformance = false;
        if (myTeamGoals || groupHistoryFlag) {
            teamPerformance = true;
        }
        resultMap.put("performanceDone", performanceDone);
        resultMap.put("myPerformance", myPerformance);
        resultMap.put("teamPerformance", teamPerformance);
        boolean achivementData = false;
        boolean achivementManage = PermissionUtils.hasFunctionPermission(ctx, "achivementManage");
        boolean myAchivementEntry = PermissionUtils.hasFunctionPermission(ctx, "myAchivementEntry");
        if (achivementManage || myAchivementEntry) {
            achivementData = true;
        }
        resultMap.put("achivementData", achivementData);
        resultMap.put("achivementManage", achivementManage);
        resultMap.put("myAchivementEntry", myAchivementEntry);
        boolean perfTaskData = false;
        boolean myPerfTask = PermissionUtils.hasFunctionPermission(ctx, "myPerfTask");
        boolean otherPerfTask = PermissionUtils.hasFunctionPermission(ctx, "otherPerfTask");
        if (myPerfTask || otherPerfTask) {
            perfTaskData = true;
        }
        resultMap.put("perfTaskData", perfTaskData);
        resultMap.put("myPerfTask", myPerfTask);
        resultMap.put("otherPerfTask", otherPerfTask);
        boolean myInchargeteamGoal = PermissionUtils.hasFunctionPermission(ctx, "myInchargeteamGoal");
        boolean myInchargeteamHistory = PermissionUtils.hasFunctionPermission(ctx, "myInchargeteamHistory");
        boolean myInchargeInteview = PermissionUtils.hasFunctionPermission(ctx, "myInchargeInteview");
        resultMap.put("myInchargeteamGoal", myInchargeteamGoal);
        resultMap.put("myInchargeteamHistory", myInchargeteamHistory);
        resultMap.put("myInchargeInteview", myInchargeInteview);
        boolean othersPerfTodoCount = PermissionUtils.hasFunctionPermission(ctx, "othersPerfTodoCount");
        resultMap.put("othersPerfTodoCount", othersPerfTodoCount);
        boolean orgOthersPerfTodoCount = PermissionUtils.hasFunctionPermission(ctx, "orgOthersPerfTodoCount");
        resultMap.put("orgOthersPerfTodoCount", orgOthersPerfTodoCount);
        return resultMap;
    }

    public static int getPersonnalTargetCount(Context ctx, String personId, boolean isOrg) throws EASBizException {
        int dataCount = 0;
        try {
            String countSQL = "select count(fid) dataCount from T_EVA_GoalsMessageReceiver where FReceiver='" + personId + "' and FHandleStatus='" + "1" + "' and FMsgType='" + "0" + "' and FTargetStatus='" + "0" + "' and FIsSelf=" + 1;
            countSQL = countSQL + OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalTarget, isOrg);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSQL);
            if (rowSet != null && rowSet.next()) {
                dataCount = rowSet.getInt("dataCount");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("perfweb", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETMYGOALSCOUNTERR, ctx)));
        }
        return dataCount;
    }

    public static int getPersonalTargetCommentCount(Context ctx, String personId, boolean isOrg) throws EASBizException {
        int dataCount = 0;
        try {
            StringBuffer totalCountSQLBuffer = new StringBuffer("select count(distinct fevaObjid) from  T_EVA_GradeTaskNodeInst inst left join T_EVA_PerfEvaObject o on inst.FEvaObjID = o.FID where inst.FNodeHandlerID='");
            totalCountSQLBuffer.append(personId).append("' and inst.FScoreStatus not in ('").append("2").append("','").append("3").append("','").append("4").append("') and ").append(" inst.FIsSelf=").append(1).append(" and inst.FIsEffective='").append("1").append("'");
            totalCountSQLBuffer.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalSelfEva, isOrg));
            IRowSet totoalCountSet = DbUtil.executeQuery((Context)ctx, (String)totalCountSQLBuffer.toString());
            try {
                if (totoalCountSet != null && totoalCountSet.next()) {
                    dataCount = totoalCountSet.getInt(1);
                }
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("perfweb", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETMYGOALSSCOREERR, ctx)));
        }
        return dataCount;
    }

    public static int getAchievementDataEntryCount(Context ctx, String personId, String resourceTag, boolean isOrg) throws BOSException {
        IAchivementDataEntrior iAchivementDataEntrior = AchivementDataEntriorFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)").append(" and target.evaObj.personalGoalStatus =3").append(" and target.achivementEntryState <> 1");
        if ("myAchivement".equals(resourceTag)) {
            sb.append(" and ruleId.inputType = '0'");
        } else {
            sb.append(" and ruleId.inputType <> '0'");
        }
        sb.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalAchivementInput, isOrg));
        CoreBaseCollection count = iAchivementDataEntrior.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getOrgAchievementDataEntryCount(Context ctx, String personId, String resourceTag) throws BOSException {
        IAchivementDataEntrior iAchivementDataEntrior = AchivementDataEntriorFactory.getLocalInstance(ctx);
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)").append("and target.evaObj.isOrg = '1'").append(" and target.evaObj.personalGoalStatus =3").append(" and target.achivementEntryState <> 1");
        if ("myAchivement".equals(resourceTag)) {
            sb.append(" and ruleId.inputType = '4'");
        } else {
            sb.append(" and ruleId.inputType <> '4'");
        }
        CoreBaseCollection count = iAchivementDataEntrior.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getOrgAchievementDataAuditCount(Context ctx, String personId) throws BOSException {
        IAchivementDataAuditor iAchivementDataAuditor = AchivementDataAuditorFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)").append("and  target.evaObj.isOrg = '1'").append(" and target.achivementEntryState = 1").append(" and target.evaObj.personalGoalStatus =3");
        CoreBaseCollection count = iAchivementDataAuditor.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getAchievementDataAuditCount(Context ctx, String personId) throws BOSException {
        IAchivementDataAuditor iAchivementDataAuditor = AchivementDataAuditorFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)").append("and  target.evaObj.isOrg <> '1'").append(" and target.achivementEntryState = 1").append(" and target.evaObj.personalGoalStatus =3");
        CoreBaseCollection count = iAchivementDataAuditor.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getOthersTodoCount(Context ctx) {
        int othersTodoCount = 0;
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntity", (Object)"com.kingdee.shr.perfweb%", CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("personUserID", (Object)HRFilterUtils.getCurrentUserId((Context)ctx), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSendMsg", (Object)1, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            AssignCollection assigns = AssignFactory.getRemoteInstance().getCollection(evi);
            if (assigns != null && !assigns.isEmpty()) {
                othersTodoCount = assigns.size();
            }
        }
        catch (Exception e) {
            logger.error("get othersTodoCount err", (Throwable)e);
        }
        return othersTodoCount;
    }

    public static int getAdjustmentCount(Context ctx, String personId) {
        IGradeTaskNodeInst iGradeTaskNodeInst = null;
        try {
            iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("nodeHandler", (Object)personId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("scoreStatus", (Object)"1", CompareType.EQUALS));
            evi.setFilter(filter);
            return iGradeTaskNodeInst.getCount(evi);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return 0;
        }
    }

    public static int getMyEvaluatedScoreCount(Context ctx) {
        try {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("rows", 1);
            paramMap.put("page", 1);
            HashMap resMap = (HashMap)OSFExecutor.executeOSF((Context)ctx, paramMap, (String)"getMyEvaluatedScoreDataService");
            if (null != resMap && null != resMap.get("records") && NumberUtils.isNumber((String)resMap.get("records").toString())) {
                return Integer.valueOf(resMap.get("records").toString());
            }
            return 0;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return 0;
        }
    }

    public static int getAchievementAuditCount(Context ctx, boolean isSelf) {
        return 0;
    }

    public static void setMenuPermission(Context ctx, Map<String, Boolean> initData) throws EASBizException {
        HashSet<String> menuPerm = new HashSet<String>();
        HashSet<String> donePerm = new HashSet<String>();
        HashSet<String> myPerfPerm = new HashSet<String>();
        HashSet<String> teamPerm = new HashSet<String>();
        HashSet<String> axvPerm = new HashSet<String>();
        HashSet<String> taskPerm = new HashSet<String>();
        HashSet<String> myInchargePer = new HashSet<String>();
        donePerm.add("goalsFilled");
        donePerm.add("groupGoals");
        donePerm.add("processedScores");
        myPerfPerm.add("myGoals");
        myPerfPerm.add("myHistory");
        myPerfPerm.add("myTargetMap");
        teamPerm.add("myTeamGoals");
        teamPerm.add("groupHistory");
        teamPerm.add("evaResultStat");
        teamPerm.add("perfSumInterview");
        axvPerm.add("achivementManage");
        axvPerm.add("myAchivementEntry");
        donePerm.add("orgHadFilled");
        donePerm.add("orgHadTransmited");
        donePerm.add("targetEvaDone4Org");
        teamPerm.add("orgTeamTarget");
        teamPerm.add("groupHistory4OrgContent");
        axvPerm.add("myORGAchivementEntry");
        taskPerm.add("myPerfTask");
        taskPerm.add("otherPerfTask");
        myInchargePer.add("myInchargeteamGoal");
        myInchargePer.add("myInchargeteamHistory");
        myInchargePer.add("myInchargeInteview");
        myInchargePer.add("orgGoalContent");
        myInchargePer.add("myHistoryTarget4Org");
        myInchargePer.add("groupPerformMapContent");
        menuPerm.addAll(donePerm);
        menuPerm.addAll(myPerfPerm);
        menuPerm.addAll(teamPerm);
        menuPerm.addAll(axvPerm);
        menuPerm.addAll(taskPerm);
        menuPerm.addAll(myInchargePer);
        PerfPortalTodoUtil.setPermission(ctx, initData, menuPerm);
        initData.put("performanceDone", PerfPortalTodoUtil.eitherHasPermission(initData, donePerm));
        initData.put("myInchargePerformance", PerfPortalTodoUtil.eitherHasPermission(initData, donePerm));
        initData.put("myPerformance", PerfPortalTodoUtil.eitherHasPermission(initData, myPerfPerm));
        initData.put("teamPerformance", PerfPortalTodoUtil.eitherHasPermission(initData, teamPerm));
        initData.put("achivementData", PerfPortalTodoUtil.eitherHasPermission(initData, axvPerm));
        initData.put("perfTaskData", PerfPortalTodoUtil.eitherHasPermission(initData, taskPerm));
        initData.put("myInchargePerformance", PerfPortalTodoUtil.eitherHasPermission(initData, myInchargePer));
    }

    public static int setTodoPermissionAndCount(Context ctx, Map<String, Object> initData) throws EASBizException {
        HashSet<String> todoPermission = new HashSet<String>();
        todoPermission.add("teamPersonalTarget");
        todoPermission.add("teamPersonalTargetEva");
        todoPermission.add("assessment360");
        todoPermission.add("myEvaTargetFill");
        todoPermission.add("myEvaSelf");
        todoPermission.add("myAchievementInputTask");
        todoPermission.add("othersPerfTodoCount");
        todoPermission.add("othersTodoCount");
        todoPermission.add("myEvaTargetFill4Org");
        todoPermission.add("teamPersonalTarget4Org");
        todoPermission.add("myEvaSelf4Org");
        todoPermission.add("teamPersonalTargetEva4Org");
        todoPermission.add("orgAssessment360");
        todoPermission.add("myAchievementInputTask4Org");
        todoPermission.add("orgOthersPerfTodoCount");
        HashMap<String, Boolean> permData = new HashMap<String, Boolean>();
        PerfPortalTodoUtil.setPermission(ctx, permData, todoPermission);
        initData.putAll(permData);
        int totalCount = 0;
        HashMap<String, Object> todoCountParams = new HashMap<String, String[]>();
        String[] teamTargetParam = new String[]{"teamTargetCount", "getTeamTargetCount"};
        String[] teamPersonalEvaParam = new String[]{"teamPersonalEvaCount", "getTeamTargetCommentCount"};
        String[] myMultiAssessmentParam = new String[]{"myMultiAssessmentCount", "getMultiAssessmentCount"};
        String[] myTargetParam = new String[]{"myTargetCount", "getPersonalTargetCount"};
        String[] mySefEvaParam = new String[]{"mySefEvaCount", "getPersonalTargetCommentCount"};
        String[] axvParam = new String[]{"myAchievementInputTaskCount", "getMyAchievementDataEntryCount"};
        String[] othersPerfCount = new String[]{"othersPerfCount", "getOthersPerfCount"};
        todoCountParams.put("teamPersonalTarget", teamTargetParam);
        todoCountParams.put("teamPersonalTargetEva", teamPersonalEvaParam);
        todoCountParams.put("assessment360", myMultiAssessmentParam);
        todoCountParams.put("myEvaTargetFill", myTargetParam);
        todoCountParams.put("myEvaSelf", mySefEvaParam);
        todoCountParams.put("myAchievementInputTask", axvParam);
        todoCountParams.put("othersPerfTodoCount", othersPerfCount);
        HashMap<String, Object> todoCount = new HashMap<String, Object>();
        totalCount += PerfPortalTodoUtil.calcTodoCountByPermission(ctx, todoCount, permData, todoCountParams, false);
        totalCount += PerfPortalTodoUtil.setTodoCountByPermission(ctx, todoCount, permData, "othersTodoCount", "othersCount", "getOthersTodoCount", new Class[]{Context.class}, new Object[]{ctx});
        initData.putAll(todoCount);
        todoCountParams = new HashMap();
        todoCountParams.put("teamPersonalTarget4Org", teamTargetParam);
        todoCountParams.put("teamPersonalTargetEva4Org", teamPersonalEvaParam);
        todoCountParams.put("orgAssessment360", myMultiAssessmentParam);
        todoCountParams.put("myEvaTargetFill4Org", myTargetParam);
        todoCountParams.put("myEvaSelf4Org", mySefEvaParam);
        todoCountParams.put("myAchievementInputTask4Org", axvParam);
        todoCountParams.put("orgOthersPerfTodoCount", othersPerfCount);
        HashMap<String, Object> orgTodoCount = new HashMap<String, Object>();
        initData.put("org", orgTodoCount);
        return totalCount += PerfPortalTodoUtil.calcTodoCountByPermission(ctx, orgTodoCount, permData, todoCountParams, true);
    }

    public static int setAxvTodoPermissionAndCount(Context ctx, Map<String, Object> initData) throws EASBizException {
        HashSet<String> todoPermission = new HashSet<String>();
        todoPermission.add("achivementDataToInput");
        todoPermission.add("achivementDataToReview");
        todoPermission.add("achivementDataToInput4Org");
        todoPermission.add("achivementDataToReview40rg");
        HashMap<String, Boolean> permData = new HashMap<String, Boolean>();
        PerfPortalTodoUtil.setPermission(ctx, permData, todoPermission);
        initData.putAll(permData);
        int totalCount = 0;
        HashMap<String, Object> todoCountParams = new HashMap<String, String[]>();
        String[] axvInputParam = new String[]{"achivementDataToInputCount", "getAchievementDataEntryCount"};
        String[] axvAuditParam = new String[]{"achivementDataToReviewCount", "getAchievementDataAuditCount"};
        todoCountParams.put("achivementDataToInput", axvInputParam);
        todoCountParams.put("achivementDataToReview", axvAuditParam);
        totalCount += PerfPortalTodoUtil.calcTodoCountByPermission(ctx, initData, todoCountParams, false);
        HashMap<String, Object> todoCount = new HashMap<String, Object>();
        todoCountParams = new HashMap();
        todoCountParams.put("achivementDataToInput4Org", axvInputParam);
        todoCountParams.put("achivementDataToReview40rg", axvAuditParam);
        initData.put("axvOrg", todoCount);
        return totalCount += PerfPortalTodoUtil.calcTodoCountByPermission(ctx, todoCount, todoCountParams, true);
    }

    public static void setPermission(Context ctx, Map<String, Boolean> initData, Set<String> permData) throws EASBizException {
        if (permData.size() > 0) {
            for (String perm : permData) {
                initData.put(perm, PermissionUtils.hasFunctionPermission(ctx, perm));
            }
        }
    }

    public static boolean eitherHasPermission(Map<String, Boolean> initData, Set<String> permData) {
        boolean flag = false;
        for (String perm : permData) {
            if (!initData.get(perm).booleanValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static int calcTodoCountByPermission(Context ctx, Map<String, Object> initData, Map<String, Boolean> permData, Map<String, String[]> todoCountParams, boolean isOrg) {
        int totalCount = 0;
        for (Map.Entry<String, String[]> item : todoCountParams.entrySet()) {
            String[] params = item.getValue();
            if (params == null || params.length != 2) continue;
            totalCount += PerfPortalTodoUtil.setTodoCountByPermission(ctx, initData, permData, item.getKey(), params[0], params[1], new Class[]{Context.class, Boolean.TYPE}, new Object[]{ctx, isOrg});
        }
        return totalCount;
    }

    public static int calcTodoCountByPermission(Context ctx, Map<String, Object> initData, Map<String, String[]> todoCountParams, boolean isOrg) throws EASBizException {
        int totalCount = 0;
        for (Map.Entry<String, String[]> item : todoCountParams.entrySet()) {
            String[] params = item.getValue();
            if (params == null || params.length != 2) continue;
            totalCount += PerfPortalTodoUtil.setTodoCountByPermission(ctx, initData, item.getKey(), params[0], params[1], new Class[]{Context.class, Boolean.TYPE}, new Object[]{ctx, isOrg});
        }
        return totalCount;
    }

    public static int setTodoCountByPermission(Context ctx, Map<String, Object> initData, Map<String, Boolean> permData, String permFlag, String countFlag, String method, Class[] argTypes, Object[] params) {
        int count = 0;
        if (!permData.containsKey(permFlag) || permData.get(permFlag).booleanValue()) {
            try {
                count = (Integer)PerfPortalTodoUtil.invokePerfPortalUtils(method, argTypes, params);
            }
            catch (Throwable e) {
                logger.error("get todo count reflect err", e);
            }
            initData.put(countFlag, count);
        }
        return count;
    }

    public static int setTodoCountByPermission(Context ctx, Map<String, Object> initData, String permFlag, String countFlag, String method, Class[] argTypes, Object[] params) throws EASBizException {
        int count = 0;
        if (PermissionUtils.hasFunctionPermission(ctx, permFlag)) {
            try {
                count = (Integer)PerfPortalTodoUtil.invokePerfPortalUtils(method, argTypes, params);
            }
            catch (Throwable e) {
                logger.error("get todo count reflect err", e);
            }
            initData.put(countFlag, count);
        }
        return count;
    }

    private static Object invokePerfPortalUtils(String methodName, Class[] argTypes, Object[] args) throws Throwable {
        Method mtd = PerfPortalUtils.class.getMethod(methodName, argTypes);
        try {
            return mtd.invoke(null, args);
        }
        catch (InvocationTargetException var7) {
            throw var7.getTargetException();
        }
        catch (Exception var8) {
            throw var8;
        }
    }
}

