/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.baseconfig.IStructureConfig;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldCollection;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.CmpQueryConfigFieldCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFieldInfo;
import com.kingdee.shr.compensation.CmpQueryConfigInfo;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemCollection;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemFactory;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemInfo;
import com.kingdee.shr.perfweb.app.comprehensive.ComprehensiveItemCollection;
import com.kingdee.shr.perfweb.app.comprehensive.ComprehensiveItemFactory;
import com.kingdee.shr.perfweb.app.comprehensive.ComprehensiveItemInfo;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryRule;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryRuleAndItemMid;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidInfo;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleFactory;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.SumCalCacheUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class SumCalUtil {
    private static Logger logger = Logger.getLogger(SumCalUtil.class);

    private SumCalUtil() {
    }

    public static CalcuItemCollection getCalcuItemCollection(Context ctx, String tableName) throws BOSException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tableName)) {
            return null;
        }
        String oql = "select id,name,dataType,dataLength,dataDot,calItemCatory,fieldSn,fieldName,tableName,evaObjRelaField where tableName = '" + tableName + "' order by fieldSn";
        CalcuItemCollection items = CalcuItemFactory.getLocalInstance(ctx).getCalcuItemCollection(oql);
        return items;
    }

    public static CalcuItemCollection getSumCalItem(Context ctx, String billId) {
        CalcuItemCollection collection = new CalcuItemCollection();
        CalcuItemInfo calcuItemInfo = null;
        Map<String, String> mainTableAndSchemeNumber = SumCalUtil.getMainTableAndSchemeNumber(ctx, billId);
        String mainTable = mainTableAndSchemeNumber.get("mainTable");
        try {
            IPerfSummaryRuleAndItemMid iPerfSummaryRuleAndItemMid = PerfSummaryRuleAndItemMidFactory.getLocalInstance(ctx);
            PerfSummaryRuleAndItemMidCollection itemColl = iPerfSummaryRuleAndItemMid.getPerfSummaryRuleAndItemMidCollection("select summaryItem.name,summaryItem.number,summaryItem.comprehensiveItemCatory.dataType where summaryRule.id = '" + billId + "'");
            if (itemColl != null && itemColl.size() > 0) {
                int len = itemColl.size();
                for (int i = 0; i < len; ++i) {
                    PerfSummaryRuleAndItemMidInfo itemMidInfo = itemColl.get(i);
                    ComprehensiveItemInfo summaryItem = itemMidInfo.getSummaryItem();
                    calcuItemInfo = new CalcuItemInfo();
                    calcuItemInfo.setId(summaryItem.getId());
                    calcuItemInfo.setName(summaryItem.getName());
                    calcuItemInfo.setDataType(summaryItem.getComprehensiveItemCatory().getDataType());
                    calcuItemInfo.setFieldName("SUMCALITEM_" + summaryItem.getNumber());
                    calcuItemInfo.setTableName(mainTable);
                    collection.add(calcuItemInfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public static Map<String, String> getCalItemFiledAliasMap(Context ctx, String billId) {
        CalcuItemCollection sumCalItemColl = SumCalUtil.getSumCalItem(ctx, billId);
        HashMap<String, String> result = new HashMap<String, String>();
        if (sumCalItemColl == null) {
            return result;
        }
        for (int i = 0; i < sumCalItemColl.size(); ++i) {
            CalcuItemInfo calcuItemInfo = sumCalItemColl.get(i);
            result.put(calcuItemInfo.getTableName() + "." + calcuItemInfo.getFieldName(), calcuItemInfo.getName());
        }
        return result;
    }

    public static CmpQueryConfigCollection getCmpConfigCollection(Context ctx) throws BOSException {
        String oql = "select id,name,fields.id,fields.alias,fields.factField.number,fields.factField.structureConfig.EntityName,parent.id,fields.factField.structureConfig.clientNumber,tableName where application in (3) order by number,fields.index";
        CmpQueryConfigCollection configs = CmpQueryConfigFactory.getLocalInstance((Context)ctx).getCmpQueryConfigCollection(oql);
        return configs;
    }

    public static QueryConfigCollection getConfigCollection(Context ctx, String schemeNumber) throws BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeNumber)) {
            return null;
        }
        String oql = "select id,name,fields.id,fields.alias,fields.factField.number,fields.factField.structureConfig.EntityName,parent.id,fields.factField.structureConfig.clientNumber,structure.id,structure.EntityName,structure.clientNumber where scheme.number = '" + schemeNumber + "' order by number,fields.index";
        QueryConfigCollection queryConfigCollection = QueryConfigFactory.getLocalInstance((Context)ctx).getQueryConfigCollection(oql);
        return queryConfigCollection;
    }

    public static Map<String, String> getQueryConfigDataSet(Context ctx, String schemeNumber, String mainTBName) throws BOSException {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeNumber)) {
            return fieldMap;
        }
        QueryConfigCollection configs = SumCalUtil.getConfigCollection(ctx, schemeNumber);
        if (configs == null || configs.size() < 1) {
            return fieldMap;
        }
        ConcurrentHashMap<String, String> structureTableMap = SumCalCacheUtils.getStructureTableMap(ctx, schemeNumber);
        for (int i = 0; i < configs.size(); ++i) {
            String table = null;
            if (null != configs.get(i).getStructure()) {
                String structureId = configs.get(i).getStructure().getId().toString();
                table = structureTableMap.get(structureId);
            }
            if (PerfwebStrUtils.isNullOrEmpty(table)) continue;
            if (!mainTBName.equalsIgnoreCase(table)) {
                table = table + "~" + configs.get(i).getStructure().getClientNumber();
            }
            String entity = configs.get(i).getStructure().getEntityName();
            QueryConfigFieldCollection fields = configs.get(i).getFields();
            for (int j = 0; j < fields.size(); ++j) {
                String fieldName = SumCalUtil.getEntityFieldName(ctx, entity, fields.get(j).getFactField().getNumber());
                fieldMap.put(table + "." + fieldName, fields.get(j).getAlias());
            }
        }
        CmpQueryConfigCollection cmpConfigs = SumCalUtil.getCmpConfigCollection(ctx);
        for (int i = 0; i < cmpConfigs.size(); ++i) {
            CmpQueryConfigInfo cmpQueryConfigInfo = cmpConfigs.get(i);
            String table = cmpQueryConfigInfo.getTableName();
            if (PerfwebStrUtils.isNullOrEmpty(table)) continue;
            CmpQueryConfigFieldCollection fields = cmpQueryConfigInfo.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                CmpQueryConfigFieldInfo cmpQueryConfigFieldInfo = fields.get(j);
                StructureConfigInfo structureConfig = cmpQueryConfigFieldInfo.getFactField().getStructureConfig();
                if (structureConfig == null) continue;
                String entity = structureConfig.getEntityName();
                String number = cmpQueryConfigFieldInfo.getFactField().getNumber();
                String fieldName = SumCalUtil.getEntityFieldName(ctx, entity, number);
                fieldMap.put(table + "~" + structureConfig.getClientNumber() + "." + fieldName, cmpQueryConfigFieldInfo.getAlias());
            }
        }
        return fieldMap;
    }

    public static String getEntityFieldName(Context ctx, String entityName, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        PropertyInfo propertyInfo = SumCalUtil.getPropertyInfo(ctx, entityName, fieldName);
        if (propertyInfo == null || propertyInfo.getMappingField() == null || StringUtils.isEmpty((String)propertyInfo.getMappingField().getName())) {
            return null;
        }
        String language = ctx.getLocale().getLanguage().toUpperCase();
        if (propertyInfo.getMappingField().isMultilingual()) {
            return propertyInfo.getMappingField().getName() + "_" + language;
        }
        return propertyInfo.getMappingField().getName();
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String fieldName) {
        if (!StringUtils.isEmpty((String)fieldName) && !StringUtils.isEmpty((String)entityName)) {
            if (!fieldName.contains(".")) {
                MetaDataPK pk = MetaDataPK.create((String)entityName);
                if (null != pk) {
                    EntityObjectInfo entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
                    return entityInfo.getPropertyByNameRuntime(fieldName);
                }
                return null;
            }
            return SumCalUtil.getPropertyInfo(ctx, entityName, fieldName.split("\\."));
        }
        return null;
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String[] fieldNames) {
        if (fieldNames != null && !StringUtils.isEmpty((String)entityName)) {
            String fieldName;
            PropertyInfo propertyInfo = null;
            String[] var4 = fieldNames;
            int var5 = fieldNames.length;
            for (int var6 = 0; var6 < var5 && (propertyInfo = SumCalUtil.getPropertyInfo(ctx, entityName, fieldName = var4[var6])) != null; ++var6) {
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                entityName = BaseMetaDataUtil.getEntityNameByPropertyInfo((Context)ctx, (String)entityName, (PropertyInfo)propertyInfo);
            }
            if (propertyInfo != null) {
                propertyInfo.put("entityName", (Object)entityName);
            }
            return propertyInfo;
        }
        return null;
    }

    public static Map<String, StructureConfigInfo> getStructureMap(Context ctx, String schemeNumber) throws BOSException {
        HashMap<String, StructureConfigInfo> map = new HashMap<String, StructureConfigInfo>();
        String cmpOql = "select structure.id where application in (3)";
        CmpQueryConfigCollection cmpConfigs = CmpQueryConfigFactory.getLocalInstance((Context)ctx).getCmpQueryConfigCollection(cmpOql);
        HashSet<String> structureIdSet = new HashSet<String>();
        if (cmpConfigs != null && cmpConfigs.size() > 0) {
            for (int i = 0; i < cmpConfigs.size(); ++i) {
                if (cmpConfigs.get(i).getStructure() == null) continue;
                structureIdSet.add(cmpConfigs.get(i).getStructure().getId().toString());
            }
        }
        IStructureConfig structureConfig = StructureConfigFactory.getLocalInstance((Context)ctx);
        String oql = "select id,clientNumber,name,EntityName where scheme.number = '" + schemeNumber + "'";
        if (!CollectionUtils.isEmpty(structureIdSet)) {
            oql = oql + " or id in('" + org.apache.commons.lang3.StringUtils.join(structureIdSet, (String)"','") + "')";
        }
        StructureConfigCollection coll = structureConfig.getStructureConfigCollection(oql);
        String number = "";
        StructureConfigInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            number = info.getClientNumber();
            map.put(number, info);
        }
        return map;
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        String tableField = "";
        ColumnInfo column = null;
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            column = propertyInfo.getMappingField();
            if (column == null) continue;
            tableField = column.getName();
            if (propertyInfo instanceof OwnPropertyInfo && ((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                map.put((tableField + mlFlag).toUpperCase(), propertyInfo);
                continue;
            }
            map.put(tableField.toUpperCase(), propertyInfo);
        }
        return map;
    }

    public static String getSumCalType(Context ctx, String billId) {
        block3: {
            try {
                IPerfSummaryRule iPerfSummaryRule = PerfSummaryRuleFactory.getLocalInstance(ctx);
                PerfSummaryRuleCollection perfSummaryRuleCollection = iPerfSummaryRule.getPerfSummaryRuleCollection("select summaryRuleType where id = '" + billId + "'");
                if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
                    return perfSummaryRuleCollection.get(0).getSummaryRuleType().getValue();
                }
            }
            catch (BOSException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.error((Object)"[perfwe]it is failed to getSumCalType cause BOSException!", (Throwable)e);
            }
        }
        return "0";
    }

    public static Map<String, String> getMainTableAndSchemeNumber(Context ctx, String billId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("mainTable", "T_EVA_EVARESULTSUMMARY");
        result.put("schemeNumber", "PERFWEB010");
        result.put("calCategoryNum", "PERF_SUM_001");
        if ("1".equals(SumCalUtil.getSumCalType(ctx, billId))) {
            result.put("mainTable", "T_EVA_ORGEVARESULTSUMMARY");
        }
        return result;
    }

    public static String getCalItemIdByNumber(Context ctx, String number) {
        try {
            ComprehensiveItemCollection comprehensiveItemCollection = ComprehensiveItemFactory.getLocalInstance(ctx).getComprehensiveItemCollection("select id where number = '" + number + "'");
            if (comprehensiveItemCollection != null && comprehensiveItemCollection.size() > 0) {
                return comprehensiveItemCollection.get(0).getId().toString();
            }
            return number;
        }
        catch (BOSException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"[perfwe]it is failed to getCalItemIdByNumber cause BOSException!", (Throwable)e);
            }
            return number;
        }
    }
}

