/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GradeTaskNodeInstImportCheckUtils {
    public static final String OK = "OK";
    private static Pattern PATTERN_NUMERIC = Pattern.compile("-?[0-9]+.*[0-9]*");

    public static String checkEvaluResultSummary(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        String errorMsg = null;
        errorMsg = GradeTaskNodeInstImportCheckUtils.checkPerfRank(ctx, coreBaseInfo);
        if (!OK.equals(errorMsg)) {
            return errorMsg;
        }
        errorMsg = GradeTaskNodeInstImportCheckUtils.checkIsNumeric(ctx, coreBaseInfo.getString("reviseSumScore"));
        if (!OK.equals(errorMsg)) {
            return errorMsg;
        }
        return errorMsg;
    }

    public static String checkOrgEvaluResultSummary(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        String errorMsg = null;
        errorMsg = GradeTaskNodeInstImportCheckUtils.checkOrgPerfRank(ctx, coreBaseInfo);
        if (!OK.equals(errorMsg)) {
            return errorMsg;
        }
        errorMsg = GradeTaskNodeInstImportCheckUtils.checkIsNumeric(ctx, coreBaseInfo.getString("reviseSumScore"));
        if (!OK.equals(errorMsg)) {
            return errorMsg;
        }
        return errorMsg;
    }

    public static String checkOrgPerfRank(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        String errorMsg = OK;
        String id = coreBaseInfo.getString("ID");
        OrgEvaResultSummaryInfo evaResultSummaryInfo = GetEntityInfoUtils.getOrgEvaResultSummaryInfoById(ctx, id);
        PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, evaResultSummaryInfo.getPeriod().getId().toString());
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, periodInfo.getPerfRule().getId().toString());
        String perfRank = coreBaseInfo.getString("reviseGradeLevel");
        String levelSelectValue = new PerfGoasFillService().getSlectLevelVal(ctx, ruleInfo.getPerfRate().getId().toString());
        if (null != perfRank && !StringUtils.isEmpty((CharSequence)perfRank) && !levelSelectValue.contains(perfRank)) {
            errorMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REVISEGRADEINPUTERR, ctx, new Object[]{levelSelectValue});
        }
        return errorMsg;
    }

    public static String checkPerfRank(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        String errorMsg = OK;
        String id = coreBaseInfo.getString("ID");
        EvaResultSummaryInfo evaResultSummaryInfo = GetEntityInfoUtils.getEvaResultSummaryInfoById(ctx, id);
        PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, evaResultSummaryInfo.getPeriod().getId().toString());
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, periodInfo.getPerfRule().getId().toString());
        String perfRank = coreBaseInfo.getString("reviseGradeLevel");
        String levelSelectValue = new PerfGoasFillService().getSlectLevelVal(ctx, ruleInfo.getPerfRate().getId().toString());
        if (null != perfRank && !StringUtils.isEmpty((CharSequence)perfRank) && !levelSelectValue.contains(perfRank)) {
            errorMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REVISEGRADEINPUTERR, ctx, new Object[]{levelSelectValue});
        }
        return errorMsg;
    }

    public static String checkIsNumeric(Context ctx, String reviseSumScore) {
        Matcher isNum;
        String errorMsg = OK;
        if (null != reviseSumScore && !StringUtils.isEmpty((CharSequence)reviseSumScore) && !(isNum = PATTERN_NUMERIC.matcher(reviseSumScore)).matches()) {
            errorMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REVISETOTALSCOREINVALID, ctx);
        }
        return errorMsg;
    }
}

