/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.IEmpLaborRelationHis;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.notice.IMessageTemplate;
import com.kingdee.shr.perfweb.app.base.notice.IMessageTemplateDefine;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateCollection;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineCollection;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineFactory;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineInfo;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateFactory;
import com.kingdee.shr.perfweb.app.common.PerfMessageRecordInfo;
import com.kingdee.shr.perfweb.app.common.PerfSendMessageTaskPoolInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.parquet.Strings;

public class MessageTemplateUtils {
    private static Logger logger = LoggerFactory.getLogger(MessageTemplateUtils.class);
    private static int ORG = 1;
    public static final HashMap<String, String> mappers = new HashMap<String, String>(){
        {
            this.put("templateTitle", "EASMessageTitle");
            this.put("templateContent", "EASMessage");
        }
    };

    public static HashMap<String, MessageTemplateDefineCollection> getMsgTempColl(Context ctx, String[] objIdArray, HashMap<String, HashMap<String, String>> map, String templateId, Integer param, boolean isOrg) {
        return MessageTemplateUtils.replaceVar(MessageTemplateUtils.getVarDataByObjIdArray(ctx, objIdArray, map, param, isOrg), MessageTemplateUtils.getMessageTemplateById(ctx, templateId));
    }

    public static HashMap<String, MessageTemplateDefineCollection> getMsgTempCollByReceiverIds(Context ctx, String[] objIdArray, HashMap<String, HashMap<String, String>> map, String templateId, Integer reType) {
        return MessageTemplateUtils.replaceVar(MessageTemplateUtils.getVarDataByReceiverIds(ctx, objIdArray, map, reType), MessageTemplateUtils.getMessageTemplateById(ctx, templateId));
    }

    public static MessageTemplateDefineCollection getMessageTemplateById(Context ctx, String templateId) {
        MessageTemplateDefineCollection messageTempDefColl = new MessageTemplateDefineCollection();
        if (!StringUtil.isEmptyString((String)templateId)) {
            try {
                IMessageTemplateDefine msgTempDef = MessageTemplateDefineFactory.getLocalInstance(ctx);
                String oql = "where messageTemplate='" + templateId + "'";
                messageTempDefColl = msgTempDef.getMessageTemplateDefineCollection(oql);
            }
            catch (BOSException e) {
                logger.error("get messagetemplate by id error \uff1a" + e.getMessage());
            }
        }
        return messageTempDefColl;
    }

    public static HashMap<String, HashMap<String, String>> getVarDataByObjIdArray(Context ctx, String[] objIdArray, HashMap<String, HashMap<String, String>> map, Integer param, boolean isOrg) {
        HashMap<String, HashMap<String, String>> reMap = new HashMap<String, HashMap<String, String>>();
        try {
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
            IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance((Context)ctx);
            String transmitName = "administrator";
            String transmitNumber = "administrator";
            Object transmitPersonInfo = null;
            String ksql = "";
            String objIdCondtion = "('" + Strings.join((String[])objIdArray, (String)"','") + "')";
            ksql = isOrg ? " select id,period.*,period.perfPlan.name,adminHis.name,adminHis.number,evaluOrgAdmin.company.name,responsor.person.id,*  where id in " + objIdCondtion : " select id,person.id,person.name,person.number,period.*,period.perfPlan.name,perfFile.position.name,perfFile.adminOrgUnit.name,perfFile.employeeType.name,*  where id in " + objIdCondtion;
            PerfEvaObjectCollection evaObjectColl = iPerfEvaObject.getPerfEvaObjectCollection(ksql);
            List langList = BOSConfigUtil.getLanguageMapingList();
            int evaObjSize = evaObjectColl.size();
            for (int i = 0; i < evaObjSize; ++i) {
                String number = "";
                String org = "";
                String enterDate = "";
                String personId = "";
                String orgNumber = "";
                String state = "";
                PerfEvaObjectInfo objectInfo = evaObjectColl.get(i);
                if (isOrg) {
                    orgNumber = objectInfo.getAdminHis().getNumber();
                } else {
                    personId = objectInfo.getPerson().getId().toString();
                    String hisOql = "where person ='" + personId + "'";
                    EmpLaborRelationHisCollection hisCollection = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(hisOql);
                    for (int k = 0; k < hisCollection.size(); ++k) {
                        if (hisCollection.get(k).getLEFFDT() == null || !DateTimeUtils.dayEquals((Date)hisCollection.get(k).getLEFFDT(), (Date)HRUtil.getMaxEndDate()) || hisCollection.get(k).getEnterDate() == null) continue;
                        enterDate = DateTimeUtils.format((Date)hisCollection.get(k).getEnterDate(), (String)"yyyy-MM-dd");
                    }
                    number = objectInfo.getPerson().getNumber();
                }
                String perfPeriod = objectInfo.getPeriod().getName();
                String perfPeriod_start = DateTimeUtils.format((Date)objectInfo.getPeriod().getPStartDate(), (String)"yyyy-MM-dd");
                String perfPeriod_end = DateTimeUtils.format((Date)objectInfo.getPeriod().getPEndDate(), (String)"yyyy-MM-dd");
                String representation = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                for (int i1 = 0; i1 < langList.size(); ++i1) {
                    String lang = (String)((Map)langList.get(i1)).get("lang");
                    Locale locale = null;
                    if ("l1".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l1;
                    } else if ("l2".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l2;
                    } else if ("l3".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l3;
                    }
                    if (locale == null) continue;
                    if (transmitPersonInfo != null) {
                        transmitName = transmitPersonInfo.getName(locale);
                    }
                    String perfPlan = objectInfo.getPeriod().getPerfPlan().getName(locale);
                    if (isOrg) {
                        org = objectInfo.getEvaluOrgAdmin().getCompany().getName(locale);
                        String orgName = objectInfo.getAdminHis().getName(locale);
                        orgName = orgName == null ? objectInfo.getName(locale) : orgName;
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NUMBER, locale), orgNumber);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ORG_NAME, locale), orgName);
                    } else {
                        String name = objectInfo.getPerson().getName(locale);
                        state = objectInfo.getPerfFile().getEmployeeType().getName(locale);
                        org = objectInfo.getPerfFile().getAdminOrgUnit().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, locale), number);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, locale), name);
                        String position = objectInfo.getPerfFile().getPosition().getName(locale);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFPOSITION, locale), position);
                        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRYDATE, locale), enterDate);
                    }
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AFFILIATEDORG, locale), org);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATIONSTATE, locale), state);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLAN, locale), perfPlan);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIOD, locale), perfPeriod);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIODSTART, locale), perfPeriod_start);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATIONEND, locale), perfPeriod_end);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, locale), representation);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNAME, locale), transmitName);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNUMBER, locale), transmitNumber);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DEALTIME, locale), DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    if (map != null && map.get(objectInfo.getId().toString()) != null) {
                        varMap.putAll((Map)map.get(objectInfo.getId().toString()));
                    }
                    if (param == 2) {
                        reMap.put(personId, varMap);
                        continue;
                    }
                    reMap.put(objectInfo.getId().toString(), varMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information BOSException fail!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        return reMap;
    }

    public static HashMap<String, HashMap<String, String>> getVarDataByReceiverIds(Context ctx, String[] receiverIds, HashMap<String, HashMap<String, String>> map, Integer reType) {
        HashMap<String, HashMap<String, String>> reMap = new HashMap<String, HashMap<String, String>>();
        try {
            String senderId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            String transmitName = "";
            String transmitNumber = "";
            if (StringUtils.isEmpty((String)senderId)) {
                senderId = "00000000-0000-0000-0000-00000000000013B7DE7F";
                transmitName = "administrator";
                transmitNumber = "administrator";
            } else {
                PersonInfo transmitPersonInfo = CurrentUserUtil.getPersonById(ctx, senderId);
                transmitName = transmitPersonInfo.getName();
                transmitNumber = transmitPersonInfo.getNumber();
            }
            List langList = BOSConfigUtil.getLanguageMapingList();
            for (int i = 0; i < receiverIds.length; ++i) {
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id='" + receiverIds[i] + "'").get(0);
                String number = personInfo.getNumber();
                String representation = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                for (int i1 = 0; i1 < langList.size(); ++i1) {
                    String lang = (String)((Map)langList.get(i1)).get("lang");
                    Locale locale = null;
                    if ("l1".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l1;
                    } else if ("l2".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l2;
                    } else if ("l3".equalsIgnoreCase(lang)) {
                        locale = LocaleUtils.locale_l3;
                    }
                    if (locale == null) continue;
                    String name = personInfo.getName(locale);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, locale), number);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, locale), name);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, locale), representation);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNAME, locale), transmitName);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TRANSMITNUMBER, locale), transmitNumber);
                    varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DEALTIME, locale), DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (map != null && map.get(receiverIds[i]) != null) {
                    varMap.putAll((Map)map.get(receiverIds[i]));
                }
                if (reType != 2) continue;
                reMap.put(receiverIds[i], varMap);
            }
        }
        catch (BOSException e) {
            logger.error("[perfweb_MessageTemplateUtils#getVarDataByObjIdArray]MessageTemplate find perfObj information fail!", (Throwable)e);
        }
        return reMap;
    }

    public static HashMap<String, MessageTemplateDefineCollection> replaceVar(HashMap<String, HashMap<String, String>> map, MessageTemplateDefineCollection messageTempDefColl) {
        HashMap<String, MessageTemplateDefineCollection> reMap = new HashMap<String, MessageTemplateDefineCollection>();
        if (messageTempDefColl != null && messageTempDefColl.size() > 0) {
            try {
                Set<String> set = map.keySet();
                for (String key : set) {
                    if (key == null || map.get(key) == null) continue;
                    HashMap<String, String> varMap = map.get(key);
                    MessageTemplateDefineCollection msgTempDefColl = (MessageTemplateDefineCollection)((Object)DeepClone.deepClone((Object)((Object)messageTempDefColl)));
                    int defCollSize = messageTempDefColl.size();
                    for (int i = 0; i < defCollSize; ++i) {
                        MessageTemplateDefineInfo info = messageTempDefColl.get(i);
                        msgTempDefColl.get(i).setTemplateTitle(MessageTemplateUtils.replaceVar(varMap, info.getTemplateTitle(LocaleUtils.locale_l1)), LocaleUtils.locale_l1);
                        msgTempDefColl.get(i).setTemplateTitle(MessageTemplateUtils.replaceVar(varMap, info.getTemplateTitle(LocaleUtils.locale_l2)), LocaleUtils.locale_l2);
                        msgTempDefColl.get(i).setTemplateTitle(MessageTemplateUtils.replaceVar(varMap, info.getTemplateTitle(LocaleUtils.locale_l3)), LocaleUtils.locale_l3);
                        msgTempDefColl.get(i).setTemplateContent(MessageTemplateUtils.replaceVar(varMap, info.getTemplateContent(LocaleUtils.locale_l1)), LocaleUtils.locale_l1);
                        msgTempDefColl.get(i).setTemplateContent(MessageTemplateUtils.replaceVar(varMap, info.getTemplateContent(LocaleUtils.locale_l2)), LocaleUtils.locale_l2);
                        msgTempDefColl.get(i).setTemplateContent(MessageTemplateUtils.replaceVar(varMap, info.getTemplateContent(LocaleUtils.locale_l3)), LocaleUtils.locale_l3);
                    }
                    reMap.put(key, (MessageTemplateDefineCollection)((Object)DeepClone.deepClone((Object)((Object)msgTempDefColl))));
                }
            }
            catch (Exception e) {
                logger.error("[perfweb_MessageTemplateUtils#replaceVar] MessageTemplate replace varValue file", (Throwable)e);
            }
        }
        return reMap;
    }

    public static String combinationCont(HashMap<String, String> map, String templateContent) throws BOSException {
        Set<String> set = map.keySet();
        for (String key : set) {
            if (key == null || map.get(key) == null) continue;
            templateContent = templateContent.replace(key, map.get(key));
        }
        return templateContent;
    }

    public static String replaceVar(HashMap<String, String> varMap, String content) {
        if (content == null || content.length() == 0 || varMap == null) {
            return content;
        }
        String reg = "\\[\\[.*?\\]\\]";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String varName = matcher.group(0);
            String varNameValue = varMap.get(varName);
            if (varNameValue == null) continue;
            content = content.replace(varName, varNameValue);
        }
        return content;
    }

    public static MessageTemplateDefineCollection combinationContByTempId(Context ctx, String templateId, HashMap<String, String> map) throws BOSException {
        IMessageTemplateDefine msgTempDef = MessageTemplateDefineFactory.getLocalInstance(ctx);
        String oql = "where messageTemplate='" + templateId + "'";
        MessageTemplateDefineCollection msgTempDefColl = msgTempDef.getMessageTemplateDefineCollection(oql);
        for (int j = 0; j < msgTempDefColl.size(); ++j) {
            String templateContent = msgTempDefColl.get(j).getTemplateContent();
            if (StringUtil.isEmptyString((String)templateContent)) continue;
            String content = MessageTemplateUtils.combinationCont(map, templateContent);
            msgTempDefColl.get(j).setTemplateContent(content);
        }
        return msgTempDefColl;
    }

    public static HashMap<String, String> getVarMap(Context ctx, String number, String name, String org, String position, String state, String enterDate, String perfPlan, String perfPeriod, String representation) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNUMBER, ctx), number);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFNAME, ctx), name);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AFFILIATEDORG, ctx), org);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.STAFFPOSITION, ctx), position);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATIONSTATE, ctx), state);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRYDATE, ctx), enterDate);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLAN, ctx), perfPlan);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPERIOD, ctx), perfPeriod);
        varMap.put(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.REPRESENTATION, ctx), representation);
        return varMap;
    }

    public static String getDefoMsgTempId(Context ctx, String busiCategoryId) {
        Object msgcollMap = null;
        String msgTempId = "";
        try {
            IMessageTemplate iMessageTemplate = MessageTemplateFactory.getLocalInstance(ctx);
            MessageTemplateCollection messageTemplateColl = iMessageTemplate.getMessageTemplateCollection("where busiCategory = '" + busiCategoryId + "' and state = 1 order by index");
            if (messageTemplateColl != null && messageTemplateColl.size() > 0) {
                msgTempId = messageTemplateColl.get(0).getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return msgTempId;
    }

    public static void asmbleMsg(Context ctx, CoreBaseCollection poolColl, CoreBaseCollection cool, ReMsgBean reMsgBean) throws EASBizException, BOSException {
        String receivePhone = null;
        String receiveEmail = null;
        String errorInfo = "";
        PersonInfo receivePersonInfo = reMsgBean.getReceiver();
        if (receivePersonInfo == null) {
            return;
        }
        MsgConfigBean config = reMsgBean.get("config") != null ? (MsgConfigBean)reMsgBean.get("config") : reMsgBean.getConfig();
        receivePhone = receivePersonInfo.getCell();
        receiveEmail = receivePersonInfo.getEmail();
        PerfSendMessageTaskPoolInfo perfSendMessageTaskPoolInfo = new PerfSendMessageTaskPoolInfo();
        perfSendMessageTaskPoolInfo.setMessageService(config.getMessageService());
        perfSendMessageTaskPoolInfo.put("receivePerson", receivePersonInfo.getId().toString());
        perfSendMessageTaskPoolInfo.setReceivePhone(receivePhone);
        perfSendMessageTaskPoolInfo.setReceiveEmail(receiveEmail);
        perfSendMessageTaskPoolInfo.setPhoneContent(config.getPhoneContent());
        perfSendMessageTaskPoolInfo.setSMSConfig(config.getSmsTemplateCode());
        perfSendMessageTaskPoolInfo.setEmailTitle(reMsgBean.getEmailTitle());
        perfSendMessageTaskPoolInfo.setEmailContent(reMsgBean.getEmailContent());
        perfSendMessageTaskPoolInfo.setEASMessageTitle(reMsgBean.getSysTitle());
        perfSendMessageTaskPoolInfo.setEASMessage(reMsgBean.getSysContent());
        perfSendMessageTaskPoolInfo.setEASMessageTitle(reMsgBean.getSysTitle_l1(), LocaleUtils.locale_L1);
        perfSendMessageTaskPoolInfo.setEASMessageTitle(reMsgBean.getSysTitle_l2(), LocaleUtils.locale_L2);
        perfSendMessageTaskPoolInfo.setEASMessageTitle(reMsgBean.getSysTitle_l3(), LocaleUtils.locale_L3);
        perfSendMessageTaskPoolInfo.setEASMessage(reMsgBean.getSysContent_l1(), LocaleUtils.locale_L1);
        perfSendMessageTaskPoolInfo.setEASMessage(reMsgBean.getSysContent_l2(), LocaleUtils.locale_L2);
        perfSendMessageTaskPoolInfo.setEASMessage(reMsgBean.getSysContent_l3(), LocaleUtils.locale_L3);
        perfSendMessageTaskPoolInfo.put("status", 0);
        perfSendMessageTaskPoolInfo.setYzjMessage(reMsgBean.getYzjContent());
        perfSendMessageTaskPoolInfo.setUrl((String)reMsgBean.get("url"));
        perfSendMessageTaskPoolInfo.setAppurl((String)reMsgBean.get("appurl"));
        HashMap<String, String> mapper = new HashMap<String, String>(){
            {
                this.put("templateTitle", "EASMsTitle");
                this.put("templateContent", "EASMessage");
            }
        };
        PerfMessageRecordInfo perfMessageRecordInfo = new PerfMessageRecordInfo();
        perfMessageRecordInfo.put("adminOrgUnit", reMsgBean.get("objAdmin"));
        perfMessageRecordInfo.put("person", reMsgBean.get("objPerson"));
        perfMessageRecordInfo.put("receivePerson", reMsgBean.getReceiver().getId().toString());
        perfMessageRecordInfo.put("perfplan", reMsgBean.get("perfplan"));
        perfMessageRecordInfo.put("perfperiod", reMsgBean.get("perfperiod"));
        perfMessageRecordInfo.put("multiPerfPlan", reMsgBean.get("multiPerfPlan"));
        perfMessageRecordInfo.put("multiPerfPeriod", reMsgBean.get("multiPerfPeriod"));
        perfMessageRecordInfo.setServiceName(config.getMessageService());
        perfMessageRecordInfo.setReceivePhone(receivePhone);
        perfMessageRecordInfo.setReceiveEmail(receiveEmail);
        perfMessageRecordInfo.setPhoneContent(config.getPhoneContent());
        perfMessageRecordInfo.setSMSConfig(config.getSmsTemplateCode());
        perfMessageRecordInfo.setEmailTitle(reMsgBean.getEmailTitle());
        perfMessageRecordInfo.setEmailContent(reMsgBean.getEmailContent());
        perfMessageRecordInfo.setEASMsTitle(reMsgBean.getSysTitle());
        perfMessageRecordInfo.setEASMessage(reMsgBean.getSysContent());
        perfMessageRecordInfo.setEASMsTitle(reMsgBean.getSysTitle_l1(), LocaleUtils.locale_L1);
        perfMessageRecordInfo.setEASMsTitle(reMsgBean.getSysTitle_l2(), LocaleUtils.locale_L2);
        perfMessageRecordInfo.setEASMsTitle(reMsgBean.getSysTitle_l3(), LocaleUtils.locale_L3);
        perfMessageRecordInfo.setEASMessage(reMsgBean.getSysContent_l1(), LocaleUtils.locale_L1);
        perfMessageRecordInfo.setEASMessage(reMsgBean.getSysContent_l2(), LocaleUtils.locale_L2);
        perfMessageRecordInfo.setEASMessage(reMsgBean.getSysContent_l3(), LocaleUtils.locale_L3);
        perfMessageRecordInfo.put("phoneMsStatus", 0);
        perfMessageRecordInfo.put("emailMsStastus", 0);
        perfMessageRecordInfo.put("EASMsStatus", 0);
        perfMessageRecordInfo.setUrl((String)reMsgBean.get("url"));
        perfMessageRecordInfo.setYzjMessage(reMsgBean.getYzjContent());
        perfMessageRecordInfo.put("YzjMsgStatus", 0);
        String hrOrgUnitId = (String)reMsgBean.get("hrOrgUnitId");
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            hrOrgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        perfMessageRecordInfo.setHrOrgUnitId(hrOrgUnitId);
        perfMessageRecordInfo.setEvaObjId((String)reMsgBean.get("evaObjId"));
        if (config.isSmsType()) {
            if (receivePhone == null) {
                perfMessageRecordInfo.put("phoneMsStatus", 0);
                perfSendMessageTaskPoolInfo.put("phoneMsStatus", 0);
                errorInfo = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RECEIVERMOBILEREQUIRED, ctx);
            } else {
                perfMessageRecordInfo.put("phoneMsStatus", 3);
                perfSendMessageTaskPoolInfo.put("phoneMsStatus", 3);
            }
        } else {
            perfMessageRecordInfo.put("phoneMsStatus", 2);
            perfSendMessageTaskPoolInfo.put("phoneMsStatus", 2);
        }
        if (config.isEmailType()) {
            if (receiveEmail == null) {
                errorInfo = StringUtils.isEmpty((String)errorInfo) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RECEIVEREMAILREQUIRED, ctx) : errorInfo + "," + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RECEIVEREMAILREQUIRED, ctx);
                perfMessageRecordInfo.put("emailMsStastus", 0);
                perfSendMessageTaskPoolInfo.put("emailMsStastus", 0);
            } else {
                perfMessageRecordInfo.put("emailMsStastus", 3);
                perfSendMessageTaskPoolInfo.put("emailMsStastus", 3);
            }
        } else {
            perfMessageRecordInfo.put("emailMsStastus", 2);
            perfSendMessageTaskPoolInfo.put("emailMsStastus", 2);
        }
        if (config.isSysType()) {
            perfMessageRecordInfo.put("EASMsStatus", 3);
            perfSendMessageTaskPoolInfo.put("EASMsStatus", 3);
        } else {
            perfMessageRecordInfo.put("EASMsStatus", 2);
            perfSendMessageTaskPoolInfo.put("EASMsStatus", 2);
        }
        if (config.isYzjType()) {
            if (StringUtils.isEmpty((String)reMsgBean.getYzjContent())) {
                errorInfo = StringUtils.isEmpty((String)errorInfo) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YZJCONTENTISNULL, ctx) : errorInfo + "," + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YZJCONTENTISNULL, ctx);
                perfMessageRecordInfo.put("YzjMsgStatus", 0);
                perfSendMessageTaskPoolInfo.put("YzjMsgStatus", 0);
            } else {
                perfMessageRecordInfo.put("YzjMsgStatus", 3);
                perfSendMessageTaskPoolInfo.put("YzjMsgStatus", 3);
            }
        } else {
            perfMessageRecordInfo.put("YzjMsgStatus", 2);
            perfSendMessageTaskPoolInfo.put("YzjMsgStatus", 2);
        }
        if (errorInfo == null) {
            errorInfo = "";
        }
        String error = "";
        BOSUuid bosUuid = BOSUuid.create((String)"DB27F143");
        perfSendMessageTaskPoolInfo.setId(bosUuid);
        perfMessageRecordInfo.put("perfSendMessageTaskPool", bosUuid.toString());
        perfMessageRecordInfo.setErrorInfo(errorInfo + error);
        cool.add((CoreBaseInfo)perfMessageRecordInfo);
        poolColl.add((CoreBaseInfo)perfSendMessageTaskPoolInfo);
    }
}

