/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.perfweb.app.base.evalrule.StatusEnum;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryPersonEvaObject;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryRule;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfSummaryRuleAndScoreFormulaMid;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndScoreFormulaMidCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndScoreFormulaMidFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfSummaryRuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(PerfSummaryRuleUtils.class);

    public static String checkSingleDataStatus(Context ctx, String summaryRuleId, String statusType) throws BOSException {
        String result = "200";
        HashSet<String> summaryRuleIds = new HashSet<String>(Arrays.asList(summaryRuleId));
        BatchMessageTipsHeader tipsHeader = new BatchMessageTipsHeader();
        PerfSummaryRuleUtils.checkDataStatus(ctx, summaryRuleIds, statusType, tipsHeader);
        if ("1".equals(statusType)) {
            if (CollectionUtils.isEmpty(summaryRuleIds)) {
                result = "enabled";
            }
        } else if (CollectionUtils.isEmpty(summaryRuleIds)) {
            List bodyList = tipsHeader.getResult();
            result = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEDISABLEERRASDISABLED, ctx).equals(((BatchMessageTipsBody)bodyList.get(0)).getMuitTipsMessage()) ? "forbided" : "disabled";
        }
        return result;
    }

    public static void checkDataHasReferenced(Context ctx, Set<String> summaryRuleIds, BatchMessageTipsHeader batchMessageTipsHeader) throws BOSException {
        if (CollectionUtils.isEmpty(summaryRuleIds)) {
            logger.error("summaryRuleIds is null");
            return;
        }
        IPerfSummaryPersonEvaObject perfSummaryPersonEvaObject = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx);
        FilterInfo ruleFilter = new FilterInfo();
        ruleFilter.getFilterItems().add(new FilterItemInfo("summaryRule", summaryRuleIds, CompareType.INCLUDE));
        PerfSummaryPersonEvaObjectCollection perfSummaryPersonEvaObjectCollection = perfSummaryPersonEvaObject.getPerfSummaryPersonEvaObjectCollection("select summaryRule.id where " + ruleFilter.toSql());
        HashSet<String> hasRefIds = new HashSet<String>(summaryRuleIds.size());
        for (int i = 0; i < perfSummaryPersonEvaObjectCollection.size(); ++i) {
            hasRefIds.add(perfSummaryPersonEvaObjectCollection.get(i).getSummaryRule().getId().toString());
        }
        if (!CollectionUtils.isEmpty(hasRefIds)) {
            PerfSummaryRuleUtils.addBatchMessageTips(hasRefIds, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DATAREFNOTDELETE, ctx), batchMessageTipsHeader);
            summaryRuleIds.removeAll(hasRefIds);
        }
    }

    public static void checkDataIsEnabled(Context ctx, Set<String> summaryRuleIds, BatchMessageTipsHeader batchMessageTipsHeader) throws BOSException {
        if (CollectionUtils.isEmpty(summaryRuleIds)) {
            logger.error("summaryRuleIds is null");
            return;
        }
        HashSet<String> enableIds = new HashSet<String>(summaryRuleIds.size());
        IPerfSummaryRule perfSummaryRule = PerfSummaryRuleFactory.getLocalInstance(ctx);
        FilterInfo ruleFilter = new FilterInfo();
        ruleFilter.getFilterItems().add(new FilterItemInfo("id", summaryRuleIds, CompareType.INCLUDE));
        ruleFilter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        PerfSummaryRuleCollection perfSummaryRuleCollection = perfSummaryRule.getPerfSummaryRuleCollection("where " + ruleFilter.toSql());
        if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
            for (int i = 0; i < perfSummaryRuleCollection.size(); ++i) {
                PerfSummaryRuleInfo perfSummaryRuleInfo = perfSummaryRuleCollection.get(i);
                enableIds.add(perfSummaryRuleInfo.getId().toString());
            }
            if (!CollectionUtils.isEmpty(enableIds)) {
                PerfSummaryRuleUtils.addBatchMessageTips(enableIds, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DATAENABLEDNOTDELETE, ctx), batchMessageTipsHeader);
                summaryRuleIds.removeAll(enableIds);
            }
        }
    }

    public static void checkDataStatus(Context ctx, Set<String> summaryRuleIds, String statusType, BatchMessageTipsHeader batchMessageTipsHeader) throws BOSException {
        if (CollectionUtils.isEmpty(summaryRuleIds)) {
            logger.error("summaryRuleIds is null");
            return;
        }
        HashSet<String> disableIds = new HashSet<String>(summaryRuleIds.size());
        HashSet<String> forbidIds = new HashSet<String>(summaryRuleIds.size());
        HashSet<String> enableIds = new HashSet<String>(summaryRuleIds.size());
        IPerfSummaryRule perfSummaryRule = PerfSummaryRuleFactory.getLocalInstance(ctx);
        FilterInfo ruleFilter = new FilterInfo();
        ruleFilter.getFilterItems().add(new FilterItemInfo("id", summaryRuleIds, CompareType.INCLUDE));
        CompareType compareType = "1".equals(statusType) ? CompareType.EQUALS : CompareType.NOTEQUALS;
        ruleFilter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", compareType));
        PerfSummaryRuleCollection perfSummaryRuleCollection = perfSummaryRule.getPerfSummaryRuleCollection("where " + ruleFilter.toSql());
        if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
            for (int i = 0; i < perfSummaryRuleCollection.size(); ++i) {
                PerfSummaryRuleInfo perfSummaryRuleInfo = perfSummaryRuleCollection.get(i);
                if ("1".equals(statusType)) {
                    enableIds.add(perfSummaryRuleInfo.getId().toString());
                    continue;
                }
                if (StatusEnum.DISABLED == perfSummaryRuleInfo.getStatus()) {
                    disableIds.add(perfSummaryRuleInfo.getId().toString());
                    continue;
                }
                if (StatusEnum.FORBID != perfSummaryRuleInfo.getStatus()) continue;
                forbidIds.add(perfSummaryRuleInfo.getId().toString());
            }
            if (!CollectionUtils.isEmpty(disableIds)) {
                PerfSummaryRuleUtils.addBatchMessageTips(disableIds, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEDISABLEERRASUNENABLE, ctx), batchMessageTipsHeader);
                summaryRuleIds.removeAll(disableIds);
            }
            if (!CollectionUtils.isEmpty(forbidIds)) {
                PerfSummaryRuleUtils.addBatchMessageTips(forbidIds, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEDISABLEERRASDISABLED, ctx), batchMessageTipsHeader);
                summaryRuleIds.removeAll(forbidIds);
            }
            if (!CollectionUtils.isEmpty(enableIds)) {
                PerfSummaryRuleUtils.addBatchMessageTips(enableIds, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEENABLEERRASENABLED, ctx), batchMessageTipsHeader);
                summaryRuleIds.removeAll(enableIds);
            }
        }
    }

    public static Set<String> checkIsHaveScoreFormula(Context ctx, Set<String> summaryRuleIds) throws BOSException {
        HashSet<String> noScoreFormulaIds = new HashSet();
        IPerfSummaryRuleAndScoreFormulaMid instance = PerfSummaryRuleAndScoreFormulaMidFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("summaryRule", summaryRuleIds, CompareType.INCLUDE));
        PerfSummaryRuleAndScoreFormulaMidCollection midCollection = instance.getPerfSummaryRuleAndScoreFormulaMidCollection("where " + filterInfo.toSql());
        if (midCollection != null && midCollection.size() > 0) {
            HashSet<String> hasScoreFormulaIds = new HashSet<String>();
            for (int i = 0; i < midCollection.size(); ++i) {
                hasScoreFormulaIds.add(midCollection.get(i).getSummaryRule().getId().toString());
            }
            summaryRuleIds.removeAll(hasScoreFormulaIds);
            noScoreFormulaIds = new HashSet<String>(summaryRuleIds);
            summaryRuleIds.clear();
            summaryRuleIds.addAll(hasScoreFormulaIds);
        } else {
            noScoreFormulaIds = new HashSet<String>(summaryRuleIds);
            summaryRuleIds.clear();
        }
        return noScoreFormulaIds;
    }

    protected static void addBatchMessageTips(Collection<String> unValidIds, String message, BatchMessageTipsHeader batchMessageTipsHeader) {
        for (String unValidId : unValidIds) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(unValidId);
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            body.setMuitTipsMessage(message);
            batchMessageTipsHeader.addResult(body);
        }
        batchMessageTipsHeader.setFailureCount(batchMessageTipsHeader.getFailureCount() + unValidIds.size());
    }
}

