/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PerfwebStrUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfwebStrUtils.class);
    private static Pattern PATTERN_NUMBER = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){1,})?$");
    private static Pattern PATTERN_PERCENTNUMBER = Pattern.compile("^\\d+\\.?\\d*\\%?$");

    public static String convertListToString(List<String> list) {
        Object[] array = list.toArray();
        return PerfwebStrUtils.convertListToString(array);
    }

    public static String convertListToString(Object[] array) {
        StringBuffer sb = new StringBuffer();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("'");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)array[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    public static String converMapToString(Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(",'").append(entry.getKey()).append("'");
        }
        String sqlId = sb.toString();
        return sqlId.replaceFirst(",", "");
    }

    public static String converStringToSqlString(String str, String splitKey) {
        StringBuilder sb = new StringBuilder();
        if (PerfwebStrUtils.isEmpty(str)) {
            return "''";
        }
        String[] array = str.split(splitKey);
        for (int i = 0; i < array.length; ++i) {
            sb.append("'").append(array[i]).append("',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean isInteger(Object obj) {
        boolean res = true;
        if (obj == null) {
            return false;
        }
        String value = obj.toString();
        if (!value.matches("[+-]?\\d*")) {
            res = false;
        }
        return res;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String s) {
        return !PerfwebStrUtils.isEmpty(s);
    }

    public static boolean isNullOrEmpty(Object ... objs) {
        boolean flag = false;
        if (null == objs || objs.length == 0) {
            return true;
        }
        for (Object o : objs) {
            if (null == o) {
                return true;
            }
            if (o instanceof String && ((String)o).trim().length() == 0) {
                return true;
            }
            if (o instanceof Integer && PerfwebStrUtils.toInt(o) == 0) {
                return true;
            }
            if (o instanceof BigDecimal && new BigDecimal(0).equals(PerfwebStrUtils.toBigDecimal(o))) {
                return true;
            }
            if (o instanceof Collection && ((Collection)o).size() == 0) {
                return true;
            }
            if (o instanceof Set && ((Set)o).size() == 0) {
                return true;
            }
            if (o instanceof List && ((List)o).size() == 0) {
                return true;
            }
            if (o instanceof IObjectCollection && ((IObjectCollection)o).size() == 0) {
                return true;
            }
            if (!(o instanceof Map) || ((Map)o).size() != 0) continue;
            return true;
        }
        return flag;
    }

    public static Integer toInt(Object obj) {
        Integer res = 0;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str).intValue();
            }
            catch (Exception e5) {
                res = 0;
            }
        }
        return res;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal res = new BigDecimal(0);
        if (obj == null) {
            return null;
        }
        String str = String.valueOf(obj);
        if ("0E-10".equalsIgnoreCase(str)) {
            return res;
        }
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str);
            }
            catch (Exception e) {
                res = new BigDecimal(0);
            }
        }
        return res;
    }

    public static java.util.Date toDate(Object obj) {
        java.util.Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                res = sdf.parse(str);
            }
            catch (ParseException e) {
                sdf = new SimpleDateFormat("yyyy/M/d");
                try {
                    res = sdf.parse(str);
                }
                catch (ParseException e1) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd");
                    try {
                        res = sdf.parse(str);
                    }
                    catch (ParseException e2) {
                        sdf = new SimpleDateFormat("yyyy-M-d");
                        try {
                            res = sdf.parse(str);
                        }
                        catch (ParseException e3) {
                            sdf = new SimpleDateFormat("EEE MMM d H:m:s z y");
                            try {
                                res = sdf.parse(str);
                            }
                            catch (ParseException e4) {
                                sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
                                try {
                                    res = sdf.parse(str);
                                }
                                catch (ParseException e5) {
                                    res = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    public static String join(Object obj, String str, String key) {
        Object[] array = null;
        if (PerfwebStrUtils.isNullOrEmpty(obj)) {
            return "";
        }
        if (obj instanceof Map) {
            if (PerfwebStrUtils.isNullOrEmpty(key)) {
                return "";
            }
            Map map = (Map)obj;
            if (map.containsKey(key)) {
                return PerfwebStrUtils.toString(map.get(key));
            }
        }
        if (obj instanceof Object[]) {
            StringBuffer sb = new StringBuffer();
            for (Object arrObj : (Object[])obj) {
                String tempStr = "";
                if (arrObj instanceof Map) {
                    if (PerfwebStrUtils.isNullOrEmpty(key)) {
                        return "";
                    }
                    Map map = (Map)arrObj;
                    if (map.containsKey(key)) {
                        tempStr = PerfwebStrUtils.toString(map.get(key));
                    }
                } else {
                    tempStr = PerfwebStrUtils.toString(arrObj);
                }
                sb.append(str + tempStr);
            }
            return sb.toString().replaceFirst(str, "");
        }
        if (obj instanceof Collection) {
            array = ((Collection)obj).toArray();
        } else if (obj instanceof Set) {
            array = ((Set)obj).toArray();
        } else if (obj instanceof List) {
            array = ((List)obj).toArray();
        } else if (obj instanceof IObjectCollection) {
            array = ((IObjectCollection)obj).toArray();
        }
        if (PerfwebStrUtils.isNullOrEmpty(array)) {
            return PerfwebStrUtils.toString(obj);
        }
        String joinStr = PerfwebStrUtils.join(array, str, key);
        return joinStr;
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof java.util.Date || obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(obj);
            }
            return String.valueOf(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = secureRandom.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String decodeSorter(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] split = str.split(",");
        StringBuffer res = new StringBuffer();
        for (String s : split) {
            if (StringUtils.isEmpty((String)s) || s.trim() == "") continue;
            if (s.contains(".") && !s.contains("\"")) {
                res.append(",\"" + s.trim().split("\\s")[0] + "\"");
                if (s.trim().split("\\s").length <= 1) continue;
                res.append(" " + s.trim().split("\\s")[1]);
                continue;
            }
            res.append("," + s.trim());
        }
        return res.toString().startsWith(",") ? res.toString().substring(1) : res.toString();
    }

    public static String buildInSql(String ids) {
        if (ids.toLowerCase().contains("select")) {
            return "(select \"cmp_ctb.id\" from (" + ids + ") as dynamicSql)";
        }
        return "('" + ids.replace(",", "','") + "')";
    }

    public static boolean isNumber(String str) {
        Matcher match = PATTERN_NUMBER.matcher(str);
        return match.matches();
    }

    public static boolean isPercentNumber(String str) {
        Matcher match = PATTERN_PERCENTNUMBER.matcher(str);
        return match.matches();
    }

    public static String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            String md5Str = new String(str);
            return md5Str;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static Boolean isDouble(Object obj) {
        try {
            String str = PerfwebStrUtils.toString(obj);
            if (str != null) {
                if (str.startsWith("0") && !str.startsWith("0\\.")) {
                    return false;
                }
                if (str.split("\\.")[0].length() > 9) {
                    return false;
                }
                double b = Double.parseDouble(str);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Double toDouble(Object obj) {
        BigDecimal bigDecimal = PerfwebStrUtils.toBigDecimal(obj);
        if (bigDecimal != null) {
            Double res = bigDecimal.doubleValue();
            return res;
        }
        if (logger.isDebugEnabled()) {
            logger.error("[PERFWEB]it is failed to get bigDecimal");
        }
        return null;
    }

    public static boolean isDate(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        return str.matches("\\d{4}/\\d{1,2}/\\d{1,2}") || str.matches("\\d{4}\\.\\d{1,2}\\.\\d{1,2}") || str.matches("\\d{4}-\\d{1,2}-\\d{1,2}") || PerfwebStrUtils.toDate(str) != null;
    }

    public static String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    public static String combineByComma(List datas) {
        if (datas == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object o : datas) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append((String)o);
        }
        return sb.toString();
    }

    public static String filterHtmlTag(String text) {
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public static boolean isNullOrEmpty(String ... strs) {
        boolean flag = false;
        for (String s : strs) {
            if (s != null && !"".equals(s.trim())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static String listToString(List<String> dataList, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : dataList) {
            sb.append(str).append(separator);
        }
        return sb.toString().substring(0, sb.length() - 1);
    }
}

