/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.bizflow.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObjMatrixWorkFlowInst;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteIndicator;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteRecord;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IIndicatorExtendHelper;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorFactory;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.QualiOrRation;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.util.IndicatorExtendHelperUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class RuleHistoryUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.RuleHistoryUtils");
    public static final int RETYPE_OTHER = 1;
    public static final int RETYPE_THIS = 2;

    public static void filterFormArea(Context ctx, String periodId, Map<String, Object> map) {
        try {
            if (StringUtils.isEmpty((String)periodId) || map == null) {
                return;
            }
            PersonalEvaBaseBean baseBean = (PersonalEvaBaseBean)map.get("rows");
            String sourcePeriodId = baseBean.getPeriodId();
            HashMap<String, String> areaMap = RuleHistoryUtils.getAreaMap(ctx, periodId, sourcePeriodId);
            map.put("areaMap", areaMap);
            HashSet<String> areaIds = RuleHistoryUtils.getAreaIdsByPeriod(ctx, periodId);
            areaIds.addAll(new HashSet<String>(areaMap.values()));
            ArrayList<EvaAreaListBean> evaAreaList = baseBean.getEvaAreaList();
            for (int i = 0; i < evaAreaList.size(); ++i) {
                if (areaIds.contains(evaAreaList.get(i).getAreaId())) continue;
                evaAreaList.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            logger.error("[perfweb_RuleHistoryUtils]:filterFormArea have err!", (Throwable)e);
        }
    }

    public static void filterPeriod(Context ctx, String ThisPeriodId, Map<String, Object> map) {
        try {
            if (StringUtils.isEmpty((String)ThisPeriodId) || map == null) {
                return;
            }
            LinkedList periodList = (LinkedList)map.get("rows");
            for (int i = 0; i < periodList.size(); ++i) {
                HashMap<String, String> areaMap = RuleHistoryUtils.getAreaMap(ctx, ThisPeriodId, ((HashMap)periodList.get(i)).get("id").toString());
                if (!CollectionUtil.isEmpty(areaMap)) continue;
                periodList.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            logger.error("[perfweb_RuleHistoryUtils]:filterPeriod have err!", (Throwable)e);
        }
    }

    public static void refGroupCopyIndicator(Context ctx, String sourceGroupId, String newGroupId, String sourecPeriod, String nowPeriod, String isUpdateIndicator) {
        try {
            IndicatorExtendHelperInfo extend;
            IndicatorExtendHelperInfo beCopyExtend;
            int i;
            int size;
            AbstractObjectCollection sourceIndicaColl;
            SelectorItemCollection uniteSelector;
            EntityViewInfo uniteViewInfo;
            FilterInfo uniteFilter;
            String sourceAreaId;
            HashSet<String> hasQualiAreas = new HashSet<String>();
            HashSet<String> refAreaIds = new HashSet<String>();
            HashMap<String, String> indiAreaMap = RuleHistoryUtils.getAreaMap(ctx, nowPeriod, sourecPeriod, "200");
            Set<String> indiAreaIdSet = indiAreaMap.keySet();
            refAreaIds.addAll(indiAreaIdSet);
            HashMap<String, String> recAreaMap = RuleHistoryUtils.getAreaMap(ctx, nowPeriod, sourecPeriod, "300");
            Set<String> recAreaIdSet = recAreaMap.keySet();
            refAreaIds.addAll(recAreaIdSet);
            if (refAreaIds.size() > 0) {
                FilterInfo fieldFilter = new FilterInfo();
                fieldFilter.getFilterItems().add(new FilterItemInfo("areaBase", refAreaIds, CompareType.INCLUDE));
                fieldFilter.getFilterItems().add(new FilterItemInfo("fieldTemplate", (Object)"UTzGVhUtlUWHcFWRvbY6spDpHWw=", CompareType.EQUALS));
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("areaBase"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fieldFilter);
                evi.setSelector(selectors);
                EvaFormFieldConfCollection colls = EvaFormFieldConfFactory.getLocalInstance(ctx).getEvaFormFieldConfCollection(evi);
                if (!CollectionUtil.isEmpty((AbstractObjectCollection)colls)) {
                    Iterator iterator = colls.iterator();
                    while (iterator.hasNext()) {
                        EvaFormFieldConfInfo formFieldConf = (EvaFormFieldConfInfo)iterator.next();
                        hasQualiAreas.add(formFieldConf.getAreaBase());
                    }
                }
            }
            IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getRemoteInstance();
            IUniteIndicator iUniteIndicator = UniteIndicatorFactory.getRemoteInstance();
            IUniteRecord iUniteRecord = UniteRecordFactory.getRemoteInstance();
            FilterInfo ruleFilter = new FilterInfo();
            ruleFilter.getFilterItems().add(new FilterItemInfo("id", (Object)nowPeriod));
            EntityViewInfo ruleEvi = new EntityViewInfo();
            SelectorItemCollection ruleSelector = ruleEvi.getSelector();
            ruleSelector.add("perfRule.id");
            ruleSelector.add("id");
            ruleSelector.add("perfPlan.id");
            ruleEvi.setFilter(ruleFilter);
            IPerfPeriod period = PerfPeriodFactory.getLocalInstance(ctx);
            PerfPeriodInfo periodInfo = period.getPerfPeriodCollection(ruleEvi).get(0);
            String perfplan = periodInfo.getPerfPlan().getId().toString();
            String ruleId = periodInfo.getPerfRule().getId().toString();
            CoreBaseCollection coreBase = new CoreBaseCollection();
            CoreBaseCollection recCoreBase = new CoreBaseCollection();
            for (String areaId : indiAreaIdSet) {
                sourceAreaId = indiAreaMap.get(areaId);
                uniteFilter = new FilterInfo();
                uniteFilter.getFilterItems().add(new FilterItemInfo("beGroup", (Object)sourceGroupId));
                uniteFilter.getFilterItems().add(new FilterItemInfo("areaBase", (Object)sourceAreaId));
                uniteViewInfo = new EntityViewInfo();
                uniteSelector = uniteViewInfo.getSelector();
                uniteSelector.add("*");
                uniteSelector.add("extend.*");
                uniteViewInfo.setFilter(uniteFilter);
                sourceIndicaColl = iUniteIndicator.getUniteIndicatorCollection(uniteViewInfo);
                size = sourceIndicaColl.size();
                for (i = 0; i < size; ++i) {
                    UniteIndicatorInfo beCopyIndicatorInfo = sourceIndicaColl.get(i);
                    beCopyIndicatorInfo.setId(null);
                    beCopyIndicatorInfo.put("perfPeriod", nowPeriod);
                    beCopyIndicatorInfo.put("beGroup", newGroupId);
                    beCopyIndicatorInfo.setAreaBase(areaId);
                    beCopyIndicatorInfo.setPerfRule(ruleId);
                    beCopyIndicatorInfo.setEvaPlan(perfplan);
                    beCopyExtend = beCopyIndicatorInfo.getExtend();
                    extend = new IndicatorExtendHelperInfo();
                    extend.setId(BOSUuid.create((String)"801580EF"));
                    if (null != beCopyExtend) {
                        for (String arr : IndicatorExtendHelperUtils.EXTENDARR) {
                            extend.put(arr, beCopyExtend.get(arr));
                        }
                    }
                    iIndicatorExtendHelper.addnew(extend);
                    beCopyIndicatorInfo.put("extend", extend.getId().toString());
                    beCopyIndicatorInfo.setRefTarget(null);
                    if (!hasQualiAreas.contains(areaId)) {
                        beCopyIndicatorInfo.setQualiOrRation(QualiOrRation.Quali);
                    }
                    if ("1".equals(isUpdateIndicator)) {
                        RuleHistoryUtils.upDatebyIndecator(ctx, beCopyIndicatorInfo);
                    }
                    coreBase.add((CoreBaseInfo)beCopyIndicatorInfo);
                }
            }
            for (String areaId : recAreaIdSet) {
                sourceAreaId = recAreaMap.get(areaId);
                uniteFilter = new FilterInfo();
                uniteFilter.getFilterItems().add(new FilterItemInfo("beGroup", (Object)sourceGroupId));
                uniteFilter.getFilterItems().add(new FilterItemInfo("areaBase", (Object)sourceAreaId));
                uniteViewInfo = new EntityViewInfo();
                uniteSelector = uniteViewInfo.getSelector();
                uniteSelector.add("*");
                uniteSelector.add("extend.*");
                uniteViewInfo.setFilter(uniteFilter);
                sourceIndicaColl = iUniteRecord.getUniteRecordCollection(uniteViewInfo);
                size = sourceIndicaColl.size();
                for (i = 0; i < size; ++i) {
                    UniteRecordInfo beCopyRecordInfo = sourceIndicaColl.get(i);
                    beCopyRecordInfo.setId(null);
                    beCopyRecordInfo.put("perfPeriod", nowPeriod);
                    beCopyRecordInfo.put("beGroup", newGroupId);
                    beCopyRecordInfo.setAreaBase(areaId);
                    beCopyRecordInfo.setPerfRule(ruleId);
                    beCopyRecordInfo.setEvaPlan(perfplan);
                    beCopyExtend = beCopyRecordInfo.getExtend();
                    extend = new IndicatorExtendHelperInfo();
                    extend.setId(BOSUuid.create((String)"801580EF"));
                    if (null != beCopyExtend) {
                        for (String arr : IndicatorExtendHelperUtils.EXTENDARR) {
                            extend.put(arr, beCopyExtend.get(arr));
                        }
                    }
                    iIndicatorExtendHelper.addnew(extend);
                    beCopyRecordInfo.put("extend", extend.getId().toString());
                    recCoreBase.add((CoreBaseInfo)beCopyRecordInfo);
                }
            }
            iUniteIndicator.addnew(coreBase);
            iUniteRecord.addnew(recCoreBase);
        }
        catch (Exception e) {
            logger.error("[perfweb_RuleHistoryUtils]:copy indicator error when refgroup!", (Throwable)e);
        }
    }

    private static void upDatebyIndecator(Context ctx, UniteIndicatorInfo beCopyIndicatorInfo) throws BOSException, EASBizException {
        String indecator = beCopyIndicatorInfo.getIndecator();
        if (indecator != null && indecator.length() > 0) {
            PerfIndecatorInfo perfIndecatorInfo = PerfIndecatorFactory.getLocalInstance(ctx).getPerfIndecatorInfo(" where id='" + indecator + "'");
            beCopyIndicatorInfo.setQualiOrRation(perfIndecatorInfo.getQualiOrRation());
            beCopyIndicatorInfo.setNumber(perfIndecatorInfo.getNumber());
            beCopyIndicatorInfo.setName(perfIndecatorInfo.getName());
            beCopyIndicatorInfo.setUnit(perfIndecatorInfo.getUnit());
            beCopyIndicatorInfo.setIndecatorDesc(perfIndecatorInfo.getIndecatorDesc());
            beCopyIndicatorInfo.setEvalStandard(perfIndecatorInfo.getEvalStandard());
            if (perfIndecatorInfo.getScoringFormula() != null) {
                beCopyIndicatorInfo.setScoringFormula(perfIndecatorInfo.getScoringFormula().getId().toString());
            }
        }
    }

    public static Map<String, String> getAreaIdSetByPeriod(Context ctx, String nowPeriod, String areaType) {
        return RuleHistoryUtils.getAreaIdSetByPeriod(ctx, nowPeriod, areaType, new HashSet<String>());
    }

    public static Map<String, String> getAreaIdSetByPeriod(Context ctx, String nowPeriod, String areaType, Set<String> hasQualiAreas) {
        HashMap<String, String> areaMap = new HashMap<String, String>();
        try {
            FilterInfo ruleFilter = new FilterInfo();
            ruleFilter.getFilterItems().add(new FilterItemInfo("id", (Object)nowPeriod));
            EntityViewInfo ruleEvi = new EntityViewInfo();
            SelectorItemCollection ruleSelector = ruleEvi.getSelector();
            ruleSelector.add("perfRule.id");
            ruleSelector.add("id");
            ruleEvi.setFilter(ruleFilter);
            IPerfPeriod period = PerfPeriodFactory.getLocalInstance(ctx);
            PerfPeriodCollection periodCol = period.getPerfPeriodCollection(ruleEvi);
            if (periodCol != null && periodCol.size() > 0) {
                String ruleId = periodCol.get(0).getPerfRule().getId().toString();
                FilterInfo areaFilter = new FilterInfo();
                areaFilter.getFilterItems().add(new FilterItemInfo("performanceRule", (Object)ruleId));
                areaFilter.getFilterItems().add(new FilterItemInfo("areaType", (Object)"100", CompareType.NOTEQUALS));
                if (!StringUtils.isEmpty((String)areaType)) {
                    areaFilter.getFilterItems().add(new FilterItemInfo("areaType", (Object)areaType));
                }
                EntityViewInfo areaEvi = new EntityViewInfo();
                SelectorItemCollection areaSelector = areaEvi.getSelector();
                areaSelector.add("id");
                areaSelector.add("relatedAreaId");
                areaEvi.setFilter(areaFilter);
                EvaluFormAreaBaseCollection areaColl = EvaluFormAreaBaseFactory.getLocalInstance(ctx).getEvaluFormAreaBaseCollection(areaEvi);
                HashSet<String> areaIds = new HashSet<String>();
                int size = areaColl.size();
                for (int i = 0; i < size; ++i) {
                    if (StringUtils.isEmpty((String)areaColl.get(i).getRelatedAreaId())) continue;
                    areaMap.put(areaColl.get(i).getRelatedAreaId(), areaColl.get(i).getId().toString());
                    areaIds.add(areaColl.get(i).getId().toString());
                }
                if (areaIds.size() > 0) {
                    FilterInfo fieldFilter = new FilterInfo();
                    fieldFilter.getFilterItems().add(new FilterItemInfo("areaBase", areaIds, CompareType.INCLUDE));
                    fieldFilter.getFilterItems().add(new FilterItemInfo("fieldTemplate", (Object)"UTzGVhUtlUWHcFWRvbY6spDpHWw=", CompareType.EQUALS));
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("areaBase"));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(fieldFilter);
                    evi.setSelector(selectors);
                    EvaFormFieldConfCollection colls = EvaFormFieldConfFactory.getLocalInstance(ctx).getEvaFormFieldConfCollection(evi);
                    if (colls != null && colls.isEmpty()) {
                        Iterator iterator = colls.iterator();
                        while (iterator.hasNext()) {
                            EvaFormFieldConfInfo formFieldConf = (EvaFormFieldConfInfo)iterator.next();
                            hasQualiAreas.add(formFieldConf.getAreaBase());
                        }
                    }
                }
            } else {
                logger.warn("[perfweb_RuleHistoryUtils]:group relate period have error!");
            }
        }
        catch (Exception e) {
            logger.error("[perfweb_RuleHistoryUtils]:getAreaIdSet have error,please check!", (Throwable)e);
        }
        return areaMap;
    }

    public static PWorkFlowDefCollection getDefaultWorkFlow(Context ctx, String perfRuleId) throws BOSException {
        return PWorkFlowDefFactory.getLocalInstance(ctx).getPWorkFlowDefCollection("where perfRule = '" + perfRuleId + "' and isDefault = 1 and wfStatus='" + "1" + "'");
    }

    private static HashSet<String> getAreaIdsByPeriod(Context ctx, String periodId) throws BOSException, SQLException {
        return RuleHistoryUtils.getAreaIdsByPeriod(ctx, periodId, null);
    }

    private static HashSet<String> getAreaIdsByPeriod(Context ctx, String periodId, String areaType) throws BOSException, SQLException {
        HashSet<String> areaIds = new HashSet<String>();
        StringBuilder sql = new StringBuilder(" select area.fid as areaId from T_EVA_PerfPeriod perfPeriod inner join T_EVA_EvaluFormAreaBase area ");
        sql.append(" on area.FPerformanceRuleID = perfPeriod.FPerfRuleID where perfPeriod.fid='").append(periodId).append("' ");
        if (!StringUtils.isEmpty((String)areaType)) {
            sql.append(" and area.FAreaType = '").append(areaType).append("' ");
        }
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (iRowSet.next()) {
            areaIds.add(iRowSet.getString("areaId"));
        }
        return areaIds;
    }

    public static HashMap<String, String> getFlowIdMap(Context ctx, String sourcePeriod, String thisPeriod) throws BOSException {
        HashMap<String, String> reMap = RuleHistoryUtils.getRefFlowIdMap(ctx, sourcePeriod, thisPeriod);
        HashMap<String, String> sourceFlowIdMap = RuleHistoryUtils.getRelateFlowIdMap(ctx, sourcePeriod);
        HashMap<String, String> thisFlowIdMap = RuleHistoryUtils.getRelateFlowIdMap(ctx, thisPeriod);
        if (sourceFlowIdMap != null && thisFlowIdMap != null) {
            for (String key : sourceFlowIdMap.keySet()) {
                reMap.put(sourceFlowIdMap.get(key), thisFlowIdMap.get(key));
            }
        }
        return reMap;
    }

    private static HashMap<String, String> getRelateFlowIdMap(Context ctx, String period) throws BOSException {
        if (StringUtils.isEmpty((String)period)) {
            return null;
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        try {
            PerfPeriodInfo periodInfo = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodInfo("select id,perfRule.id where id = '" + period + "'");
            PWorkFlowDefCollection workFlowColl = PWorkFlowDefFactory.getLocalInstance(ctx).getPWorkFlowDefCollection("select id,relatedFlowId where perfRule = '" + periodInfo.getPerfRule().getId().toString() + "'");
            if (workFlowColl != null && workFlowColl.size() > 0) {
                int size = workFlowColl.size();
                for (int i = 0; i < size; ++i) {
                    PWorkFlowDefInfo info = workFlowColl.get(i);
                    String relatedFlowId = info.getRelatedFlowId();
                    if (StringUtils.isEmpty((String)relatedFlowId)) continue;
                    reMap.put(relatedFlowId, info.getId().toString());
                }
            }
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return reMap;
    }

    public static String getFlowRoot(Context ctx, String workFlowId, HashSet<String> flowTempSet) throws BOSException, SQLException {
        String sql;
        IRowSet iRowSet;
        if (flowTempSet == null) {
            flowTempSet = new HashSet();
        }
        if ((iRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select workFlow.FRefFlowId as flowId,workFlow.fid as fid from  T_EVA_PWorkFlowDef workFlow  where workFlow.fid='" + workFlowId + "'"))).next()) {
            String refFlowId = iRowSet.getString("flowId");
            if (StringUtils.isEmpty((String)refFlowId)) {
                return iRowSet.getString("fid");
            }
            if (flowTempSet.contains(refFlowId)) {
                return iRowSet.getString("fid");
            }
            flowTempSet.add(refFlowId);
            return RuleHistoryUtils.getFlowRoot(ctx, refFlowId, flowTempSet);
        }
        return null;
    }

    public static boolean judgePeriodMap(Context ctx, String sourcePeriod, String thisPeriod) throws BOSException, SQLException {
        String sourcePeriodRootId = RuleHistoryUtils.getPeriodRoot(ctx, sourcePeriod, null);
        String thisPeriodRootId = RuleHistoryUtils.getPeriodRoot(ctx, thisPeriod, null);
        return sourcePeriodRootId != null && !StringUtils.isEmpty((String)sourcePeriodRootId) && sourcePeriodRootId.equals(thisPeriodRootId);
    }

    public static String getPeriodRoot(Context ctx, String periodId, Set<String> periodSet) throws BOSException, SQLException {
        String sql;
        IRowSet iRowSet;
        if (periodSet == null) {
            periodSet = new HashSet<String>();
        }
        if ((iRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select Fid,FRefPeriodID from  T_EVA_PerfPeriod   where fid='" + periodId + "'"))).next()) {
            String refPeriodID = iRowSet.getString("FRefPeriodID");
            if (StringUtils.isEmpty((String)refPeriodID)) {
                return iRowSet.getString("Fid");
            }
            if (periodSet.contains(refPeriodID)) {
                return iRowSet.getString("Fid");
            }
            periodSet.add(refPeriodID);
            return RuleHistoryUtils.getPeriodRoot(ctx, refPeriodID, periodSet);
        }
        return null;
    }

    public static HashMap<String, String> getRefAreaIdMap(Context ctx, String sourcePeriod, String thisPeriod, int reType, String areaType) throws BOSException {
        HashMap<String, String> reMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sourcePeriod) || StringUtils.isEmpty((String)thisPeriod)) {
            return reMap;
        }
        try {
            if (!RuleHistoryUtils.judgePeriodMap(ctx, sourcePeriod, thisPeriod)) {
                return reMap;
            }
            HashSet<String> tempAreaSet = new HashSet<String>();
            HashMap<String, String> sourAreaRootMap = RuleHistoryUtils.getAreaMapByPeriod(ctx, sourcePeriod, tempAreaSet, areaType);
            HashSet<String> thisTempAreaSet = new HashSet<String>();
            HashMap<String, String> thisAreaRootMap = RuleHistoryUtils.getAreaMapByPeriod(ctx, thisPeriod, thisTempAreaSet, areaType);
            for (Map.Entry<String, String> sourEntry : sourAreaRootMap.entrySet()) {
                String thisArea = thisAreaRootMap.get(sourEntry.getKey());
                if (2 == reType && !StringUtils.isEmpty((String)thisArea)) {
                    reMap.put(thisArea, sourEntry.getValue());
                    continue;
                }
                if (StringUtils.isEmpty((String)sourEntry.getValue())) continue;
                reMap.put(sourEntry.getValue(), thisArea);
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return reMap;
    }

    public static HashMap<String, String> getRefFlowIdMap(Context ctx, String sourcePeriod, String thisPeriod) throws BOSException {
        HashMap<String, String> reMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sourcePeriod) || StringUtils.isEmpty((String)thisPeriod)) {
            return reMap;
        }
        try {
            if (!RuleHistoryUtils.judgePeriodMap(ctx, sourcePeriod, thisPeriod)) {
                return reMap;
            }
            HashSet<String> tempAreaSet = new HashSet<String>();
            HashMap<String, String> sourFlowRootMap = RuleHistoryUtils.getFlowMapByPeriod(ctx, sourcePeriod, tempAreaSet);
            HashSet<String> thisTempAreaSet = new HashSet<String>();
            HashMap<String, String> thisFlowRootMap = RuleHistoryUtils.getFlowMapByPeriod(ctx, thisPeriod, thisTempAreaSet);
            for (Map.Entry<String, String> sourEntry : sourFlowRootMap.entrySet()) {
                String thisFlow = thisFlowRootMap.get(sourEntry.getKey());
                reMap.put(sourEntry.getValue(), thisFlow);
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return reMap;
    }

    public static HashMap<String, String> getAreaMap(Context ctx, String thisPeriod, String sourcePeriod) throws BOSException {
        return RuleHistoryUtils.getAreaMap(ctx, thisPeriod, sourcePeriod, null);
    }

    public static HashMap<String, String> getAreaMap(Context ctx, String thisPeriod, String sourcePeriod, String areaType) throws BOSException {
        return RuleHistoryUtils.getAreaMap(ctx, thisPeriod, sourcePeriod, areaType, 2);
    }

    public static HashMap<String, String> getAreaMap(Context ctx, String thisPeriod, String sourcePeriod, String areaType, int reType) throws BOSException {
        HashMap<String, String> reMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)thisPeriod) && thisPeriod.equals(sourcePeriod)) {
            HashSet<Object> areaSet = new HashSet();
            try {
                areaSet = RuleHistoryUtils.getAreaIdsByPeriod(ctx, thisPeriod, areaType);
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
            for (String string : areaSet) {
                reMap.put(string, string);
            }
            return reMap;
        }
        Map<String, String> nowAreaMap = RuleHistoryUtils.getAreaIdSetByPeriod(ctx, thisPeriod, areaType);
        Map<String, String> sourceAreaMap = RuleHistoryUtils.getAreaIdSetByPeriod(ctx, sourcePeriod, areaType);
        for (String nowTempKey : nowAreaMap.keySet()) {
            if (StringUtils.isEmpty((String)sourceAreaMap.get(nowTempKey))) continue;
            if (reType == 2) {
                reMap.put(nowAreaMap.get(nowTempKey), sourceAreaMap.get(nowTempKey));
                continue;
            }
            reMap.put(sourceAreaMap.get(nowTempKey), nowAreaMap.get(nowTempKey));
        }
        HashMap<String, String> hashMap = RuleHistoryUtils.getRefAreaIdMap(ctx, sourcePeriod, thisPeriod, reType, areaType);
        for (String refkey : hashMap.keySet()) {
            if (hashMap.get(refkey) == null) continue;
            reMap.put(refkey, hashMap.get(refkey));
        }
        return reMap;
    }

    public static String getAreaRoot(Context ctx, String areaId, HashSet<String> areaTempSet) throws BOSException, SQLException {
        String sql;
        IRowSet iRowSet;
        if (areaTempSet == null) {
            areaTempSet = new HashSet();
        }
        if ((iRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select area.FRefAreaId as refAreaId,area.fid as fid from  T_EVA_EvaluFormAreaBase area  where area.fid='" + areaId + "'"))).next()) {
            String refAreaId = iRowSet.getString("refAreaId");
            if (StringUtils.isEmpty((String)refAreaId)) {
                return iRowSet.getString("fid");
            }
            if (areaTempSet.contains(refAreaId)) {
                return iRowSet.getString("fid");
            }
            areaTempSet.add(refAreaId);
            return RuleHistoryUtils.getAreaRoot(ctx, refAreaId, areaTempSet);
        }
        return null;
    }

    private static HashMap<String, String> getAreaMapByPeriod(Context ctx, String periodId, HashSet<String> areaTempSet, String areaType) throws BOSException, SQLException {
        HashSet<String> areaIds = new HashSet<String>();
        StringBuilder sql = new StringBuilder(" select area.fid as areaId from T_EVA_PerfPeriod perfPeriod inner join T_EVA_EvaluFormAreaBase area ");
        sql.append(" on area.FPerformanceRuleID = perfPeriod.FPerfRuleID where perfPeriod.fid='").append(periodId).append("' ");
        if (!StringUtils.isEmpty((String)areaType)) {
            sql.append(" and area.FAreaType = '").append(areaType).append("' ");
        }
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (iRowSet.next()) {
            areaIds.add(iRowSet.getString("areaId"));
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        for (String areaId : areaIds) {
            String areaRoot = RuleHistoryUtils.getAreaRoot(ctx, areaId, areaTempSet);
            reMap.put(areaRoot, areaId);
        }
        return reMap;
    }

    private static HashMap<String, String> getFlowMapByPeriod(Context ctx, String periodId, HashSet<String> flowTempSet) throws BOSException, SQLException {
        HashSet<String> flowIds = new HashSet<String>();
        String sql = "select workFlow.fid as flowId from T_EVA_PerfPeriod perfPeriod inner join T_EVA_PWorkFlowDef workFlow on workFlow.FPerfRule = perfPeriod.FPerfRuleID where perfPeriod.fid='" + periodId + "'";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            flowIds.add(iRowSet.getString("flowId"));
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        for (String flowId : flowIds) {
            String flowRoot = RuleHistoryUtils.getFlowRoot(ctx, flowId, flowTempSet);
            reMap.put(flowRoot, flowId);
        }
        return reMap;
    }

    public static void copyMatrixWork(Context ctx, HashMap<String, String> evaObjMap, String sourcePeriod, String thisPeriod) throws BOSException, EASBizException {
        if (evaObjMap == null || CollectionUtils.isEmpty(evaObjMap.keySet())) {
            return;
        }
        IPerfEvaObjMatrixWorkFlowInst iMatrixWork = PerfEvaObjMatrixWorkFlowInstFactory.getLocalInstance(ctx);
        String sourceEvaObjstr = "('" + Strings.join(evaObjMap.keySet(), (String)"','") + "')";
        PerfEvaObjMatrixWorkFlowInstCollection matrixWorkColl = iMatrixWork.getPerfEvaObjMatrixWorkFlowInstCollection("where evaObj in " + sourceEvaObjstr);
        if (matrixWorkColl != null) {
            HashMap<String, String> flowIdMap = RuleHistoryUtils.getFlowIdMap(ctx, sourcePeriod, thisPeriod);
            HashMap<String, String> areaMap = RuleHistoryUtils.getAreaMap(ctx, thisPeriod, sourcePeriod, null, 1);
            CoreBaseCollection core = new CoreBaseCollection();
            int size = matrixWorkColl.size();
            for (int i = 0; i < size; ++i) {
                PerfEvaObjMatrixWorkFlowInstInfo info = matrixWorkColl.get(i);
                String thisFlow = flowIdMap.get(info.getWorkflow().getId().toString());
                String thisArea = areaMap.get(info.getAreaBase().getId().toString());
                if (StringUtils.isEmpty((String)thisFlow) || StringUtils.isEmpty((String)thisArea)) continue;
                info.put("workflow", thisFlow);
                info.put("areaBase", thisArea);
                info.put("evaObj", evaObjMap.get(info.getEvaObj().getId().toString()));
                info.setId(null);
                core.add((CoreBaseInfo)info);
            }
            iMatrixWork.save(core);
        }
    }
}

