/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.AESUtil;
import com.kingdee.shr.perfweb.utils.EmailConfigConst;
import com.kingdee.shr.perfweb.utils.EmailServiceForPerf;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendEmailUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.SendEmailUtils");

    public static EmailResult sendEmail(Context ctx, String receiverAddress, String title, String content) {
        Boolean isSupportSSL;
        String server;
        String from;
        String company;
        EmailResult result = new EmailResult();
        result.setSuccess(true);
        String pwd = null;
        boolean flag = false;
        try {
            PerfEmailConfigInfo perfEmailConfInfo = GetEntityInfoUtils.getAndUpdateCurrentUsePerfEmailConfigInfo(ctx);
            if (perfEmailConfInfo == null) {
                if (logger.isDebugEnabled()) {
                    logger.error("[PERFWEB]it is faild to get perfEmailConfInfo");
                }
                result.setSuccess(false);
                result.setErrorCode("60601");
                result.setErrorMsg(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEMAILSERVICECONFIGERR, ctx));
                return result;
            }
            if (!StringUtils.isEmpty((String)perfEmailConfInfo.getPassword())) {
                pwd = AESUtil.decryptToString(perfEmailConfInfo.getPassword(), EmailConfigConst.seccode);
            }
            company = perfEmailConfInfo.getCompany();
            from = perfEmailConfInfo.getAddress();
            server = perfEmailConfInfo.getEmailServer();
            isSupportSSL = perfEmailConfInfo.getIsSupportSSL().getValue().equals("1");
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-GETEMAILSERVICECONFIGERR\uff01", (Throwable)e);
            result.setSuccess(false);
            result.setErrorCode("60601");
            result.setErrorMsg(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEMAILSERVICECONFIGERR, ctx));
            return result;
        }
        try {
            try {
                flag = EmailServiceForPerf.doSendEmail(pwd, company, from, receiverAddress, server, isSupportSSL, title, content, null);
            }
            catch (Exception e) {
                logger.error("\u3010PERFWEB\u3011-SENDEMAILERRUSEPERFEMAILSERVICE\uff01", (Throwable)e);
            }
            if (!flag) {
                flag = EmailServiceForPerf.sendEmail(ctx, title, receiverAddress, null, null, content, null);
            }
            if (!flag) {
                result.setSuccess(false);
                result.setErrorCode("60602");
                result.setErrorMsg(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EMAILSENDERRASEMAILSERVICEINVALID, ctx));
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorCode("60603");
            result.setErrorMsg(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EMAILSENDERRASEMAILSERVICEINVALID, ctx));
        }
        return result;
    }

    public static class EmailResult {
        private boolean success;
        private String uuid;
        private String errorCode;
        private String errorMsg;

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}

