/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.formula.evaluator.aviator.function.person;

import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.formula.evaluator.FunTypeEnum;
import com.kingdee.shr.base.formula.evaluator.aviator.ShrAbstractFunction;
import java.util.Map;
import org.apache.log4j.Logger;

public class IsPersonRoleFunction
extends ShrAbstractFunction {
    private static Logger logger = Logger.getLogger(IsPersonRoleFunction.class);

    public String getName() {
        return "my.personisrole";
    }

    @Override
    public String getTitle() {
        return "\u5458\u5de5\u662f\u5426\u89d2\u8272";
    }

    @Override
    public String getParam() {
        return "roleNumber";
    }

    @Override
    public String getHideParam() {
        return "ctx, personId, ";
    }

    @Override
    public String getDescr() {
        return "\u5224\u65ad\u5458\u5de5\uff08\u975e\u767b\u5f55\u8005\uff09\u662f\u5426\u5c5e\u4e8e\u7f16\u7801\u4e3a\u53c2\u6570 roleNumber \u7684\u89d2\u8272\u6210\u5458\uff0c\u8fd4\u56de\u5e03\u5c14\u503c\uff0c\u793a\u4f8b\uff1a\u5458\u5de5\u662f\u5426\u89d2\u8272('0001')==\u662f";
    }

    @Override
    public FunTypeEnum getType() {
        return FunTypeEnum.PERSON;
    }

    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
        Context ctx = (Context)FunctionUtils.getJavaObject((AviatorObject)arg1, env);
        String personId = FunctionUtils.getStringValue((AviatorObject)arg2, env);
        String roleId = FunctionUtils.getStringValue((AviatorObject)arg3, env);
        try {
            UserCollection userColl = this.getUserCollectionByPersonId(ctx, personId);
            IUserRoleOrgManager userRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < userColl.size(); ++j) {
                RoleCollection roleCollection = userRoleOrgManager.getAllUserRole((IObjectPK)new ObjectUuidPK(userColl.get(j).getId()));
                for (int i = 0; i < roleCollection.size(); ++i) {
                    RoleInfo roleInfo = roleCollection.get(i);
                    if (!roleInfo.getNumber().equals(roleId)) continue;
                    return AviatorRuntimeJavaType.valueOf((Object)true);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return AviatorRuntimeJavaType.valueOf((Object)false);
    }

    private UserCollection getUserCollectionByPersonId(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        view.setFilter(filter);
        UserCollection coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
        return coll;
    }
}

