/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.api.auth;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.util.HrPermissionTools;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.cache.ShrPermissionCacheHelper;
import com.kingdee.shr.base.permission.helper.DataOperateHelper;
import com.kingdee.shr.base.permission.helper.SHRMenuServiceHelper;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import com.kingdee.shr.base.permission.util.Assert;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SHRUserOrgPermissionApi {
    private static Logger logger = Logger.getLogger(SHRUserOrgPermissionApi.class);
    private static final int FILTER_ID_LIMIT = 50;

    public static String getUserAdminRangeSQL(Context ctx, String userId, String permItemId) {
        Assert.validateUserIdNotNull(userId, ctx);
        Assert.validatePermItemIdNotNull(permItemId, ctx);
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        return SHRPermissionSQL.getUserAdminOrgRangeSQL(ctx, userId, permItemId);
    }

    public static void addUserAdminRangeFilter(Context ctx, String userId, String permItemId, FilterInfo filter, String ou) {
        if (null == ctx || null == filter || StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)permItemId) || StringUtils.isEmpty((String)ou)) {
            return;
        }
        Set<String> ouSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        if (null != ouSet && ouSet.size() <= 50) {
            filter.getFilterItems().add(new FilterItemInfo(ou, ouSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(ou, (Object)SHRUserOrgPermissionApi.getUserAdminRangeSQL(ctx, userId, permItemId), CompareType.INNER));
        }
    }

    public static FilterInfo getAdminOrgRangeFilter(Context ctx, String userId, String permItemId, String ou) {
        if (null == ctx || StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)permItemId) || StringUtils.isEmpty((String)ou)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        Set<String> ouSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        if (null != ouSet && ouSet.size() <= 50) {
            filter.getFilterItems().add(new FilterItemInfo(ou, ouSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(ou, (Object)SHRUserOrgPermissionApi.getUserAdminRangeSQL(ctx, userId, permItemId), CompareType.INNER));
        }
        return filter;
    }

    public static Set<String> getUserAdminRangeIdSet(Context ctx, String userId, String permItemId) {
        Assert.validateUserIdNotNull(userId, ctx);
        Assert.validatePermItemIdNotNull(permItemId, ctx);
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        Set idSet = (Set)ShrPermissionCacheHelper.getPermCacheValue(0, userId, permItemId);
        if (idSet == null || idSet.size() == 0) {
            try {
                idSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSetFromDB(ctx, userId, permItemId);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ShrPermissionCacheHelper.putPermCacheValue(0, userId, permItemId, idSet);
        }
        if (idSet == null || idSet.size() == 0) {
            try {
                idSet = HrPermissionTools.getUserAdminOrgRange((Context)ctx, (String)userId);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return idSet;
    }

    public static String getUserHROrgRangeInSQL(Context ctx, String userId, String permItemId) {
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        Set<String> idSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemId);
        return DataValueTranslatorUtil.hashSet2String(idSet);
    }

    public static String getUserHROrgRangeInSQLWithBracket(Context ctx, String userId, String permItemId) {
        return "(" + SHRUserOrgPermissionApi.getUserHROrgRangeInSQL(ctx, userId, permItemId) + ")";
    }

    public static Set<String> getUserHROrgRangeIdSet(Context ctx, String userId, String permItemId) {
        Assert.validateUserIdNotNull(userId, ctx);
        Assert.validatePermItemIdNotNull(permItemId, ctx);
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        Set idSet = new HashSet();
        try {
            idSet = HrPermissionTools.getAuthorizedHrOrgByUserWithPerm((Context)ctx, (String)userId, (String)permItemId);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            idSet = new HashSet();
        }
        return idSet;
    }

    public static Set<String> getUserAdminRangeIdSetFromDB(Context ctx, String userId, String permItemId) throws BOSException {
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        return DataOperateHelper.getAssembleAssignedPermItemAdminOrgIdSet(ctx, userId, permItemId);
    }

    public static String getUserAllHrAndAdminRangeSql(Context ctx, String userId, String permItemId) {
        Assert.validateUserIdNotNull(userId, ctx);
        Assert.validatePermItemIdNotNull(permItemId, ctx);
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        return SHRPermissionSQL.getUserAllHrAdnAdminRangeSQL(userId, permItemId);
    }

    public static PermItemInfo getPermItemInfoByServiceID(String serviceId) {
        return SHRUserOrgPermissionApi.getPermItemInfoByServiceID(null, serviceId);
    }

    public static PermItemInfo getPermItemInfoByServiceID(Context ctx, String serviceId) {
        return SHRMenuServiceHelper.getPermItemInfoByServiceId(ctx, serviceId);
    }

    public static String getPermItemIDByServiceID(String serviceId) {
        return SHRUserOrgPermissionApi.getPermItemIDByServiceID(null, serviceId);
    }

    public static String getPermItemIDByServiceID(Context ctx, String serviceId) {
        PermItemInfo permItemInfo = SHRUserOrgPermissionApi.getPermItemInfoByServiceID(ctx, serviceId);
        return permItemInfo != null && permItemInfo.getId() != null ? permItemInfo.getId().toString() : "";
    }

    public static boolean containsAdminOrgRange(Context ctx, String userId, String permItemId, String adminOrgId) {
        Set<String> adminOrgIdSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet(ctx, userId, permItemId);
        return null != adminOrgIdSet && adminOrgIdSet.contains(adminOrgId);
    }

    public static boolean containsHROrgRange(Context ctx, String userId, String permItemId, String hrOrgId) {
        Set<String> hrOrgIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemId);
        return null != hrOrgIdSet && hrOrgIdSet.contains(hrOrgId);
    }

    public static void checkPermItemIdSecurityVerification(String permItemId) {
        SHRUserOrgPermissionApi.doCheckIdSecurityVerification(permItemId);
    }

    public static void doCheckIdSecurityVerification(String id) {
        BOSUuid.read((String)id);
    }

    public static String getUserHeadOfDepartmentAdminRangeSQL(Context ctx, String userId, String permItemId) {
        Assert.validateUserIdNotNull(userId, ctx);
        Assert.validatePermItemIdNotNull(permItemId, ctx);
        SHRUserOrgPermissionApi.checkPermItemIdSecurityVerification(permItemId);
        return SHRPermissionSQL.getUserHeadOfDepartmentAdminOrgRangeSQL(ctx, userId, permItemId);
    }

    public static Set<String> getUserHeadOfDepartmentAdminRangeSet(Context ctx, String userId, String permItemId) {
        String sql = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL(ctx, userId, permItemId);
        HashSet<String> idSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                idSet.add(rs.getString("FAdminOrgID"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }
}

