/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ExpFilterConfigInfo;
import com.kingdee.shr.base.permission.ExpFilterRoleFactory;
import com.kingdee.shr.base.permission.ExpFilterRoleInfo;
import com.kingdee.shr.base.permission.ExpFilterUserFactory;
import com.kingdee.shr.base.permission.ExpFilterUserInfo;
import com.kingdee.shr.base.permission.IExpFilterRole;
import com.kingdee.shr.base.permission.IExpFilterUser;
import com.kingdee.shr.base.permission.app.AbstractExpFilterFacadeControllerBean;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ExpFilterFacadeControllerBean
extends AbstractExpFilterFacadeControllerBean {
    private static final int COUNT = 500;

    @Override
    protected void _distributeExpFilter2User(Context ctx, String[] expFilterIds, String[] userIds) throws BOSException, EASBizException {
        if (null == expFilterIds || null == userIds) {
            return;
        }
        if (expFilterIds.length * userIds.length > 500) {
            this._distributeExpFilter2UserByTempTable(ctx, expFilterIds, userIds);
        } else {
            this._distributeExpFilter2UserByExists(ctx, expFilterIds, userIds);
        }
    }

    private void _distributeExpFilter2UserByTempTable(Context ctx, String[] expFilterIds, String[] userIds) throws BOSException {
        String tempTableName = null;
        try {
            List params = this.createParams(expFilterIds, userIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FUserID VARCHAR(44),FExpFilterId VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FUserID,FExpFilterId) values(?,?)"), (List)params);
            StringBuffer insertSql = new StringBuffer(200);
            insertSql.append("INSERT INTO T_HR_ExpFilterUser (FID,FUserID,FExpFilterId,FCreateTime,FLastUpdateTime,FCreatorID,FLastUpdateUserID,FControlUnitID)").append(" SELECT newbosid('DA680912'),FUserID,FExpFilterId,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_HR_ExpFilterUser t2 where t1.FUserID = t2.FUserID and t1.FExpFilterId = t2.FExpFilterId)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void _distributeExpFilter2UserByExists(Context ctx, String[] expFilterIds, String[] userIds) throws BOSException, EASBizException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection expFilterUserCollection = new CoreBaseCollection();
        IExpFilterUser iExpFilterUser = ExpFilterUserFactory.getLocalInstance(ctx);
        for (int i = 0; i < expFilterIds.length; ++i) {
            String expFilterId = expFilterIds[i];
            ExpFilterConfigInfo expFilterConfigInfo = new ExpFilterConfigInfo();
            expFilterConfigInfo.setId(BOSUuid.read((String)expFilterId));
            for (int j = 0; j < userIds.length; ++j) {
                String userId = userIds[j];
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userId));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("expFilterId", (Object)expFilterId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId, CompareType.EQUALS));
                if (iExpFilterUser.exists(filterInfo)) continue;
                ExpFilterUserInfo expFilterUserInfo = new ExpFilterUserInfo();
                expFilterUserInfo.setExpFilterId(expFilterConfigInfo);
                expFilterUserInfo.setUserId(userInfo);
                expFilterUserInfo.setCreateTime(timestamp);
                expFilterUserInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                expFilterUserInfo.setLastUpdateTime(timestamp);
                expFilterUserInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                expFilterUserInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
                expFilterUserCollection.add((CoreBaseInfo)expFilterUserInfo);
            }
        }
        ExpFilterUserFactory.getLocalInstance(ctx).saveBatchData(expFilterUserCollection);
    }

    @Override
    protected void _distributeExpFilter2Role(Context ctx, String[] expFilterIds, String[] roleIds) throws BOSException, EASBizException {
        if (null == expFilterIds || null == roleIds) {
            return;
        }
        if (expFilterIds.length * roleIds.length > 500) {
            this._distributeExpFilter2RoleByTempTable(ctx, expFilterIds, roleIds);
        } else {
            this._distributeExpFilter2RoleByExists(ctx, expFilterIds, roleIds);
        }
    }

    private void _distributeExpFilter2RoleByTempTable(Context ctx, String[] expFilterIds, String[] roleIds) throws BOSException {
        String tempTableName = null;
        try {
            List params = this.createParams(expFilterIds, roleIds);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String createTableSql = "Create Table " + tempTableName + " (FRoleID VARCHAR(44),FExpFilterId VARCHAR(44))";
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            DbUtil.executeBatch((Context)ctx, (String)("insert into " + tempTableName + "(FRoleID,FExpFilterId) values(?,?)"), (List)params);
            StringBuffer insertSql = new StringBuffer(200);
            insertSql.append("INSERT INTO T_HR_ExpFilterRole (FID,FRoleID,FExpFilterId,FCreateTime,FLastUpdateTime,FCreatorID,FLastUpdateUserID,FControlUnitID)").append(" SELECT newbosid('DA669DBD'),FRoleID,FExpFilterId,now(),now()").append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("','").append(HRFilterUtils.getCurrentCU((Context)ctx).getId().toString()).append("' FROM ").append(tempTableName).append(" t1 where not exists (select 1 from T_HR_ExpFilterRole t2 where t1.FRoleID = t2.FRoleID and t1.FExpFilterId = t2.FExpFilterId)");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                tempTableName = null;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (!StringUtils.isEmpty(tempTableName)) {
                this.dropTable(ctx, tempTableName);
            }
        }
    }

    private void _distributeExpFilter2RoleByExists(Context ctx, String[] expFilterIds, String[] roleIds) throws BOSException, EASBizException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection expFilterRoleCollection = new CoreBaseCollection();
        IExpFilterRole iExpFilterRole = ExpFilterRoleFactory.getLocalInstance(ctx);
        for (int i = 0; i < expFilterIds.length; ++i) {
            String expFilterId = expFilterIds[i];
            ExpFilterConfigInfo expFilterConfigInfo = new ExpFilterConfigInfo();
            expFilterConfigInfo.setId(BOSUuid.read((String)expFilterId));
            for (int j = 0; j < roleIds.length; ++j) {
                String roleId = roleIds[j];
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)roleId));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("expFilterId", (Object)expFilterId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("roleId", (Object)roleId, CompareType.EQUALS));
                if (iExpFilterRole.exists(filterInfo)) continue;
                ExpFilterRoleInfo expFilterRoleInfo = new ExpFilterRoleInfo();
                expFilterRoleInfo.setExpFilterId(expFilterConfigInfo);
                expFilterRoleInfo.setRoleId(roleInfo);
                expFilterRoleInfo.setCreateTime(timestamp);
                expFilterRoleInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                expFilterRoleInfo.setLastUpdateTime(timestamp);
                expFilterRoleInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                expFilterRoleInfo.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
                expFilterRoleCollection.add((CoreBaseInfo)expFilterRoleInfo);
            }
        }
        ExpFilterRoleFactory.getLocalInstance(ctx).saveBatchData(expFilterRoleCollection);
    }

    private List createParams(String[] expFilterIds, String[] ids) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < expFilterIds.length; ++i) {
            for (int j = 0; j < ids.length; ++j) {
                Object[] objArr = new Object[]{ids[j], expFilterIds[i]};
                params.add(objArr);
            }
        }
        return params;
    }

    @Override
    protected void _unDistributeExpFilter2User(Context ctx, String[] billIds) throws BOSException, EASBizException {
        IObjectPK[] objectPKArr = this.getIObjectPkArr(billIds);
        ExpFilterUserFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
    }

    @Override
    protected void _unDistributeExpFilter2Role(Context ctx, String[] billIds) throws BOSException, EASBizException {
        IObjectPK[] objectPKArr = this.getIObjectPkArr(billIds);
        ExpFilterRoleFactory.getLocalInstance(ctx).deleteBatchData(objectPKArr);
    }

    private IObjectPK[] getIObjectPkArr(String[] billIds) {
        IObjectPK[] objectPKArr = new IObjectPK[billIds.length];
        for (int i = 0; i < billIds.length; ++i) {
            objectPKArr[i] = new ObjectUuidPK(BOSUuid.read((String)billIds[i]));
        }
        return objectPKArr;
    }

    private void dropTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            DbUtil.execute((Context)ctx, (String)("TRUNCATE TABLE " + tempTableName));
            DbUtil.execute((Context)ctx, (String)("DROP TABLE " + tempTableName));
        }
    }
}

