/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.IPRuleConfigUiviewExt;
import com.kingdee.shr.base.permission.IPermissionRuleConfig;
import com.kingdee.shr.base.permission.PRuleConfigUiviewCollection;
import com.kingdee.shr.base.permission.PRuleConfigUiviewExtCollection;
import com.kingdee.shr.base.permission.PRuleConfigUiviewExtFactory;
import com.kingdee.shr.base.permission.PRuleConfigUiviewExtInfo;
import com.kingdee.shr.base.permission.PRuleConfigUiviewInfo;
import com.kingdee.shr.base.permission.PermissionRuleConfigFactory;
import com.kingdee.shr.base.permission.PermissionRuleConfigInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.app.AbstractPRuleConfigUiviewControllerBean;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PRuleConfigUiviewControllerBean
extends AbstractPRuleConfigUiviewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.permission.app.PRuleConfigUiviewControllerBean");

    @Override
    protected IObjectPK _extendSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo info = (PRuleConfigUiviewInfo)model;
        return this.doSaveReal(ctx, info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IObjectPK doSaveReal(Context ctx, PRuleConfigUiviewInfo info) throws EASBizException, BOSException {
        if (null == info.getUiview() || null == info.getUiview().getId()) {
            throw new ShrPermissionException(ShrPermissionException.UIVIEW_NOT_ALLOW_NULL);
        }
        boolean isProductionMode = (Boolean)info.get("productionMode");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)info.getUiview().getId().toString()));
        if (StringUtils.isEmpty((String)info.getShruicode())) {
            filter.getFilterItems().add(new FilterItemInfo("shruicode", null));
            info.setShruicode(null);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("shruicode", (Object)info.getShruicode()));
        }
        if (null != info.getId()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new ShrPermissionException(ShrPermissionException.UIVIEWANDSHRUICODE_NOT_ALLOW_DUMP);
        }
        boolean isExtend = false;
        boolean isSaveHeader = false;
        PermissionRuleConfigInfo permissionRuleConfigInfo = null;
        PRuleConfigUiviewInfo oldModel = null;
        String config = null;
        ObjectUuidPK pk = null;
        if (isProductionMode) {
            isExtend = true;
            permissionRuleConfigInfo = info.getPRuleExt();
            config = info.getConfigExt();
            if (null == info.getId()) {
                isSaveHeader = true;
                info.setPRule(null);
                info.setConfig(null);
            } else {
                pk = new ObjectUuidPK(info.getId());
                oldModel = this.getPRuleConfigUiviewInfo(ctx, (IObjectPK)pk);
                if (StringUtils.isEmpty((String)info.getShruicode())) {
                    oldModel.setShruicode(null);
                } else {
                    oldModel.setShruicode(info.getShruicode());
                }
            }
        } else {
            if (null != info.getId()) {
                info.setId(info.getId());
                pk = new ObjectUuidPK(info.getId());
            }
            info.setConfigExt(null);
            info.setPRuleExt(null);
            permissionRuleConfigInfo = info.getPRule();
            config = info.getConfig();
            isSaveHeader = true;
        }
        PermissionRuleConfigInfo prc = null;
        ObjectUuidPK ruleConfigPK = null;
        IPermissionRuleConfig iPermissionRuleConfig = PermissionRuleConfigFactory.getLocalInstance(ctx);
        if (null == permissionRuleConfigInfo || null == permissionRuleConfigInfo.getId()) {
            if (!isExtend) throw new ShrPermissionException(ShrPermissionException.PERMISSION_RULE_NOT_NULL);
            if (null == info.getPRule() || null == info.getPRule().getId()) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_RULE_NOT_NULL);
            }
            ruleConfigPK = new ObjectUuidPK(info.getPRule().getId());
            if (!iPermissionRuleConfig.exists((IObjectPK)ruleConfigPK)) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_RULE_NOT_EXISTS);
            }
            prc = iPermissionRuleConfig.getPermissionRuleConfigInfo((IObjectPK)ruleConfigPK);
        } else {
            ruleConfigPK = new ObjectUuidPK(permissionRuleConfigInfo.getId());
            if (!iPermissionRuleConfig.exists((IObjectPK)ruleConfigPK)) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_RULE_NOT_EXISTS);
            }
            prc = iPermissionRuleConfig.getPermissionRuleConfigInfo((IObjectPK)ruleConfigPK);
        }
        String validateConfig = config;
        if (!StringUtils.isEmpty((String)prc.getProKeys()) && StringUtils.isEmpty((String)config)) {
            if (!isExtend) throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIG_NOT_NULL);
            if (StringUtils.isEmpty((String)info.getConfig())) {
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIGEXT_NOT_NULL);
            }
            validateConfig = info.getConfig();
        }
        if (!StringUtils.isEmpty((String)prc.getProKeys()) && !StringUtils.isEmpty((String)validateConfig)) {
            HashMap config0 = null;
            try {
                config0 = JSONUtils.convertJsonToObject((Context)ctx, (String)validateConfig);
            }
            catch (Exception e) {
                throw new ShrPermissionException(ShrPermissionException.CONFIG_MUST_JSON);
            }
            if (null == config0) {
                if (!isExtend) throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIG_NOT_NULL);
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIGEXT_NOT_NULL);
            }
            String[] keys = prc.getProKeys().split(",");
            StringBuffer s = new StringBuffer();
            for (String key : keys) {
                if (!config0.containsKey(key)) continue;
                if (StringUtils.isEmpty((String)s.toString())) {
                    s.append(",");
                }
                s.append(key);
            }
            if (StringUtils.isEmpty((String)s.toString())) {
                if (!isExtend) throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIG_MISSING, new Object[]{s.toString()});
                throw new ShrPermissionException(ShrPermissionException.PERMISSION_FIELD_CONFIGEXT_MISSING, new Object[]{s.toString()});
            }
        }
        if (StringUtils.isEmpty((String)info.getShruicode())) {
            info.setShruicode(null);
        }
        if (null != oldModel) {
            super._save(ctx, (IObjectValue)oldModel);
        }
        if (isSaveHeader) {
            pk = super._save(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        if (!isExtend) return pk;
        this.saveExtend(ctx, info, permissionRuleConfigInfo, config);
        return pk;
    }

    private void saveExtend(Context ctx, PRuleConfigUiviewInfo pModel, PermissionRuleConfigInfo permissionRuleConfigInfo, String config) throws BOSException, EASBizException {
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pModel.getId().toString()));
        PRuleConfigUiviewExtInfo model = null;
        if (iPRuleConfigUiviewExt.exists(filter)) {
            model = iPRuleConfigUiviewExt.getPRuleConfigUiviewExtInfo("where parent.id='" + pModel.getId().toString() + "'");
        } else {
            model = new PRuleConfigUiviewExtInfo();
            model.setParent(pModel);
        }
        model.setPRule(permissionRuleConfigInfo);
        model.setConfig(config);
        iPRuleConfigUiviewExt.save((CoreBaseInfo)model);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("uiview.id"));
        selector.add(new SelectorItemInfo("uiview.uipk"));
        selector.add(new SelectorItemInfo("shruicode"));
        selector.add(new SelectorItemInfo("config"));
        selector.addObjectCollection((IObjectCollection)this.getRuleConfigSelector());
        return selector;
    }

    private SelectorItemCollection getRuleConfigSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("pRule.id"));
        selector.add(new SelectorItemInfo("pRule.number"));
        selector.add(new SelectorItemInfo("pRule.name"));
        selector.add(new SelectorItemInfo("pRule.config"));
        selector.add(new SelectorItemInfo("pRule.isPreset"));
        selector.add(new SelectorItemInfo("pRule.checker"));
        selector.add(new SelectorItemInfo("pRule.proKeys"));
        return selector;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo model = (PRuleConfigUiviewInfo)super._getValue(ctx, pk);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iPRuleConfigUiviewExt, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo model = (PRuleConfigUiviewInfo)super._getValue(ctx, pk, selector);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iPRuleConfigUiviewExt, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo model = (PRuleConfigUiviewInfo)super._getValue(ctx, pk, selector, sorter);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iPRuleConfigUiviewExt, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo model = (PRuleConfigUiviewInfo)super._getValue(ctx, pk, sorter);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iPRuleConfigUiviewExt, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        PRuleConfigUiviewInfo model = (PRuleConfigUiviewInfo)super._getValue(ctx, oql);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iPRuleConfigUiviewExt, model);
        return model;
    }

    @Override
    protected IObjectValue _getValueByUIViewIdAndShruicode(Context ctx, String uiViewId, String shruicode) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(this.getSelector());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)uiViewId));
        filterInfo.getFilterItems().add(new FilterItemInfo("shruicode", (Object)shruicode));
        entityViewInfo.setFilter(filterInfo);
        PRuleConfigUiviewCollection coll = this.getPRuleConfigUiviewCollection(ctx, entityViewInfo);
        IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
        if (coll != null && coll.size() > 0) {
            if (coll.size() > 1) {
                logger.error((Object)("PRuleConfigUiview has more than 1, filter: " + filterInfo));
            }
            return this.mergeExtInfo(iPRuleConfigUiviewExt, coll.get(0));
        }
        return null;
    }

    private IObjectValue mergeExtInfo(IPRuleConfigUiviewExt iPRuleConfigUiviewExt, PRuleConfigUiviewInfo pRuleConfigUiviewInfo) throws BOSException {
        if (null == pRuleConfigUiviewInfo) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pRuleConfigUiviewInfo.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getRuleConfigSelector());
        viewInfo.getSelector().add(new SelectorItemInfo("config"));
        PRuleConfigUiviewExtCollection coll = iPRuleConfigUiviewExt.getPRuleConfigUiviewExtCollection(viewInfo);
        if (null != coll && coll.size() > 0) {
            PRuleConfigUiviewExtInfo info = coll.get(0);
            pRuleConfigUiviewInfo.setConfigExt(info.getConfig());
            pRuleConfigUiviewInfo.setPRuleExt(info.getPRule());
        }
        return null;
    }

    @Override
    public PRuleConfigUiviewCollection getPRuleConfigUiviewCollection(Context ctx, EntityViewInfo view) throws BOSException {
        PRuleConfigUiviewCollection coll = super.getPRuleConfigUiviewCollection(ctx, view);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public PRuleConfigUiviewCollection getPRuleConfigUiviewCollection(Context ctx) throws BOSException {
        PRuleConfigUiviewCollection coll = super.getPRuleConfigUiviewCollection(ctx);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public PRuleConfigUiviewCollection getPRuleConfigUiviewCollection(Context ctx, String oql) throws BOSException {
        PRuleConfigUiviewCollection coll = super.getPRuleConfigUiviewCollection(ctx, oql);
        return this.doGetCollection(ctx, coll);
    }

    private PRuleConfigUiviewCollection doGetCollection(Context ctx, PRuleConfigUiviewCollection coll) throws BOSException {
        if (coll != null && coll.size() > 0) {
            IPRuleConfigUiviewExt iPRuleConfigUiviewExt = PRuleConfigUiviewExtFactory.getLocalInstance(ctx);
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                PRuleConfigUiviewInfo info = coll.get(i);
                this.mergeExtInfo(iPRuleConfigUiviewExt, info);
            }
        }
        return coll;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }
}

