/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.field.list;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.formula.evaluator.FormulaExpressInfo;
import com.kingdee.shr.base.formula.util.FormulapUtil;
import com.kingdee.shr.base.permission.FieldPermConfigEntryInfo;
import com.kingdee.shr.base.permission.FieldPermConfigInfo;
import com.kingdee.shr.base.permission.field.EntityFieldInfo;
import com.kingdee.shr.base.permission.field.QueryType;
import com.kingdee.shr.base.permission.field.ShrFieldPerm;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ShrFieldPermList
extends ShrFieldPerm {
    protected Set<String> noPermColumnSet = new HashSet<String>();
    protected Set<String> noPermAllAndPartColumnSet = new HashSet<String>();
    private QueryType queryType;
    protected Map<String, String> modelMap = new HashMap<String, String>();
    private Map<String, Map<Map, Boolean>> expValueMap = new HashMap<String, Map<Map, Boolean>>();

    public ShrFieldPermList(Context ctx, QueryType queryType) {
        super(ctx);
        this.queryType = queryType;
    }

    public List filterData(List rows) throws EASBizException, BOSException {
        if (null != rows && rows.size() > 0) {
            if (this.isHasFieldPermByCurrentUser()) {
                if (this.limitFields.size() == 0) {
                    this.addNeedSelect(this.queryType);
                } else if (rows.size() > 20) {
                    String personId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
                    FormulapUtil.getPersonEmpMethodCallResult("initDataByPersonId", this.ctx, personId);
                }
                List rowsCopy = this.deepClone(rows);
                for (EntityFieldInfo entityFieldInfo : this.limitFields) {
                    String modelShortNumber = entityFieldInfo.getPrefixOldColumnName();
                    for (int j = 0; j < this.fieldPermConfigCollection.size(); ++j) {
                        FieldPermConfigInfo fieldPermConfigInfo = this.fieldPermConfigCollection.get(j);
                        for (int m = 0; m < fieldPermConfigInfo.getEntrys().size(); ++m) {
                            FieldPermConfigEntryInfo fieldPermConfigEntryInfo = fieldPermConfigInfo.getEntrys().get(m);
                            if (StringUtils.isEmpty((String)entityFieldInfo.getEntity()) || StringUtils.isEmpty((String)entityFieldInfo.getField()) || !entityFieldInfo.getEntity().equalsIgnoreCase(fieldPermConfigInfo.getModel()) || !entityFieldInfo.getField().equalsIgnoreCase(fieldPermConfigEntryInfo.getFieldFlag())) continue;
                            if (!StringUtils.isEmpty((String)fieldPermConfigEntryInfo.getCondition())) {
                                FormulaExpressInfo formulaExpressInfo = (FormulaExpressInfo)JSONUtils.convertJsonToObject((Context)this.ctx, (String)fieldPermConfigEntryInfo.getCondition(), FormulaExpressInfo.class);
                                for (int n = 0; n < rows.size(); ++n) {
                                    Map map = (Map)rows.get(n);
                                    Map mapCopy = (Map)rowsCopy.get(n);
                                    if (null == map.get(entityFieldInfo.getOldColumnName())) continue;
                                    HashMap<String, Object> formulaDataMap = new HashMap<String, Object>();
                                    for (String paramField : formulaExpressInfo.getParam()) {
                                        if (!this.setFormulaDataMap(formulaDataMap, paramField, mapCopy)) continue;
                                        if (null != modelShortNumber) {
                                            String fieldKey = MessageFormat.format("{0}.{1}", modelShortNumber, paramField);
                                            Object rowFieldValue = null != mapCopy.get(fieldKey) ? mapCopy.get(fieldKey) : mapCopy.get(fieldKey.toLowerCase());
                                            formulaDataMap.put(paramField, rowFieldValue);
                                            continue;
                                        }
                                        Object rowFieldValue = null != mapCopy.get(paramField) ? mapCopy.get(paramField) : mapCopy.get(paramField.toLowerCase());
                                        formulaDataMap.put(paramField, rowFieldValue);
                                    }
                                    boolean formulaResult = this.getExpressionResult(fieldPermConfigEntryInfo.getId().toString(), formulaExpressInfo.getFormula(), formulaDataMap);
                                    if ((formulaResult || !fieldPermConfigEntryInfo.isHasShow()) && (!formulaResult || fieldPermConfigEntryInfo.isHasShow()) || null == map.get(entityFieldInfo.getOldColumnName())) continue;
                                    this.setMapValNoPerm(map, entityFieldInfo.getOldColumnName());
                                }
                                this.noPermAllAndPartColumnSet.add(entityFieldInfo.getOldColumnName());
                                continue;
                            }
                            if (fieldPermConfigEntryInfo.isHasShow()) continue;
                            this.noPermColumnSet.add(entityFieldInfo.getOldColumnName());
                            this.noPermAllAndPartColumnSet.add(entityFieldInfo.getOldColumnName());
                            for (int n = 0; n < rows.size(); ++n) {
                                ((Map)rows.get(n)).remove(entityFieldInfo.getOldColumnName());
                            }
                        }
                    }
                }
            }
            for (String addField : this.newAddFields) {
                for (int n = 0; n < rows.size(); ++n) {
                    ((Map)rows.get(n)).remove(addField);
                }
            }
        }
        return rows;
    }

    protected void setMapValNoPerm(Map map, String key) {
        Object objVal = map.get(key);
        if (null != objVal) {
            Set<String> noPermFieldSet;
            if (objVal instanceof String && objVal.toString().length() == 0) {
                return;
            }
            map.put(key, "***");
            if (null != map.get("_noPermFields")) {
                noPermFieldSet = (Set)map.get("_noPermFields");
                noPermFieldSet.add(key);
            } else {
                noPermFieldSet = new HashSet();
                noPermFieldSet.add(key);
            }
            map.put("_noPermFields", noPermFieldSet);
        }
    }

    protected <T> List<T> deepClone(List<T> scr) throws BOSException {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(scr);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            List dest = (List)in.readObject();
            return dest;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean setFormulaDataMap(Map<String, Object> formulaDataMap, String paramField, Map<String, Object> mapCopy) {
        if (paramField.equals("ctx")) {
            formulaDataMap.put("ctx", this.ctx);
        } else if (paramField.equals("personId")) {
            String personId = null;
            if (null != mapCopy.get("person.id")) {
                personId = mapCopy.get("person.id").toString();
            } else if (null != this.personIdEntity) {
                personId = mapCopy.get(this.personIdEntity.getOldColumnName()).toString();
            }
            formulaDataMap.put("personId", personId);
        } else {
            return true;
        }
        return false;
    }

    protected boolean getExpressionResult(String infoId, String formula, Map<String, Object> formulaDataMap) throws BOSException {
        if (this.expValueMap.containsKey(infoId)) {
            Map<Map, Boolean> map = this.expValueMap.get(infoId);
            if (map.containsKey(formulaDataMap)) {
                return map.get(formulaDataMap);
            }
            boolean result = (Boolean)this.getExpressionFromMap(infoId, formula).execute(formulaDataMap);
            map.put(formulaDataMap, result);
            return result;
        }
        boolean result = (Boolean)this.getExpressionFromMap(infoId, formula).execute(formulaDataMap);
        HashMap<Map<String, Object>, Boolean> map = new HashMap<Map<String, Object>, Boolean>();
        map.put(formulaDataMap, result);
        this.expValueMap.put(infoId, map);
        return result;
    }
}

