/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public abstract class DataOperateHelper {
    public static Logger logger = Logger.getLogger(DataOperateHelper.class);

    public static Map getUserInfo(Context ctx, String userId) {
        String sql = SHRPermissionSQL.assembleUserBaseInfoSQL(ctx);
        Object[] params = new Object[]{userId};
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rowSet.next()) {
                map.put("userName", rowSet.getString("userName"));
                map.put("userNumber", rowSet.getString("userNumber"));
                map.put("personName", rowSet.getString("personName"));
                map.put("adminOrgName", rowSet.getString("adminOrgName"));
                map.put("adminOrgLongName", rowSet.getString("adminOrgLongName"));
                map.put("postionName", rowSet.getString("postionName"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static ResultSet getAssembleAssignedPermItemFromEAS(Context ctx, String userId, String hrOrgId) {
        IRowSet rowSet = null;
        String sql = SHRPermissionSQL.assembleAssignedPermItemSQL(ctx);
        Object[] params = new Object[]{userId, hrOrgId};
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rowSet;
    }

    public static ResultSet getAssembleAssignedPermItemAdminOrgRangeFromDB(Context ctx, String userId, String permItemId) {
        IRowSet rowSet = null;
        String sql = SHRPermissionSQL.getHRUserAdminOrgRangeSql(userId, permItemId);
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rowSet;
    }

    public static boolean checkUserisManager(Context ctx, String userId) {
        boolean isManager = false;
        String managerRoleId = "00000000-0000-0000-0000-00000000000013B6732A";
        HashSet<String> set = new HashSet<String>();
        IRowSet rowSet = null;
        String sql = SHRPermissionSQL.getRoleIdByUser(userId);
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                set.add(rowSet.getString("FROLEID"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (set.contains("00000000-0000-0000-0000-00000000000013B6732A")) {
            isManager = true;
        }
        return isManager;
    }

    public static Set<String> getManagerHROrgIdSet(Context ctx) {
        UserInfo user;
        HashSet<String> set = new HashSet<String>();
        String personId = null;
        if (StringUtils.isEmpty(personId) && (user = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && user.getPerson() != null) {
            personId = user.getPerson().getId().toString();
        }
        if (StringUtils.isEmpty(personId)) {
            return null;
        }
        IRowSet rs = DataOperateHelper.getManagerOrg(ctx, personId);
        String adminOrgId = null;
        if (null != rs && rs.size() > 0) {
            try {
                while (rs.next()) {
                    adminOrgId = rs.getString("FADMINORGID");
                    ResultSet hrOrgRowSet = DataOperateHelper.getManageHrOrg(ctx, adminOrgId, "bizManageType");
                    while (hrOrgRowSet.next()) {
                        set.add(hrOrgRowSet.getString("FMANAGEHRORGID"));
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return set;
    }

    public static ResultSet getManageHrOrg(Context ctx, String adminOrgId, String bizManageType) {
        IRowSet rowSet = null;
        String sql = SHRPermissionSQL.getManageHrOrg(adminOrgId, "bizManageType");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rowSet;
    }

    public static Set<String> getAssembleAssignedPermItemAdminOrgIdSet(Context ctx, String userId, String permItemId) {
        HashSet<String> set = new HashSet<String>();
        ResultSet rowSet = DataOperateHelper.getAssembleAssignedPermItemAdminOrgRangeFromDB(ctx, userId, permItemId);
        try {
            while (rowSet.next()) {
                set.add(rowSet.getString("FAdminOrgID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return set;
    }

    public static Set<String> getManagerOrgIdSet(Context ctx) {
        UserInfo user;
        HashSet<String> set = new HashSet<String>();
        String personId = null;
        if (StringUtils.isEmpty(personId) && (user = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && user.getPerson() != null) {
            personId = user.getPerson().getId().toString();
        }
        if (StringUtils.isEmpty(personId)) {
            return null;
        }
        IRowSet rs = DataOperateHelper.getManagerOrg(ctx, personId);
        String longNumber = null;
        if (null != rs && rs.size() > 0) {
            try {
                while (rs.next()) {
                    longNumber = rs.getString("FLONGNUMBER");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            String ManagerOrgIncluSub = SHRPermissionSQL.getManagerOrgIncluSub(longNumber);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)ManagerOrgIncluSub);
                while (rowSet.next()) {
                    set.add(rowSet.getString("FID"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return set;
    }

    public static IRowSet getManagerOrg(Context ctx, String personId) {
        String sql = SHRPermissionSQL.getManagerOrg();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rs;
    }
}

