/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHRPermissionParamUtil {
    private static Logger logger = Logger.getLogger(SHRPermissionParamUtil.class);

    public static void isShrMenuPermission(Context ctx, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        IPermission perm = PermissionFactory.getRemoteInstance();
        ObjectUuidPK orgPK = null;
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        Set<String> ids = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, HRFilterUtils.getCurrentUserId((Context)ctx), permItemInfo.getId().toString());
        for (String id : ids) {
            orgPK = new ObjectUuidPK(id);
            try {
                perm.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemInfo.getName());
                return;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        throw new ShrPermissionException(ShrPermissionException.NO_ITEM_PERMISSION, new Object[]{permItemInfo.getAlias()});
    }

    public static boolean isSHRPermissionVerificationWithWhiteList(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_PERMISSION_VERIFICATION_SET", null, (boolean)false));
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }

    public static boolean isSHRPermissionHandlerRefuse(Context ctx) {
        try {
            return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"Is_Handler_Refusal", null, (boolean)false));
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }
}

