/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.sensitive.rule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.SensitiveRuleFactory;
import com.kingdee.shr.base.permission.SensitiveRuleInfo;
import com.kingdee.shr.base.syssetting.sensitive.rule.ISensitiveRule;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SensitiveRuleBuilderFactory {
    private static Logger logger = Logger.getLogger(SensitiveRuleBuilderFactory.class);
    private static Map<String, ISensitiveRule> classMap = new HashMap<String, ISensitiveRule>();

    public static String getRuleValue(Context ctx, String ruleName, Object oldValue) throws EASBizException, BOSException {
        if (null == oldValue || oldValue instanceof String && StringUtils.isEmpty((String)((String)oldValue))) {
            return null;
        }
        if (null != classMap.get(ruleName)) {
            ISensitiveRule sensitiveRule = classMap.get(ruleName);
            return sensitiveRule.process(ctx, oldValue);
        }
        String impClass = null;
        try {
            impClass = SensitiveRuleBuilderFactory.getRuleImplClass(ctx, ruleName);
            if (null == impClass) {
                throw new BaseConfigException(BaseConfigException.IMPL_CLASS_NO_LOAD, new Object[]{impClass});
            }
            Class<?> clazz = Class.forName(impClass);
            Object obj = clazz.newInstance();
            if (!(obj instanceof ISensitiveRule)) {
                throw new BaseConfigException(BaseConfigException.NO_IMPL, new Object[]{impClass, ISensitiveRule.class.toString()});
            }
            ISensitiveRule sensitiveRule = (ISensitiveRule)obj;
            classMap.put(ruleName, sensitiveRule);
            return sensitiveRule.process(ctx, oldValue);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BaseConfigException(BaseConfigException.IMPL_CLASS_NO_LOAD, new Object[]{impClass});
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static String getRuleImplClass(Context ctx, String ruleName) throws BOSException, EASBizException {
        SensitiveRuleInfo sensitiveRuleInfo = SensitiveRuleFactory.getLocalInstance(ctx).getSensitiveRuleInfo("select implClass where number='" + ruleName + "'");
        return sensitiveRuleInfo.getImplClass();
    }
}

