/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentSecurityFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentSecurity;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.EASBizException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentCheckUtils {
    private static Logger logger = LoggerFactory.getLogger(AttachmentCheckUtils.class);

    public static void checkFileType(Context ctx, String fileName, InputStream fileInputStream) throws EASBizException {
        try {
            IAttachment ia = AttachmentFactory.getLocalInstance((Context)ctx);
            PlainFileInfo plainInfo = new PlainFileInfo(fileName, fileInputStream);
            IAttachmentSecurity security = AttachmentSecurityFactory.getInstance();
            byte[] bytes = AttachmentCheckUtils.inputStreamToByte(fileInputStream);
            StringUtil4File.checkFile((IAttachment)ia, (byte[])bytes);
            StringUtil4File.checkInvalidCharsInFileName((String)fileName);
            security.check(plainInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] inputStreamToByte(InputStream fileInputStream) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = fileInputStream.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }

    public static void checkFileType(Context ctx, String fileName, byte[] fileByte) throws EASBizException {
        try {
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(fileByte);
            IAttachment ia = AttachmentFactory.getLocalInstance((Context)ctx);
            PlainFileInfo plainInfo = new PlainFileInfo(fileName, (InputStream)fileInputStream);
            IAttachmentSecurity security = AttachmentSecurityFactory.getInstance();
            StringUtil4File.checkFile((IAttachment)ia, (byte[])fileByte);
            StringUtil4File.checkInvalidCharsInFileName((String)fileName);
            security.check(plainInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

