/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.Context;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public final class FaqPermOrgsUtils {
    public static final String PAGE_MATHRANDOM = "page_mathrandom";
    private Map<String, List<Map<String, Object>>> DATA_CACHE = new ConcurrentHashMap<String, List<Map<String, Object>>>();

    private FaqPermOrgsUtils() {
    }

    public static final FaqPermOrgsUtils getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static String assembleMapKey(HttpServletRequest request, Context ctx) {
        String mathRandom = request.getParameter(PAGE_MATHRANDOM);
        String userId = ctx.getCaller().toString();
        String ip = ctx.getClientHostIP();
        return userId + "-*-" + ip + "-*-" + mathRandom;
    }

    public List<Map<String, Object>> getData(String key) {
        return this.DATA_CACHE.get(key);
    }

    public List<Map<String, Object>> getData(HttpServletRequest request, Context ctx) {
        return this.DATA_CACHE.get(FaqPermOrgsUtils.assembleMapKey(request, ctx));
    }

    public void putData(String key, List<Map<String, Object>> data) {
        this.DATA_CACHE.put(key, data);
    }

    public void removeKey(String key) {
        this.DATA_CACHE.remove(key);
    }

    private static class SingletonHolder {
        private static final FaqPermOrgsUtils INSTANCE = new FaqPermOrgsUtils();

        private SingletonHolder() {
        }
    }
}

