/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.websso.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.websso.WSUserInfo;
import com.kingdee.shr.websso.WSUserInfoDbType;
import com.kingdee.shr.websso.WSUserInfoLanguage;
import com.kingdee.shr.websso.WebSSOBizException;
import com.kingdee.shr.websso.app.AbstractWSUserControllerBean;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WSUserControllerBean
extends AbstractWSUserControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.websso.app.WSUserControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String dcName = ctx.getAIS();
        String dbType = ContextUtil.getDbType((Context)ctx);
        WSUserInfo wsUser = (WSUserInfo)model;
        if (dbType != null) {
            String lowerCase = dbType.toLowerCase();
            if (lowerCase.contains("server")) {
                wsUser.setDbType(WSUserInfoDbType.SQLSERVER);
            } else if (lowerCase.contains("oracle")) {
                wsUser.setDbType(WSUserInfoDbType.ORACLE);
            } else if (lowerCase.contains("db2")) {
                wsUser.setDbType(WSUserInfoDbType.DB2);
            } else {
                wsUser.setString("dbType", String.valueOf(DbType.getValue((String)dbType)));
            }
        }
        wsUser.setDcName(dcName);
        wsUser.setLanguage(WSUserInfoLanguage.SIMPLIFIED);
        wsUser.setSlnName("eas");
        wsUser.setState(BaseItemStateEnum.NEW);
        String userName = wsUser.getUserName();
        String wsuserPwd = wsUser.getPasswd();
        IUser instance = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection coll = instance.getCollection("where number ='" + userName + "'");
        UserInfo user = null;
        if (coll != null && coll.size() > 0) {
            user = (UserInfo)coll.get(0);
        }
        if (user == null) {
            user = UserInfoHelper.createNewDefaultUserInfo();
            try {
                user.setPassword(CryptoTean.encrypt((String)userName, (String)wsuserPwd));
            }
            catch (CryptException e) {
                e.printStackTrace();
            }
            user.setName(userName);
            user.setNumber(userName);
            SecurityInfo security = (SecurityInfo)SecurityFactory.getLocalInstance((Context)ctx).getValue("where number = '001'");
            user.setSecurity(security);
            CtrlUnitInfo cu = ContextUtil.getCurrentUserInfo((Context)ctx).getCU();
            user.setCU(cu);
            instance.addnew((CoreBaseInfo)user);
        } else {
            String userPwd = user.getPassword();
            if (StringUtils.isEmpty((CharSequence)userPwd)) {
                throw new WebSSOBizException(WebSSOBizException.USERNAME_NOTNULL, new Object[]{user.getNumber()});
            }
            String newPwd = PermissionUtil.encrypt((String)user.getId().toString(), (String)wsuserPwd, (PasswordType)user.getPasswordType());
            if (!newPwd.equals(userPwd)) {
                throw new WebSSOBizException(WebSSOBizException.PWD_ERROR, new Object[]{user.getNumber()});
            }
        }
        if (!StringUtils.isEmpty((CharSequence)wsuserPwd)) {
            String newWsPwd = new BASE64Encoder().encodeBuffer(wsuserPwd.getBytes());
            wsUser.setPasswd(newWsPwd);
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WSUserInfo wsUser = (WSUserInfo)model;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection coll = iUser.getCollection("where number ='" + wsUser.getUserName() + "'");
        UserInfo user = null;
        if (coll != null && coll.size() > 0) {
            user = (UserInfo)coll.get(0);
            int state = wsUser.getState().getValue();
            if (state == 0 || state == 2) {
                user.setIsForbidden(true);
            } else {
                user.setIsForbidden(false);
            }
            iUser.update((IObjectPK)new ObjectUuidPK(user.getId()), (CoreBaseInfo)user);
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String userPwd;
        WSUserInfo wsUser = (WSUserInfo)super._getValue(ctx, pk);
        String userName = wsUser.getUserName();
        IUser instance = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection coll = instance.getCollection("where number ='" + userName + "'");
        UserInfo user = null;
        if (coll != null && coll.size() > 0) {
            user = (UserInfo)coll.get(0);
        }
        if (StringUtils.isEmpty((CharSequence)(userPwd = user.getPassword()))) {
            throw new WebSSOBizException(WebSSOBizException.USERNAME_NOTNULL, new Object[]{user.getNumber()});
        }
        try {
            byte[] bs = new BASE64Decoder().decodeBuffer(wsUser.getPasswd());
            String wsuserPwd = new String(bs);
            String newPwd = PermissionUtil.encrypt((String)user.getId().toString(), (String)wsuserPwd, (PasswordType)user.getPasswordType());
            if (!newPwd.equals(userPwd)) {
                throw new WebSSOBizException(WebSSOBizException.PWD_ERROR, new Object[]{user.getNumber()});
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return super._getValue(ctx, pk);
        }
        return super._getValue(ctx, pk);
    }
}

