/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.toolset.app.AbstractEasToolsetFacadeControllerBean;
import com.kingdee.eas.toolset.bean.ClassBean;
import com.kingdee.eas.toolset.bean.Customer;
import com.kingdee.eas.toolset.bean.FileBean;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.bean.ToolFilterBean;
import com.kingdee.eas.toolset.bean.ToolList;
import com.kingdee.eas.toolset.bean.UserBehaviorLog;
import com.kingdee.eas.toolset.util.ETSCloudUtil;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.eas.toolset.util.EncodeUtil;
import com.kingdee.eas.toolset.util.FileUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class EasToolsetFacadeControllerBean
extends AbstractEasToolsetFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.toolset.app.EASToolSetFacedeControllerBean");
    private String sprt = System.getProperty("file.separator");
    private String easHome = System.getProperty("EAS_HOME");
    private static HashMap<String, ClassBean> classCacheMap = new HashMap();
    private static HashMap<String, List<String>> jarForClassMap = new HashMap();
    private static long maxZipFileLength = 0x1400000L;
    private static long maxFilesLength = 0x3200000L;
    private static int serverMode = -1;
    private static long lastGetParamTime = 0L;
    private static boolean isInit = false;

    protected byte[] _download(Context ctx, List srcFileList) throws BOSException {
        this.getETSParams(ctx);
        String filePath = String.valueOf(this.easHome) + this.sprt + ETSUtil.genRandomTxt(6) + ".zip";
        this.checkFileSize(srcFileList);
        FileUtil.compress(srcFileList, filePath, this.easHome);
        File file = new File(filePath);
        long flength = file.length();
        logger.info((Object)("fileLength:" + flength + "  maxZipFileLength:" + maxZipFileLength));
        if (flength > maxZipFileLength) {
            file.delete();
            throw new BOSException("\u6587\u4ef6\u538b\u7f29\u540e\u5927\u5c0f\u8d85\u9650\uff1a" + flength + ">" + maxZipFileLength);
        }
        byte[] content = FileUtil.fileToByte(file);
        if (file.exists()) {
            file.delete();
        }
        return content;
    }

    public void checkFileSize(List srcFileList) throws BOSException {
        int size = srcFileList.size();
        StringBuffer total = new StringBuffer("0");
        int i = 0;
        while (i < size) {
            String srcFilename = (String)srcFileList.get(i);
            srcFilename = srcFilename.startsWith("/") || srcFilename.startsWith("\\") ? String.valueOf(this.easHome) + srcFilename : String.valueOf(this.easHome) + this.sprt + srcFilename;
            File srcFile = new File(srcFilename);
            if (srcFile.exists()) {
                this.calcLength(srcFile, total);
            }
            ++i;
        }
    }

    public void calcLength(File file, StringBuffer totalLength) throws BOSException {
        Long total = Long.valueOf(totalLength.toString());
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                file = files[i];
                this.calcLength(file, totalLength);
                ++i;
            }
        } else {
            total = total + file.length();
            totalLength.setLength(0);
            totalLength.append(total);
            if (total > maxFilesLength) {
                throw new BOSException("\u6587\u4ef6\u603b\u5927\u5c0f\u8d85\u8fc7(" + maxFilesLength / 1024L / 1024L + "M)\u9650\u5236");
            }
        }
    }

    protected boolean _upload(Context ctx, Map srcFiles) throws BOSException {
        Set keys = srcFiles.keySet();
        for (String key : keys) {
            int result;
            String[] fileInfo;
            block5: {
                byte[] srcData = (byte[])srcFiles.get(key);
                fileInfo = key.split("@");
                String destPath = String.valueOf(this.easHome) + fileInfo[1];
                result = FileUtil.byteToFile(srcData, fileInfo[0], destPath);
                if (result >= 0) break block5;
                return false;
            }
            try {
                String jarPath;
                List<String> list;
                if (result != 0 || !fileInfo[0].endsWith(".jar") || (list = jarForClassMap.get(jarPath = String.valueOf(fileInfo[1]) + fileInfo[0])) == null) continue;
                int i = 0;
                while (i < list.size()) {
                    classCacheMap.remove(list.get(i));
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected boolean _deletefile(Context ctx, List fileList) throws BOSException {
        int size = fileList.size();
        int i = 0;
        while (i < size) {
            String filePath = String.valueOf(this.easHome) + fileList.get(i);
            File file = new File(filePath);
            if (file.exists() && !file.isDirectory() && !file.delete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List _listDir(Context ctx, String dir, boolean genMd5) throws BOSException {
        File[] files;
        dir = String.valueOf(this.easHome) + dir;
        File file = new File(dir);
        ArrayList<FileBean> result = new ArrayList<FileBean>();
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                FileBean f = new FileBean();
                f.setDir(files[i].isDirectory());
                f.setLastUpdateTime(files[i].lastModified());
                f.setName(files[i].getName());
                if (dir.endsWith("/") || dir.endsWith("\\")) {
                    f.setPath(String.valueOf(dir) + files[i].getName());
                } else {
                    f.setPath(String.valueOf(dir) + "/" + files[i].getName());
                }
                if (!files[i].isDirectory()) {
                    f.setSize(files[i].length());
                }
                if (genMd5 && !files[i].isDirectory()) {
                    f.setMd5(DigestUtils.md5Hex((byte[])FileUtil.fileToByte(files[i])));
                }
                result.add(f);
                ++i;
            }
        }
        return result;
    }

    protected String _getInstance(Context ctx) throws BOSException {
        String instUrl = System.getProperty("EAS_INSTANCE_HOME");
        return instUrl;
    }

    protected Object _invokeSrvClass(Context ctx, List fileList, String className, String method, Class[] paramClass, Object[] params) throws BOSException {
        ClassLoader loader = null;
        Class<?> clazz = null;
        Object inst = null;
        Object object = null;
        try {
            ClassBean classBean = classCacheMap.get(className);
            logger.debug((Object)("cachedClass:" + className + "   " + classBean));
            if (classBean != null) {
                inst = classBean.getInst();
                Method med = classBean.getMethod(method);
                if (med == null && (med = paramClass != null ? inst.getClass().getMethod(method, paramClass) : inst.getClass().getMethod(method, new Class[0])) != null) {
                    classBean.setMethod(method, med);
                }
                logger.debug((Object)("\u8c03\u7528\u7f13\u5b58\u65b9\u6cd5" + className + "." + method));
                if (params != null) {
                    logger.debug((Object)"\u53c2\u6570");
                    int i = 0;
                    while (i < params.length) {
                        logger.debug((Object)("\t" + i + ":" + params[i].toString()));
                        ++i;
                    }
                }
                if (params != null) {
                    Object object2 = med.invoke(inst, params);
                    return object2;
                }
                Object object3 = med.invoke(inst, new Object[0]);
                return object3;
            }
            try {
                int j = 0;
                if (fileList != null && fileList.size() > 0) {
                    logger.debug((Object)("\u52a8\u6001\u52a0\u8f7d\u5305" + fileList));
                    int size = fileList.size();
                    URL[] urls = new URL[size];
                    File file = null;
                    int i = 0;
                    while (i < size) {
                        String filePath;
                        String jarName = fileList.get(i).toString();
                        List<String> classNames = jarForClassMap.get("/server/eastoolset/lib/" + jarName);
                        if (classNames == null) {
                            classNames = new ArrayList<String>();
                            jarForClassMap.put(jarName, classNames);
                        }
                        if (!classNames.contains(className)) {
                            classNames.add(className);
                        }
                        if ((file = new File(filePath = String.valueOf(this.easHome) + jarName)).exists()) {
                            urls[j] = file.toURI().toURL();
                            ++j;
                        }
                        file = null;
                        ++i;
                    }
                    loader = new URLClassLoader(urls);
                }
                logger.debug((Object)("\u8c03\u7528\u65b9\u6cd5" + className + "." + method));
                if (params != null) {
                    logger.debug((Object)"\u53c2\u6570");
                    int i = 0;
                    while (i < params.length) {
                        logger.debug((Object)("\t" + i + ":" + params[i].toString()));
                        ++i;
                    }
                }
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                clazz = loader.loadClass(className);
                try {
                    Constructor<?> constructor = clazz.getConstructor(ctx.getClass());
                    inst = constructor.newInstance(ctx);
                }
                catch (Exception e) {
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    inst = constructor.newInstance(new Object[0]);
                }
                Method med = paramClass != null ? clazz.getMethod(method, paramClass) : clazz.getMethod(method, new Class[0]);
                object = params != null ? med.invoke(inst, params) : med.invoke(inst, new Object[0]);
                classBean = new ClassBean();
                classBean.setInst(inst);
                classBean.setMethod(method, med);
                classCacheMap.put(className, classBean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            clazz = null;
            loader = null;
        }
        return object;
    }

    protected byte[] _downloadTool(Context ctx, String toolNumber) throws BOSException {
        String destPath = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/installpacks/";
        String packName = String.valueOf(destPath) + toolNumber + ".zip";
        File f = new File(packName);
        String path = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/";
        String version = FileUtil.loadStrFromFile(String.valueOf(path) + "ets.version", true);
        if (f.exists()) {
            byte[] fileBytes = FileUtil.fileToByte(f);
            if (this.getServerMode(ctx) == 0) {
                return fileBytes;
            }
            String md5 = DigestUtils.md5Hex((byte[])fileBytes);
            Map map = new HashMap<String, String>();
            map.put("'" + toolNumber + "'", "'" + md5 + "'");
            map = ETSCloudUtil.checkToolUpdate(version, map);
            if (map == null || map.get(toolNumber) == null) {
                ETSCloudUtil.addDownloadTime(toolNumber);
                return fileBytes;
            }
        } else if (this.getServerMode(ctx) == 0) {
            return null;
        }
        try {
            ETSCloudUtil.downloadTool(this._getETSVersion(ctx), toolNumber, destPath);
            return FileUtil.fileToByte(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void getETSParams(Context ctx) {
        long time = Calendar.getInstance().getTimeInMillis();
        if (lastGetParamTime > 0L && time - lastGetParamTime < 60000L) {
            return;
        }
        try {
            String sql = "select fkey,fvalue from t_dt_dttempparam where fkey like 'ets%'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                if ("etsServerNetworkMode".equals(rowSet.getString(1))) {
                    serverMode = rowSet.getInt(2);
                }
                if ("etsMaxZipFileLength".equals(rowSet.getString(1))) {
                    maxZipFileLength = rowSet.getLong(2);
                }
                if ("etsMaxFilesLength".equals(rowSet.getString(1))) {
                    maxFilesLength = rowSet.getLong(2);
                }
                lastGetParamTime = time;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected List _getToolListFromCloud(Context ctx, ToolFilterBean filter) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return this.getToolListFromLocal(filter);
        }
        return ETSCloudUtil.getToolListFromCloud(filter);
    }

    private List getToolListFromLocal(ToolFilterBean filter) {
        String path = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/installpacks/";
        File dir = new File(path);
        if (!dir.exists()) {
            return null;
        }
        ToolList lst = new ToolList();
        File[] listFiles = dir.listFiles();
        String numbers = filter.getInstalledNumbers();
        ArrayList<String> numberLst = new ArrayList<String>();
        if (numbers != null && numbers.trim().length() > 0) {
            numbers = numbers.replace("'", "");
            String[] split = numbers.split(",");
            int i = 0;
            while (i < split.length) {
                numberLst.add(split[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < listFiles.length) {
            block12: {
                File f = listFiles[i];
                if (f.exists()) {
                    try {
                        ZipFile zip = new ZipFile(f);
                        ZipEntry entry = zip.getEntry("tool.info");
                        if (entry == null) break block12;
                        InputStream inp = zip.getInputStream(entry);
                        InputStreamReader isr = new InputStreamReader(inp);
                        BufferedReader reader = new BufferedReader(isr);
                        String s = reader.readLine();
                        reader.close();
                        isr.close();
                        inp.close();
                        zip.close();
                        try {
                            s = EncodeUtil.decrypt(s);
                        }
                        catch (IllegalBlockSizeException e) {
                            e.printStackTrace();
                        }
                        catch (BadPaddingException e) {
                            e.printStackTrace();
                        }
                        s = new String(s.getBytes(System.getProperty("file.encoding")), "utf-8");
                        JSONObject o = JSONObject.fromObject((Object)s);
                        ToolBean t = (ToolBean)JSONObject.toBean((JSONObject)o, ToolBean.class);
                        if (!numberLst.contains(t.getNumber())) {
                            lst.add(t);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        if (lst.size() > 0) {
            lst.setCurPage(1);
            lst.setTotalPage(1);
            lst.setPageSize(20);
            lst.setTotalCount(lst.size());
            return lst;
        }
        return null;
    }

    public Map _checkNeedUpdate(Context ctx, Map toolMap) {
        if (this.getServerMode(ctx) == 0) {
            if (toolMap != null) {
                String path = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/installpacks/";
                Iterator itr = toolMap.keySet().iterator();
                HashMap<String, String> map = new HashMap<String, String>();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String md5 = (String)toolMap.get(key);
                    String fileName = String.valueOf(path) + key + ".zip";
                    File f = new File(fileName);
                    if (!f.exists()) continue;
                    try {
                        ZipFile zip = new ZipFile(f);
                        ZipEntry entry = zip.getEntry("tool.info");
                        if (entry == null) continue;
                        InputStream inp = zip.getInputStream(entry);
                        InputStreamReader isr = new InputStreamReader(inp);
                        BufferedReader reader = new BufferedReader(isr);
                        String s = reader.readLine();
                        reader.close();
                        isr.close();
                        inp.close();
                        zip.close();
                        try {
                            s = EncodeUtil.decrypt(s);
                        }
                        catch (IllegalBlockSizeException e) {
                            e.printStackTrace();
                        }
                        catch (BadPaddingException e) {
                            e.printStackTrace();
                        }
                        s = new String(s.getBytes(System.getProperty("file.encoding")), "utf-8");
                        JSONObject o = JSONObject.fromObject((Object)s);
                        ToolBean t = (ToolBean)JSONObject.toBean((JSONObject)o, ToolBean.class);
                        if (md5.equals(t.getMd5())) continue;
                        map.put(key, "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return map;
            }
            return null;
        }
        String path = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/";
        String version = FileUtil.loadStrFromFile(String.valueOf(path) + "ets.version", true);
        return ETSCloudUtil.checkToolUpdate(version, toolMap);
    }

    public void _userBehaviorLog(Context ctx, UserBehaviorLog log) {
        if (this.getServerMode(ctx) == 0) {
            return;
        }
        ETSCloudUtil.userBehaviorLog(log);
    }

    protected ToolBean _getToolInfo(Context ctx, String number) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            String destPath = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/installpacks/";
            String packName = String.valueOf(destPath) + number + ".zip";
            File f = new File(packName);
            if (f.exists()) {
                try {
                    ZipFile zip = new ZipFile(f);
                    ZipEntry entry = zip.getEntry("tool.info");
                    entry = zip.getEntry("tool.info");
                    if (entry != null) {
                        InputStream inp = zip.getInputStream(entry);
                        InputStreamReader isr = new InputStreamReader(inp);
                        BufferedReader reader = new BufferedReader(isr);
                        String s = reader.readLine();
                        reader.close();
                        isr.close();
                        inp.close();
                        zip.close();
                        s = EncodeUtil.decrypt(s);
                        s = new String(s.getBytes(System.getProperty("file.encoding")), "utf-8");
                        JSONObject o = JSONObject.fromObject((Object)s);
                        ToolBean t = (ToolBean)JSONObject.toBean((JSONObject)o, ToolBean.class);
                        return t;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        return ETSCloudUtil.getToolInfo(number);
    }

    protected Customer _getCustomerInfo(Context ctx, String productNumber) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return null;
        }
        return ETSCloudUtil.getCustomerInfo(productNumber);
    }

    protected void _addDownloadTime(Context ctx, String number) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return;
        }
        ETSCloudUtil.addDownloadTime(number);
    }

    protected boolean _comment(Context ctx, Map params) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return false;
        }
        return ETSCloudUtil.comment(params);
    }

    protected List _getToolChangeLogs(Context ctx, String toolId) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return null;
        }
        return ETSCloudUtil.getToolChangeLogs(toolId);
    }

    protected List _getToolComments(Context ctx, String toolId) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return null;
        }
        return ETSCloudUtil.getToolCommentList(toolId);
    }

    protected boolean _feedback(Context ctx, Map params) throws BOSException {
        if (this.getServerMode(ctx) == 0) {
            return false;
        }
        return ETSCloudUtil.feedback(params);
    }

    private int getServerMode(Context ctx) {
        this.getETSParams(ctx);
        return serverMode;
    }

    private long getMaxZipFileLength(Context ctx) {
        this.getETSParams(ctx);
        return maxZipFileLength;
    }

    private long getMaxFilesLength(Context ctx) {
        this.getETSParams(ctx);
        return maxFilesLength;
    }

    protected byte[] _updateClient(Context ctx, String md5) throws BOSException {
        String clientPack = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/EasToolsetClient.zip";
        File f = new File(clientPack);
        if (!f.exists()) {
            return null;
        }
        byte[] bytes = FileUtil.fileToByte(f);
        if (md5 == null || md5.trim().length() == 0) {
            return bytes;
        }
        String remoteMd5 = DigestUtils.md5Hex((byte[])bytes);
        if (!md5.equals(remoteMd5)) {
            return bytes;
        }
        return null;
    }

    public String _getETSVersion(Context ctx) throws BOSException {
        String path = String.valueOf(System.getenv("EAS_HOME")) + "/server/eastoolset/";
        String version = FileUtil.loadStrFromFile(String.valueOf(path) + "ets.version", true);
        return version;
    }

    public void _initEntityIndex(final Context ctx) throws BOSException {
        if (isInit) {
            return;
        }
        isInit = true;
        Thread t = new Thread(new Runnable(){

            public void run() {
                EasToolsetFacadeControllerBean.this.doBuildEntityInfoIndex(ctx, false);
            }
        });
        t.setName("BuildEntityInfoIndex");
        t.start();
    }

    private void doBuildEntityInfoIndex(Context ctx, boolean isRebuild) {
        boolean isTableExist;
        Connection conn;
        PreparedStatement ps;
        block13: {
            logger.debug((Object)"\u521d\u59cb\u5316\u5b9e\u4f53\u7d22\u5f15");
            ps = null;
            conn = null;
            String checkSql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='T_ISQL_EntityInfoIndex'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            isTableExist = false;
            if (rowSet.next()) {
                checkSql = "select 1 from  ksql_usercolumns  where KSQL_COL_NAME ='FBOSTYPE' AND KSQL_COL_TABNAME='T_ISQL_ENTITYINFOINDEX'";
                rowSet.close();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                if (rowSet.next()) {
                    isTableExist = true;
                } else {
                    DbUtil.execute((Context)ctx, (String)"drop table T_ISQL_ENTITYINFOINDEX");
                    logger.debug((Object)"drop table T_ISQL_ENTITYINFOINDEX");
                }
            }
            if (!isTableExist || isRebuild) break block13;
            SQLUtils.cleanup(ps, conn);
            return;
        }
        try {
            try {
                EntityObjectInfo entityObjInfo;
                if (!isTableExist) {
                    StringBuffer sbCreateTable = new StringBuffer();
                    sbCreateTable.append("Create Table T_ISQL_EntityInfoIndex(FId VARCHAR(44),FName VARCHAR(200),FBosType varchar(20),FFullName VARCHAR(200),FALias VARCHAR(100),FTableName VARCHAR(100))");
                    DbUtil.execute((Context)ctx, (String)sbCreateTable.toString());
                    logger.debug((Object)"create table T_ISQL_ENTITYINFOINDEX");
                } else {
                    DbUtil.execute((Context)ctx, (String)"truncate table T_ISQL_EntityInfoIndex");
                }
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectCollection entityCollection = loader.getEntityCollection();
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement("insert into T_ISQL_EntityInfoIndex(FId,FName,FBosType,FFullName,FALias,FTableName)\nvalues(?,?,?,?,?,?)");
                int size = entityCollection.size();
                int i = 0;
                while (i < size) {
                    entityObjInfo = entityCollection.get(i);
                    ps.clearParameters();
                    ps.setString(1, BOSUuid.create((String)"AAAAAAAA").toString());
                    ps.setString(2, entityObjInfo.getName());
                    ps.setString(3, entityObjInfo.getType() == null ? "" : entityObjInfo.getType().toString());
                    ps.setString(4, entityObjInfo.getFullName());
                    ps.setString(5, entityObjInfo.getAlias());
                    DataTableInfo tableInfo = entityObjInfo.getTable();
                    ps.setString(6, tableInfo == null ? "" : tableInfo.getName());
                    ps.addBatch();
                    if (i % 500 == 0) {
                        ps.executeBatch();
                        ps.clearBatch();
                    }
                    ++i;
                }
                entityObjInfo = null;
                entityCollection.clear();
                entityCollection = null;
                if (size % 500 != 0) {
                    ps.executeBatch();
                }
                logger.debug((Object)"\u521d\u59cb\u5316\u5b9e\u4f53\u8868\u7d22\u5f15\u5b8c\u6bd5");
            }
            catch (Exception e) {
                logger.debug((Object)"\u5b9e\u4f53\u7d22\u5f15\u521b\u5efa\u5931\u8d25");
                e.printStackTrace();
                isInit = false;
                SQLUtils.cleanup(ps, conn);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

