/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.eas.toolset.bean.EASTool;
import com.kingdee.eas.toolset.bean.ToolBean;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.eas.toolset.util.FileUtil;
import com.kingdee.eas.toolset.util.HttpUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class ClassUtil {
    private static URLClassLoader urlLoader;

    public static void loadJars(File[] files) {
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isFile() && f.getName().endsWith(".jar")) {
                ClassUtil.loadJar(files[i].getAbsolutePath());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EASTool getEASToolInstanceDyn(ToolBean tool) {
        String toolPath;
        File f;
        if (ETSContext.getRunMode() == -1) {
            if (!ClassUtil.loadExtLibsRemote(tool.getNumber())) {
                System.out.println("\u52a0\u8f7d\u4f9d\u8d56EAS\u5305\u5931\u8d25");
            }
        } else if (ETSContext.getRunMode() == 1 && !ClassUtil.loadExtLibsLocal(tool.getNumber())) {
            System.out.println("\u52a0\u8f7d\u4f9d\u8d56EAS\u5305\u5931\u8d25");
        }
        if (!(f = new File(String.valueOf(toolPath = ETSUtil.getToolPath(tool.getNumber())) + "/lib")).exists()) return null;
        File[] jarFiles = f.listFiles();
        if (jarFiles == null) return null;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            try {
                Class<?> clazz;
                URLClassLoader loader;
                int i = 0;
                while (true) {
                    if (i >= jarFiles.length) {
                        if (urls.size() <= 0) return null;
                        URL[] urlArr = new URL[urls.size()];
                        urls.toArray(urlArr);
                        loader = new URLClassLoader(urlArr);
                        clazz = loader.loadClass(tool.getLauncher());
                        try {
                            Constructor<?> con = clazz.getConstructor(String.class, String.class);
                            if (con != null) {
                                EASTool eASTool = (EASTool)((Object)con.newInstance(tool.getName(), tool.getNumber()));
                                clazz = null;
                                loader = null;
                                return eASTool;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        break;
                    }
                    File file = jarFiles[i];
                    if (file.getName().endsWith(".jar")) {
                        urls.add(file.toURI().toURL());
                    }
                    ++i;
                }
                EASTool eASTool = (EASTool)((Object)clazz.newInstance());
                clazz = null;
                loader = null;
                return eASTool;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Object clazz = null;
                Object loader = null;
                return null;
            }
        }
        finally {
            Object clazz = null;
            Object var3_12 = null;
        }
    }

    public static void loadJar(String jarPath) {
        System.out.println("load:" + jarPath);
        if (!jarPath.startsWith("file:///")) {
            jarPath = "file:///" + jarPath;
        }
        if (urlLoader == null) {
            urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        try {
            Method method = sysClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlLoader, new URL(jarPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean loadExtLibsLocal(String toolNumber) {
        String[] split;
        String clientLibPath = String.valueOf(ETSContext.getEasClientHome()) + "/lib/";
        String str = FileUtil.loadStrFromFile(String.valueOf(ETSUtil.getToolPath(toolNumber)) + "/lib/jarlist.list", true);
        if (str != null && (split = str.split("\n")) != null) {
            int i = 0;
            while (i < split.length) {
                str = split[i];
                if (!str.isEmpty()) {
                    String[] jars = str.split("@");
                    File f = new File(String.valueOf(clientLibPath) + jars[0]);
                    if (f.exists()) {
                        ClassUtil.loadJar(f.getAbsolutePath());
                    }
                    if (jars.length > 1 && (f = new File(String.valueOf(clientLibPath) + jars[1])).exists()) {
                        ClassUtil.loadJar(f.getAbsolutePath());
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean loadExtLibsRemote(String toolNumber) {
        String[] split;
        String ip = ETSContext.getIp();
        String port = ETSContext.getHttpPort();
        String localPath = String.valueOf(ETSContext.getETSHome()) + "/lib/" + ip + "-" + port;
        String localSpPath = String.valueOf(localPath) + "/sp";
        String serverPath = "http://" + ip + ":" + port + "/easWebClient/lib/";
        String str = FileUtil.loadStrFromFile(String.valueOf(ETSUtil.getToolPath(toolNumber)) + "/lib/jarlist.list", true);
        if (str != null && (split = str.split("\n")) != null) {
            int i = 0;
            while (i < split.length) {
                str = split[i];
                if (!str.isEmpty()) {
                    String sprt;
                    String[] jars = str.split("@");
                    String spJarPath = jars[0];
                    if (spJarPath.indexOf(sprt = System.getProperty("file.separator")) >= 0) {
                        spJarPath = spJarPath.substring(spJarPath.lastIndexOf(sprt) + 1);
                    } else if (spJarPath.indexOf("/") >= 0) {
                        spJarPath = spJarPath.substring(spJarPath.lastIndexOf("/") + 1);
                    }
                    File f = new File(String.valueOf(localSpPath) + "/" + spJarPath);
                    int a = 0;
                    if (!f.exists()) {
                        a = HttpUtil.downloadFile(serverPath, jars[0], localSpPath, null);
                    }
                    if (a == 0) {
                        ClassUtil.loadJar(f.getAbsolutePath());
                    }
                    int b = 0;
                    if (jars.length == 1) {
                        if (a != 0) {
                            return false;
                        }
                    } else {
                        spJarPath = jars[1];
                        if (spJarPath.indexOf(sprt) >= 0) {
                            spJarPath = spJarPath.substring(spJarPath.lastIndexOf(sprt) + 1);
                        } else if (spJarPath.indexOf("/") >= 0) {
                            spJarPath = spJarPath.substring(spJarPath.lastIndexOf("/") + 1);
                        }
                        f = new File(String.valueOf(localPath) + "/" + spJarPath);
                        if (!f.exists()) {
                            b = HttpUtil.downloadFile(serverPath, jars[1], localPath, null);
                        }
                        if (b == 0) {
                            ClassUtil.loadJar(f.getAbsolutePath());
                        }
                    }
                    if (a != 0 && b != 0) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }
}

