/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.toolset.bean.SqlResult;
import com.kingdee.eas.toolset.client.LoginHelper;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class EASDBUtil {
    private static Object isql;
    private static long lastRequestTime;
    static Class c;
    private static Class src;

    static {
        try {
            c = Class.forName("com.kingdee.eas.fm.common.IFMIsqlFacade");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void updLastRequestTime() {
        lastRequestTime = Calendar.getInstance().getTimeInMillis();
    }

    public static void keepConn() {
        EASDBUtil.updLastRequestTime();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                long curTime = Calendar.getInstance().getTimeInMillis();
                if (curTime - lastRequestTime >= 240000L) {
                    try {
                        EASDBUtil.executeQuery("select '1' ", null);
                        lastRequestTime = curTime;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            isql = null;
                            LoginHelper.reLogin();
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                }
            }
        }, 240000L, 240000L);
    }

    private static Object getConn() throws Exception {
        if (isql == null) {
            try {
                Class<?> cls = Class.forName("com.kingdee.eas.fm.common.FMIsqlFacadeFactory");
                Method m = cls.getMethod("getRemoteInstance", new Class[0]);
                isql = m.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return isql;
    }

    public static void executeUpdate(String sql) throws Exception {
        try {
            try {
                Method m = c.getMethod("executeSql", String.class);
                m.invoke(EASDBUtil.getConn(), sql);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                if (ETSUtil.causedByCannotFoundSession(e)) {
                    try {
                        isql = null;
                        LoginHelper.reLogin();
                        Method m = c.getMethod("executeSql", String.class);
                        m.invoke(EASDBUtil.getConn(), sql);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        throw ee;
                    }
                } else {
                    throw e;
                }
                EASDBUtil.updLastRequestTime();
            }
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static SqlResult executeSql(String sql) throws Exception {
        Method m = c.getMethod("executeSql", String.class);
        try {
            Object result = m.invoke(EASDBUtil.getConn(), sql);
            SqlResult sqlResult = EASDBUtil.objectToSqlResult(result);
            return sqlResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    isql = null;
                    LoginHelper.reLogin();
                    Object result = m.invoke(EASDBUtil.getConn(), sql);
                    SqlResult sqlResult = EASDBUtil.objectToSqlResult(result);
                    return sqlResult;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    throw ee;
                }
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static void executeSql(String sql, Object[] params) throws Exception {
        Method m = c.getMethod("executeSql", String.class, Object[].class);
        try {
            try {
                m.invoke(EASDBUtil.getConn(), sql, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ETSUtil.causedByCannotFoundSession(e)) {
                    try {
                        isql = null;
                        LoginHelper.reLogin();
                        m.invoke(EASDBUtil.getConn(), sql, params);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        throw ee;
                    }
                } else {
                    throw e;
                }
                EASDBUtil.updLastRequestTime();
            }
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws Exception {
        Method m = c.getMethod("executeQuery", String.class, Object[].class);
        try {
            Object o = m.invoke(EASDBUtil.getConn(), sql, params);
            IRowSet iRowSet = (IRowSet)o;
            return iRowSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    isql = null;
                    LoginHelper.reLogin();
                    Object o = m.invoke(EASDBUtil.getConn(), sql, params);
                    IRowSet iRowSet = (IRowSet)o;
                    return iRowSet;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    throw ee;
                }
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static Object executeQueryByReflect(String sql, Object[] params) throws Exception {
        return EASDBUtil.executeQuery(sql, params);
    }

    public static List fectchAllTableName() throws Exception {
        Method m = c.getMethod("fectchAllTableName", new Class[0]);
        try {
            Object o = m.invoke(EASDBUtil.getConn(), new Object[0]);
            List list = (List)o;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                try {
                    isql = null;
                    LoginHelper.reLogin();
                    Object o = m.invoke(EASDBUtil.getConn(), new Object[0]);
                    List list = (List)o;
                    return list;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    throw ee;
                }
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static String getTableNameByBosType(BOSObjectType bosType) throws Exception {
        Method m = c.getMethod("getTableNameByBosType", BOSObjectType.class);
        try {
            Object o = m.invoke(EASDBUtil.getConn(), bosType);
            String string = (String)o;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                isql = null;
                LoginHelper.reLogin();
                Object o = m.invoke(EASDBUtil.getConn(), bosType);
                String string = (String)o;
                return string;
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static Object runScript(String script) throws Exception {
        Method m = c.getMethod("runScript", String.class);
        try {
            Object o;
            Object object = o = m.invoke(EASDBUtil.getConn(), script);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                Object o;
                isql = null;
                LoginHelper.reLogin();
                Object object = o = m.invoke(EASDBUtil.getConn(), script);
                return object;
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static String transSql(String script, int i) throws Exception {
        Method m = c.getMethod("transSql", String.class, Integer.TYPE);
        try {
            Object o = m.invoke(EASDBUtil.getConn(), script, i);
            String string = (String)o;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                isql = null;
                LoginHelper.reLogin();
                Object o = m.invoke(EASDBUtil.getConn(), script, i);
                String string = (String)o;
                return string;
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    public static String wholeSearchs(String uuid) throws Exception {
        Method m = c.getMethod("wholeSearchs", String.class);
        try {
            Object o = m.invoke(EASDBUtil.getConn(), uuid);
            String string = (String)o;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (ETSUtil.causedByCannotFoundSession(e)) {
                isql = null;
                LoginHelper.reLogin();
                Object o = m.invoke(EASDBUtil.getConn(), uuid);
                String string = (String)o;
                return string;
            }
            throw e;
        }
        finally {
            EASDBUtil.updLastRequestTime();
        }
    }

    private static SqlResult objectToSqlResult(Object sqlResutls) throws Exception {
        SqlResult result = new SqlResult();
        Method m = EASDBUtil.getSqlResultClass().getMethod("getRowSets", new Class[0]);
        List lst = (List)m.invoke(sqlResutls, new Object[0]);
        result.setRowsets(lst);
        m = EASDBUtil.getSqlResultClass().getMethod("getUpdateCount", new Class[0]);
        Object cnt = m.invoke(sqlResutls, new Object[0]);
        result.setUpdateCount(Integer.valueOf(cnt.toString()));
        return result;
    }

    private static Class getSqlResultClass() throws ClassNotFoundException {
        if (src == null) {
            try {
                src = Class.forName("com.kingdee.eas.base.core.SqlResult");
            }
            catch (ClassNotFoundException e) {
                src = Class.forName("com.kingdee.eas.fm.common.SqlResult");
            }
        }
        return src;
    }
}

