/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.toolset.bean.Customer;
import com.kingdee.eas.toolset.bean.ServerInstInfo;
import com.kingdee.eas.toolset.bean.UserBehaviorLog;
import com.kingdee.eas.toolset.util.EASDBUtil;
import com.kingdee.eas.toolset.util.ETSUtil;
import com.kingdee.eas.toolset.util.FileUtil;
import com.kingdee.util.ScriptUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETSContext
extends HashMap {
    private static HashMap<String, Object> props;
    private static HashMap<String, ServerInstInfo> serverInstMap;
    private static boolean updated;
    private static boolean needReboot;
    private static String easVersion;

    static {
        String easHome;
        props = new HashMap();
        updated = false;
        needReboot = false;
        String etsHome = System.getenv("ETS_HOME");
        ETSContext.setClientNetworkMode(1);
        ETSContext.setRunMode(-1);
        if (etsHome != null && !etsHome.isEmpty()) {
            ETSContext.setETSHome(etsHome);
        }
        if ((easHome = System.getenv("EAS_SERVER")) != null) {
            ETSContext.setEasServerUrl(easHome);
            String[] split = easHome.trim().substring(easHome.indexOf("tcp://") + 6).split(":");
            ETSContext.setIp(split[0]);
            ETSContext.setRpcPort(split[1]);
            easHome = System.getenv("EAS_HOME");
            ETSContext.setEasHome(easHome);
            ETSContext.setEasClientHome(String.valueOf(easHome) + "/client");
            ETSContext.setETSHome(String.valueOf(easHome) + "/EasToolsetClient");
            ETSContext.initUserInfo();
            ETSContext.setEasDCName(SysContext.getSysContext().getDcName());
            ETSContext.setClientIp(SysContext.getSysContext().getClientIP());
            ETSContext.initDbType();
            ETSContext.setRunMode(0);
            ETSContext.initRootOrgName();
            ETSContext.initCustomerInfo();
            ETSContext.initClientIp();
            ETSContext.initClientNetworkMode();
            ETSContext.initHttpPort();
            ETSContext.initServerInstInfo();
        }
    }

    public static HashMap<String, ServerInstInfo> getServerInstMap() {
        if (serverInstMap == null) {
            ETSContext.initServerInstInfo();
        }
        return serverInstMap;
    }

    public static boolean isServer() {
        return System.getProperty("EAS_INSTANCE_HOME") != null;
    }

    public static boolean isNeedReboot() {
        return needReboot;
    }

    public static void setNeedReboot(boolean needReboot) {
        ETSContext.needReboot = needReboot;
    }

    public static boolean isUpdated() {
        return updated;
    }

    public static void setUpdated(boolean upd) {
        updated = upd;
    }

    public static void put(String key, Object value) {
        props.put(key, value);
    }

    public static Object get(String key) {
        return props.get(key);
    }

    public static void remove(String key) {
        props.remove(key);
    }

    public static LoginContext getLoginContext() {
        return (LoginContext)props.get("loginCtx");
    }

    public static void setLoginContext(LoginContext ctx) {
        props.put("loginCtx", ctx);
    }

    public static String getProductNumber() {
        return (String)props.get("productNumber");
    }

    public static void setProductNumber(String productNumber) {
        props.put("productNumber", productNumber);
    }

    public static boolean isAdminAccess() {
        return (Boolean)props.get("adminAccess");
    }

    public static int getRunMode() {
        return (Integer)props.get("runMode");
    }

    public static void setRunMode(int mode) {
        props.put("runMode", mode);
    }

    public static int getClientNetworkMode() {
        return (Integer)props.get("clientNetworkMode");
    }

    public static void setClientNetworkMode(int mode) {
        props.put("clientNetworkMode", mode);
    }

    public static void setDBType(int dbType) {
        props.put("dbType", dbType);
    }

    public static int getDBType() {
        return props.get("dbType") != null ? (Integer)props.get("dbType") : 2;
    }

    public static String getUserName() {
        return (String)props.get("userName");
    }

    public static void setUserName(String userName) {
        props.put("userName", userName);
    }

    public static String getUserNumber() {
        return (String)props.get("userNumber");
    }

    public static void setUserNumber(String userNumber) {
        props.put("userNumber", userNumber);
    }

    public static String getCustNumber() {
        return (String)props.get("custNumber");
    }

    public static void setCustNumber(String custNumber) {
        props.put("custNumber", custNumber);
    }

    public static String getCustName() {
        return (String)props.get("custName");
    }

    public static void setCustName(String custName) {
        props.put("custName", custName);
    }

    public static String getEasRootOrgName() {
        return (String)props.get("easRootOrgName");
    }

    public static void setEasRootOrgName(String orgName) {
        props.put("easRootOrgName", orgName);
    }

    public static String getEasDCName() {
        return (String)props.get("easDCName");
    }

    public static void setEasDCName(String easDCName) {
        props.put("easDCName", easDCName);
    }

    public static void setIp(String ip) {
        props.put("ip", ip);
    }

    public static String getIp() {
        return (String)props.get("ip");
    }

    public static void setClientIp(String ip) {
        props.put("clientIp", ip);
    }

    public static String getClientIp() {
        return (String)props.get("clientIp");
    }

    public static void setClientName(String hostName) {
        props.put("clientName", hostName);
    }

    public static String getClientName() {
        return (String)props.get("clientName");
    }

    public static void setHttpPort(String ip) {
        props.put("httpPort", ip);
    }

    public static String getHttpPort() {
        return (String)props.get("httpPort");
    }

    public static void setRpcPort(String ip) {
        props.put("rpcPort", ip);
    }

    public static String getRpcPort() {
        return (String)props.get("rpcPort");
    }

    public static void setETSHome(String etsHome) {
        props.put("etsHome", etsHome);
    }

    public static String getETSHome() {
        String path = (String)props.get("etsHome");
        if (path == null) {
            path = new File("").getAbsolutePath();
            props.put("etsHome", path);
        }
        return path;
    }

    public static void setEasServerUrl(String easServerUrl) {
        props.put("easServerUrl", easServerUrl);
    }

    public static String getEasServerUrl() {
        return (String)props.get("easServerUrl");
    }

    public static void setEasClientHome(String easClientHome) {
        props.put("easClientHome", easClientHome);
    }

    public static String getEasClientHome() {
        return (String)props.get("easClientHome");
    }

    public static void setEasHome(String easHome) {
        props.put("easHome", easHome);
    }

    public static String getEasHome() {
        return (String)props.get("easHome");
    }

    public static String getPlatVersion() {
        if (props.get("platVersion") == null) {
            props.put("platVersion", ETSUtil.getETSVersion());
        }
        return (String)props.get("platVersion");
    }

    public static String getEASVersion() {
        if (easVersion != null) {
            return easVersion;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var result;");
        sb.append("var path=java.lang.System.getProperty('EAS_HOME')+'/server/properties/eas_version.data';");
        sb.append("var file=new java.io.File(path); ");
        sb.append("try {");
        sb.append("var r=new org.dom4j.io.SAXReader();");
        sb.append("var d =r.read(file);");
        sb.append("if(d!=null){");
        sb.append("var e=d.getRootElement().attribute('productVersion');");
        sb.append("result=e.getValue();");
        sb.append("}");
        sb.append("} catch (err) {");
        sb.append("try {");
        sb.append("var dis = new java.io.DataInputStream(new java.io.FileInputStream(file));");
        sb.append("var reader = new java.io.BufferedReader(new java.io.InputStreamReader(dis,java.lang.System.getProperty('file.encoding')));");
        sb.append("var s;");
        sb.append("do {");
        sb.append("s = null;");
        sb.append("s = reader.readLine();");
        sb.append("if (s == null){");
        sb.append("continue;");
        sb.append("}");
        sb.append("if(s.indexOf('productVersion')>=0){");
        sb.append("var str=s;");
        sb.append("var arr=str.split(' ');");
        sb.append("for(var i=0;i<arr.length;i++){");
        sb.append("str=arr[i];");
        sb.append("if(str.indexOf('productVersion')>=0){");
        sb.append("result=str.substring(str.indexOf('");
        sb.append('\"');
        sb.append("')+1,str.lastIndexOf('");
        sb.append('\"');
        sb.append("'));");
        sb.append("break;");
        sb.append("}");
        sb.append("}");
        sb.append("\t\t                  }");
        sb.append("} while (s != null);");
        sb.append("} catch(err){");
        sb.append("}");
        sb.append("}");
        sb.append("result;");
        try {
            Object result = null;
            result = System.getProperty("EAS_INSTANCE_HOME") != null ? ScriptUtil.evalExpr((String)sb.toString(), null) : EASDBUtil.runScript(sb.toString());
            System.out.println("version result:" + result);
            if (result != null) {
                easVersion = result.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return easVersion;
    }

    private static void initCustomerInfo() {
        Customer cust = ETSUtil.getCustomerInfo();
        ETSContext.setProductNumber(ETSUtil.getProductNumber());
        if (cust != null) {
            ETSContext.setCustName(cust.getName());
            ETSContext.setCustNumber(cust.getNumber());
        }
    }

    private static void initHttpPort() {
        if (ETSContext.getHttpPort() == null) {
            String updServer = System.getProperty("UPDATE_SERVER_ADDR");
            if (updServer == null || updServer.trim().length() == 0) {
                String config = String.valueOf(ETSContext.getEasClientHome()) + "/bin/set-client-env.bat";
                String str = FileUtil.loadStrFromFile(config, true);
                String[] split = str.split("\n");
                int i = 0;
                while (i < split.length) {
                    str = split[i];
                    if (str != null && str.indexOf("SET UPDATE_SERVER") >= 0) {
                        updServer = str.substring(str.indexOf("=") + 1);
                        break;
                    }
                    ++i;
                }
            }
            System.out.println(System.getProperties());
            if (updServer != null && updServer.trim().length() > 0) {
                ETSContext.setHttpPort(updServer.trim().substring(updServer.indexOf(":") + 1));
            }
        }
    }

    private static void initUserInfo() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user != null) {
            ETSContext.setUserNumber(user.getNumber());
            ETSContext.setUserName(user.getName());
            props.put("adminAccess", "administrator".equals(user.getNumber()));
        } else {
            props.put("adminAccess", false);
            if (ETSContext.getUserNumber() != null) {
                if ("administrator".equals(ETSContext.getUserNumber())) {
                    props.put("adminAccess", true);
                }
                String sql = "select fname_l2 from t_pm_user where fnumber='" + ETSContext.getUserNumber() + "'";
                try {
                    Object o = EASDBUtil.executeQueryByReflect(sql, null);
                    if (o != null) {
                        Boolean b;
                        Class<?> rsClass = o.getClass();
                        Method m = rsClass.getMethod("next", new Class[0]);
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                        }
                        if ((b = (Boolean)m.invoke(o, new Object[0])).booleanValue()) {
                            m = rsClass.getMethod("getString", Integer.TYPE);
                            if (!m.isAccessible()) {
                                m.setAccessible(true);
                            }
                            ETSContext.setUserName((String)m.invoke(o, 1));
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void initClientNetworkMode() {
        String sql = "select fvalue from t_dt_dttempparam where fkey='etsClientNetworkMode'";
        try {
            Object o = EASDBUtil.executeQueryByReflect(sql, null);
            if (o != null) {
                Boolean b;
                Class<?> rsClass = o.getClass();
                Method m = rsClass.getMethod("next", new Class[0]);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                if ((b = (Boolean)m.invoke(o, new Object[0])).booleanValue()) {
                    m = rsClass.getMethod("getInt", Integer.TYPE);
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    ETSContext.setClientNetworkMode((Integer)m.invoke(o, 1));
                }
            }
        }
        catch (Throwable e) {
            System.out.print(e.toString());
            e.printStackTrace();
        }
    }

    private static void initRootOrgName() {
        String sql = "select fname_l2 from t_org_baseunit where fid ='00000000-0000-0000-0000-000000000000CCE7AED4'";
        try {
            Object o = EASDBUtil.executeQueryByReflect(sql, null);
            if (o != null) {
                Boolean b;
                Class<?> rsClass = o.getClass();
                Method m = rsClass.getMethod("next", new Class[0]);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                if ((b = (Boolean)m.invoke(o, new Object[0])).booleanValue()) {
                    m = rsClass.getMethod("getString", Integer.TYPE);
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    ETSContext.setEasRootOrgName((String)m.invoke(o, 1));
                }
            }
        }
        catch (Throwable e) {
            System.out.print(e.toString());
            e.printStackTrace();
        }
    }

    private static void initDbType() {
        String script = "com.kingdee.bos.sql.KSqlUtil.getDbTypeName(com.kingdee.bos.framework.ejb.EJBFactory.getConnection(com.kingdee.bos.ContextUtils.getContextFromSession()))";
        try {
            String str = (String)EASDBUtil.runScript(script);
            if (str == null) {
                ETSContext.setDBType(2);
            }
            if ((str = str.toLowerCase()).indexOf("ms sql") >= 0) {
                ETSContext.setDBType(0);
            } else if (str.indexOf("db2") >= 0) {
                ETSContext.setDBType(1);
            } else {
                ETSContext.setDBType(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ETSContext.setDBType(2);
        }
    }

    public static void initServerInstInfo() {
        ServerInstInfo serverInst;
        Object result;
        StringBuffer script = new StringBuffer();
        script.append("var d=null;");
        script.append("var path=java.lang.System.getProperty('EAS_HOME')+'/admin/config/domain.xml';");
        script.append("try {");
        script.append("d = new org.dom4j.io.SAXReader().read(new java.io.File(path));");
        script.append("} catch (err) {");
        script.append("a=err;");
        script.append("}");
        script.append("var result='';");
        script.append("var lst=null ;");
        script.append("if(d!=null){");
        script.append("var e=d.getRootElement().element('clustermanager');");
        script.append("if(e!=null){");
        script.append("e=e.element('eascluster');");
        script.append("if(e!=null){");
        script.append("e=e.element('members');");
        script.append("if(e!=null){");
        script.append("lst=e.elements();");
        script.append("}");
        script.append("}");
        script.append("}");
        script.append("var attr;");
        script.append("if(lst!=null&&lst.size()>0){");
        script.append("result='[';");
        script.append("for(var i=0;i<lst.size();i++){");
        script.append("e = lst.get(i);");
        script.append("if(i>0){");
        script.append("result+=',';");
        script.append("}");
        script.append("attr = e.attribute('instance');");
        script.append("result+='{name:\"';");
        script.append("result+=attr.getValue();");
        script.append("result+='\",httpPort:\"';");
        script.append("attr = e.attribute('appServerHttpPort');");
        script.append("result+=attr.getValue();");
        script.append("attr = e.attribute('rpcport');");
        script.append("result+='\",rpcPort:\"';");
        script.append("result+=attr.getValue();");
        script.append("result+='\"}';");
        script.append("}");
        script.append("result+=']';");
        script.append("}");
        script.append("}");
        script.append("result;");
        try {
            result = EASDBUtil.runScript(script.toString());
            System.out.println("result:");
            System.out.println(result);
            serverInstMap = new HashMap();
            if (result != null) {
                JSONArray arr = JSONArray.fromObject((Object)result);
                int i = 0;
                while (i < arr.size()) {
                    Object o = arr.get(i);
                    serverInst = (ServerInstInfo)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)arr.get(i)), ServerInstInfo.class);
                    script.setLength(0);
                    script.append("com.kingdee.eas.util.PropertiesUtil.getProperties(java.lang.System.getProperties().getProperty('EAS_HOME')+'/server/profiles/" + serverInst.getName() + "'+'/config/jmxconnector.properties').getProperty('http.port')");
                    result = EASDBUtil.runScript(script.toString());
                    if (result != null) {
                        serverInst.setJmxPort(result.toString().trim());
                    }
                    serverInstMap.put(serverInst.getName(), serverInst);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (serverInstMap.size() == 0) {
            serverInst = new ServerInstInfo();
            serverInst.setName("server1");
            serverInst.setHttpPort(ETSContext.getHttpPort());
            serverInst.setRpcPort(ETSContext.getRpcPort());
            script.setLength(0);
            script.append("com.kingdee.eas.util.PropertiesUtil.getProperties(java.lang.System.getProperties().getProperty('EAS_HOME')+'/server/profiles/server1/config/jmxconnector.properties').getProperty('http.port')");
            try {
                result = EASDBUtil.runScript(script.toString());
                if (result != null) {
                    serverInst.setJmxPort(result.toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            serverInstMap.put("server1", serverInst);
        }
    }

    public static void initClientEnv(String clientHome) {
        block5: {
            if (clientHome != null && !clientHome.isEmpty()) {
                ETSContext.setRunMode(1);
                ETSContext.setEasClientHome(clientHome);
                clientHome = clientHome.endsWith("\\") || clientHome.endsWith("/") ? String.valueOf(clientHome) + "bin/set-client-env.bat" : String.valueOf(clientHome) + "/bin/set-client-env.bat";
                try {
                    String[] split;
                    String loadFromFile = FileUtil.loadStrFromFile(clientHome, true);
                    if (loadFromFile == null) break block5;
                    String[] stringArray = split = loadFromFile.split("\n");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        if (str != null && str.indexOf("SET EAS_SERVER") >= 0) {
                            split = str.split("=");
                            str = split[1];
                            ETSContext.setEasServerUrl(str);
                            split = str.trim().substring(str.indexOf("tcp://") + 6).split(":");
                            ETSContext.setIp(split[0]);
                            ETSContext.setRpcPort(split[1]);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    System.out.println(clientHome);
                    e.printStackTrace();
                }
            }
        }
    }

    private static void initClientIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress().toString();
            String hostName = addr.getHostName().toString();
            if (ip != null) {
                ETSContext.setClientIp(ip);
            }
            if (hostName != null) {
                ETSContext.setClientName(hostName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initAfterLogin() {
        ETSContext.initClientNetworkMode();
        ETSContext.initClientIp();
        ETSContext.initCustomerInfo();
        ETSContext.initRootOrgName();
        ETSContext.initUserInfo();
        if (ETSContext.getHttpPort() == null) {
            ETSContext.initHttpPort();
        }
        ETSContext.initServerInstInfo();
    }

    public static UserBehaviorLog getUserBehaviorLog() {
        UserBehaviorLog log = new UserBehaviorLog();
        log.setUserName(ETSContext.getUserName());
        log.setEasVersion(ETSContext.getEASVersion());
        log.setUserNumber(ETSContext.getUserNumber());
        log.setClientIp(ETSContext.getClientIp());
        log.setClientName(ETSContext.getClientName());
        log.setEasDCName(ETSContext.getEasDCName());
        log.setEasRootOrgName(ETSContext.getEasRootOrgName());
        log.setCustNumber(ETSContext.getCustNumber());
        log.setCustName(ETSContext.getCustName());
        log.setProductNumber(ETSContext.getProductNumber());
        log.setPlatVersion(ETSContext.getPlatVersion());
        return log;
    }
}

