/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.util;

import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class EncodeUtil {
    private static Cipher encryptCipher = null;
    private static Cipher decryptCipher = null;

    static {
        Security.addProvider(new SunJCE());
        try {
            Key key = EncodeUtil.getKey("ETS".getBytes());
            encryptCipher = Cipher.getInstance("DES");
            encryptCipher.init(1, key);
            decryptCipher = Cipher.getInstance("DES");
            decryptCipher.init(2, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String byteArr2HexStr(byte[] arrB) throws Exception {
        int iLen = arrB.length;
        StringBuffer sb = new StringBuffer(iLen * 2);
        int i = 0;
        while (i < iLen) {
            int intTmp = arrB[i];
            while (intTmp < 0) {
                intTmp += 256;
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
            ++i;
        }
        return sb.toString();
    }

    private static byte[] hexStr2ByteArr(String strIn) {
        try {
            byte[] arrB = strIn.getBytes("UTF-8");
            int iLen = arrB.length;
            byte[] arrOut = new byte[iLen / 2];
            int i = 0;
            while (i < iLen) {
                String strTmp = new String(arrB, i, 2);
                arrOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
                i += 2;
            }
            return arrOut;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] encrypt(byte[] arrB) throws Exception {
        return encryptCipher.doFinal(arrB);
    }

    public static String encrypt(String strIn) throws Exception {
        return EncodeUtil.byteArr2HexStr(EncodeUtil.encrypt(strIn.getBytes("utf-8")));
    }

    private static byte[] decrypt(byte[] arrB) throws IllegalBlockSizeException, BadPaddingException {
        return decryptCipher.doFinal(arrB);
    }

    public static String decrypt(String strIn) throws IllegalBlockSizeException, BadPaddingException {
        byte[] arrB = EncodeUtil.decrypt(EncodeUtil.hexStr2ByteArr(strIn));
        try {
            return new String(arrB, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Key getKey(byte[] arrBTmp) throws Exception {
        byte[] arrB = new byte[8];
        int i = 0;
        while (i < arrBTmp.length && i < arrB.length) {
            arrB[i] = arrBTmp[i];
            ++i;
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }
}

